/**********************************************************************
 *  
 *  NAME:           vidchr.h
 *  
 *  DESCRIPTION:    video character class
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  10/27/90    J. Alan Eldridge    created
 *  
 *  10/29/90    JAE                 modified data structures
 *                                  (interface stays the same)
 *
 *********************************************************************/

#ifndef __VIDCHR_H
#define __VIDCHR_H

class vidchr {

private:

    enum { C, A };          //  array subscripts for ca[]
    union {
        short   i;
        uchar   ca[2];
    } vcu;                  //  character/attrib in Video RAM

public:

    //  set values
    
    void    put(int c)              { vcu.ca[C] = c; }
    void    puta(int a)             { vcu.ca[A] = a; }
    void    put(int c, int a)       { vcu.ca[C] = c; vcu.ca[A] = a; }
    void    puti(int i)             { vcu.i = i; }
    
    //  get values
    
    int     get()                   { return vcu.ca[C]; }
    int     geta()                  { return vcu.ca[A]; }
    void    get(int &c, int &a)     { c = vcu.ca[C]; a = vcu.ca[A]; }
    void    get(uchar &c, uchar &a) { c = vcu.ca[C]; a = vcu.ca[A]; }
    int     geti()                  { return vcu.i; }

};

#endif  //  !defined(__VIDCHR_H)



