/**********************************************************************
 *  
 *  NAME:           winlist.cpp
 *  
 *  DESCRIPTION:    manage a front to back list of windows
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  12/25/90    J. Alan Eldridge    created
 *  
 *********************************************************************/

#include    "w.h"

#define MAXWINS 32

static int      nwins = 0;
static Window   *wins[ MAXWINS ];

//  delete the window at position n

static void
delwin(int n)
{
    for (; n < nwins - 1; n++)
        wins[n] = wins[n+1];
    nwins--;
}
        
//  insert a new window at the front of the list

void
Window::newtop()
{
    if (nwins > 0)
        wins[0]->deactivate();
    for (int n = nwins; n > 0; n--)
        wins[n] = wins[n-1];
    (wins[0] = this)->activate();
    nwins++;
}    

//  is a window in the list?

static int
find(Window *w)
{
    for (int n = nwins - 1; n >= 0; n--)
        if (wins[n] == w) break;
    return n;
}

//  is this the top window?

int
Window::istop()
{
    return nwins > 0 && wins[0] == this;
}

//  make this the top window

int
Window::maketop(int show)
{
    int n = find(this);
    
    if (n) {
        if (n > 0)
            delwin(n);
    
        if (nwins < MAXWINS)
            newtop();
        else
            return ERR;
    }

    if (show)
        refresh();

    return OK;
}

//  remove this from the list and activate
//  new top (if there is one)

void
Window::unlink()
{
    int n = find(this);
    
    if (n >= 0) {
        delwin(n);
        if (!n && nwins > 0)
            wins[0]->activate();
    }
}

//  find which window the mouse went down in

Window *
findwin(int &y, int &x)
{
    for (int n = 0; n < nwins; n++)
        if (wins[n]->inwindow(y, x))
            return wins[n];

    return 0;
}
