#define  EXTERN
#include "fntool.h"
#include <stdarg.h>

static char *progname;
static char usage[] = {
"usage: fntool [options] file1 file2 ...\n"
"  options:\n"
"    -itype {C|fna|fnt|bdf}     input file type (default: fna)\n"
"    -otype {C|fna|fnt|dir}     output file type (default: fnt)\n"
"    -oname <pattern>           output name or pattern.\n"
"           pattern format sequences:\n"
"             %W=font Width, %H=font Height,\n"
"             %G=font weiGht (bold, etc..), %S=slant (italic, etc..),\n"
"             %U=make font name Unique\n"
"    -family <name>             font family name\n"
"    -minchar <value>           lowest character code to convert\n"
"    -maxchar <value>           highest character code to convert\n"
"    -cvtp2f                    convert proportional to fixed\n"
"    -cvtf2p                    convert fixed to proportional\n"
"    -centerwidth               center characters horizontally\n"
"    -centerheight              center characters vertically\n"
"    -resize <width> <height>   resize font to width by height\n"
"    -show                      display font before saving\n"
"    -edit                      edit font before saving\n"
"    -verbose                   verbose operation\n"
"    -help                      show this screen\n"
};

static void argerr(char *msg,...)
{
	va_list ap;

	va_start(ap,msg);
	fprintf(stderr,"%s: ",progname);
	vfprintf(stderr,msg,ap);
	putc('\n',stderr);
	va_end(ap);
	fputs(usage,stderr);
	exit(1);
}

static void checkoptions(void)
{
	if(opt.minchar < 0)  opt.minchar = 0;
	if(opt.maxchar <= 0) opt.maxchar = 32767;
	if(opt.maxchar < opt.minchar) opt.maxchar = opt.minchar;
	if(opt.do_resize && ((opt.res_wdt < 3) || (opt.res_hgt < 3))) {
	    fprintf(stderr,"%s: invalid font size (%dx%d) for \"-resize\""
		" option\nWARNING: resizing not done\n",
		progname,
		opt.res_wdt,
		opt.res_hgt
	    );
	    opt.do_resize = 0;
	}
	if(opt.do_fix2prop && opt.do_prop2fix) {
	    fprintf(stderr,"%s: both fixed to proportional and\n"
		"proportional to fixed conversion specified!\n"
		"WARNING: no conversion is done\n",
		progname
	    );
	    opt.do_fix2prop = 0;
	    opt.do_prop2fix = 0;
	}
	if(opt.do_edit || opt.do_show) opt.verbose = 0;
	if(opt.do_edit && opt.do_show) opt.do_show = 0;
	switch(opt.outtype) {
	  case _C_:
	  case FNA:
	    break;
	  case DIR:
	    if(opt.namepattern[0] == '\0')
		strcpy(opt.namepattern,"fonts.dir");
	    break;
	  default:
	    opt.outtype = FNT;
	    break;
	}
}

#ifdef __GNUC__
static int compareargs(void *first,void *second)
#endif
#ifdef __TURBOC__
static int compareargs(const void *first,const void *second)
#endif
{
	return(strcmp(*((char **)first),*((char **)second)));
}

void main(int argc,char **argv)
{
	static char noarg[]  = { "missing argument(s) for option \"%s\"" };
	static char invarg[] = { "invalid argument(s) for option \"%s\"" };
	char *ap;
	char **inputs;
	int  inputno;

	progname = *argv;
	memset(&opt,0,sizeof(opt));
	inputs = malloc(sizeof(char *) * argc);
	inputno = 0;
	while(--argc > 0) {
	    if(*(ap = *++argv) != '-') {
		inputs[inputno] = ap;
		inputno++;
		continue;
	    }
	    if(strmatch(ap,"-centerh")) {
		opt.do_centerhgt = 1;
		continue;
	    }
	    if(strmatch(ap,"-centerw")) {
		opt.do_centerwdt = 1;
		continue;
	    }
	    if(strmatch(ap,"-cvtf2p")) {
		opt.do_fix2prop = 1;
		continue;
	    }
	    if(strmatch(ap,"-cvtp2f")) {
		opt.do_prop2fix = 1;
		continue;
	    }
	    if(strmatch(ap,"-ed")) {
		opt.do_edit = 1;
		continue;
	    }
	    if(strmatch(ap,"-fam")) {
		if(--argc <= 0) argerr(noarg,"-family");
		strcpy(opt.family,*++argv);
		continue;
	    }
	    if(strmatch(ap,"-h")) {
		printf("%s:\n%s",progname,usage);
		exit(0);
	    }
	    if(strmatch(ap,"-i")) {
		if(--argc <= 0) argerr(noarg,"-itype");
		ap = *++argv;
		if(strmatch(ap,"C"))   { opt.intype = _C_; continue; }
		if(strmatch(ap,"fna")) { opt.intype = FNA; continue; }
		if(strmatch(ap,"fnt")) { opt.intype = FNT; continue; }
		if(strmatch(ap,"bdf")) { opt.intype = BDF; continue; }
		argerr(invarg,"-itype");
	    }
	    if(strmatch(ap,"-minc")) {
		if(--argc <= 0) argerr(noarg,"-minchar");
		if(sscanf(*++argv,"%d",&opt.minchar) != 1) argerr(invarg,"-minchar");
		continue;
	    }
	    if(strmatch(ap,"-maxc")) {
		if(--argc <= 0) argerr(noarg,"-maxchar");
		if(sscanf(*++argv,"%d",&opt.maxchar) != 1) argerr(invarg,"-maxchar");
		continue;
	    }
	    if(strmatch(ap,"-on")) {
		if(--argc <= 0) argerr(noarg,"-oname");
		strcpy(opt.namepattern,*++argv);
		continue;
	    }
	    if(strmatch(ap,"-ot")) {
		if(--argc <= 0) argerr(noarg,"-otype");
		ap = *++argv;
		if(strmatch(ap,"C"))   { opt.outtype = _C_; continue; }
		if(strmatch(ap,"fna")) { opt.outtype = FNA; continue; }
		if(strmatch(ap,"fnt")) { opt.outtype = FNT; continue; }
		if(strmatch(ap,"dir")) { opt.outtype = DIR; continue; }
		argerr(invarg,"-otype");
	    }
	    if(strmatch(ap,"-res")) {
		if((argc -= 2) <= 0) argerr(noarg,"-resize");
		if(sscanf(*++argv,"%d",&opt.res_wdt) != 1) argerr(invarg,"-resize");
		if(sscanf(*++argv,"%d",&opt.res_hgt) != 1) argerr(invarg,"-resize");
		opt.do_resize = 1;
		continue;
	    }
	    if(strmatch(ap,"-sh")) {
		opt.do_show = 1;
		continue;
	    }
	    if(strmatch(ap,"-v")) {
		opt.verbose = 1;
		continue;
	    }
	    argerr("invalid argument: \"%s\"",ap);
	}
	checkoptions();
	if(inputno == 0) argerr("no input file(s) specified");
	qsort(inputs,inputno,sizeof(char *),compareargs);
	if(opt.verbose) printf("%s: LIBGRX font conversion program\n",progname);
	processfonts(inputno,inputs);
	exit(0);
}

