/**
 ** TEXTFONT.C ---- hacked text modes with 14 and 8 row fonts
 **
 ** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
 ** Copyright (C) 1992 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** Copyright (C) 1993 Grzegorz Mazur, gbm@ii.pw.edu.pl
 **
 ** This file is distributed under the terms listed in the document
 ** "copying.dj", available from DJ Delorie at the address above.
 ** A copy of "copying.dj" should accompany this file; if not, a copy
 ** should be available from where this file was obtained.  This file
 ** may not be distributed without a verbatim copy of "copying.dj".
 **
 ** This file is distributed WITHOUT ANY WARRANTY; without even the implied
 ** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **/

int set_custom_text_mode(GrModeEntry *md,int noclear,int AXval)
{
	int mode = md->mode.vdr.BIOS_mode;
#ifdef VESA_FUNC
	if(mode >= 0x100) {
	    _BX = mode | (noclear ? 0x8000 : 0);
	    _AX = VESA_FUNC + VESA_SET_MODE;
	    geninterrupt(0x10);
	    if(_AX != VESA_SUCCESS) return(-1);
	}
	else {
#endif
	    _AX = mode | (noclear ? 0x80 : 0);
	    geninterrupt(0x10);
#ifdef VESA_FUNC
	}
#endif
	_AX = AXval;			/* load BIOS font */
	_BX = 0;
	geninterrupt(0x10);
	return(HDR->driver_flags);
}

#define mode_set_8x14_font(MD,CLF)	set_custom_text_mode(MD,CLF,0x1111)
#define mode_set_8x8_font(MD,CLF)	set_custom_text_mode(MD,CLF,0x1112)

