/**
 ** P8BITBLT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p8.h"
#include "memcopy.h"
#include "gmalloc.h"

void _GrP8PixCopy(GC *dst,long daddr,GC *src,long saddr,int w,int h,int op)
{
	pixptr dstp = P_ADDRESS(dst,daddr);
	pixptr srcp = P_ADDRESS(src,saddr);
	pixptr temp;
	int doff = dst->gc_lineoffset - w;
	int soff = src->gc_lineoffset - w;
	int bytecpy = ((int)daddr | (int)saddr | doff | soff | w) & 1;
	int copywdt = w >> (bytecpy ^ 1);
	int reverse = FALSE;

	if((w <= 0) || (h <= 0)) return;
	op = C_OPER(op);
	_ClrDir();
	if(_GrP8UsePlanarMode) PLANAR_MODE_OFF();
	if((dst->gc_baseaddr == src->gc_baseaddr) && (daddr > saddr)) {
	    dstp += (unsigned)((h * dst->gc_lineoffset) - doff - 2 + bytecpy);
	    srcp += (unsigned)((h * src->gc_lineoffset) - soff - 2 + bytecpy);
	    doff = (-doff);
	    soff = (-soff);
	    reverse = TRUE;
	    _SetDir();
	}
	if(dst->gc_onscreen && src->gc_onscreen && _GrBigFrameBuffer) {
	    if(_GrCanBcopyInBlit && (op == C_SET)) {
		dstp += _GrWrOnlyOffset;
		srcp += _GrRdOnlyOffset;
	    }
	    else {
		temp = (pixptr)_GrGetTempBuffer(w + 2);
		if(temp == (pixptr)NULL) return;
		if(reverse) { temp += w; w = (-w); }
		doff += w;
		soff += w;
		_SaveDS();
		if(bytecpy) while(--h >= 0) {
		    _RowCpyB(RB,temp,srcp,copywdt);
		    switch(op) {
			case C_XOR: _RowCpyXorB(WBX,dstp,temp,copywdt); break;
			case C_OR:  _RowCpyOrB(WBO,dstp,temp,copywdt);  break;
			case C_AND: _RowCpyAndB(WBA,dstp,temp,copywdt); break;
			default:    _RowCpyB(WB,dstp,temp,copywdt);	break;
		    }
		    dstp += doff;
		    srcp += soff;
		}
		else while(--h >= 0) {
		    _RowCpyW(RW,temp,srcp,copywdt);
		    switch(op) {
			case C_XOR: _RowCpyXorW(WWX,dstp,temp,copywdt); break;
			case C_OR:  _RowCpyOrW(WWO,dstp,temp,copywdt);  break;
			case C_AND: _RowCpyAndW(WWA,dstp,temp,copywdt); break;
			default:    _RowCpyW(WW,dstp,temp,copywdt);	break;
		    }
		    dstp += doff;
		    srcp += soff;
		}
		_RestoreDS();
		_ClrDir();
		return;
	    }
	}
	_SaveDS();
	if(bytecpy) switch(op) {
	    case C_XOR: _BlkCpyXorB(CBX,dstp,doff,srcp,soff,copywdt,h); break;
	    case C_OR:  _BlkCpyOrB(CBO,dstp,doff,srcp,soff,copywdt,h);  break;
	    case C_AND: _BlkCpyAndB(CBA,dstp,doff,srcp,soff,copywdt,h); break;
	    default:	_BlkCpyB(CB,dstp,doff,srcp,soff,copywdt,h);	break;
	}
	else switch(op) {
	    case C_XOR: _BlkCpyXorW(CWX,dstp,doff,srcp,soff,copywdt,h); break;
	    case C_OR:  _BlkCpyOrW(CWO,dstp,doff,srcp,soff,copywdt,h);  break;
	    case C_AND: _BlkCpyAndW(CWA,dstp,doff,srcp,soff,copywdt,h); break;
	    default:	_BlkCpyW(CW,dstp,doff,srcp,soff,copywdt,h);	break;
	}
	_RestoreDS();
	_ClrDir();
}

