/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by the University of California, Berkeley and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software. Neither the name of the University nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)inet.h	5.4 (Berkeley) 6/1/90
 */

/* External definitions for functions in inet(3) */

#ifndef _ARPA_INET_H_
#define _ARPA_INET_H_

#ifndef NO_PROTO

#ifdef __cplusplus                      /* for C++ V2.0 */
  extern "C" {   /* do not leave open across includes */
#endif /* __cplusplus */

    unsigned long inet_addr(const char *);
    char *inet_ntoa(struct in_addr);
    struct in_addr inet_makeaddr(long, long);
    unsigned long inet_network(const char *);
    unsigned long inet_lnaof(struct in_addr);
    unsigned long inet_netof(struct in_addr);

#ifdef __cplusplus                      /* for C++ V2.0 */
  }
#endif /* __cplusplus */

#else /* NO_PROTO */

    unsigned long inet_addr();
    char *inet_ntoa();
    struct in_addr inet_makeaddr();
    unsigned long inet_network(), inet_lnaof(), inet_netof();

#endif /* NO_PROTO */

#endif /* _ARPA_INET_H_ */

