/*
 * DESQview/X Socket Library. Copyright (c) 1991 Quarterdeck Office Systems.
 */

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

/*      @(#)netdb.h    */

#ifndef __NETDB_H__
#define __NETDB_H__

/*
 * Structures returned by network data base library.  All addresses are
 * supplied in host order, and returned in network order (suitable for
 * use in system calls).
 */
struct	hostent {
	char	*h_name;	/* official name of host */
	char	**h_aliases;	/* alias list */
	int	h_addrtype;	/* host address type */
	int	h_length;	/* length of address */
	char	**h_addr_list;	/* list of addresses from name server */
#define	h_addr	h_addr_list[0]	/* address, for backward compatiblity */
};

struct  servent {
        char    *s_name;        /* primary name of service */
        char    **s_aliases;    /* other names of service */
        short   s_port;         /* port number to use */
        char    *s_proto;       /* protocol service is offered on */
};

struct  protoent {
        char    *p_name;        /* primary name of protocol */
        char    **p_aliases;    /* other names of protocol */
        short   p_proto;        /* protocol number */
};


#ifndef NO_PROTO

/* hosts C functions */

  struct hostent *gethostbyname(char *);
  struct hostent *gethostbyaddr(char *,int,int);

/* services C functions */

  struct servent *getservbyname(char *,char *);
  struct servent *getservbyport(int,char *);

/* protocol C functions */

  struct protoent *getprotobyname(char *);
  struct protoent *getprotobynumber(int);

#else /* NO_PROTO */

    struct hostent      *gethostbyname(), *gethostbyaddr();
    struct servent      *getservbyname(), *getservbyport();
    struct protoent     *getprotobyname(), *getprotobynumber();

#endif /* NO_PROTO */

#endif /* __NETDB_H__ */

