/*
 * DESQview/X Socket Library. 
 * Copyright (c) 1991,1992,1993 Quarterdeck Office Systems.
 *
 *
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

/*
 * Constants and structures defined by the internet system,
 * Per RFC 790, September 1981.
 */

#ifndef _NETINET_IN_H_
#define _NETINET_IN_H_

/*
 * Protocols
 */
#define IPPROTO_TCP		6		/* tcp */
#define IPPROTO_UDP		17		/* user datagram protocol */
/*
 * Local port number conventions:
 * Ports < IPPORT_RESERVED are reserved for
 * privileged processes (e.g. root).
 * Ports > IPPORT_USERRESERVED are reserved
 * for servers, not necessarily privileged.
 */
#define IPPORT_RESERVED         1024
#define IPPORT_USERRESERVED     5000

/*
 * Definitions of bits in internet address integers.
 * On subnets, the decomposition of addresses to host and net parts
 * is done according to subnet mask, not the masks here.
 */
#define IN_CLASSA(i)            (((long)(i) & 0x80000000) == 0)
#define IN_CLASSA_NET           0xff000000
#define IN_CLASSA_NSHIFT        24
#define IN_CLASSA_HOST          0x00ffffff
#define IN_CLASSA_MAX           128

#define IN_CLASSB(i)            (((long)(i) & 0xc0000000) == 0x80000000)
#define IN_CLASSB_NET           0xffff0000
#define IN_CLASSB_NSHIFT        16
#define IN_CLASSB_HOST          0x0000ffff
#define IN_CLASSB_MAX           65536

#define IN_CLASSC(i)            (((long)(i) & 0xe0000000) == 0xc0000000)
#define IN_CLASSC_NET           0xffffff00
#define IN_CLASSC_NSHIFT        8
#define IN_CLASSC_HOST          0x000000ff

#define IN_CLASSD(i)            (((long)(i) & 0xf0000000) == 0xe0000000)
#define IN_MULTICAST(i)         IN_CLASSD(i)

#define IN_EXPERIMENTAL(i)      (((long)(i) & 0xe0000000) == 0xe0000000)
#define IN_BADCLASS(i)          (((long)(i) & 0xf0000000) == 0xf0000000)


/* Internet Address structure
*/
struct in_addr {
    union {
        struct { char s_b1,s_b2,s_b3,s_b4; } S_un_b;
        struct { unsigned short s_w1,s_w2; } S_un_w;
        long S_addr;
    } S_un;
#define    s_addr  S_un.S_addr        /* can be used for most tcp & ip code */
#define    s_host  S_un.S_un_b.s_b2   /* host on imp */
#define    s_net   S_un.S_un_b.s_b1   /* network */
#define    s_imp   S_un.S_un_w.s_w2   /* imp */
#define    s_impno S_un.S_un_b.s_b4   /* imp # */
#define    s_lh    S_un.S_un_b.s_b3   /* logical host */
#define    S_baddr S_un.S_un_b
};

#define    INADDR_ANY              (u_long)0x00000000
#define    INADDR_BROADCAST        (u_long)0xffffffff      /* must be masked */

struct sockaddr_in {
        short		sin_family;
        unsigned short	sin_port;
        struct in_addr	sin_addr;
        char		sin_zero[8];
};

#ifndef NO_PROTO

#ifdef __cplusplus                      /* for C++ V2.0 */
  extern "C" {   /* do not leave open across includes */
#endif /* __cplusplus */

/* Network and machine order conversion routines */

  unsigned short htons(unsigned short);
  unsigned short ntohs(unsigned short);
  unsigned long  htonl(unsigned long);
  unsigned long  ntohl(unsigned long);

/* Inet C functions    */

  unsigned long  inet_addr(const char *);
  unsigned long  inet_network(const char *);
  char           *inet_ntoa(struct in_addr);
  struct in_addr inet_makeaddr(long, long);
  unsigned long  inet_lnaof(struct in_addr);
  unsigned long  inet_netof(struct in_addr);

#ifdef __cplusplus                      /* for C++ V2.0 */
  }
#endif /* __cplusplus */

#else /* NO_PROTO */

/* Network and machine order conversion routines */

  unsigned short htons();
  unsigned short ntohs();
  unsigned long  htonl();
  unsigned long  ntohl();

/* Inet C functions    */

  unsigned long  inet_addr();
  unsigned long  inet_network();
  char           *inet_ntoa();
  struct in_addr inet_makeaddr();
  unsigned long  inet_lnaof();
  unsigned long  inet_netof();

#endif /* NO_PROTO */

#endif /* _NETINET_IN_H_ */
