/*
 * DESQview/X Socket Library. 
 * Copyright (c) Quarterdeck Office Systems 1991,1992,1993.
 */

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

/*      @(#)socket.h    */

/*
 * Definitions related to sockets: types, address families, options.
 */

#ifndef __SYS_SOCKET_H__
#define __SYS_SOCKET_H__

#include <sys\time.h> /* for timeval */

/* Socket Types */
#define SOCK_STREAM     1               /* TCP */
#define SOCK_DGRAM      2               /* UDP */
#define SOCK_RAW        3               /* direct protocol interface */

/* Socket Options */
#define SO_DEBUG        0x01    /* record debugging info */
#define SO_ACCEPTCONN   0x02    /* socket is listen()ing */
#define SO_REUSEADDR    0x04    /* allow local address to be reused */
#define SO_KEEPALIVE    0x08    /* keep connections alive */
#define SO_DONTROUTE    0x10
#define SO_BROADCAST    0x20
#define SO_DONTLINGER   0x40    /* 4.2 compatible */
#define SO_LINGER       0x80

#define SO_SNDBUF       0x1001
#define SO_RCVBUF       0x1002
#define SO_SNDLOWAT     0x1003
#define SO_RCVLOWAT     0x1004
#define SO_SNDTIMEO     0x1005
#define SO_RCVTIMEO     0x1006

#define MSG_OOB         0x01
#define MSG_PEEK        0x02
#define MSG_DONTROUTE   0x04

/* Address Families */
#define AF_UNSPEC       0
#define AF_UNIX         1
#define AF_INET         2               /* Internet Protocols */
#define AF_IMPLINK      3
#define AF_PUP          4
#define AF_DECnet       12              /* DECnet */

/* Protocol Families */
#define PF_UNSPEC       AF_UNSPEC
#define PF_UNIX         AF_UNIX
#define PF_INET         AF_INET
#define PF_IMPLINK      AF_IMPLINK      /* Internet Protocols */
#define PF_PUP          AF_PUP

/* setsocketopt */
#define TCP_NODELAY	0x01

struct sockaddr {
        unsigned short	sa_family;
        char		sa_data[14];
};

#if !defined(__GNUC__) && !defined(__SALFORD__)
#define bcopy(a,b,c)    	memcpy(b,a,c)
#define bcmp(a,b,c)     	memcmp(a,b,c)
#define bzero(a,b)      	memset(a,0,b)
#endif

#define NUMSOCKS 32

/*
 * Level number for (get/set)sockopt() to apply to socket itself.
 */
#define SOL_SOCKET      0xffff          /* options for socket level */


#define NBBY    8               /* number of bits in a byte */

#ifndef FD_SETSIZE
/*
 * Select uses bit masks of file descriptors in longs.
 * These macros manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here
 * should be >= NOFILE (param.h).
 */
#define FD_SETSIZE      32 /* sun/wollongong are 16,ftp is 20,novell is 128 */

typedef long    fd_mask;
#define NFDBITS (sizeof (fd_mask) * NBBY)       /* bits per mask */
#ifndef howmany
#define howmany(x, y)   (((x)+((y)-1))/(y))
#endif

typedef struct fd_set {
        fd_mask fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1UL << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1UL << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1UL << ((n) % NFDBITS)))
#define FD_ZERO(p)      memset((char *)(p), 0, sizeof (*(p)))

#endif

#ifndef NO_PROTO

/* bsd43 c functions */

  int  accept(int, struct sockaddr  *, int  *);
  int  bind(int, struct sockaddr  *, int);
  int  so_close(int );
  int  connect(int, struct sockaddr  *, int );
  int  gethostname(char *, int);
  int  getpeername(int, struct sockaddr  *, int  *);
  int  getsockname(int, struct sockaddr  *, int  *);
  int  getsockopt(int, int, int, char  *, int  *);
  int  ioctl(int, int, long *);
  int  issock(int );
  int  listen(int, int );
  int  recv(int, char  *, int, int );
  int  recvfrom(int, char  *, int, int, struct sockaddr  *, int  *);
  int  select(int, struct fd_set *, struct fd_set *, struct fd_set *, struct timeval *);
  int  send(int, char  *, int, int);
  int  sendto(int, char  *, int, int, struct sockaddr *, int);
  int  setsockopt(int, int, int, char *, int);
  int  so_attach(unsigned long );
  unsigned long  so_detach(int );
  int  so_close(int );
  void so_fatal(int );
  int  socket(int, int, int);

  int  so_linkup(int s);
  int	 so_unlink(int s);
  int	 so_daemon(char *args[],char wait);
  int  so_initdaemon(char *parmList[],unsigned long *mb);
  void so_setupdaemon(char *name);
  void so_exitdaemon(void);

#else /* NO_PROTO */

/* bsd43 c functions */

  int  accept();
  int  bind();
  int  so_close();
  int  recv();
  int  send();
  int  connect();
  int  gethostname();
  int  getpeername();
  int  getsockname();
  int  getsockopt();
  int  ioctl();
  int  issock();
  int  listen();
  int  recv();
  int  recvfrom();
  int  select();
  int  send();
  int  sendto();
  int  setsockopt();
  int  so_attach();
  unsigned long  so_detach();
  int  so_close();
  void so_fatal();
  int  socket();

  int  so_linkup();
  int	 so_unlink();
  int	 so_daemon();
  int  so_initdaemon();
  void so_setupdaemon();
  void so_exitdaemon();

#endif /* NO_PROTO */

#endif /* __SYS_SOCKET_H__ */
