/*****************************************************************************
*  
*                                  DESQview/X 
*                           BASIC STREAM DAEMON TESTER
*
*  The following code is used to test the basic stream daeomon (TDAEMON.C).
*
*
******************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys\time.h>

#include <netdb.h>		
#include <netinet\in.h>	
#include <sys\socket.h>
#include <sys\errno.h>
#include <sys\ioctl.h>

#define TEST_SERVICE	"tcptest"

void	chat(int s);

extern int kbhit(void);

void main(int argc, char *argv[])
{
	int		s;
	struct	sockaddr_in	addr;
	struct	hostent		*h;
	struct	servent		*serv;

	if(argc < 2){

        printf("\n\nUsage %s <host>\n\n",(argv[0] ? argv[0] : "tclient"));

		exit(1);
	}

	/* Open a stream (TCP) socket for the conversation.			*/

	s = socket(AF_INET,SOCK_STREAM,0);

	if(s < 0){

		printf("\nError:  Could not open stream socket.\n\n");

		exit(2);
	}

	/* Retrieve the information about the port (service) that we	*/
	/* wish to connect to.														*/

	serv = getservbyname(TEST_SERVICE,"tcp");

	if(serv == NULL){

		printf("\nError:  Unable to retrieve information for %s service.\n\n",TEST_SERVICE);

		exit(3);
	}

	/* Now get the host (address) information for the destination	*/
	/* host and fill the destination address structure giving it	*/
	/* the address from the host information and the port from		*/
	/* the retrieved service information.									*/

	h = gethostbyname(argv[1]);

	if(h == NULL){

		printf("\nError:  Unknown host name specified.\n\n");

		exit(3);
	}

	memset(&addr,0,sizeof(struct sockaddr_in));

	addr.sin_family	= AF_INET;
        addr.sin_addr           = *((struct in_addr *)h->h_addr);
	addr.sin_port		= serv->s_port;
	
	/* Attempt to connect to the destination host.						*/

    if(connect(s, (struct sockaddr *)&addr, sizeof(struct sockaddr_in)) != 0){

		printf("\nError:  Unable to connect to %s (%s).\n\n",argv[1],inet_ntoa(addr.sin_addr));

		exit(4);
	}

	chat(s);

	so_close(s);

	exit(0);
}



/*****************************************************************************
*
*	void	chat(int session);
*
* 	The following code demonstrates some of the basic BSD4.3 socket I/O calls.
*  Basically, we poll for data on the socket, while allowing the user to 
*  enter some text which we then send to our connection partner.
*
******************************************************************************/
void	chat(int s)
{
	struct	timeval	t;							/* set to 0 to indicate polling */
	long		nonBlocking = 1l;					
	char		recvBuff[100];						/* Buffer to receive data into */
	char		sendBuff[100];						/* Buffer data sent from */
	long		ioBit,readBit,writeBit;			/* I/O bits for the socket */
	int		bytes,i;								
	char		done;

	printf("\n\n-----------------------------------");
	printf("---------------------------------------------\n");
	printf("<Enter> - Send (blank line to end)\n\n");

	/*  Set the I/O strategy for the socket to non-blocking.  This will	*/
	/*  force I/O calls to return immediately if there is nothing to		*/
	/*	 do.																					*/
	   
	ioctl(s,FIONBIO,(char *)&nonBlocking); 

	/*  Initialize the timeout for the select call to 0.  This will      */
	/*  transform the call from a waiting call to a polling call.			*/

	memset(&t,0,sizeof(struct timeval));

	/*  The select call takes pointers to bit arrays indicating which    */
	/*  sockets we are concerned about.  Initialize the bit indicating   */
	/*  the current socket.																*/

	ioBit = (long)(1l << s);

	done = 0;

	while(!done){

		writeBit = readBit = ioBit;	

		select(s + 1,(struct fd_set *)&readBit,(struct fd_set *)&writeBit,(struct fd_set *)NULL,&t);	/* Get read/write status */

		/* If the 'read' bit is still set after the select call, one of  	*/
		/* two things is indicated.  Either the socket has been closed, 	*/
		/* or there is data to read for the socket. 								*/

		if(readBit & ioBit){

			bytes = recv(s,recvBuff,sizeof(recvBuff),0);	

			switch(bytes){
				case 0:								 	/* Normal close	*/
					printf("\n\nSession Terminated by Partner.\n\n");
					done = 1;
					break;
				case -1:					
					if(errno != EWOULDBLOCK){		/* Abnormal close */
						printf("\n\nSession Terminated Abnormally on Read.\n\n");
						done = 1;
					}
					break;
				default:
					for(i = 0;i < bytes;i++)	 	/* Got some data	*/
						printf("%c",recvBuff[i]);
			}
		} else {

		/* If the 'write' bit is set and a key has been hit, collect the	*/
		/* user data and send it to the connection partner.					*/

			if((writeBit & ioBit) && kbhit()){
	
				strcpy(sendBuff,"<");
				gets(sendBuff + 1);

				if(!strlen(sendBuff + 1)){
					done = 1;
					break;
				}
				strcat(sendBuff,">\n");
	
				bytes = send(s,sendBuff,strlen(sendBuff),0);

				if(bytes == -1 && errno != EWOULDBLOCK){		/* Error Occured */
					printf("\n\nSession Terminated Abnormally on Write.\n\n");
					done = 1;
				}
			}
		}		
	}
}

