/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Src/Graphics/Rect.CC
   Author    : Eric NICOLAS
   Overview  : TRect Object = couple of points (P1,P2)
   UpDate    : Nov 11, 1994

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Rect.H"

static TRect TempRect;

// Constructors

TRect::TRect()
{ _P1=_P2=TPoint();
}

TRect::TRect(TPoint& P1, TPoint& P2)
{ _P1=P1;
  _P2=P2;
}

TRect::TRect(TRect& R)
{ _P1=R._P1;
  _P2=R._P2;
}

TRect::TRect(int X1, int Y1, int X2, int Y2)
{ _P1=TPoint(X1,Y1);
  _P2=TPoint(X2,Y2);
}

// Operators

TRect TRect::operator+(TRect& R)
{ TempRect._P1=TPoint(min(X1(),R.X1()),min(Y1(),R.Y1()));
  TempRect._P2=TPoint(max(X2(),R.X2()),max(Y2(),R.Y2()));
  return TempRect;
}

TRect TRect::operator+=(TRect& R)
{ _P1=TPoint(min(X1(),R.X1()),min(Y1(),R.Y1()));
  _P2=TPoint(max(X2(),R.X2()),max(Y2(),R.Y2()));
  return (*this);
}

TRect TRect::operator-(TRect& R)
{ TempRect._P1=TPoint(max(X1(),R.X1()),max(Y1(),R.Y1()));
  TempRect._P2=TPoint(min(X2(),R.X2()),min(Y2(),R.Y2()));
  return TempRect;
}

TRect TRect::operator-=(TRect& R)
{ _P1=TPoint(max(X1(),R.X1()),max(Y1(),R.Y1()));
  _P2=TPoint(min(X2(),R.X2()),min(Y2(),R.Y2()));
  return (*this);
}

boolean TRect::operator==(TRect& R)
{ return (boolean)((X1()==R.X1()) && (X2()==R.X2()) &&
                   (Y1()==R.Y1()) && (Y2()==R.Y2()));
}

boolean TRect::Empty()
{ return (boolean)((X1()>X2()) || (Y1()>Y2()));
}

TRect TRect::operator+(TPoint& P)
{ TempRect._P1=_P1+P;
  TempRect._P2=_P2+P;
  return TempRect;
}

TRect TRect::operator+=(TPoint& P)
{ _P1+=P;
  _P2+=P;
  return (*this);
}

TRect TRect::operator-(TPoint& P)
{ TempRect._P1=_P1-P;
  TempRect._P2=_P2-P;
  return TempRect;
}

TRect TRect::operator-=(TPoint& P)
{ _P1-=P;
  _P2-=P;
  return (*this);
}

// Object stream

void TRect::Read(TDisk *file)
{ _P1.Read(file);
  _P2.Read(file);
}

void TRect::Write(TDisk *file)
{ _P1.Write(file);
  _P2.Write(file);
}
