/* Project SWORD
   V2.0

   SubSystem : ToolBox for 3D graphics
   File      : LibSrc/ToolBox/Graph3D/Camera.CC
   Author    : Eric NICOLAS
   Overview  : Object TCamera : Characteristic of the observation camera
   UpDate    : Apr  3, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <math.h>

#include "Common/Common.H"
#include "Mecanism/Collec.H"
#include "ToolBox/Graph3D/Point3D.H"
#include "ToolBox/Graph3D/Transf.H"
#include "ToolBox/Graph3D/Camera.H"

void TCamera::SetUp()
{ TPoint3D V=Position-Observation;
  // Compute camera characteristics in local coordinates
  PositionX=norm(V);
  PositionLens=(PositionX-sqrt(PositionX*PositionX-4*FocalLength*PositionX))/2;
  // Compute transformation matrix from global to local coordinates
  // :: The order of the transformation is
  // :: 1. Translation of -Observation
  // :: 2. Rotation in OXY plane of Theta angle
  // :: 3. Rotation in OXZ plane of Phi angle
  // :: So the matrix must be M3*M2*M1
  // M3: Rotation in OXZ plane
  Transform=RotateOXZ(-V.Phi());
  // M2: Rotation in OXY plane
  Transform=Transform*RotateOXY(-V.Theta());
  // M1: Translation of -Observation
  Transform=Transform*Translation(-Observation);
}

float TCamera::ImageSpot(float ObjetX)
{ float Lp;
  Lp=1/(1/(PositionLens-ObjetX)+1/FocalLength);
  return FocalLength/N*(1-PositionLens/Lp);
}

int TCamera::Projection(TPoint3D& P, float &X, float& Y, float& s)
{ TPoint3D Pp=Transform*P;
  float    SA=-((PositionX-PositionLens)-Pp.X());
  if (SA>=0) return FALSE;
  if (SA==FocalLength) return FALSE;
  float    SA1=1/(1/SA+1/FocalLength);
  float    Xp=SA1-PositionLens;
  float    Yp=Pp.Y()*SA1/SA;
  float    Zp=Pp.Z()*SA1/SA;
  s=Xp/SA1*FocalLength/N;
  X=-Yp*PositionLens/SA1;
  Y=-Zp*PositionLens/SA1;
  X=Pp.Y()/PositionX;
  Y=Pp.Z()/PositionX;
  return TRUE;
}
