/* Project SWORD
   V2.0

   SubSystem : Mathematical toolbox
   File      : LibSrc/ToolBox/Math/Vector.CC
   Author    : Eric NICOLAS
   Overview  : Variable size vectors arithmetics
   UpDate    : May 07, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <math.h>
#include "Common/Common.H"
#include "ToolBox/Math/MError.H"
#include "ToolBox/Math/Complex.H"
#include "ToolBox/Math/Vector.H"

int    VectorDefaultSize=1;

static TVector tempVector;

TVector::TVector(int eSize)
{ Size=eSize;
  Tabl=new complex[Size];
}

TVector::TVector(TVector& V)
{ int i;
  Size=V.Size;
  Tabl=new complex[Size];
  for(i=0;i<Size;i++) Tabl[i]=V(i);
}

TVector::~TVector()
{ delete Tabl;
}

void TVector::Reset(void)
{ int i;
  for(i=0;i<Size;i++) Tabl[i]=0;
}

TVector TVector::operator=(TVector& V)
{ int i;
  if (Size!=V.Size)
  { // Ajust sizes
    delete Tabl;
    Size=V.Size;
    Tabl=new complex[Size];
  }
  for(i=0;i<Size;i++) Tabl[i]=V(i);
  return (*this);
}

TVector TVector::operator+(TVector& V)
{ if (V.Size!=Size) MathError=MError_Vector_MixingSizes;
  if (MathError) return (*this);
  int i;
  tempVector=*this;
  for(i=0;i<Size;i++) tempVector(i)+=V(i);
  return tempVector;
}

TVector TVector::operator+=(TVector& V)
{ if (V.Size!=Size) MathError=MError_Vector_MixingSizes;
  if (MathError) return (*this);
  int i;
  for(i=0;i<Size;i++) Tabl[i]+=V(i);
  return (*this);
}

TVector TVector::operator-(TVector& V)
{ if (V.Size!=Size) MathError=MError_Vector_MixingSizes;
  if (MathError) return (*this);
  int i;
  tempVector=*this;
  for(i=0;i<Size;i++) tempVector(i)-=V(i);
  return tempVector;
}

TVector TVector::operator-=(TVector& V)
{ if (V.Size!=Size) MathError=MError_Vector_MixingSizes;
  if (MathError) return (*this);
  int i;
  for(i=0;i<Size;i++) Tabl[i]-=V(i);
  return (*this);
}

TVector TVector::operator*(TVector& V)
{ if (V.Size!=Size) MathError=MError_Vector_MixingSizes;
  if (MathError) return (*this);
  int i;
  tempVector=*this;
  for(i=0;i<Size;i++) tempVector(i)*=V(i);
  return tempVector;
}

TVector TVector::operator*=(TVector& V)
{ if (V.Size!=Size) MathError=MError_Vector_MixingSizes;
  if (MathError) return (*this);
  int i;
  for(i=0;i<Size;i++) Tabl[i]*=V(i);
  return (*this);
}

TVector TVector::operator/(TVector& V)
{ if (V.Size!=Size) MathError=MError_Vector_MixingSizes;
  if (MathError) return (*this);
  int i;
  tempVector=*this;
  for(i=0;i<Size;i++) tempVector(i)/=V(i);
  return tempVector;
}

TVector TVector::operator/=(TVector& V)
{ if (V.Size!=Size) MathError=MError_Vector_MixingSizes;
  if (MathError) return (*this);
  int i;
  for(i=0;i<Size;i++) Tabl[i]/=V(i);
  return (*this);
}

complex TVector::operator%(TVector& V)
{ if (V.Size!=Size) MathError=MError_Vector_MixingSizes;
  if (MathError) return 0;
  int     i;
  complex C=0;
  for(i=0;i<Size;i++) C+=Tabl[i]*conj(V(i));
  return C;
}

TVector TVector::operator^(TVector& V)
{ if (V.Size!=Size) MathError=MError_Vector_MixingSizes;
  if (MathError) return (*this);
  int     i,i1,i2;
  tempVector=V;
  for(i=0;i<Size;i++)
  { i1=i+1;
    i2=i1+1;
    while(i1>=Size) i1-=Size;
    while(i2>=Size) i2-=Size;
    tempVector(i)=Tabl[i1]*V(i2)-Tabl[i2]*V(i1);
  }
  return tempVector;
}

float norm(TVector& V)
{ return (V%V).re;
}

float abs(TVector& V)
{ return sqrt((V%V).re);
}

TVector operator*(TVector& V, complex  C)
{ int i;
  tempVector=V;
  for(i=0;i<tempVector.Size;i++) tempVector(i)*=C;
  return tempVector;
}

TVector operator*(complex  C, TVector& V)
{ int i;
  tempVector=V;
  for(i=0;i<tempVector.Size;i++) tempVector(i)=C*V(i);
  return tempVector;
}

TVector TVector::operator*=(complex  C)
{ int i;
  for(i=0;i<Size;i++) Tabl[i]*=C;
  return (*this);
}

TVector operator/(TVector& V, complex  C)
{ int i;
  tempVector=V;
  for(i=0;i<tempVector.Size;i++) tempVector(i)/=C;
  return tempVector;
}

TVector operator/(complex  C, TVector& V)
{ int i;
  tempVector=V;
  for(i=0;i<tempVector.Size;i++) tempVector(i)=C/V(i);
  return tempVector;
}

TVector TVector::operator/=(complex  C)
{ int i;
  for(i=0;i<Size;i++) Tabl[i]/=C;
  return (*this);
}
