This is Info file rhide.info, produced by Makeinfo version 1.67 from the
input file rhide.num.

START-INFO-DIR-ENTRY
* RHIDE: (rhide.inf).           Documentation about RHIDE, an IDE for DJGPP.
END-INFO-DIR-ENTRY

This is the documentation for the Integrated Development Environment RHIDE
for DJGPP.

Copyright (C) 1996 Robert Hhne

This documentation may be freely distributed with the RHIDE package or any
part thereof, provided this copyright notice is left intact on all copies.


File: rhide.info,  Node: Builtin compiler specs,  Next: Builtin variables,  Prev: Project window,  Up: Detailed description of some parts of RHIDE

4.5 Builtin compiler specs
==========================

RHIDE uses for compiling, linking, and the other stages of generating a
file also specs, like you can change in the local options for a project
item (*Note Local options::). Here the specs, which are used currently:

$(RHIDE_COMPILE_C)
     For compiling C source files

$(RHIDE_COMPILE_CC)
     For compiling C++ source files

$(RHIDE_COMPILE_ASM)
     For compiling assembler source files

$(RHIDE_COMPILE_PASCAL)
     For compiling pascal source files

$(RHIDE_COMPILE_OBJC)
     For compiling objective C source files

$(RHIDE_COMPILE_LINK)
     For linking

$(RHIDE_COMPILE_LINK_PASCAL)
     For linking when the project contain pascal source files

$(RHIDE_COMPILE_LINK_PASCAL_AUTOMAKE)
     This spec is used only, when you have set the (*Note Primary file::),
     to tell RHIDE, not to check for dependencies but to use the 'automake'
     feature of GPC.

$(RHIDE_COMPILE_ARCHIVE)
     For creating a library

$(RHIDE_FSDB)
     For calling fsdb.

$(RHIDE_GDB)
     For calling gdb.

$(RHIDE_GPROF)
     For calling gprof.

$(RHIDE_GREP)
     For calling grep.

All of these specs have a default contentents in RHIDE, but they can be
overwritten by setting the environment variable with the same name and any
other contents.


File: rhide.info,  Node: Builtin variables,  Next: Change the defaults of RHIDE,  Prev: Builtin compiler specs,  Up: Detailed description of some parts of RHIDE

4.6 Builtin variables
=====================

This section describe, which variables can be used within RHIDE to get
values from some of the configurations, which you have made inside RHIDE.

All of these variables are refernced by a name enclosed in parantheses
preceeded by a dollar sign. Example: `$(RHIDE_GCC)'. You can overwrite any
of the following variables, if you define in your environment the same
variable with any contents you want.

When RHIDE tries to get the contents of such a variable, it searches at
first if it is found in it's internal database. If it was not found, the
environment is checked for such a variable and if that fails, the
resulting value is the variable itself.

In addition to the use of variables, RHIDE has a limited ability of using
string manipulating functions. I have implemented some of the functions,
which are available with GNU make. They have the same name and should work
exactly like the GNU make counterpart.

`$(strip arg)'
     This function removes any leading and trailing whitespace and converts
     all multispaces to single spaces from the (whitespace separated list)
     `arg'.

`$(addsuffix arg1,arg2)'
     These functions append on each argument from the whitespace separated
     list `arg2' the string `arg1'.

`$(addprefix arg1,arg2)'
     This is the same as `$(addsuffix arg1,arg2)', except that it puts the
     string `arg1' before each argument from `arg2'.

`$(notdir arg)'
     This removes any directory part from the argument `arg'.

`$(dir)'
     This extracts only the directory part from the argument `arg'. If
     there was not directory in `arg', an empty string is returned. (The
     directory contains also the drive letter, if there was one)

`$(subst arg1,arg2,arg3)'
     This replaces every occoureance of `arg1' in `arg3' with `arg2'

The following variables have a special meaning in RHIDE with the default
contents:
$(RHIDE_GCC)
     gcc

$(RHIDE_AS)
     gcc

$(RHIDE_GXX)
     gcc

$(RHIDE_GPC)
     gpc

$(RHIDE_AR)
     ar

$(RHIDE_LD)
     gcc

$(RHIDE_LD_PASCAL)
     gpc

$(RHIDE_ARFLAGS)
     rcs

$(RHIDE_INCLUDES)
     $(SPECIAL_CFLAGS) $(addprefix -I,$(INCLUDE_DIRS))

$(RHIDE_LIBDIRS)
     $(addprefix -L,$(LIB_DIRS))

$(RHIDE_LIBS)
     $(addprefix -l,$(LIBS))

$(RHIDE_LDFLAGS)
     $(SPECIAL_LDFLAGS) $(addprefix -Xlinker ,$(LD_EXTRA_FLAGS))

$(RHIDE_COMPILE_C)
     $(RHIDE_GCC) $(RHIDE_INCLUDES) $(C_DEBUG_FLAGS) \
     $(C_OPT_FLAGS) $(C_WARN_FLAGS) $(C_C_LANG_FLAGS) \
     $(C_EXTRA_FLAGS) $(LOCAL_OPT) -c $(SOURCE_NAME) \
     -o $(OUTFILE)

$(RHIDE_COMPILE_CC)
     $(RHIDE_GXX) $(RHIDE_INCLUDES) $(C_DEBUG_FLAGS) \
     $(C_OPT_FLAGS) $(C_WARN_FLAGS) $(C_CXX_LANG_FLAGS) \
     $(C_EXTRA_FLAGS) $(LOCAL_OPT) -c $(SOURCE_NAME) \
     -o $(OUTFILE)

$(RHIDE_COMPILE_ASM)
     $(RHIDE_AS) $(RHIDE_INCLUDES) $(C_DEBUG_FLAGS) \
     $(C_OPT_FLAGS) $(C_WARN_FLAGS) $(C_EXTRA_FLAGS) \
     $(LOCAL_OPT) -c $(SOURCE_NAME) -o $(OUTFILE)

$(RHIDE_GPC_FLAGS)
     $(RHIDE_INCLUDES) $(C_DEBUG_FLAGS) $(C_OPT_FLAGS) \
     $(C_WARN_FLAGS) $(C_P_LANG_FLAGS) $(C_EXTRA_FLAGS)

$(RHIDE_COMPILE_PASCAL)
     $(RHIDE_GPC) $(RHIDE_GPC_FLAGS) $(LOCAL_OPT) \
     -c $(SOURCE_NAME) -o $(OUTFILE)

$(RHIDE_COMPILE_LINK)
     $(RHIDE_LD) $(RHIDE_LIBDIRS) $(C_EXTRA_FLAGS) \
     $(RHIDE_LDFLAGS) -o $(OUTFILE) $(OBJFILES) \
     $(LIBRARIES) $(RHIDE_LIBS)

$(RHIDE_COMPILE_LINK_PASCAL)
     $(RHIDE_LD_PASCAL) $(RHIDE_LIBDIRS) $(C_EXTRA_FLAGS) \
     $(RHIDE_LDFLAGS) -o $(OUTFILE) $(OBJFILES) \
     $(LIBRARIES) $(RHIDE_LIBS)

$(RHIDE_COMPILE_LINK_PASCAL_AUTOMAKE)
     $(RHIDE_LD_PASCAL) $(RHIDE_LIBDIRS) $(RHIDE_LDFLAGS) \
     -o $(OUTFILE) \
     --automake=\"$(strip $(RHIDE_GPC_FLAGS))\" \
     $(RHIDE_GPC_FLAGS) $(SOURCE_NAME) $(LIBRARIES) $(RHIDE_LIBS)

$(RHIDE_COMPILE_ARCHIVE)
     $(RHIDE_AR) $(RHIDE_ARFLAGS) $(OUTFILE) $(OBJFILES)

$(RHIDE_FSDB)
     fsdb $(OUTFILE) $(addprefix -p ,$(SRC_DIRS)) $(PROG_ARGS)

$(RHIDE_GDB)
     gdb $(OUTFILE) $(addprefix -d ,$(SRC_DIRS))

$(RHIDE_GREP)
     grep -n $(prompt arguments for GREP)

$(RHIDE_GPROF)
     gprof $(OUTFILE)

The following are not used as real variables, but they are used to get the
contents of options from RHIDE. But you can override them also by setting
them as an environment variable.

$(INCLUDE_DIRS)
     All the include directories

$(LIB_DIRS)
     All the library directories

$(SOURCE_NAME)
     The actual compiled source file

$(OUTFILE)
     The actual created file

$(C_DEBUG_FLAGS)
     All the debugging flags

$(C_OPT_FLAGS)
     All the optimization flags

$(C_WARN_FLAGS)
     All the warning flags

$(C_C_LANG_FLAGS)
     All the C language flags

$(C_CXX_LANG_FLAGS)
     ALL the C++ language flags

$(C_P_LANG_FLAGS)
     All the pascal language flags

$(LIBS)
     All the libraries, which are given in the libraries options

$(LD_EXTRA_FLAGS)
     All the additional linker options

$(LOCAL_OPT)
     All the local options for that project item

$(OBJFILES)
     All the destination files, which are part of the project and which
     are not a library and not excluded from linking

$(LIBRARIES)
     All the libraries, which are explicit included in the project and not
     exlcuded from linking

$(SPECIAL_CFLAGS)
     Some special flags for `gcc'. Currently only the `-nostdlib' switch.

$(SPECIAL_LDFLAGS)
     Some special flags for `gcc' when linking. Currently only the
     switches `-pg' and `-nostdlib'.

$(prompt TITLE)
     RHIDE prompts for arguments which get the title `TITLE' and insert
     the parameters here.


File: rhide.info,  Node: Change the defaults of RHIDE,  Next: Message window,  Prev: Builtin variables,  Up: Detailed description of some parts of RHIDE

4.7 Change the defaults of RHIDE
================================

If you have special wishes for compiling your source files, you can
configure for RHIDE mostly everything. For adding support for other than
the builtin known file types (*Note Builtin variables::). If you want to
change the behaviour of RHIDE for compiling all the known file types you
should know at first really what you do. If you think, this is a good idea
or if you only want only check if it works you can do it.

Before RHIDE compiles any file (this includes also linking and building a
library) it searches the environment for a variable after the following
scheme: When compiling a file with suffix `.c' to a file with suffix `.o'
RHIDE checks for the variable $(RHIDE_COMPILE.c.o). If this variable is
defined the contents of this variable is taken as the compile spec.

If you want to change the specs for linking you must take as destiniation
suffix `.exe' or `.' and as source suffix the suffix of your object files.
Example:

$(RHIDE_COMPILE.o.)


File: rhide.info,  Node: Message window,  Next: Syntax highlighting,  Prev: Change the defaults of RHIDE,  Up: Detailed description of some parts of RHIDE

4.8 Message window
==================

This window shows every time you compile a file the resulting messages,
which gcc produces. These messages were converted in a special format to
show them in the window. Some of the messages contain a file eventually
combined with a line number. If you press <ENTER>  on such a message, the
corresponding source line in the file will be highlighted and the window
with this file will be selected. If this file is not already on the
dektop, it will be opened.

If the file, to which the messages refer, is already in the foreground you
can see the selected source line for your messages directly on the screen.


File: rhide.info,  Node: Syntax highlighting,  Next: Checking the dependencies,  Prev: Message window,  Up: Detailed description of some parts of RHIDE

4.9 Syntax highlighting
=======================

Syntax highlighting is now supported directly by the editor. It should
work in mostly every situation for all the supported types. Currently (in
RHIDE) only the C/C++ style syntax highlight and the Pascal style syntax
highlight are supported.

With which style a file is highlighted is choosen by RHIDE by checking the
suffix of the file and determining the file type from that suffix.  (*Note
Known suffixes::)


File: rhide.info,  Node: Checking the dependencies,  Next: What is Turbo Vision,  Prev: Syntax highlighting,  Up: Detailed description of some parts of RHIDE

4.10 Checking the dependencies
==============================

This is one of the main parts of RHIDE. To speed up the work, I have added
a cache for checking the modification time of a file and for finding a
file (computing the full name of a file). But sometimes the data in the
cache isn't valid, especialy when running under Windows. If you see this,
you can clear the cache by leaving RHIDE and starting again.

If you didn't any special things but have problems with it, please run
RHIDE with the `-df' switch and try to find out, where the problem is and
post it to me so I can fix it.


File: rhide.info,  Node: What is Turbo Vision,  Next: How the dialogs work,  Prev: Checking the dependencies,  Up: Detailed description of some parts of RHIDE

4.11 What is Turbo Vision
=========================

The Turbo Vision library is part of Turbo C++ version 3.1. I have ported
this library to use with DJGPP because I think it is the most powerful
text windowing library, which is available for MS-DOS. With the help of
this library you can write front end application which looks very well and
the interface is easy to use.

The Turbo Vision library is not only a window based text user interface,
it is also a very good event handling mechanism. It supports the use of
the mouse and keyboard with the ability of defining and using of hotkeys,
that means, you can assign to some keys or combinations of keys, which
function should be executed.

The main parts of an application, which is using this library, are the
desktop, the menu bar and the statusline. The menu bar is usualy shown as
the topmost line of the screen. There are shown the main parts of the pull
down menus, from where you can select the most functions, which are
implemented in an application.

To use the menu you can use the mouse as well the keyboard. With the mouse
you can click every where on a menu entry and the corresponding function
will be executed. There are some different actions, which a menu entry can
have. At first some of them, these are for example all the entries in the
menu bar, open a submenu with more menu entries which are related to the
name of this main entry. And the others, most in such a submenu, execute a
definite function of the application.

With the keyboard you can walk through the menu very simply. To activate
the menu bar, you have to press <F10> . In the pull down menus you can use
the cursor keys to move the highlighted bar up and down and with the
cursor right and left keys you can switch to next or previous menu. With
the <ENTER>  key you activate the function, which corresponds to this
entry. If this was a submenu, which is indicated with a symbol like a
small right arrow, this will be opened.

If you walk through the menu with the cursor keys or the mouse (hold the
left mouse button down and move the mouse) in the statusline will be shown
for each entry a short hint for the function of this menu entry.


File: rhide.info,  Node: How the dialogs work,  Next: Defining macros,  Prev: What is Turbo Vision,  Up: Detailed description of some parts of RHIDE

4.12 How the dialogs work
=========================

In a dialog, like the file open dialog, are many things which you can
select or where you can type in some data. At first some general
functions. If you press <ESC> , the dialog will be closed and nothing will
be changed. The same can be done with the mouse by clicking on the close
symbol (this is the small symbol on upper left frame of the dialog).

In the next paragraphs I will describe the most used elements of a dialog.
For selecting each element of a dialog you can use the <Tab> key to select
the next element in the dialog or the <Shift+Tab> key, to select the
previous element.

A button is a rectangle with some text on it. If you activate such a
button a specified action is executed. To select a button you can use the
<Tab> key, until the button is special highlighted and press then <ENTER>
. Or most times a character of the text on this button has a different
color. So you can press <Alt+> this charcter to activate the button. With
the mouse you can simply click on a button to activate it.

A listbox is a collection of some strings in one or more columns and rows
as needed. The project window (*Note Project window::) is such a listbox
with the names of the project items. You can use the cursor keys to move
the focus bar in the list, or if it is a sorted listbox, you can also type
some characters and the focus will moved to the item, which starts with
this characters. To select a item in a list box, press <SPACE> or <ENTER>
or double click with mouse on it.

In an input line you can type some text which can be edited with the usual
editing keys.

A checkbox is a collection of options, which can be turned on or off.
Each option has in front of it a small indicator, if it is turned on (an X
is shown) or not (the X is not shown). To toggle such an option, use the
cursor keys to move the focus to the option you want and press <SPACE> .
If a character in an optionstring is highlighted you can press this key
and the option will be turned on or off or click with the mouse on the
option.

Radiobuttons are similar to checkboxes, but there you can select only one
of all the shown options.


File: rhide.info,  Node: Defining macros,  Next: The INFO Viewer,  Prev: How the dialogs work,  Up: Detailed description of some parts of RHIDE

4.13 Defining macros
====================

Please look for a detailed documentation here: see *Note Documentation
about Pseudo Macros: (editor.inf)Pseudo Macros,


File: rhide.info,  Node: The INFO Viewer,  Prev: Defining macros,  Up: Detailed description of some parts of RHIDE

4.14 The INFO Viewer
====================

The integrated helpsystem of RHIDE is based on the INFO Viewer written by
SALVADOR EDUARDO TROPEA (SET) <ice@inti.edu.ar>. It gives you access to
all the INFO files which you have installed in the correct directories like
for `info.exe'.

To get help about the INFO Viewer hit <F1>

when the helpwindow is opened or follow this link see *Note Top:
(infview.inf)Top.

In addition to getting help with this system you can also copy text from
the helpscreen to the clippboard. This is usefull if you want for instance
to copy an example from the libc reference in your program. This feature
is not so powerfull like in the editor, but it is good enough. To mark
some text use the <Shift> and cursor keys and copy the selected text with
<Ctrl+Ins> to the clipboard.

In RHIDE you have also the possiblility to get help about a specific
function. Currently this works only for functions, which are documneted in
the libc reference. For doing this, move the cursor to the function and
hit <Ctrl+F1>  or click with the right button of the mouse on that word.


File: rhide.info,  Node: Debugging with RHIDE,  Next: Debugging with RHGDB,  Prev: Detailed description of some parts of RHIDE,  Up: Top

5. Debugging with RHIDE
***********************

For debugging your programs you need now no external debugger, because
RHIDE has one integrated. The integrated debugger is not code which I have
written, but it is GDB 4.16, which is linked in RHIDE.

Because RHIDE uses a special method to communicated with GDB it is
currently not possible to use all of the features, which GDB has. I have
implemented at this time the most important functions, which are needed to
debug your program. So it is not possible to give GDB the same commands as
when running GDB standalone. That means, if you need any very special
feature of GDB you have to run GDB.

The integrated debugger is a real source level debugger like GDB. If you
step trough your program you will see every time exactly where in the
sources you are. But to use the aibility to debug your program needs, that
you have compiled your source files with debugging information and this
symbols must not be stripped from the executable.

* Menu:

* Limitations of the integrated debugger::
* Dual display debugging::
* Using the integrated debugger::
* Problems with C++ programs::
* Using Breakpoints::


File: rhide.info,  Node: Limitations of the integrated debugger,  Next: Dual display debugging,  Prev: Debugging with RHIDE,  Up: Debugging with RHIDE

5.1 Limitations of the integrated debugger
==========================================

Because the integrated debugger is GDB, you will have all the limitations
which GDB has in addition to well known DJGPP and/or MS-DOS limitations.
Here is a (not completely) list of known misfeatures:

   * Signals are not handled every time correct by distinguishing between
     the debuggee and RHIDE

   * Remote debugging is NOT supported

   * Debugging of graphic programs may work or not depending on the
     software you are using. Currently only the VESA modes and the
     standard VGA graphic modes are supported.

   * When using the integrated debugger under Windows 3.1x (in Windows 95
     there is no such limitation) the number of breakpoints is limited to
     3, because you can use there only hardware breakpoints. The i386
     supports only 4 hardware breakpoints and 1 is needed for internal use.
     This is a common problem for all DJGPP debuggers. (Try to use FSDB
     with more than 3 breakpoints under Windows 3.1x)

   * Sometimes the source line, which is shown by RHIDE in assuming that
     the execution is there, is not correct. But this is NOT a bug of
     RHIDE and NOT of GDB. This is a bug in GCC which produces wrong line
     number information in the object files. Here is a very simple test
     program, with which you can see this problem.

          /* This is an example, that gcc produces wrong line number
             information for code which is optimized out. (compile this
             with -O) */
          
          int a = 1;
          int b = 2;
          
          int main()
          {
            if (a == b) return 0;
            if ((a + 1) == b) return 1;
            return 0; /* The debugger should never come here,
                         but it comes */
          }


File: rhide.info,  Node: Dual display debugging,  Next: Using the integrated debugger,  Prev: Limitations of the integrated debugger,  Up: Debugging with RHIDE

5.2 Dual display debugging
==========================

RHIDE supports now also to use an installed dual display. This is when you
have installed in addition to your VGA card a monochrome display card
together with a monitor. RHIDE checks this by asking the BIOS if it is
present and if this is true and the option is enabled (*Note
Preferences::) then RHIDE switches automatically to the secondary display
when debugging and your program will run on the primary display.

With this debugging technique you will get the best debugging results
especially when debugging graphics programs.

To use the dual display with RHGDB use the `-D' switch for RHGDB.


File: rhide.info,  Node: Using the integrated debugger,  Next: Problems with C++ programs,  Prev: Dual display debugging,  Up: Debugging with RHIDE

5.3 Using the integrated debugger
=================================

If you are familiar with Borland's debugger, you will see, that most of
the function of that debaugger are implemented in the same or in a similar
way (this includes the key bindings).

* Menu:

* Stepping trough the source code::
* Evaluating the contents of variables::
* Watching the contents of variables::


File: rhide.info,  Node: Stepping trough the source code,  Next: Evaluating the contents of variables,  Prev: Using the integrated debugger,  Up: Using the integrated debugger

5.3.1 Stepping trough the source code
-------------------------------------

For stepping trough your code, there are three ways. This is at first the
Step-function <F8>. With this you execute a complete source line. If there
is a function call at the current execution point, this function is called
without debugging it. This technique is the same like the `next'-command
from GDB.

The next way is the Trace-function.  It does the same like the
Step-function <f7>, except if there is a function call at the current
execution point, you will go into this function, if there is debugging
information for that function available.  This technique is the same like
the `step'-command from GDB.

And the third way is the Goto-Cursor-function. For this, move the cursor
to the line in yur source code and press <F4>. Now the execution of your
program is continued until it comes to that line. Sometimes you will get
an error message, that for the specified line is no code generated.  This
comes from the optimization of yor code by GCC. In this case try a line
below or above.


File: rhide.info,  Node: Evaluating the contents of variables,  Next: Watching the contents of variables,  Prev: Stepping trough the source code,  Up: Using the integrated debugger

5.3.2 Evaluating the contents of variables
------------------------------------------

You can evaluate also the the contents of variables, when your program has
been started. For this you can press <Ctrl+F4> and you will see a dialog,
where you can type in the expression to evaluate, a line with the result
and a line, where you can give the expression a new value. If you have
pressed this in an editor window, RHIDE tries to find the a word under the
cursor and copies this as default in the expression-inputline. To get the
contents of this expression you have to press the *Evaluate*-button.

If the expression could not be evaluated so it is shown in the result line.
For the exact syntax of getting the contents of an expression see *Note
Expressions: (gdb.inf)Expressions. You can also show the value of the
expression in several formats see *Note Output Formats: (gdb.inf)Output
Formats.

In addition to the functionallity of the Borland debuggers, GDB (and of
course also RHIDE) can evaluate the result of function calls. If you have
for example in your debugged program a function
     int foo(int arg1)
     {
     /* do something and return a value */
     }
defined, you can type in the expression inputline
foo(16)
and you will get as result, what the function would return, if it is
called with the argument `16'. As arguments you can also use any known
variable or complex expressions.

A known limitation is, that the expressions are NOT checked for validity.
That means, you can produce any exception there, which will terminate your
program. As an example type in the expression inputline
3/0
And, of course, you cannot assign to a function call a new value.

As an special side effect you can use this also as a calculator. You can
evaluate any trivial or complex expression and this is also available, if
you didn't started the integrated debugger.


File: rhide.info,  Node: Watching the contents of variables,  Prev: Evaluating the contents of variables,  Up: Using the integrated debugger

5.3.3 Watching the contents of variables
----------------------------------------

In addition to a single look at the contents of a variable, you can add
the variable to a list which is updated after each debugger step and is
shown in the watching window. For this function you can use the hotkey
<Ctrl+F7> .

Within the watch window you can press <Enter> on an expression to change
that expression (NOT the contents of that expression) or you can press
<Del>  to remove the variable from the watch window.


File: rhide.info,  Node: Problems with C++ programs,  Next: Using Breakpoints,  Prev: Using the integrated debugger,  Up: Debugging with RHIDE

5.4 Problems with C++ programs
==============================

Because GDB cannot handle correct C++ debugging information you will have
many problems when debugging C++ programs to get the contents of a
variable when it is a member of a class. Because GDB does not detect, that
your program is a C++ program, it sees it as a normal C program and so GDB
does nothing know about classes and all what have to do with it.

For accessing the member of a baseclass you must do some tricks. Let me
explain it on an example:

     class A
     {
     public:
       int a;
     };
     
     class B : public A
     {
     public:
       void test();
     };
     
     void B::test()
     {
       fprintf(stdout,"%d\n",a);
     }

If you debug the program in the function `B::test()' and you want to get
the contents of the member `a', you have to access it with `this->A.a' !!!
That means: At first you must access all members with the implicit `this'
variable and at second you must give all baseclasses until that, where the
member was declared.


File: rhide.info,  Node: Using Breakpoints,  Prev: Problems with C++ programs,  Up: Debugging with RHIDE

5.5 Using Breakpoints
=====================

Breakpoints are a very usefull thing when debugging a program. You can set
a breakpont at any location of your program and run it. It will be
automatically stopped, if the program execution reaches the breakpoint.

* Menu:

* Setting a breakpoint::
* Modifying and setting a breakpoint::
* Problems with breakpoints::


File: rhide.info,  Node: Setting a breakpoint,  Next: Modifying and setting a breakpoint,  Prev: Using Breakpoints,  Up: Using Breakpoints

5.5.1 Setting a breakpoint
--------------------------

For setting a breakpoint there are two different ways. The first is by
setting a breakpoint at any line by pressing <Ctrk+F8> . You will see,
that there is a breakpoint set, that this line is shown in an other color.
If you hit <Ctrl+F8>  on a line, which has already a breakpoint, the
breakpoint at this line is removed.


File: rhide.info,  Node: Modifying and setting a breakpoint,  Next: Problems with breakpoints,  Prev: Setting a breakpoint,  Up: Using Breakpoints

5.5.2 Modifying and setting a breakpoint
----------------------------------------

The second way is by setting a breakpoint with the breakpoint dialog which
is selectable only from the menu. There you will see any breakpoint for
your program. These breakpoints can be modified now in many things.  In
this dialog you can enable/disable a breakpoint. This is not the same as
deleting and resetting it. If you disable a brekpoint, it is stored
internal but it is not used. If you enable it again all the sttings for
that breakpoint, which you have already made, are remembered.

In the breakpoint dialog you can also set or delete a breakpoint with the
given buttons. If you want to set a new breakpoint, use the New-Button.
Then you will get a dialog which you also get when you press the
Modify-Button. In this dialog you can change many things of the breakpoint.

In this dialog is the only point for setting a breakpoint at a specified
function. For doing this you must set at first the type of the breakpoint
to Function. Then you can type in the function inputline the name of the
function or hit <Ctrl+F1>

to get a list of functions which are available from where you can select
one with <Enter>.

For setting a breakpoint at a specified line, set the breakpoint type to
Line and type in the filename and the linenumber.

The next what you can modify on a breakpoint is a condition. That means
that the breakpoint should stop your program only, if the condition is
true. Write the condition in the programming language of your source file
and you can use any accessable variable and you can call also functions of
the debugged program. For other information about the syntax see *Note
Conditions: (gdb.inf)Conditions.

And at last you can give your breakpoints also a count. A breakpoint count
is a number, how often this breakpoint is ignored. That means, if you type
there for example 10, then the RHIDE stops the execution of the program
only, if it comes to that point the 10th time. WARNING: This count is set
by RHIDE only once. After the breakpoint is realy hit, from now on the
breakpoint stops your program every time, the breakpoint is reached.


File: rhide.info,  Node: Problems with breakpoints,  Prev: Modifying and setting a breakpoint,  Up: Using Breakpoints

5.5.3 Problems with breakpoints
-------------------------------

Currently there is a big problem, when you have set a breakpoint at a line
(not at a function) of your program and you edit now the source code. If
you insert or delete some lines the breakpoints, which are set at lines
after or at the modified lines are NOT updated to the correct line number.


File: rhide.info,  Node: Debugging with RHGDB,  Next: Some FAQs,  Prev: Debugging with RHIDE,  Up: Top

6. Debugging with RHGDB
***********************

In addition to RHIDE, which has an integrated debugger, there is also a
standalone debugger called RHGDB. (The name comes from my initials and GDB)

RHGDB has the same aibilities like RHIDE for debugging your program. But
it has no editor. The source files are shown in read only windows where
you can move the curser and other things (except editing) like in RHIDE.

The menu tree is anolog to RHIDE but (of course) it has not all the menu
entries of RHIDE, becuse RHGDB should be used only for debugging and
nothing else.

I have written it to debug DJGPP programs, for which there is no RHIDE
project file available but the program has debugging information and, if
you are small of memory, it is much smaller than RHIDE.

The syntax for using RHGDB is very simple. Run it with your program as the
first argument followed by any argument, which should be passed to your
program.

RHGDB saves and reads the options from files with the suffix `.rgd'.  This
done automatacly when you run RHGDB with your program as argument by
searching a file with the same basename of your program and the suffix
`.rgd' and in this file the options are also automaticaly stored, when you
exit RHGDB.

Alternatively you can also save/read the options from within RHIDE by
selecting the corresponding menu entries from the Options menu.

To use the the "Dual display debugging" feature of RHGDB you must give on
commandline the `-D' switch.


File: rhide.info,  Node: Some FAQs,  Next: Index,  Prev: Debugging with RHGDB,  Up: Top

7. Some FAQs
************

**Question*: I have enabled the `Use tabs' option, but if I move the
cursor through that tab, it seems, that RHIDE uses spaces*

*Answer*:This behaviour cannot (currently) not changed. Even when you have
enabled the use of real tabs (charcaters with the code 9), the cursor is
moved like as there are spaces.

**Question*: If I write an ALL UPPERCASE TEXT while pressing down the shift
key and typing the characters, the SPACE key is not recognized*

*Answer*: This correct, because RHIDE uses as default the key combination
<Shift+Space> for executing a Pseudo Macro (*Note Defining macros::).  If
you don't like this behaviour, or when you also want to change some other
keybindings, please read in the documentation about the editor, how you
can configure the keybindings.

see *Note Documentation about the keyboard: (editor.inf)Keyboard,

**Question*: Are there any sample project files, to show how RHIDE works?*

*Answer*:The sources of RHIDE include many project files to rebuild at
least RHIDE with itself and many others.

**Question*: I have written some libraries. How can I use them in a
project?*

**Question*: How I can use a library, which I got?*

*Answer*: There are some different ways to do this. On the one side you can
include them directly in the project with the *Add to project item*
function (*Note Add item::). But if they are not in the current directory,
you must also set the library search path to the directory, where they
are. (*Note Library directories::). The other variant is to include them
in the list of libraries. (*Note Libraries::)

If this library is created with RHIDE, that means you have a project file
for building this library you can also simply include that project file in
you project. For examples look at the RHIDE sources in the project file
for RHIDE.

**Question*: I have a directory, where all my include files are. Can I
setup RHIDE to have this directory every time in the include search path,
when creating a new project?*

**Question*: I prefer the 80x28 video mode over the default 80x25 mode.
How I can turn this mode on by default for all newly created project
files?*

*Answer*: You can create a default project file. From this file RHIDE reads
all the options, if it creates a new project. The default project must
have the same basename as the executable of RHIDE and must be located in
the same directory.

The creation of such a default project file is very simple. Change to the
directory, where `rhide.exe' is located and run there
rhide rhide

Now make any changes in the options which you want to have as default for
all new created projects. This includes also settings in the various
search paths. If you are ready, exit RHIDE and this project file will be
your default project file.

**Question*: I know, that I can create a default project file. Can I
create and use more than one?*

*Answer*:Since DJGPP supports a quasi-Unix-like link for executables, you
can create such a link also for RHIDE. As an example I will create a link
to `rhide.exe' with the name `myrhide.exe'. At first I have to create the
new file.
     stubify -g myrhide.exe
Now I must tell `myrhide.exe' which program it really should run.
     stubedit myrhide.exe runfile=rhide
Thats all. Or, if you have installed the GNU fileutils, you can use also
now the `ln.exe' program to create the link:
     ln -s rhide.exe myrhide.exe

**Question*: I don't want to type every time I start RHIDE the commandline
-L DE to use the german user interface. Is there any better way?*

*Answer*: Create an environment variable LANGUAGE with your preferred
language like
     set LANGUAGE=de
and your problem is solved.

**Question*: I have 4 Mb RAM in my computer and every time, when I compile
large files with optimizations enabled, my hard disk is working very hard.*

*Answer*:Buy more RAM!

**Question*: I heard something about a newer version RHIDE. From where I
can get exact information about this?*

*Answer*: See at the RHIDE home page, at this URL:

     http://www.tu-chemnitz.de/~rho/rhide.html

.  This page contains the latest news and the latest version of RHIDE.

**Question*: I have a lot of money and don't know what to do with it. Can
you help me?*

*Answer*: Send it to me, so I can spend more time for developing RHIDE. My
Address is:
     Robert Hhne
     Am Berg 3
     D-09573 Dittmannsdorf
     Germany

**Question*: I think, I found a bug in RHIDE. How can I report it?*

*Answer*:At first try for your own to solve the problem by checking the
documentation.  See at the RHIDE home page, at this URL:

     http://www.tu-chemnitz.de/~rho/rhide.html

, if this problem was already reported by other users. As the next ask the
problem in the news group comp.os.msdos.djgpp Newsgroup, because there may
be some other people with the same problem, and they can give you an
answer or I, because I read this group also.

If this don't help you, do the following:

     Try to reproduce the error with the smallest possible project or
     source file. Run RHIDE with all debugging options enabled and redirect
     the printed output to a file. (*Note Debugging RHIDE::) Send me this
     file and a detailed as possible description of the problem and
     include in your report the exact version of RHIDE you are using.

     The exact version is shown in the About-Dialog and means the version
     number together with the build date.


