#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	resize

#ifdef PDCDEBUG
char *rcsid_resize = "$Header: C:\CURSES\nonport\RCS\resize.c 2.1 1993/06/18 20:22:14 MH Rel MH $";
#endif




/*man-start*********************************************************************

  resize()	- Resizes PDCurses; Changes video text size if necessary.

  PDCurses Description:
 	Does necessary initializations for the PDCurses package when
 	doing screen size changes. The user is responsible for
 	deleting and/or resizing windows after this call is made.

 	See the call _resize_win().

 	WARNING: This routine deallocated the existing stdscr, curscr
 	and modifies LINES, COLS and other internal PDCurses
 	variables.

  PDCurses Return Value:
 	The resize() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function before calling initscr().
 	Also, an error will be generated if we fail to create a newly
 	sized replacement window for curscr, or stdscr.
 	This will typically happen when increasing the window size.

 	NOTE:  If this happens, the previously successfully allocated
 	windows are left alone.  i.e. The resize is NOT cancelled for
 	those windows.

  PDCurses BUGS:

 	At this time, there is no support for any 40-column screen modes.

  Portability:
 	PDCurses	int	resize( int newlines );

**man-end**********************************************************************/

int	resize(int newlines)
{
	WINDOW*	tmp;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("resize() - called: newlines %d\n",newlines);
#endif

	if (stdscr == (WINDOW *)NULL)
		return(ERR);

#ifdef	FLEXOS
	/*
	 * Under FlexOS, this is functionally equivalent to a recallable
	 * initscr() because FlexOS does not yet support determination of
	 * screen fonts and therefore font loading and therefore text mode
	 * screen resolution changes...
	 */
	return( ERR );
#endif

#if defined(DOS)
	switch (_cursvar.adapter)
	{
	case _EGACOLOR:
		if (newlines >= 43)		PDC_set_font(_FONT8);
		else				PDC_set_80x25();
		break;

	case _VGACOLOR:
		if	(newlines > 28)		PDC_set_font(_FONT8);
		else	if (newlines > 25)	PDC_set_font(_FONT14);
		else				PDC_set_80x25();
		break;

	default:
		break;
	}
#endif

#ifdef     OS2
	if (newlines >= 43)		PDC_set_font(_FONT8);
	else	if (newlines > 25)	PDC_set_font(_FONT14);
	else				PDC_set_80x25();
#endif

	_cursvar.lines = LINES = PDC_get_rows();
	_cursvar.cols  = COLS  = PDC_get_columns();

	if (curscr->_pmaxy > LINES)
	{
		PDC_scroll(0, 0, curscr->_pmaxy - 1, COLS - 1, 0, _cursvar.orig_attr);
	}
	else
	{
		PDC_scroll(0, 0, LINES - 1, COLS - 1, 0, _cursvar.orig_attr);
	}
	if ((tmp = resize_win(curscr, LINES, COLS)) != (WINDOW *) NULL)
	{
		curscr = tmp;
	}
	else
	{
		return (ERR);
	}
	if ((tmp = resize_win(stdscr, LINES, COLS)) != (WINDOW *) NULL)
	{
		stdscr = tmp;
		touchwin(stdscr);
		wnoutrefresh(stdscr);
	}
	else
	{
		return (ERR);
	}
	return (OK);
}
