#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	setscrreg

#ifdef PDCDEBUG
char *rcsid_setscrrg = "$Header: C:\CURSES\portable\RCS\setscrrg.c 2.1 1993/06/18 20:21:08 MH Rel MH $";
#endif




/*man-start*********************************************************************

  setscrreg()	- set scrolling region

  X/Open Description:	setscrreg(), wsetscrreg()
 	These functions allow the suer to set a software scrolling region
 	in a window.  The parameters 'top' and 'bot' are the line numbers
 	of the top and bottom margin of the scrolling region.  (Line 0 is
 	the top line of the window.)  If this option and scrollok() are
 	enabled, an attempt to move off the bottom margin will cause all
 	lines in the scrolling region to scroll up one line.  Only the
 	text of the window is scrolled.

  PDCurses Description:
 	PDCurses implements the standard OK and ERR return values.

 	FYI: setscrreg() is also defined as a macro.

  X/Open Return Value:
 	No return values are defined for these functions.

  PDCurses Errors:
 	It is an error to pass a NULL WINDOW pointer.
 	The top and bottom coordinates must be inside the passed window
 	and must bound the window's cursor position.  e.g.  The cursor
 	cannot be above or below the top or bottom margins.

  Portability:
 	PDCurses	int setscrreg( int top, int bottom );
 	X/Open Dec '88	int setscrreg( int top, int bottom );
 	SysV Curses	int setscrreg( int top, int bottom );
 	BSD Curses	int setscrreg( int top, int bottom );

**man-end**********************************************************************/

int	setscrreg(int top, int bottom)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("setscrreg() - called: top %d bottom %d\n",top,bottom);
#endif

	if (stdscr == (WINDOW *)NULL)
		return (ERR);

	if ((0 <= top) &&
	    (top <= stdscr->_cury) &&
	    (stdscr->_cury <= bottom) &&
	    (bottom < LINES))
	{
		stdscr->_tmarg = top;
		stdscr->_bmarg = bottom;
		return (OK);
	}
	else
	{
		return (ERR);
	}
}
