{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; registration of objects

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBIO, EFLIBDAT;


type MyObjectType = object (DataObjectType)
                    constructor StreamLoad (Stream : pointer);
                    procedure StreamStore (Stream : pointer); virtual;
                    { Implementation of a data type (currently abstract) }
                    end;


const { Registration record for the object type; required to support stream
        storage. The identity must not be the same as any previously reg-
        istered object. Object identity is used to identify objects that
        are stored in streams. Wrong identity numbers may result in fatal
        errors. }
      MyObjectRegistration : RegisterType = (Identity     : 1000; { Specific ID number }
                                             { Addresses of object VMT, load constructor
                                               and store method. }
                                             VMTAddress   : Ofs(TypeOf(MyObjectType)^);
                                             LoadAddress  : @MyObjectType.StreamLoad;
                                             StoreAddress : @MyObjectType.StreamStore);

{ Loads (constructs) the object from a stream }
constructor MyObjectType.StreamLoad (Stream : pointer);
var Storage : StreamObjectPointerType absolute Stream;
begin
     { Load any object specific data;
       Storage^.Write (SpecificData, SizeOf(SpecificData)); }
     Inherited StreamLoad (@Storage); { Call inherited load constructor }
     InitializeVMT; { Override VMT; must be done }
end;

{ Stores the object to a stream for later reconstruction }
procedure MyObjectType.StreamStore (Stream : pointer);
var Storage : StreamObjectPointerType absolute Stream;
begin
     { Store any object specific data;
       Storage^.Read (SpecificData, SizeOf(SpecificData)); }
     Inherited StreamStore (@Storage); { Call inherited store constructor }
end;


{ Registration example }

var MyType : MyObjectType;

begin
     MyType.Initialize;

     { Register a new object type }
     Register.Register (@MyObjectRegistration);

     { Verify registration }
     if Register.IsRegistered(@MyType) then WriteLn ('Your type is registered.')
        else WriteLn ('Your type has not been registered for stream storage.');

     { Write the identity number for the registered object }
     WriteLn ('Object is registered with the ID ', Register.WhatIdentity(@MyType), ' (zero = not registered).');

     MyType.Intercept;
end.