{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; linked lists

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBWIN, EFLIBDAT, EFLIBTXT, EFLIBKBD;


const ListEntries = 13;

var MyWindow : WindowObjectType;
    MyList1,
    MyList2  : LinkedListObjectType;
    Data     : string[60];
    Index    : word;



begin
     with MyWindow do begin
          { Initialize a text window }
          InitializeWindow (1, 1, 80, 25, '', NoBorder, FALSE, FALSE);
          SetTextCoordinates (3, 3, 78, 24);

          WriteLn ('@C@@LightGreen:Blue@* Linked lists *');
          WriteLn ('@C@@White:Blue@All data types have many common features. Linked lists are equiped');
          WriteLn ('@C@with specific features like active sorting, binary searching and more.');
          WriteLn ('@Yellow:Blue@'); LineFeed;


          MyList1.InitializeList (SizeOf(Data),      UnsortedOrder,
                                  { Element size }   { Sort order (none) }
                                  TRUE,              FALSE);
                                  { Faster access }  { Reversed access }

          Randomize;

          { Generate a linked list containing randomly generated strings }
          for Index := 1 to ListEntries do begin
              Data := StringGeneratedRandomly (Pred(SizeOf(Data)));
              MyList1.Add (Data);
          end;

          Index := 0; { Reset counter }

          { Do a task for each entry; write all entries on the screen }
          with MyList1.CreateIterator^ do begin { Allocate iterator object }
               repeat
                     Inc (Index);
                     MyWindow.WriteLn ('['+StringNumber(Index, 2, 0)+']     : ' + String(Content^));
                     WalkForward; { Next element }
               until IsEnd;
               Free; { Iterator }
          end;

          WriteLn ('@White:Blue@');
          WriteLn ('[Intact]  :  ' + StringBoolean (MyList1.IsIntact));
          WriteLn ('[Errors]  :  ' + StringBoolean (GlobalErrorFlag or GlobalDataError));

          { Intercept objects (and dispose all entries from the heap) }
          MyList1.Intercept;

          repeat until Keyboard.KeyPressed;

          Intercept;
     end;
end.