{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; Euler's step method and Heun's method

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBMTH, EFLIBBAS, EFLIBTXT;


const Iterations = 1000; { Number of iterations -
                           larger value gives better precision in results }
      Decimals   = 5;    { Number of decimals in evaluation }

var Expression : string; Result : real;

{ Returns y'(x) there y is the function that should be solved }
function Derivate (x, y : real) : real; far;
begin
     Derivate := EvaluateXYZ (Expression, X, Y, 0, Decimals);
end;

begin
     { Expression to solve }
     Expression := 'x+y';

     { Euler's step method }
     EulersStepMethod (0, 1, Iterations, 2, Result, @Derivate);
     WriteLn ('Eulers step method: y''=x+y; y''(0)=2 => y(1)',Result:4:4,' with ', Iterations:0,' iterations.');

     WriteLn;
     { Heun's method }
     HeunsMethod (0, 1, Iterations, 2, Result, @Derivate);
     WriteLn ('Heuns method: y''=x+y; y''(0)=2 => y(1)',Result:4:4,' with ', Iterations:0,' iterations.');

     WriteLn;
end.