{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Testing; polymorphic duplication of data types

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBBAS, EFLIBDAT;

var Data1, Data2 : DataObjectPointerType;
    SomeData : string;


begin
     { Initialize a linked list }
     Data1 := New(LinkedListObjectPointerType,
              InitializeList (SizeOf(String), UnsortedOrder, TRUE, FALSE));
                             { Element size } { Sort order }  { Settings }

     { Add some data }
     SomeData := 'First element';  Data1^.Add (SomeData);
     SomeData := 'Second element'; Data1^.Add (SomeData);
     SomeData := 'Third element';  Data1^.Add (SomeData);
     SomeData := 'Forth element';  Data1^.Add (SomeData);

     { Duplicate first data type into a new array list }
     Data2 := New(ArrayListObjectPointerType, InitializeDuplicate (Data1));

     Data1^.Free; { Dispose the first data type (the linked list) }

     WriteLn ('* Duplicated linked data into an array *');

     { Create a iterator and perform a task with all elements }
     with Data2^.CreateIterator^ do begin
          repeat
                WriteLn (String(Content^));
                WalkForward;
          until IsEnd;
          Free; { Iterator }
     end;

     Data2^.Free; { Dispose the second data type (the array list) }
end.