
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994 Stefan Milius                }
{                                                       }
{*******************************************************}

{
  GVWinNum.TXT GVWinNum.DOC GINFO.TXT GINFO.DOC NEW.TXT GV.VER
}

Unit GVWinNum;

{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-}

interface

uses Drivers;

  function GetWindowNumber(PrefNum: Integer): Integer;
  procedure FreeWindowNumber(AWindowNumber: Integer);

  function GetNumberFromEvent(Event: TEvent; EventType: Byte): Integer;

const

{ Event types for GetNumberFromEvent }

  etAltNumKeys = 1;
  etNumberKeys = 2;
  etFuncKeys   = 3;
  etAltFunc    = 4;
  etCtrlFunc   = 5;
  etShiftFunc  = 6;

implementation

uses Views;

const WindowNums: Word = 0;

function GetWindowNumber(PrefNum: Integer): Integer;
var I: Word;
    C: Byte;
Begin
  GetWindowNumber := wnNoNumber;
  If PrefNum = wnNoNumber then Exit
  Else If (PrefNum < 10) and (WindowNums and (1 shl (PrefNum-1)) = 0) then Begin
    WindowNums := WindowNums or (1 shl (PrefNum-1));
    Exit;
  End
  Else Begin
    I := 1;
    C := 1;
    While C < 10 do Begin
      If WindowNums and I = 0 then Begin
        WindowNums := WindowNums or I;
        GetWindowNumber := C;
        Exit;
      End;
      I := I shl 1;
      Inc(C);
    End
  End
End;

procedure FreeWindowNumber(AWindowNumber: Integer);
Begin
  If (AWindowNumber = wnNoNumber) or (AWindowNumber >= 10) then Exit;
  WindowNums := WindowNums and not (1 shl (AWindowNumber-1));
End;

function GetNumberFromEvent(Event: TEvent; EventType: Byte): Integer;
var Num: Integer;
Begin
  GetNumberFromEvent := wnNoNumber;
  If Event.What <> evKeyBoard then Exit;
  Case EventType of
    etAltNumKeys: Num := Ord(GetAltChar(Event.KeyCode)) - Ord('1') + 1;
    etNumberKeys: Num := Ord(Event.CharCode) - Ord('1') + 1;
    etFuncKeys  : Num := (Event.KeyCode - kbF1) shr 8 + 1;
    etAltFunc   : Num := (Event.KeyCode - kbAltF1) shr 8 + 1;
    etCtrlFunc  : Num := (Event.KeyCode - kbCtrlF1) shr 8 + 1;
    etShiftFunc : Num := (Event.KeyCode - kbShiftF1) shr 8 + 1;
   else Exit;
  End;
  If (Num > 9) or (Num < 1) then Exit;
  GetNumberFromEvent := Num;
End;

End.

