{ͻ
                      M.R.E (MOS RESOURCE EDITOR) v2.4                      
 ͹
                  UNITE DE GESTION DE L'ACTION DES BOUTONS                  
 ͹
  Coded by Zuul as BouFFtou as Cheveau Frdric.                            
  Programm  Toulouse COG (Gendarmerie) sur Turbo Pascal v7.00.            
  Contact us on 36.15 RTEL1 - Bal "BouFFtou" or Bal "ICF".                  
 ͼ}

Unit MRE_ACTS;                           {*Nom du l'Unit*}

Interface

Uses MOS_BAS,
     MOS_ASM,                            {*Gestion des Instructions ASM*}
     MOS_MSE,                            {*Gestion de la Souris*}
     MOS_TOO,                            {*Gestion des Tools et Box*}
     MOS_GAD,                            {*Gestion des Gadgets*}
     MOS_REQ,                            {*Gestion des Requesters*}
     MOS_MEN,                            {*Gestion des Menus*}
     MOS_WIN,                            {*Gestion des Fentres*}
     MOS_DIR,                            {*Gestion du Directory*}
     Crt,Dos,
     Graph;

Const Esp='                                                                ';
      Bev_Style=1;                       {*Def Const pour Bevels Entries*}
      Bev_Coul=6;

      Max_TBB=20;                        {*Define Maximum for Array Gadgets*}
      Max_TSB=20;
      Max_TXT=20;
      Max_TBU=20;
      Max_TCY=10;
      Max_TRB=30;
      Max_TSL=10;
      Max_TCO=10;

Type Window0=Record
    X1,Y1,X2,Y2  :Integer;
    Xu,Yu,Xv,Yv  :Integer;               {*2nd Coordones Window for Extend*}
    XMin,YMin    :Integer;               {*Taille minimum de la Fentre*}
    XMax,YMax    :Integer;               {*Taille maximum de la Fentre*}
    Name         :String;                {*Name de la Fentre*}
    IDCMP        :Word;                  {*Flags IDCMP Window*}
    IDRES        :Word;                  {*Flags IDCMP Window*}
    BarSld       :Integer;               {*Nb Sliders Hz or Vertical ou None*}
    Coul         :Integer;               {*Couleur de Fond de la Fentre*}
    End;

    TBevel=Record                        {*Struct pour Bevel et String Box*}
    X1,Y1,X2,Y2:Integer;
    Style,Co:Integer;
    Cave,Fill:Boolean;
    End;

    TText=Record                         {*Struct pour Labels Textes*}
    X1,Y1:Integer;
    CP,CB:Integer;
    Cin:String[42];
    TyF,SiF:Byte;
    End;

    TButG=Record                         {*Record Buttons*}
    X1,Y1,SX,SY:Integer;
    Freeze:Boolean;
    VanillaKey :Byte;
    Action:Byte;
    Cin:String;
    B:ButG;
    End;

    TRad=Record                          {*Record Radios*}
    X1,Y1:Integer;
    Freeze:Boolean;
    Group:Byte;
    R:Rad;
    End;

    TSlide=Record                        {*Record Sliders*}
    X1,Y1,X2,Y2:Integer;
    S:Slide;
    End;

    TTCoReq=Record                       {*Record Commands*}
    X1,Y1:Integer;
    Freeze:Boolean;
    Cin:String;
    T:TCoReq;
    End;

Var W            :Win;                   {*Structure Fentre*}
    W0           :Window0;               {*Stocke Value Window*}
    Gad_Exist    :Boolean;               {*Gadgets Exists*}
    NUndo        :Byte;                  {*Numro de l'Undo*}
    Qtt_Pro      :Byte;                  {*Quantit de Projets ds la Fentre*}
    Num_Pro      :Byte;                  {*Numro du Projet Actuel*}

    Gen_Prog     :Boolean;               {*Genre Programme Entier*}
    Gen_Rem      :Boolean;               {*Genre Remarques dans Prog*}
    Gen_Menu     :Boolean;               {*Genre le Code pour le Menu*}
    Opt_Source   :Boolean;               {*Optimize Source*}
    Show_Report  :Boolean;               {*Show Report when save Source*}
    Full_Simul   :Boolean;               {*Full Simulation when Message*}

    Name_Prog    :String[30];            {*Nom du Programme*}
    Name_Proc    :String[30];            {*Nom de la Procdure*}
    Save_FileName:String[12];            {*Nom Sauvegarde Projet*}
    Nom_Undo     :String[12];            {*Nom du Fichier Undo*}
    Xold,Yold    :Word;                  {*Ancienne position souris*}
    OPos,OType   :Integer;               {*Old Type & Item Selected by Mouse*}
    NPos,NType   :Integer;               {*New Type et Pos dans Liste*}

    Lb1          :LightB;                {*Structure Light_Box*}
    Item         :Byte;                  {*Type de Gadget Utilis Actuellement*}
    My_Grid      :Boolean;               {*Pour Redfinir Grid Quand je Veux*}
    Has_Changed  :Word;                  {*Bits de Projets Modifis ?*}
    Disp_Beep    :Boolean;               {*Display Beep if Msg*}
    Show_MCoo    :Boolean;               {*Show Mouse Coordones*}
    WSizeX,WSizeY:Integer;               {*Taille Window de Test X et Y*}

    Qtt_ITM      :Array[1..8] of Byte;   {*Quantit de Chaque Gadgets*}

    Pos_ITM      :Array[1..8] of Shortint;   {*Position dans Tableau pour Gadgets*}

    TBU   :Array[1..Max_TBU] Of TButG;   {*Tableau Boutons*}
    TCY   :Array[1..Max_TCY] Of TButG;   {*Tableau Cyclers*}
    TRB   :Array[1..Max_TRB] Of TRad;    {*Tableau Radio Boxes*}
    TSL   :Array[1..Max_TSL] Of TSlide;  {*Tableau Sliders*}
    TCO   :Array[1..Max_TCO] Of TTCoReq; {*Tableau Command Strings*}
    TBB   :Array[1..Max_TBB] Of TBevel;  {*Tableau Bevels Boxes*}
    TSB   :Array[1..Max_TSB] Of TBevel;  {*Tableau String Boxes*}
    TXT   :Array[1..Max_TXT] Of TText;   {*Tableau Labels Texte*}

Var Menu:TMenu;                         {*Menu Temporaire et Menu dfinitif*}
    Qtt_Menu:Byte;                      {*Nombre de Menus et Labels ds Menu*}
    Menu_Num,Point_Num:Byte;            {*Menu Label et Menu Point Courant*}
    Qtt_MenuP:Array[1..Max_Menu_Points] of Byte;{*Nb de Points dans Menus*}

{============================================================================}

Type RFileR=Record                       {*Record File Requester*}
    X1,Y1,Sv:Integer;
    Name    :String[100];
    OkBut   :String[16];
    Mask    :String[6];
    Style   :Byte;
    SendToCom:Boolean;
    FPath,FName,FSize:Byte;
    End;

Type RPalR=Record                        {*Record Palette Requester*}
    X1,Y1   :Integer;
    Name    :String[100];
    ColSel  :Byte;
    End;

Type RMemR=Record                        {*Record Memory Requester*}
    X1,Y1   :Integer;
    Name    :String[100];
    End;

Type RHardR=Record                       {*Record Hardware Requester*}
    X1,Y1   :Integer;
    Name    :String[100];
    End;

Type RSysR=Record                        {*Record System Requester*}
    X1,Y1   :Integer;
    Name    :String[100];
    SMosIni :Boolean;
    End;

Type REzR=Record                         {*Record EZ Requester*}
    Title   :String[100];
    Phrase  :String;
    Gadget  :String[150];
    TestRes :Boolean;
    BCenter :Boolean;
    NumIco  :Byte;
    End;

Type RFntR=Record                        {*Record Font Requester*}
    X1,Y1   :Integer;
    Name    :String[100];
    Font_Sel:Integer;
    Size_Sel:Integer;
    End;

Type RAttrR=Record                       {*Record Attrib Requester*}
    X1,Y1   :Integer;
    Name    :String[150];
    End;

Type RStR=Record                         {*Record String Requester*}
    Name    :String[150];
    Txt,Gad :String;
    Str     :String;
    NbChar  :Integer;
    Size    :Integer;
    TestRes :Boolean;
    BCenter :Boolean;
    NumIco  :Byte;
    End;

Type RVaR=Record                         {*Record Value Requester*}
    Name    :String[150];
    Txt,Gad :String;
    BMin,BMax:Longint;
    Vai     :Longint;
    TestRes :Boolean;
    BCenter :Boolean;
    NumIco  :Byte;
    End;

Type RProR=Record                        {*Record Progress Requester*}
    Name    :String[150];
    Explain :String[150];
    Cob     :Integer;
    End;

Type RSldR=Record                        {*Record Slider->Command*}
    ComNum  :Integer;
    End;

Var Proc_Name    :String;                {*Nom de la Proc  Appeler*}
    RFileV       :RFileR;                {*Type pour Record*}
    RPalV        :RPalR;
    RMemV        :RMemR;
    RhardV       :RHardR;
    RSysV        :RSysR;
    REzV         :REzR;
    RFntV        :RFntR;
    RAttrV       :RAttrR;
    RStV         :RStR;
    RVaV         :RVaR;
    RProV        :RProR;
    RSldV :Array[1..MAX_TSL] of RSldR;   {*Tableau Sliders Actions*}
    M            :TMenu;                 {*Gestion des Menus de MRE*}

{============================================================================}

Procedure BUTTON_ACTION(Pos:Byte);       {*Menu pour l'action des Boutons*}

Procedure ASK_SLIDER_TO_COMMAND(Pos:Integer);{*Def Slider to Command*}
Procedure TIC;                           {*Fait un tic (son)*}
Procedure SET_PNAME_IN_MENU(FName:String);{*Modif Title Menu Projet*}
Procedure SAVE_PROJECT(Mode:Byte);       {*Mode: 0=Normal, 1=Update*}
Procedure CREATE_UNDO;                   {*Fait un Fichier UNDO*}
Function  PUISS(X,Exponent:Word):Word;   {*Fonction PUISSANCE d'un Nombre*}

Implementation

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

{ͻ
                               PROCEDURE PUISS                              
 ͹
  MET A LA PUISSANCE PRECISEE PAR EXPONENT LE NOMBRE X.                     
 ͼ}

Function PUISS(X,Exponent:Word):Word;
Var A,Res:Integer;
Begin
If Exponent=0 Then Begin PUISS:=1; Exit; End;
Res:=1;
For A:=1 to Exponent do Res:=Res*X;
PUISS:=Res;
End;

{ͻ
                               PROCEDURE TIC                                
 ͹
                   FAIT UN TIC QUAND ON APPELE LA PROCEDURE                 
 ͼ}

Procedure TIC;
Begin
If Disp_Beep=No Then Exit;
Sound(20);
Delay(10);
NoSound;
End;

{ͻ
                         PROCEDURE SET_PNAME_IN_MENU                        
 ͹
  MET DANS LE TITRE DU MENU LE NOM DU PROJET .MRE COURRANT...               
 ͼ}

Procedure SET_PNAME_IN_MENU(FName:String);
Var FD           :DirStr;               {*For FSplit... and .TMP*}
    FN           :NameStr;
    FE           :ExtStr;
Begin
FSplit(FName, FD, FN, FE);
M.TbMen[8,1]:='Project: '''+FN+'.MRE''';
End;

{ͻ
                         SAUVEGARDE PROJET EN DATAS                         
  Mode : 2 = Sauvegarde ".TMP" pour MultiProjets                            
 ͼ}

Procedure ASAVE_PROJECT(Mode:Byte);      {*Mode: 0=Normal, 1=Update, 2=Undo*}
Var DirSel,FilSel,FName:String;
    Size         :Longint;
    F            :Text;
    NUM,A,B,Code :Integer;

Begin
FilSel:=Save_FileName;                  {*FileName Courrant*}
DirSel:=Get_Current_Drawer+'\';
If (Mode=0) Or ((FilSel='') And (Mode>=1))
   Then Begin DirSel:='';               {*Mode "Save" With New Name*}
   Get_FileDir(50,32,282,Loc(653),Loc(460),'*.MRE',0,DirSel,FilSel,Size);
   End;

If FilSel<>'' Then Begin
   If Mode=2 Then FName:=DirSel+FilSel  {*Concatne pour Projet ".TMP"*}
      Else Begin
      A:=Pos('.',FilSel);               {*Search if Suffix Exist*}
      If A=0 Then FilSel:=FilSel+'.MRE';{*Append Suffix at Last*}
      FName:=DirSel+FilSel;             {*Concatne Nom*}
      End;
   If (Test_File_Exist(FName)) And (Mode=0) Then Begin
      Num:=3;                           {*Icne Question*}
      EZ_RequestG(Loc(461),Loc(654),Loc(463),Num);
      If Num<>1 Then Exit;              {*Fichier dja Existant !!!*}
      End;

   If Pos('\\',FName)>0 Then Delete(FName,3,1);{*Enlve 1 '\' sur les 2 car Root*}

   Assign(F,FName);
   {$I-}
   Rewrite(F);                          {*Create and Open File*}
   {$I+}
   If IOResult=0 Then Begin             {*No Errors ? => Ok !*}
      Set_Pointer(P_Busy);
      Save_FileName:=FilSel;            {*Redfinit Nom Fichier Sauvegarde*}
      SET_PNAME_IN_MENU(FilSel);        {*Update Title Menu Current Projet*}

{      M.TbMen[8,1]:='Project: '''+FilSel+'''';}

      Writeln(F,'MRE v2.4 data file.');
      Writeln(F,Loc(655));
      Writeln(F,Loc(656));
      Writeln(F);

      Writeln(F,Name_Prog);             {*Ecriture Source Prefs*}
      Writeln(F,Name_Proc);
      Writeln(F,Gen_Prog);
      Writeln(F,Gen_Rem);
      Writeln(F,Opt_Source);
      Writeln(F,Show_Report);
      Writeln(F,Full_Simul);
      Writeln(F,HaF1);                  {*Write Hauteur Fonte pour Update*}
      Writeln(F);

      Writeln(F,'1');                   {*Write Window Parameters*}
      Writeln(F,W.X1);
      Writeln(F,W.Y1);
      Writeln(F,W.X2);
      Writeln(F,W.Y2);
      Writeln(F,W.IDCMP);
      Writeln(F,W.Name);
      Writeln(F,W.Xu);
      Writeln(F,W.Yu);
      Writeln(F,W.Xv);
      Writeln(F,W.Yv);
      Writeln(F,W.XMin);
      Writeln(F,W.YMin);
      Writeln(F,W.XMax);
      Writeln(F,W.YMax);
      Writeln(F,W.BarSld);
      Writeln(F,W.Coul);
      Writeln(F,W.IDRES);
      Writeln(F);
      Writeln(F);

      Writeln(F,Qtt_ITM[6]);
      For A:=1 to Qtt_ITM[6] do Begin   {*Write Bevel Boxes Parameters*}
      Writeln(F,TBB[A].X1);
      Writeln(F,TBB[A].Y1);
      Writeln(F,TBB[A].X2);
      Writeln(F,TBB[A].Y2);
      Writeln(F,TBB[A].Style);
      Writeln(F,TBB[A].Co);
      Writeln(F,TBB[A].Cave);
      Writeln(F,TBB[A].Fill);
      End;
      Writeln(F);

      Writeln(F,Qtt_ITM[7]);
      For A:=1 to Qtt_ITM[7] do Begin   {*Write String Boxes Parameters*}
      Writeln(F,TSB[A].X1);
      Writeln(F,TSB[A].Y1);
      Writeln(F,TSB[A].X2);
      Writeln(F,TSB[A].Y2);
      Writeln(F,TSB[A].Style);
      Writeln(F,TSB[A].Co);
      Writeln(F,TSB[A].Cave);
      End;
      Writeln(F);

      Writeln(F,Qtt_ITM[8]);
      For A:=1 to Qtt_ITM[8] do Begin   {*Write Texts Parameters*}
      Writeln(F,TXT[A].X1);
      Writeln(F,TXT[A].Y1);
      Writeln(F,TXT[A].CB);
      Writeln(F,TXT[A].CP);
      Writeln(F,TXT[A].Cin);
      End;
      Writeln(F);

      Writeln(F,Qtt_ITM[1]);
      For A:=1 to Qtt_ITM[1] do Begin   {*Write Buttons Parameters*}
      Writeln(F,TBU[A].X1);
      Writeln(F,TBU[A].Y1);
      Writeln(F,TBU[A].SX);
      Writeln(F,TBU[A].SY);
      Writeln(F,TBU[A].Freeze);
      Writeln(F,TBU[A].B.CoB);
      Writeln(F,TBU[A].B.CoP);
      Writeln(F,TBU[A].B.Lock);
      Writeln(F,TBU[A].VanillaKey);
      Writeln(F,TBU[A].Action);
      Writeln(F,TBU[A].B.TCT[1]);
      End;
      Writeln(F);

      Writeln(F,Qtt_ITM[2]);
      For A:=1 to Qtt_ITM[2] do Begin   {*Write Cyclers Parameters*}
      Writeln(F,TCY[A].X1);
      Writeln(F,TCY[A].Y1);
      Writeln(F,TCY[A].SX);
      Writeln(F,TCY[A].SY);
      Writeln(F,TCY[A].B.CyclVal);
      Writeln(F,TCY[A].B.CoB);
      Writeln(F,TCY[A].B.CoP);
      Writeln(F,TCY[A].B.Lock);
      Writeln(F,TCY[A].Freeze);
      Writeln(F,TCY[A].Cin);
      End;
      Writeln(F);

      Writeln(F,Qtt_ITM[3]);
      For A:=1 to Qtt_ITM[3] do Begin   {*Write Radios Parameters*}
      Writeln(F,TRB[A].X1);
      Writeln(F,TRB[A].Y1);
      Writeln(F,TRB[A].R.Style);
      Writeln(F,TRB[A].R.Status);
      Writeln(F,TRB[A].Freeze);
      Writeln(F,TRB[A].Group);
      End;
      Writeln(F);

      Writeln(F,Qtt_ITM[4]);
      For A:=1 to Qtt_ITM[4] do Begin   {*Write Sliders Parameters*}
      Writeln(F,TSL[A].X1);
      Writeln(F,TSL[A].Y1);
      Writeln(F,TSL[A].X2);
      Writeln(F,TSL[A].Y2);
      Writeln(F,TSL[A].S.Qtt);
      Writeln(F,TSL[A].S.Aff);
      Writeln(F,TSL[A].S.Psl);
      Writeln(F,TSL[A].S.Typ);
      Writeln(F,TSL[A].S.GDep);
      End;
      Writeln(F);

      Writeln(F,Qtt_ITM[5]);
      For A:=1 to Qtt_ITM[5] do Begin   {*Write Commands Parameters*}
      Writeln(F,TCO[A].X1);
      Writeln(F,TCO[A].Y1);
      Writeln(F,TCO[A].T.Siz);
      Writeln(F,TCO[A].T.Len);
      Writeln(F,TCO[A].T.CoB);
      Writeln(F,TCO[A].T.Co2);
      Writeln(F,TCO[A].T.Sty);
      Writeln(F,TCO[A].Freeze);
      Writeln(F,TCO[A].Cin);
      End;
      Writeln(F);

      {======================================================================}

      Writeln(F,Proc_Name);             {*Ecriture Nom Proc  Appeller*}
      Writeln(F);

      Writeln(F,RFileV.X1);             {*Write File Requester Values*}
      Writeln(F,RFileV.Y1);
      Writeln(F,RFileV.Sv);
      Writeln(F,RFileV.Name);
      Writeln(F,RFileV.OkBut);
      Writeln(F,RFileV.Mask);
      Writeln(F,RFileV.Style);
      Writeln(F,RFileV.FPath);
      Writeln(F,RFileV.FName);
      Writeln(F,RFileV.FSize);
      Writeln(F,RFileV.SendToCom);
      Writeln(F);

      Writeln(F,RPalV.X1);              {*Write Palette Requester Values*}
      Writeln(F,RPalV.Y1);
      Writeln(F,RPalV.Name);
      Writeln(F,RPalV.ColSel);
      Writeln(F);

      Writeln(F,RMemV.X1);              {*Write Memory Requester Values*}
      Writeln(F,RMemV.Y1);
      Writeln(F,RMemV.Name);
      Writeln(F);

      Writeln(F,RHardV.X1);             {*Write Hardware Requester Values*}
      Writeln(F,RHardV.Y1);
      Writeln(F,RHardV.Name);
      Writeln(F);

      Writeln(F,RSysV.SMosIni);         {*Write System Requester Values*}
      Writeln(F,RSysV.X1);
      Writeln(F,RSysV.Y1);
      Writeln(F,RSysV.Name);
      Writeln(F);

      Writeln(F,REzV.Title);            {*Write EZ Requester*}
      Writeln(F,REzV.Phrase);
      Writeln(F,REzV.Gadget);
      Writeln(F,REzV.TestRes);
      Writeln(F,REzV.BCenter);
      Writeln(F);

      Writeln(F,RFntV.X1);              {*Write Font Requester*}
      Writeln(F,RFntV.Y1);
      Writeln(F,RFntV.Name);
      Writeln(F,RFntV.Font_Sel);
      Writeln(F,RFntV.Size_Sel);
      Writeln(F);

      Writeln(F,RAttrV.X1);             {*Write Attrib Requester*}
      Writeln(F,RAttrV.Y1);
      Writeln(F,RAttrV.Name);
      Writeln(F);

      Writeln(F,RStV.Name);             {*Write String Requester*}
      Writeln(F,RStV.Txt);
      Writeln(F,RStV.Gad);
      Writeln(F,RStV.Str);
      Writeln(F,RStV.NbChar);
      Writeln(F,RStV.Size);
      Writeln(F,RStV.TestRes);
      Writeln(F,RStV.BCenter);
      Writeln(F);

      Writeln(F,RVaV.Name);             {*Write Value Requester*}
      Writeln(F,RVaV.Txt);
      Writeln(F,RVaV.Gad);
      Writeln(F,RVaV.BMin);
      Writeln(F,RVaV.BMax);
      Writeln(F,RVaV.Vai);
      Writeln(F,RVaV.TestRes);
      Writeln(F,RVaV.BCenter);
      Writeln(F);

      Writeln(F,RProV.Name);            {*Write Progress Requester*}
      Writeln(F,RProV.Explain);
      Writeln(F,RProV.Cob);
      Writeln(F);

      For A:=1 to Max_TSL do Writeln(F,RSldV[A].ComNum);
      Writeln(F);                       {*Write Command to Slider*}

      {======================================================================}

      Writeln(F,Gen_Menu);              {*Ecriture des Paramtres du Menu*}
      Writeln(F,Qtt_Menu);              {*Write Qtt Menus*}
      For A:=1 to Qtt_Menu do Writeln(F,Qtt_MenuP[A]);{*Write Qtt Menu Labels*}
      Writeln(F);

      For A:=1 to Qtt_Menu do
         For B:=1 to Qtt_MenuP[A]+1 do
            Writeln(F,Menu.TbMen[A,B]);
      Writeln(F);

      {======================================================================}

      If Mode<2 Then BCLR(Has_Changed,Num_Pro); {*Rinit Modifications Potentielles*}

      Close(F);                         {*Ferme le Fichier*}
      Set_Pointer(P_Current);
      End
      Else Begin
      Num:=1;                           {*Icne Warning*}
      EZ_RequestG(Loc(461),Loc(657),Loc(469),NUM);
      End;
   End;
End;
{***********************}
{***********************}
{***********************}
{***********************}
{ͻ
                         SAUVEGARDE PROJET EN DATAS                         
  Mode : 2 = Sauvegarde ".TMP" pour MultiProjets                            
 ͼ}

Procedure SAVE_PROJECT(Mode:Byte);      {*Mode: 0=Normal, 1=Update, 2=Undo*}
Var DirSel,FilSel,FName:String;
    Size         :Longint;
    F            :File;
    NUM,A,B,Code :Integer;
    St           :String;

Begin
FilSel:=Save_FileName;                  {*FileName Courrant*}
DirSel:=Get_Current_Drawer+'\';
If (Mode=0) Or ((FilSel='') And (Mode>=1))
   Then Begin DirSel:='';               {*Mode "Save" With New Name*}
   Get_FileDir(50,32,282,Loc(653),Loc(460),'*.MRE',0,DirSel,FilSel,Size);
   End;

If FilSel<>'' Then Begin
   If Mode=2 Then FName:=DirSel+FilSel  {*Concatne pour Projet ".TMP"*}
      Else Begin
      A:=Pos('.',FilSel);               {*Search if Suffix Exist*}
      If A=0 Then FilSel:=FilSel+'.MRE';{*Append Suffix at Last*}
      FName:=DirSel+FilSel;             {*Concatne Nom*}
      End;
   If (Test_File_Exist(FName)) And (Mode=0) Then Begin
      Num:=3;                           {*Icne Question*}
      EZ_RequestG(Loc(461),Loc(654),Loc(463),Num);
      If Num<>1 Then Exit;              {*Fichier dja Existant !!!*}
      End;

   If Pos('\\',FName)>0 Then Delete(FName,3,1);{*Enlve 1 '\' sur les 2 car Root*}

   Assign(F,FName);
   {$I-}
   Rewrite(F,1);                        {*Create and Open File*}
   {$I+}
   If IOResult=0 Then Begin             {*No Errors ? => Ok !*}
      Set_Pointer(P_Busy);
      Save_FileName:=FilSel;            {*Redfinit Nom Fichier Sauvegarde*}
      SET_PNAME_IN_MENU(FilSel);        {*Update Title Menu Current Projet*}

      St:=Loc(482)+Chr(10)+Chr(13); BlockWrite(F,St,21);
      St:=Loc(655)+Chr(10)+Chr(13); BlockWrite(F,St,35);
      St:=Loc(656)+Chr(10)+Chr(13); BlockWrite(F,St,43);
                                        {*Ecriture Source Prefs*}
      BlockWrite(F,Name_Prog,30);
      BlockWrite(F,Name_Proc,30);
      BlockWrite(F,Gen_Prog,1);
      BlockWrite(F,Gen_Rem,1);
      BlockWrite(F,Opt_Source,1);
      BlockWrite(F,Show_Report,1);
      BlockWrite(F,Full_Simul,1);
      BlockWrite(F,HaF1,2);             {*Write Hauteur Fonte pour Update*}
      BlockWrite(F,W,Sizeof(W));        {*Write Window Parameters*}

      For B:=1 to 8 do Begin            {*Write Main Gadgets*}
         BlockWrite(F,Qtt_ITM[B],1);    {*Qtt of Gadgets*}
         For A:=1 to Qtt_ITM[B] do
            Case B of
               1: BlockWrite(F,TBU[A],Sizeof(TBU[A]));{*Write Buttons Parameters*}
               2: BlockWrite(F,TCY[A],Sizeof(TCY[A]));{*Write Cyclers Parameters*}
               3: BlockWrite(F,TRB[A],Sizeof(TRB[A]));{*Write Radios Parameters*}
               4: BlockWrite(F,TSL[A],Sizeof(TSL[A]));{*Write Sliders Parameters*}
               5: BlockWrite(F,TCO[A],Sizeof(TCO[A]));{*Write Commands Parameters*}
               6: BlockWrite(F,TBB[A],Sizeof(TBB[A]));{*Write Bevel Boxes Parameters*}
               7: BlockWrite(F,TSB[A],Sizeof(TSB[A]));{*Write String Boxes Parameters*}
               8: BlockWrite(F,TXT[A],Sizeof(TXT[A]));{*Write Texts Parameters*}
               End;
         End;

      {======================================================================}

      BlockWrite(F,Proc_Name,256);      {*Ecriture Nom Proc  Appeller*}

      BlockWrite(F,RFileV,Sizeof(RFileV));{*Write File Requester Values*}
      BlockWrite(F,RPalV,Sizeof(RPalV));{*Write Palette Requester Values*}
      BlockWrite(F,RMemV,Sizeof(RMemV));{*Write Memory Requester Values*}
      BlockWrite(F,RHardV,Sizeof(RHardV));{*Write Hardware Requester Values*}
      BlockWrite(F,RSysV,Sizeof(RSysV));{*Write System Requester Values*}
      BlockWrite(F,REzV,Sizeof(REzV));  {*Write EZ Requester Values*}
      BlockWrite(F,RFntV,Sizeof(RFntV));{*Write Font Requester Values*}
      BlockWrite(F,RAttrV,Sizeof(RAttrV));{*Write Attrib Requester Values*}
      BlockWrite(F,RStV,Sizeof(RStV));  {*Write String Requester Values*}
      BlockWrite(F,RVaV,Sizeof(RVaV));  {*Write Value Requester Values*}
      BlockWrite(F,RProV,Sizeof(RProV));{*Write Progress Requester Values*}

      For A:=1 to Max_TSL do BlockWrite(F,RSldV[A].ComNum,1);{*Write Command to Slider*}

      {======================================================================}

      BlockWrite(F,Gen_Menu,1);         {*Ecriture des Paramtres du Menu*}
      BlockWrite(F,Qtt_Menu,1);         {*Write Qtt Menus*}

      For A:=1 to Qtt_Menu do Begin
         BlockWrite(F,Qtt_MenuP[A],1);  {*Write Qtt Menu Labels*}
         For B:=1 to Qtt_MenuP[A]+1 do
            BlockWrite(F,Menu.TbMen[A,B],Max_Length_Points); {*Write Labels*}
         End;

      {======================================================================}

      If Mode<2 Then BCLR(Has_Changed,Num_Pro); {*Rinit Modifications Potentielles*}

      Close(F);                         {*Ferme le Fichier*}
      Set_Pointer(P_Current);
      End
      Else Begin
      Num:=1;                           {*Icne Warning*}
      EZ_RequestG(Loc(461),Loc(657),Loc(469),NUM);
      End;
   End;
End;

{ͻ
                           PROCEDURE CREATE_UNDO                            
 ͼ}

Procedure CREATE_UNDO;
Var PName:String;                       {*Sauvegarde nom du Projet*}
    Px:Integer;
Begin
PName:=Save_FileName;                   {*Backup of Project Name*}
{gotoxy(1,1); writeln('-',Save_Filename);}
Save_FileName:='MRE.U00';               {*Name of The Undo File*}
SAVE_PROJECT(2);                        {*Sauvegarde Automatique Boulot+Undo*}
Save_FileName:=PName;                   {*Restaure Nom Projet*}
Px:=Pos('.TMP',PName);
If Px>0 Then PName:=Copy(PName,1,Px)+'MRE';
M.TbMen[8,1]:='Project: '''+PName+'''';
{gotoxy(1,2); writeln('*',M.TbMen[8,1]);}
End;

{ͻ
                          PROCEDURE SELECT_SPICON                           
 ͼ}

Function SELECT_SPICON(Sp:Byte):Byte;
Const TN:Array[1..6] of String[12]=('I_WARN.ICO','I_STOP.ICO','I_QUEST.ICO','I_INFORM.ICO','I_BOMB.ICO','.ICO');
Var W1            :Win;                 {*Window Structure*}
    Even          :Byte;                {*Get Windows Evens*}
    Cancel        :Boolean;             {*Annulation Flag*}
    Exit_Flg      :Boolean;             {*Exit Flag*}
    But1,But2,But3:ButG;                {*Buttons Structure*}
    Cyc1          :ButG;                {*Cyclers Structure*}
    OldSp         :Byte;                {*Old Value for Sp Icon*}

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure DRAW_SPICON;
Begin
Clip_Window(On,W1);                     {*Clipping Window*}
Button( LaF*31, HaF*5+1,LaF*7,0,7,False,But1,'D:\MOS\SYSTEM\'+TN[Cyc1.CyclVal]);
Clip_Window(Off,W1);                    {*Restore Normal Clipping*}
End;

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Begin
Clip_Window(On,W1);                     {*Clipping Window*}
String_Box( LaF*4, HaF*3+1, LaF*42, HaF*10+1,1,6,False);
String_Box( LaF*10, HaF*2+1, LaF*36, HaF*3+6,1,3,False);
Bevel( LaF*29, HaF*4+6, LaF*40, HaF*9+1,1,7,False,True);
SetColor(15);
DispG( LaF*16, HaF*2+3,3,Loc(442));

Button( LaF*6, HaF*11+6,LaF*14,0,7,False,But2,'  _OK  ');
Button( LaF*25, HaF*11+6,LaF*14,0,7,False,But3,Loc(13));
Cycler( LaF*6, HaF*5+6,LaF*17,Cyc1.CyclVal,0,7,Cyc1,Loc(853));
Clip_Window(Off,W1);                    {*Restore Normal Clipping*}
DRAW_SPICON;
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
Init_Window(200,99,200+LaF*46,99+HaF1+HaF*13+7,$51D9,Loc(441),W1);
Sup_Window(100,50,250,200,79,60,639,479,0,5,$0A00,W1);{*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Draw_Window(W1);                        {*Display Window*}

Cyc1.CyclVal:=Sp;
OldSp:=Sp;                              {*Store Values*}

REDRAW_FRAME;                           {*Display Window Content*}
Exit_Flg:=False;                        {*Init Exit Flag*}
Cancel:=False;

Repeat;
Main_Task;                              {*Manage System*}
If Window_Ready(W1) Then                {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Clip_Window(On,W1);                  {*Clipping Window*}
   If GetMsg_Button(But2,1) Then Exit_Flg:=True;
   If GetMsg_Button(But3,1) Then Cancel:=True;
   If GetMsg_Button(Cyc1,1) Then DRAW_SPICON;
   Clip_Window(Off,W1);                 {*Restore Normal Clipping*}
   End;

Even:=Active_Window(W1);                {*Get Windows Evens*}
If Even=1 Then Cancel:=True;            {*Window Closed   => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until (Exit_Flg) Or (Cancel);           {*Exit Flag*}

Kill_Window(W1);                        {*Close Window if Needs*}
If Not Cancel Then SELECT_SPICON:=Cyc1.CyclVal
              Else SELECT_SPICON:=OldSp;
End;

{ͻ
                           PROCEDURE ASK_FONTREQ                            
 ͹
           DEMANDE A L'UTILISATEUR DE DEFINIR UN REQUESTER DE FONTE         
 ͼ}

Procedure ASK_FONTREQ;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But1,But2     :ButG;                {*Structure Boutons*}
    Com1,Com2,Com3,
    Com4,Com5     :TCoReq;              {*Structure Commands*}
    Cin1,Cin2,Cin3,
    Cin4,Cin5     :String;              {*Strings pour Commands*}
    Code          :Integer;
    Cancel        :Boolean;             {*Annulation Modif*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4+1, HaF*2+7, LaF*31+4,HaF*8+5,1,6,False);
String_Box( LaF*34+1,HaF*2+7, LaF*71+4,HaF*8+5,1,6,False);
String_Box( LaF*8+1, HaF*1+7, LaF*27+4,HaF*3+2,1,3,False);
String_Box( LaF*40+1,HaF*1+7, LaF*65+4,HaF*3+2,1,3,False);
String_Box( LaF*4,   HaF*10+1,LaF*72,  HaF*13+6,1,6,False);
String_Box( LaF*26,  HaF*9+1, LaF*50,  HaF*10+6,1,3,False);
SetColor(0);
DispG( LaF*14,HaF*4+2,6,Loc(658));
DispG( LaF*36,HaF*4+2,6,Loc(659));
DispG( LaF*36,HaF*6+2,6,Loc(660));
DispG( LaF*6, HaF*11+7,6,Loc(661));
DispG( LaF*14,HaF*6+2,6,Loc(662));
SetColor(15);
DispG( LaF*44,  HaF*1+9,3,Loc(663));
DispG( LaF*13,  HaF*1+9,3,Loc(603));
DispG( LaF*30+1,HaF*9+2,3,Loc(664));

Button( LaF*16, HaF*15+1,LaF*16,0,7,False,But1,'_OK');
Button( LaF*44, HaF*15+1,LaF*16,0,7,False,But2,Loc(13));
Command( LaF*6, HaF*4+2,LaF*6,10,12,13,0,$26,Com1,Cin1);
Command( LaF*6, HaF*6+2,LaF*6,10,12,13,0,$26,Com2,Cin2);
Command( LaF*63,HaF*4+2,LaF*6,3,2,1,0,$26,Com3,Cin3);
Command( LaF*63,HaF*6+2,LaF*6,3,2,1,0,$26,Com4,Cin4);
Command( LaF*14,HaF*11+6,LaF*54,255,4,11,0,$27,Com5,Cin5);
Freeze_Command(On,Com3); Freeze_Command(On,Com4);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Init_Window(80,75,80+LaF*76,75+HaF1+HaF*17+1,$59D9,Loc(665),W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Str(RFntV.X1,Cin1);                     {*Load Font Values*}
Str(RFntV.Y1,Cin2);
Cin5:=RFntV.Name;
Str(RFntV.Font_Sel,Cin3);
Str(RFntV.Size_Sel,Cin4);

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=False; Cancel:=False;         {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Perso*}
   If GetMsg_Button(But1,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But2,1)=True Then Cancel:=True;
   GetMsg_Command(Com1,Cin1);
   GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com3,Cin3);
   GetMsg_Command(Com4,Cin4);
   GetMsg_Command(Com5,Cin5);
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=True) Or (Cancel=True); {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=False Then Begin              {*Save Values*}
   Val(Cin1,RFntV.X1,Code);
   Val(Cin2,RFntV.Y1,Code);
   RFntV.Name:=Cin5;
   Val(Cin3,RFntV.Font_Sel,Code);
   Val(Cin4,RFntV.Size_Sel,Code);
   End;
End;

{ͻ
                           PROCEDURE ASK_MEMORY                             
 ͹
          DEMANDE A L'UTILISATEUR DE DEFINIR UN REQUESTER DE MEMOIRE        
 ͼ}

Procedure ASK_MEMORY;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But1,But2     :ButG;                {*Structure Boutons*}
    Com1,Com2,Com3:TCoReq;              {*Structure Commands*}
    Cin1,Cin2,Cin3:String;              {*Strings pour Commands*}
    Num           :Integer;             {*Gestion Rponses Requesters*}
    Code          :Integer;
    Cancel        :Boolean;             {*Annulation Changements*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4+1, HaF*2+7, LaF*31+4, HaF*8+5,1,6,False);
String_Box( LaF*34+1,HaF*2+7, LaF*71+4, HaF*6+5,1,6,False);
String_Box( LaF*8+1, HaF*1+7, LaF*27+4, HaF*3+2,1,3,False);
String_Box( LaF*40+1,HaF*1+7, LaF*65+4, HaF*3+2,1,3,False);
SetColor(0);
DispG( LaF*14, HaF*4+2,6,Loc(658));
DispG( LaF*14, HaF*6+2,6,Loc(662));
SetColor(15);
DispG( LaF*45+1,HaF*1+9,3,Loc(664));
DispG( LaF*13,  HaF*1+9,3,Loc(603));

Button( LaF*16, HaF*10+1,LaF*16,0,7,False,But1,'_OK');
Button( LaF*44, HaF*10+1,LaF*16,0,7,False,But2,Loc(13));
Command( LaF*6, HaF*4+2, LaF*6,10,12,13,0,$27,Com1,Cin1);
Command( LaF*6, HaF*6+2, LaF*6,10,12,13,0,$26,Com2,Cin2);
Command( LaF*36,HaF*4+2, LaF*34,100,4,11,0,$26,Com3,Cin3);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Init_Window(80,75,80+LaF*76,75+HaF1+HaF*12+1,$59D9,Loc(666),W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Str(RMemV.X1,Cin1);                     {*Init Memory Values*}
Str(RMemV.Y1,Cin2);
Cin3:=RMemV.Name;

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=False; Cancel:=Off;           {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Perso*}
   If GetMsg_Button(But1,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But2,1)=True Then Cancel:=True;
   GetMsg_Command(Com1,Cin1);
   GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com3,Cin3);
   End;

Even:=Active_Window(W1);
If Even=1 Then Exit_Flg:=True;          {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=True) Or (Cancel=True); {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=False Then Begin
   Val(Cin1,RMemV.X1,Code);                  {*Save Memory Values*}
   Val(Cin2,RMemV.Y1,Code);
   RMemV.Name:=Cin3;
   End;
End;

{ͻ
                          PROCEDURE ASK_HARDWARE                            
 ͹
           DEMANDE A L'UTILISATEUR DE DEFINIR UN REQUESTER HARDWARE         
 ͼ}

Procedure ASK_HARDWARE;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But1,But2     :ButG;                {*Structure Boutons*}
    Com1,Com2,Com3:TCoReq;              {*Structure Commands*}
    Cin1,Cin2,Cin3:String;              {*Strings pour Commands*}
    Code          :Integer;
    Cancel        :Boolean;

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4+1, HaF*2+7, LaF*31+4, HaF*8+5,1,6,False);
String_Box( LaF*34+1,HaF*2+7, LaF*71+4, HaF*6+5,1,6,False);
String_Box( LaF*8+1, HaF*1+7, LaF*27+4, HaF*3+2,1,3,False);
String_Box( LaF*40+1,HaF*1+7, LaF*65+4, HaF*3+2,1,3,False);
SetColor(0);
DispG( LaF*14, HaF*4+2,6,Loc(658));
DispG( LaF*14, HaF*6+2,6,Loc(662));
SetColor(15);
DispG( LaF*45+1,HaF*1+9,3,Loc(664));
DispG( LaF*13,  HaF*1+9,3,Loc(603));

Button( LaF*16,HaF*10+1,LaF*16,0,7,False,But1,'_OK');
Button( LaF*44,HaF*10+1,LaF*16,0,7,False,But2,Loc(13));
Command(LaF*6, HaF*4+2,LaF*6,10,12,13,0,$27,Com1,Cin1);
Command(LaF*6, HaF*6+2,LaF*6,10,12,13,0,$26,Com2,Cin2);
Command(LaF*36,HaF*4+2,LaF*34,100,4,11,0,$26,Com3,Cin3);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Init_Window(80,75,80+LaF*76,75+HaF1+HaF*12+1,$59D9,Loc(667),W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Str(RHardV.X1,Cin1);                    {*Init Hardware Values*}
Str(RHardV.Y1,Cin2);
Cin3:=RHardV.Name;

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=False; Cancel:=False;         {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Perso*}
   If GetMsg_Button(But1,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But2,1)=True Then Cancel:=True;
   GetMsg_Command(Com1,Cin1);
   GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com3,Cin3);
   End;

Even:=Active_Window(W1);
If Even=1 Then Exit_Flg:=True;          {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=True) Or (Cancel=True); {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=False Then Begin              {*Save Hardware Values*}
   Val(Cin1,RHardV.X1,Code);
   Val(Cin2,RHardV.Y1,Code);
   RMemV.Name:=Cin3;
   End;
End;

{ͻ
                           PROCEDURE ASK_PALETTE                            
 ͹
          DEMANDE A L'UTILISATEUR DE DEFINIR UN REQUESTER DE PALETTE        
 ͼ}

Procedure ASK_PALETTE;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg,Cancel:Boolean;            {*Flag de Sortie*}
    But1,But2     :ButG;                {*Structure Boutons*}
    Com1,Com2,Com3,
    Com4          :TCoReq;              {*Structure Commands*}
    Cin1,Cin2,Cin3,
    Cin4          :String;              {*Strings pour Commands*}
    Code          :Integer;

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4+1, HaF*2+7, LaF*31+4, HaF*8+5,1,6,False);
String_Box( LaF*34+1,HaF*2+7, LaF*71+4, HaF*8+5,1,6,False);
String_Box( LaF*8+1, HaF*1+7, LaF*27+4, HaF*3+2,1,3,False);
String_Box( LaF*40+1,HaF*1+7, LaF*65+4, HaF*3+2,1,3,False);
SetColor(0);
DispG( LaF*14, HaF*4+2,6,Loc(658));
DispG( LaF*14, HaF*6+2,6,Loc(662));
DispG( LaF*36, HaF*6+2,6,Loc(668));
SetColor(15);
DispG( LaF*45+1,HaF*1+9,3,Loc(664));
DispG( LaF*13,  HaF*1+9,3,Loc(603));

Button( LaF*16,HaF*10+1,LaF*16,0,7,False,But1,'_OK');
Button( LaF*44,HaF*10+1,LaF*16,0,7,False,But2,Loc(13));
Command(LaF*6, HaF*4+2,LaF*6,10,12,13,0,$27,Com1,Cin1);
Command(LaF*6, HaF*6+2,LaF*6,10,12,13,0,$26,Com2,Cin2);
Command(LaF*36,HaF*4+2,LaF*34,100,4,11,0,$26,Com3,Cin3);
Command(LaF*64,HaF*6+2,LaF*6,100,2,1,0,$26,Com4,Cin4);
Freeze_Command(On,Com4);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Init_Window(110,65,110+LaF*76,65+HaF1+HaF*12+1,$59D9,Loc(669),W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Str(RPalV.X1,Cin1);                     {*Get Values*}
Str(RPalV.Y1,Cin2);
Cin3:=RPalV.Name;
Cin4:='0';

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=False; Cancel:=False;         {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Perso*}
   If GetMsg_Button(But1,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But2,1)=True Then Cancel:=True;
   GetMsg_Command(Com1,Cin1);
   GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com3,Cin3);
   GetMsg_Command(Com4,Cin4);
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=True) Or (Cancel=True); {*Flags de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=False Then Begin              {*Save Values*}
   Val(Cin1,RPalV.X1,Code);
   Val(Cin2,RPalV.Y1,Code);
   RPalV.Name:=Cin3;
   End;
End;

{ͻ
                           PROCEDURE ASK_FILEREQ                            
 ͹
         DEMANDE A L'UTILISATEUR DE DEFINIR UN REQUESTER DE DIRECTORY       
 ͼ}

Procedure ASK_FILEREQ;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But1,But2     :ButG;                {*Structure Boutons*}
    Cyc1          :ButG;                {*Structure Cyclers*}
    Rad1,Rad2     :Rad;                 {*Structure Radios*}
    Com1,Com2,Com3,
    Com4,Com5,Com6,
    Com7,Com8,Com9:TCoReq;              {*Structure Commands*}
    Cin1,Cin2,Cin3,
    Cin4,Cin5,Cin6,
    Cin7,Cin8,Cin9:String;              {*Strings pour Commands*}
    Code          :Integer;
    Cancel        :Boolean;             {*Annulation*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure FREEZE_COM1;
Begin
If Rad1.Status=On Then Begin
   Freeze_Command(Off,Com7); Freeze_Command(Off,Com8); Freeze_Command(Off,Com9);
   End Else Begin
   Freeze_Command(On,Com7); Freeze_Command(On,Com8); Freeze_Command(On,Com9);
   End;
End;

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4+1, HaF*2+7, LaF*31+4, HaF*10+5,1,6,False);
String_Box( LaF*34+1,HaF*2+7, LaF*71+4, HaF*10+5,1,6,False);
String_Box( LaF*8+1, HaF*1+7, LaF*27+4, HaF*3+2,1,3,False);
String_Box( LaF*44+1,HaF*1+7, LaF*61+4, HaF*3+2,1,3,False);
String_Box( LaF*4+1, HaF*11+2,LaF*71+4, HaF*16+5,1,6,False);
SetColor(0);
DispG( LaF*14, HaF*4+2,6,Loc(658));
DispG( LaF*14, HaF*6+2,6,Loc(662));
DispG( LaF*14, HaF*8+2,6,Loc(670));
DispG( LaF*52, HaF*6+2,6,Loc(671));
DispG( LaF*52, HaF*8+2,6,Loc(672));
DispG( LaF*46, HaF*11+7,6,Loc(673));
DispG( LaF*46, HaF*13+2,6,Loc(674));
DispG( LaF*46, HaF*14+7,6,Loc(675));
DispG( LaF*30, HaF*11+7,6,Loc(676));
DispG( LaF*32, HaF*14+7,6,Loc(80));
DispG( LaF*39, HaF*14+7,6,Loc(81));
DispG( LaF*8+3,HaF*12+2,6,Loc(677));
SetColor(15);
DispG( LaF*49+1,HaF*1+9,3,Loc(678));
DispG( LaF*13,  HaF*1+9,3,Loc(603));

Button( LaF*16,HaF*18+1,LaF*16,0,7,False,But1,'_OK');
Button( LaF*44,HaF*18+1,LaF*16,0,7,False,But2,Loc(13));
Cycler( LaF*8, HaF*14+1,LaF*14+2,Cyc1.CyclVal,0,7,Cyc1,Loc(679));
Radio_Box( LaF*32, HaF*13+1,2,Rad1.Status,Rad1);
Radio_Box( LaF*38, HaF*13+1,2,Rad2.Status,Rad2);
Command( LaF*6, HaF*4+2, LaF*6,10,12,13,0,$27,Com1,Cin1);
Command( LaF*6, HaF*6+2, LaF*6,10,12,13,0,$26,Com2,Cin2);
Command( LaF*6, HaF*8+2, LaF*6,10,12,13,0,$26,Com3,Cin3);
Command( LaF*36,HaF*4+2, LaF*34,100,4,11,0,$26,Com4,Cin4);
Command( LaF*36,HaF*6+2, LaF*14,100,4,11,0,$26,Com5,Cin5);
Command( LaF*36,HaF*8+2, LaF*10,100,4,11,0,$26,Com6,Cin6);
Command( LaF*64,HaF*11+7,LaF*6,3,2,1,0,$26,Com7,Cin7);
Command( LaF*64,HaF*13+2,LaF*6,3,2,1,0,$26,Com8,Cin8);
Command( LaF*64,HaF*14+7,LaF*6,3,2,1,0,$26,Com9,Cin9);

FREEZE_COM1;
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Init_Window(110,65,110+LaF*76,65+HaF1+HaF*20+1,$51F9,Loc(680),W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

If RFileV.SendToCom=True
   Then Begin Rad2.Status:=False; Rad1.Status:=True; End
   Else Begin Rad2.Status:=True; Rad1.Status:=False; End;
Str(RFileV.X1,Cin1);
Str(RFileV.Y1,Cin2);
Str(RFileV.Sv,Cin3);
Cin4:=RFileV.Name;
Cin5:=RFileV.OkBut;
Cin6:=RFileV.Mask;
Cyc1.CyclVal:=RFileV.Style+1;
Str(RFileV.FPath,Cin7);
Str(RFileV.FName,Cin8);
Str(RFileV.FSize,Cin9);

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=False; Cancel:=Off;           {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Perso*}
   If GetMsg_Button(But1,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But2,1)=True Then Cancel:=True;
   GetMsg_Button(Cyc1,1);
   GetMsg_Command(Com1,Cin1);
   GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com3,Cin3);
   GetMsg_Command(Com4,Cin4);
   GetMsg_Command(Com5,Cin5);
   GetMsg_Command(Com6,Cin6);
   GetMsg_Command(Com7,Cin7);
   GetMsg_Command(Com8,Cin8);
   GetMsg_Command(Com9,Cin9);
   If GetMsg_Radio(Rad1,1) Then FREEZE_COM1;
   If GetMsg_Radio(Rad2,1) Then FREEZE_COM1;
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=False Then Begin              {*Save Values*}
   If Rad1.Status=True Then RFileV.SendToCom:=True
      Else RFileV.SendToCom:=False;
   Val(Cin1,RFileV.X1,Code);
   Val(Cin2,RFileV.Y1,Code);
   Val(Cin3,RFileV.Sv,Code);
   RFileV.Name:=Cin4;
   RFileV.OkBut:=Cin5;
   RFileV.Mask:=Cin6;
   RFileV.Style:=Cyc1.CyclVal-1;
   Val(Cin7,RFileV.FPath,Code);
   Val(Cin8,RFileV.FName,Code);
   Val(Cin9,RFileV.FSize,Code);
   End;
End;

{ͻ
                           PROCEDURE ASK_ATTRIB                             
 ͹
         DEMANDE A L'UTILISATEUR DE DEFINIR UN REQUESTER ATTRIB-FLAGS       
 ͼ}

Procedure ASK_ATTRIB;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But1,But2     :ButG;                {*Structure Boutons*}
    Com1,Com2,Com3:TCoReq;              {*Structure Commands*}
    Cin1,Cin2,Cin3:String;              {*Strings pour Commands*}
    Code          :Integer;
    Cancel        :Boolean;             {*Annulation Modifs*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4+1, HaF*2+7, LaF*31+4, HaF*8+5,1,6,False);
String_Box( LaF*34+1,HaF*2+7, LaF*71+4, HaF*6+5,1,6,False);
String_Box( LaF*8+1, HaF*1+7, LaF*27+4, HaF*3+2,1,3,False);
String_Box( LaF*40+1,HaF*1+7, LaF*65+4, HaF*3+2,1,3,False);
SetColor(0);
DispG( LaF*14, HaF*4+2,6,Loc(658));
DispG( LaF*14, HaF*6+2,6,Loc(662));
SetColor(15);
DispG( LaF*42+4,HaF*1+9,3,Loc(681));
DispG( LaF*13,  HaF*1+9,3,Loc(603));

Button( LaF*16,HaF*10+1,LaF*16,0,7,False,But1,'_OK');
Button( LaF*44,HaF*10+1,LaF*16,0,7,False,But2,Loc(13));
Command(LaF*6, HaF*4+2,LaF*6,10,12,13,0,$27,Com1,Cin1);
Command(LaF*6, HaF*6+2,LaF*6,10,12,13,0,$26,Com2,Cin2);
Command(LaF*36,HaF*4+2,LaF*34,100,4,11,0,$26,Com3,Cin3);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Init_Window(80,75,80+LaF*76,75+HaF1+HaF*12+1,$59D9,Loc(682),W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Str(RAttrV.X1,Cin1);                    {*Load Attrib Values*}
Str(RAttrV.Y1,Cin2);
Cin3:=RAttrV.Name;

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=False; Cancel:=False;         {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Perso*}
   If GetMsg_Button(But1,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But2,1)=True Then Cancel:=True;
   GetMsg_Command(Com1,Cin1);
   GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com3,Cin3);
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=False Then Begin
   Val(Cin1,RAttrV.X1,Code);            {*Save Attrib Values*}
   Val(Cin2,RAttrV.Y1,Code);
   RAttrV.Name:=Cin3;
   End;
End;

{ͻ
                           PROCEDURE ASK_SYSTEM                             
 ͹
           DEMANDE A L'UTILISATEUR DE DEFINIR UN REQUESTER SYSTEM           
 ͼ}

Procedure ASK_SYSTEM;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But1,But2     :ButG;                {*Structure Boutons*}
    Rad1          :Rad;                 {*Structure Radios*}
    Com1,Com2,Com3:TCoReq;              {*Structure Commands*}
    Cin1,Cin2,Cin3:String;              {*Strings pour Commands*}
    Code          :Integer;
    Cancel        :Boolean;             {*Annulation Modifs*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_DEFCOMMAND;            {*Dfinition Command*}
Begin
If Rad1.Status=On Then Cin3:='MOS.INI';
Command( W1.X1+LaF*36, W1.Y1+HaF1+HaF*4+2,LaF*34,100,4,11,0,$26,Com3,Cin3);
If Rad1.Status=On Then Freeze_Command(On,Com3)
                  Else Freeze_Command(Off,Com3);
End;

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4+1, HaF*2+7, LaF*31+4, HaF*8+5,1,6,False);
String_Box( LaF*34+1,HaF*2+7, LaF*71+4, HaF*8+5,1,6,False);
String_Box( LaF*8+1, HaF*1+7, LaF*27+4, HaF*3+2,1,3,False);
String_Box( LaF*40+1,HaF*1+7, LaF*65+4, HaF*3+2,1,3,False);
SetColor(0);
DispG( LaF*14, HaF*4+2,6,Loc(658));
DispG( LaF*14, HaF*6+2,6,Loc(662));
DispG( LaF*42, HaF*6+2,6,Loc(683));
SetColor(15);
DispG( LaF*43+3,HaF*1+9,3,Loc(684));
DispG( LaF*13,  HaF*1+9,3,Loc(603));

Button( LaF*16,HaF*10+1,LaF*16,0,7,False,But1,'_OK');
Button( LaF*44,HaF*10+1,LaF*16,0,7,False,But2,Loc(13));
Command(LaF*6, HaF*4+2,LaF*6,10,12,13,0,$27,Com1,Cin1);
Command(LaF*6, HaF*6+2,LaF*6,10,12,13,0,$26,Com2,Cin2);
Radio_Box( LaF*36, HaF*6+1,1,Rad1.Status,Rad1);
Clip_Window(Off,W1);

REDRAW_DEFCOMMAND;                      {*Dfinition Command*}
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Init_Window(80,75,80+LaF*76,75+HaF1+HaF*12+1,$59D9,Loc(685),W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Rad1.Status:=RSysV.SMosIni;
Str(RSysV.X1,Cin1);                     {*Init System Values*}
Str(RSysV.Y1,Cin2);
Cin3:=RSysV.Name;

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=False; Cancel:=Off;           {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Perso*}
   If GetMsg_Button(But1,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But2,1)=True Then Cancel:=True;
   If GetMsg_Radio(Rad1,1)=True Then REDRAW_DEFCOMMAND;
   GetMsg_Command(Com1,Cin1);
   GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com3,Cin3);
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=True) Or (Cancel=True); {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=False Then Begin              {*Save Values*}
   RSysV.SMosIni:=Rad1.Status;
   Val(Cin1,RSysV.X1,Code);
   Val(Cin2,RSysV.Y1,Code);
   RSysV.Name:=Cin3;
   End;
End;

{ͻ
                         PROCEDURE ASK_EZREQUESTER                          
 ͹
             DEMANDE A L'UTILISATEUR DE DEFINIR UN EZ REQUESTER             
 ͼ}

Procedure ASK_EZ_REQUESTER;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But1,But2,But3:ButG;                {*Structure Boutons*}
    Rad1,Rad2     :Rad;                 {*Structure Radios*}
    Com1,Com2,Com3:TCoReq;              {*Structure Commands*}
    Cin1,Cin2,Cin3:String;              {*Strings pour Commands*}
    Code          :Integer;
    Cancel        :Boolean;             {*Annulation Modifications*}
    VSp           :Byte;                {*Value Special Icon*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4, HaF*2+6, LaF*72, HaF*10+6,1,6,False);
String_Box( LaF*24,HaF*1+6, LaF*52, HaF*3+1,1,3,False);
String_Box( LaF*4, HaF*12+6,LaF*32, HaF*16+6,1,6,False);
String_Box( LaF*10,HaF*11+6,LaF*26, HaF*13+1,1,3,False);
String_Box( LaF*34,HaF*12+6,LaF*72, HaF*18+6,1,6,False);
String_Box( LaF*42,HaF*11+6,LaF*64, HaF*13+1,1,3,False);
SetColor(15);
DispG( LaF*28+4, HaF*1+8,3,Loc(686));
DispG( LaF*13+4, HaF*11+8,3,Loc(687));
DispG( LaF*45+1, HaF*11+8,3,Loc(688));
SetColor(0);
DispG( LaF*46, HaF*4+1,6,Loc(689));
DispG( LaF*42, HaF*16+2,6,Loc(690));
DispG( LaF*42, HaF*14+2,6,Loc(691));

Button( LaF*44,HaF*20+1,LaF*16,0,7,False,But1,Loc(13));
Button( LaF*16,HaF*20+1,LaF*16,0,7,False,But2,'_OK');
Button( LaF*7, HaF*14+1,LaF*22,0,7,False,But3,Loc(471));
Command(LaF*6, HaF*4+1,LaF*38,255,4,11,0,$27,Com1,Cin1);
Command(LaF*6, HaF*6+1,LaF*64,255,4,11,0,$26,Com2,Cin2);
Command(LaF*6, HaF*8+1,LaF*64,255,4,11,0,$26,Com3,Cin3);
Radio_Box( LaF*36,HaF*16+1,1,Rad1.Status,Rad1);
Radio_Box( LaF*36,HaF*14+1,1,Rad2.Status,Rad2);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Init_Window(110,65,110+LaF*76,65+HaF1+HaF*22+1,$59D9,Loc(692),W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Cin1:=REzV.Title;                       {*Init EZ Requester Values*}
Cin2:=REzV.Phrase;
Cin3:=REzV.Gadget;
Rad1.Status:=REzV.TestRes;
Rad2.Status:=REzV.BCenter;
VSp:=REzV.NumIco;

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=False; Cancel:=False;         {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Perso*}
   If GetMsg_Button(But1,1)=True Then Cancel:=True;
   If GetMsg_Button(But2,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But3,1)=True Then VSp:=SELECT_SPICON(VSp);
   GetMsg_Radio(Rad1,1);
   GetMsg_Radio(Rad2,1);
   GetMsg_Command(Com1,Cin1);
   GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com3,Cin3);
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=Off Then Begin
   REzV.Title:=Cin1;                    {*Save EZ Requester Values*}
   REzV.Phrase:=Cin2;
   REzV.Gadget:=Cin3;
   REzV.TestRes:=Rad1.Status;
   REzV.BCenter:=Rad2.Status;
   REzV.NumIco:=VSp;
   End;
End;

{ͻ
                      PROCEDURE ASK_STRING_REQUESTER                        
 ͹
          DEMANDE A L'UTILISATEUR DE DEFINIR UN REQUESTER DE STRING         
 ͼ}

Procedure ASK_STRING_REQUESTER;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But1,But2,But3:ButG;                {*Structure Boutons*}
    Rad1,Rad2     :Rad;                 {*Structure Radios*}
    Com1,Com2,Com3,
    Com4,Com5,Com6:TCoReq;              {*Structure Commands*}
    Cin1,Cin2,Cin3,
    Cin4,Cin5,Cin6:String;              {*Strings pour Commands*}
    Code          :Integer;
    Cancel        :Boolean;             {*Annulation Modifications*}
    VSp           :Byte;                {*Value Special Icon*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4, HaF*2+6, LaF*72, HaF*12+6,1,6,False);
String_Box( LaF*24,HaF*1+6, LaF*52, HaF*3+1,1,3, False);
String_Box( LaF*4, HaF*14+6,LaF*32, HaF*22+6,1,6,False);
String_Box( LaF*8, HaF*13+6,LaF*28, HaF*15+1,1,3,False);
String_Box( LaF*34,HaF*14+6,LaF*72, HaF*20+6,1,6,False);
String_Box( LaF*42,HaF*13+6,LaF*64, HaF*15+1,1,3,False);
SetColor(15);
DispG( LaF*28+4, HaF*1+8,3,Loc(693));
DispG( LaF*10+1, HaF*13+8,3,Loc(664));
DispG( LaF*46+4, HaF*13+8,3,Loc(694));
SetColor(0);
DispG( LaF*46,  HaF*4+1,6,Loc(695));
DispG( LaF*11+2,HaF*16+2,6,Loc(696));
DispG( LaF*36,  HaF*16+2,6,Loc(697));
DispG( LaF*36,  HaF*18+2,6,Loc(698));
DispG( LaF*11+2,HaF*18+2,6,Loc(699));

Button( LaF*44,HaF*24+1,LaF*16,0,7,False,But1,Loc(13));
Button( LaF*16,HaF*24+1,LaF*16,0,7,False,But2,'_OK');
Button( LaF*6, HaF*20+3,LaF*24,0,7,False,But3,Loc(471));
Command(LaF*6, HaF*4+1,LaF*38,100,4,11,0,$27,Com1,Cin1);
Command(LaF*6, HaF*6+1,LaF*64,100,4,11,0,$26,Com2,Cin2);
Command(LaF*6, HaF*8+1,LaF*64,100,4,11,0,$26,Com3,Cin3);
Command(LaF*64,HaF*16+2,LaF*6,3,2,1,0,$26,Com4,Cin4);
Command(LaF*64,HaF*18+2,LaF*6,4,2,1,0,$26,Com5,Cin5);
Command(LaF*6, HaF*10+2,LaF*64,255,2,11,0,$26,Com6,Cin6);
Radio_Box( LaF*6, HaF*16+1,1,Rad1.Status,Rad1);
Radio_Box( LaF*6, HaF*18+1,1,Rad2.Status,Rad2);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Init_Window(110,65,110+LaF*76,65+HaF1+HaF*26+1,$59D9,Loc(700),W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Rad1.Status:=RStV.TestRes;              {*Load And Init Values*}
Rad2.Status:=RStV.BCenter;
Cin1:=RStV.Name;
Cin2:=RStV.Txt;
Cin3:=RStV.Gad;
Str(RStV.NbChar,Cin4);
Str(RStV.Size,Cin5);
Cin6:=RStV.Str;
VSp:=RStV.NumIco;

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=False; Cancel:=Off;           {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Perso*}
   If GetMsg_Button(But1,1)=True Then Cancel:=True;
   If GetMsg_Button(But2,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But3,1)=True Then VSp:=SELECT_SPICON(VSp);
   GetMsg_Radio(Rad1,1);
   GetMsg_Radio(Rad2,1);
   GetMsg_Command(Com1,Cin1);
   GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com3,Cin3);
   GetMsg_Command(Com6,Cin6);
   GetMsg_Command(Com4,Cin4);
   GetMsg_Command(Com5,Cin5);
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=Off Then Begin                {*Save Modifications*}
   RStV.TestRes:=Rad1.Status;           {*Save Values*}
   RStV.BCenter:=Rad2.Status;
   RStV.Name:=Cin1;
   RStV.Txt:=Cin2;
   RStV.Gad:=Cin3;
   Val(Cin4,RStV.NbChar,Code);
   Val(Cin5,RStV.Size,Code);
   RStV.Str:=Cin6;
   RStV.NumIco:=VSp;
   End;
End;

{ͻ
                       PROCEDURE ASK_VALUE_REQUESTER                        
 ͹
         DEMANDE A L'UTILISATEUR DE DEFINIR UN REQUESTER DE VALEURS         
 ͼ}

Procedure ASK_VALUE_REQUESTER;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But1,But2,But3:ButG;                {*Structure Boutons*}
    Rad1,Rad2     :Rad;                 {*Structure Radios*}
    Com1,Com2,Com3,
    Com4,Com5,Com6:TCoReq;              {*Structure Commands*}
    Cin1,Cin2,Cin3,
    Cin4,Cin5,Cin6:String;              {*Strings pour Commands*}
    Code          :Integer;
    Cancel        :Boolean;             {*Annulation Modifications*}
    VSp           :Byte;                {*Value Special Icon*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4, HaF*2+6,  LaF*72, HaF*12+6,1,6,False);
String_Box( LaF*24,HaF*1+6,  LaF*52, HaF*3+1,1,3,False);
String_Box( LaF*4, HaF*14+6, LaF*32, HaF*22+6,1,6,False);
String_Box( LaF*8, HaF*13+6, LaF*28, HaF*15+1,1,3,False);
String_Box( LaF*34,HaF*14+6, LaF*72, HaF*20+6,1,6,False);
String_Box( LaF*42,HaF*13+6, LaF*64, HaF*15+1,1,3,False);
SetColor(15);
DispG( LaF*28+4, HaF*1+8,3,Loc(693));
DispG( LaF*10+1, HaF*13+8,3,Loc(664));
DispG( LaF*46+4, HaF*13+8,3,Loc(694));
SetColor(0);
DispG( LaF*46,  HaF*4+1,6,Loc(695));
DispG( LaF*11+2,HaF*16+2,6,Loc(696));
DispG( LaF*36,  HaF*16+2,6,Loc(701));
DispG( LaF*36,  HaF*18+2,6,Loc(702));
DispG( LaF*24,  HaF*10+2,6,Loc(703));
DispG( LaF*11+2,HaF*18+2,6,Loc(691));

Button( LaF*44,HaF*24+1,LaF*16,0,7,False,But1,Loc(13));
Button( LaF*16,HaF*24+1,LaF*16,0,7,False,But2,'_OK');
Button( LaF*6, HaF*20+3,LaF*24,0,7,False,But3,Loc(471));
Command(LaF*6, HaF*4+1,LaF*38,100,4,11,0,$27,Com1,Cin1);
Command(LaF*6, HaF*6+1,LaF*64,100,4,11,0,$26,Com2,Cin2);
Command(LaF*6, HaF*8+1,LaF*64,100,4,11,0,$26,Com3,Cin3);
Command(LaF*60,HaF*16+2,LaF*10,10,2,1,0,$26,Com4,Cin4);
Command(LaF*60,HaF*18+2,LaF*10,10,2,1,0,$26,Com5,Cin5);
Command(LaF*6, HaF*10+2,LaF*16,255,2,11,0,$26,Com6,Cin6);
Radio_Box( LaF*6, HaF*16+1,1,Rad1.Status,Rad1);
Radio_Box( LaF*6, HaF*18+1,1,Rad2.Status,Rad2);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Init_Window(110,65,110+LaF*76,65+HaF1+HaF*26+1,$59D9,Loc(704),W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Rad1.Status:=RVaV.TestRes;              {*Init Values*}
Rad2.Status:=RVaV.BCenter;
Cin1:=RVaV.Name;
Cin2:=RVaV.Txt;
Cin3:=RVaV.Gad;
Str(RVaV.BMin,Cin4);
Str(RVaV.BMax,Cin5);
Str(RVaV.Vai,Cin6);
VSp:=RVaV.NumIco;

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=Off; Cancel:=Off;             {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Perso*}
   If GetMsg_Button(But1,1)=True Then Cancel:=True;
   If GetMsg_Button(But2,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But3,1)=True Then VSp:=SELECT_SPICON(VSp);
   GetMsg_Radio(Rad1,1);
   GetMsg_Radio(Rad2,1);
   GetMsg_Command(Com1,Cin1);
   GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com3,Cin3);
   GetMsg_Command(Com6,Cin6);
   GetMsg_Command(Com4,Cin4);
   GetMsg_Command(Com5,Cin5);
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=Off Then Begin                {*Save Values*}
   RVaV.TestRes:=Rad1.Status;
   RVaV.BCenter:=Rad2.Status;
   RVaV.Name:=Cin1;
   RVaV.Txt:=Cin2;
   RVaV.Gad:=Cin3;
   Val(Cin4,RVaV.BMin,Code);
   Val(Cin5,RVaV.BMax,Code);
   Val(Cin6,RVaV.Vai,Code);
   RVaV.NumIco:=VSp;
   End;
End;

{ͻ
                     PROCEDURE ASK_PROGRESS_REQUESTER                       
 ͹
          DEMANDE A L'UTILISATEUR DE DEFINIR UN REQUESTER PROGRESS          
 ͼ}

Procedure ASK_PROGRESS_REQUESTER;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But1,But2     :ButG;                {*Structure Boutons*}
    Com1,Com2,Com3:TCoReq;              {*Structure Commands*}
    Cin1,Cin2,Cin3:String;              {*Strings pour Commands*}
    Code          :Integer;
    Cancel        :Boolean;             {*Annulation Modifications*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4, HaF*2+6, LaF*72, HaF*8+6,1,6,False);
String_Box( LaF*24,HaF*1+6, LaF*52, HaF*3+1,1,3,False);
String_Box( LaF*4, HaF*10+6,LaF*40, HaF*14+6,1,6,False);
String_Box( LaF*10,HaF*9+6, LaF*34, HaF*11+1,1,3,False);
SetColor(15);
DispG( LaF*28+4,HaF*1+8,3,Loc(693));
DispG( LaF*14,  HaF*9+8,3,Loc(664));
SetColor(0);
DispG( LaF*46,HaF*4+1,6,Loc(695));
DispG( LaF*8, HaF*12+2,6,Loc(705));

Button( LaF*44,HaF*16+1,LaF*16,0,7,False,But1,Loc(13));
Button( LaF*16,HaF*16+1,LaF*16,0,7,False,But2,'_OK');
Command(LaF*6, HaF*4+1,LaF*38,100,4,11,0,$27,Com1,Cin1);
Command(LaF*6, HaF*6+1,LaF*44,100,4,11,0,$26,Com2,Cin2);
Command(LaF*30,HaF*12+2,LaF*6,3,2,1,0,$26,Com3,Cin3);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Init_Window(110,65,110+LaF*76,65+HaF1+HaF*18+1,$59D9,Loc(706),W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Cin1:=RProV.Name;                       {*Init And Load Values*}
Cin2:=RProV.Explain;
Str(RProV.Cob,Cin3);

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=Off; Cancel:=Off;             {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Perso*}
   If GetMsg_Button(But1,1)=True Then Cancel:=On;
   If GetMsg_Button(But2,1)=True Then Exit_Flg:=On;
   GetMsg_Command(Com1,Cin1);
   GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com3,Cin3);
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=On;              {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=Off Then Begin                {*Save Values*}
   RProV.Name:=Cin1;
   RProV.Explain:=Cin2;
   Val(Cin3,RProV.Cob,Code);
   End;
End;

{ͻ
                           PROCEDURE ASK_PROCNAME                           
 ͹
    DEMANDE A L'UTILISATEUR LE NOM DE LA PROCEDURE QUI DOIT ETRE APPELLEE   
 ͼ}

Procedure ASK_PROCNAME;
Var NUM:Integer;
    ES :String;
Begin
ES:=Proc_Name;
String_RequestG(Loc(461),Loc(707),Loc(708),64,390,ES,NUM);
If NUM=1 Then Proc_Name:=ES;
End;

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

{ͻ
                          PROCEDURE BUTTON_ACTION                           
 ͹
       DEMANDE A L'UTILISATEUR QUELLE ACTION IL DESIRE POUR SON BOUTON      
      SELECTION ET EDITION POSSIBLE DES DIFFERENTS REQUESTERS STANDARDS     
 ͼ}

Procedure BUTTON_ACTION;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    Cancel        :Boolean;
    A             :Integer;             {*For Loop*}
    But1,But2,But3:ButG;                {*Structure Boutons*}
    TRad          :Array[1..20] of Rad; {*Tableau de Radios*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Var    A :Integer;                      {*For Loop*}
Begin
Clip_Window(On,W1);                     {*Clipping de la Fentre*}
String_Box( LaF*4, HaF*2+6, LaF*74, HaF*29+6,1,6,False);
String_Box( LaF*28+1, HaF*1+6, LaF*49+4, HaF*3+1,1,3,False);
SetColor(15);
DispG( LaF*35+1, HaF*1+8,3,Loc(709));
SetColor(0);
For A:=1 to 3 do Begin
   Radio_Box(LaF*6,(HaF+5)*A+26,2,TRad[A].Status,TRad[A]);
   DispG(LaF*13, (HaF+5)*A+27,6,Loc(728+A));
   End;
For A:=4 to 15 do Begin
   Radio_Box(LaF*6,(HaF+5)*A+41,2,TRad[A].Status,TRad[A]);
   DispG(LaF*13, (HaF+5)*A+42,6,Loc(728+A));
   End;
For A:=16 to 20 do Begin
   Radio_Box(LaF*42,(HaF+5)*(A-15)+26,2,TRad[A].Status,TRad[A]);
   DispG(LaF*48, (HaF+5)*(A-15)+27,6,Loc(728+A));
   Freeze_Radio(On,TRad[A]);
   End;

Button( LaF*13, HaF*31+1,LaF*14,0,7,False,But1,'_OK');
Button( LaF*33, HaF*31+1,LaF*14,0,7,False,But2,Loc(714));
Button( LaF*52, HaF*31+1,LaF*14,0,7,False,But3,Loc(13));

Clip_Window(Off,W1);                    {*Restore le Clipping Normal*}
End;

{************************** PROCEDURE PRINCIPALE ****************************}

Begin
Init_Window(250,0,250+LaF*78,HaF1+HaF*33,$59D9,Loc(715),W1);
Sup_Window(100,50,250,200,59,50,639,349,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

For A:=1 to 20 do If TBU[Pos].Action=A-1 Then TRad[A].Status:=True
                                         Else TRad[A].Status:=False;
REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=False; Cancel:=False;         {*Init Flags de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Personnels*}
   If GetMsg_Button(But1,1) Then Exit_Flg:=True;
   If GetMsg_Button(But2,1)=True Then Begin    {*Edit Requesters*}
      If TRad[3].Status=True  Then ASK_PROCNAME;
      If TRad[4].Status=True  Then ASK_EZ_REQUESTER;
      If TRad[5].Status=True  Then ASK_FONTREQ;
      If TRad[6].Status=True  Then ASK_STRING_REQUESTER;
      If TRad[7].Status=True  Then ASK_VALUE_REQUESTER;
      If TRad[8].Status=True  Then ASK_PALETTE;
      If TRad[9].Status=True  Then ASK_MEMORY;
      If TRad[10].Status=True Then ASK_HARDWARE;
      If TRad[11].Status=True Then ASK_PROGRESS_REQUESTER;
      If TRad[12].Status=True Then ASK_FILEREQ;
      If TRad[13].Status=True Then ASK_ATTRIB;
      If TRad[14].Status=True Then ASK_SYSTEM;
      End;
   If GetMsg_Button(But3,1) Then Cancel:=True;
   For A:=1 to 20 do GetMsg_Radio(TRad[A],1);
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg) Or (Cancel);           {*Flags de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Not Cancel Then
   For A:=1 to 20 do                    {*Save Values*}
      If TRad[A].Status=True Then TBU[Pos].Action:=A-1;
End;

{ͻ
                      PROCEDURE ASK_SLIDER_TO_COMMAND                       
 ͹
      DEMANDE A L'UTILISATEUR DE DEFINIR UN REQUESTER SLIDER TO COMMAND     
 ͼ}

Procedure ASK_SLIDER_TO_COMMAND(Pos:Integer);
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evnements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But1,But2     :ButG;                {*Structure Boutons*}
    Com1          :TCoReq;              {*Structure Commands*}
    Cin1          :String;              {*Strings pour Commands*}
    Code          :Integer;
    Cancel        :Boolean;             {*Annulation Modifications*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box( LaF*4+1,  HaF*2+7, LaF*50+4, HaF*6+5,1,6,False);
String_Box( LaF*14+1, HaF*1+7, LaF*40+1, HaF*3,1,3,False);
DispG( LaF*6,  HaF*4+2,6,Loc(716));
DispG(LaF*19+1,HaF*1+8,3,Loc(717));

Button( LaF*8,  HaF*8+1,LaF*16,0,7,False,But1,'_OK');
Button( LaF*30, HaF*8+1,LaF*16,0,7,False,But2,Loc(13));
Command(LaF*42, HaF*4+2,LaF*6,3,2,1,0,$27,Com1,Cin1);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Str(Pos,Cin1);
Init_Window(80,75,80+LaF*55,75+HaF1+HaF*10+1,$59D9,Loc(718)+Cin1,W1);
Sup_Window(100,50,250,200,59,50,500,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Str(RSldV[Pos].ComNum,Cin1);                 {*Init and Load Values*}
REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=Off; Cancel:=Off;             {*Init Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin                                {*Test des Gadgets Personnels*}
   If GetMsg_Button(But1,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But2,1)=True Then Cancel:=On;
   GetMsg_Command(Com1,Cin1);
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=Off Then                      {*Save Value*}
   Val(Cin1,RSldV[Pos].ComNum,Code);
End;

{**************************** PROGRAMME PRINCIPAL ***************************}

Begin                                   {*Def File Requester Values*}
RFileV.X1:=120;                         {*Init File Requester*}
RFileV.Y1:=30;
RFileV.Sv:=300;
RFileV.Name:=Loc(720);
RFileV.OkBut:='_OK';
RFileV.Mask:='*.*';
RFileV.Style:=0;
RFileV.FPath:=0;
RFileV.FName:=0;
RFileV.FSize:=0;
RFileV.SendToCom:=False;

RPalV.X1:=120;                          {*Init Palette Requester*}
RPalV.Y1:=30;
RPalV.Name:=Loc(721);
RPalV.ColSel:=0;

RMemV.X1:=120;                          {*Init Memory Requester*}
RMemV.Y1:=30;
RMemV.Name:=Loc(722);

RHardV.X1:=120;                         {*Init Hardware Requester*}
RHardV.Y1:=30;
RHardV.Name:=Loc(723);

RSysV.X1:=120;                          {*Init System Requester*}
RSysV.Y1:=30;
RSysV.Name:='MOS.INI';
RSysV.SMosIni:=True;

REzV.Title:=Loc(724);                   {*Init EZ Requester*}
REzV.Phrase:=Loc(725);
REzV.Gadget:=Loc(726);
REzV.TestRes:=Yes;
REzV.BCenter:=No;
REzV.NumIco:=4;

RFntV.X1:=120;                          {*Record Font Requester*}
RFntV.Y1:=30;
RFntV.Name:=Loc(724);
RFntV.Font_Sel:=0;
RFntV.Size_Sel:=0;

RAttrV.X1:=120;                         {*Record Attrib Requester*}
RAttrV.Y1:=30;
RAttrV.Name:='TEST.EXE';

RStV.Name:=Loc(724);                    {*Record String Requester*}
RStV.Txt:=Loc(725);
RStV.Gad:=Loc(726);
RStV.Str:=Loc(727);
RStV.NbChar:=100;
RStV.Size:=180;
RStV.TestRes:=On;
RStV.BCenter:=Off;
RStV.NumIco:=4;

RVaV.Name:=Loc(724);                    {*Record Value Requester*}
RVaV.Txt:=Loc(725);
RVaV.Gad:=Loc(726);
RVaV.BMin:=-100;
RVaV.BMax:=100;
RVaV.Vai:=0;
RVaV.TestRes:=On;
RVaV.BCenter:=Off;
RVaV.NumIco:=4;

RProV.Name:=Loc(724);                   {*Record Progress Requester*}
RProV.Explain:=Loc(728);
RProV.Cob:=12;

For Item:=1 to MAX_TSL do RSldV[Item].ComNum:=0;{*Record pour Slider to Command*}
End.
