{ͻ
                      M.R.E (MOS RESOURCE EDITOR) v2.4                      
 ͹
                         UNITE DE GESTION DES ITEMS                         
 ͹
  Coded by Zuul as BouFFtou as Cheveau Frdric.                            
  Programm  Toulouse COG (Gendarmerie) sur Turbo Pascal v7.00.            
  Contact us on 36.15 RTEL1 - Bal "BouFFtou" or Bal "ICF".                  
 ͼ}

Unit MRE_ITEMS;                          {*Nom du l'Unit*}

Interface

Uses MOS_BAS,
     MOS_ASM,                            {*Gestion des Instructions ASM*}
     MOS_MSE,                            {*Gestion de la Souris*}
     MOS_TOO,                            {*Gestion des Tools et Box*}
     MOS_GAD,                            {*Gestion des Gadgets*}
     MOS_REQ,                            {*Gestion des Requesters*}
     MOS_MEN,                            {*Gestion des Menus*}
     MOS_WIN,                            {*Gestion des Fentres*}
     MOS_DIR,                            {*Gestion du Directory*}
     MRE_ACTS,                           {*Gestion Action des Boutons*}
     Crt,
     Graph;
                                         {*Espaces pour Strings*}
Procedure HELP(P:Integer);               {*Gestion de l'Aide*}
Procedure ERROR_01;                      {*Gestion des Erreurs*}
Procedure ABOUT;
Procedure REDRAW_WINDOW;                 {*Raffiche le Contenu de Window*}

Procedure GERE_ITEMS(I:Byte);            {*Gestion des Items*}

Procedure TOGGLE_ITEM(Ty:Byte);          {*Toggle Cadre Items*}

Procedure SAVE_MRE_CONFIG;
Procedure LOAD_MRE_CONFIG;               {*Load And Init MRE Constants*}
Procedure QTT_TO_0;                      {*POS et QTT to 0...*}
Procedure POS_TO_0;

Implementation

{ͻ
                         GESTION DE L'AIDE DANS MRE                         
 ͼ}

Procedure HELP(P:Integer);
Var NUM:Integer;
Begin
Num:=4;                                 {*Icne Information*}
Ez_RequestG(Loc(588),Loc(581+P),'  _OK  |',NUM);{*Display Help*}
End;

{ͻ
                           ERREURS INTERNES A MRE                           
 ͼ}

Procedure ERROR_01;
Var NUM:Integer;
Begin
Num:=1;                                 {*Icne Warning*}
EZ_RequestG(Loc(461),Loc(589),Loc(469),NUM);
End;

{ͻ
                         ABOUT AND REGISTERING INFO                         
 ͼ}

Procedure ABOUT;
Var NUM:Integer;
Begin
Num:=4;                                 {*Icne Information*}
EZ_RequestG(Loc(590),Loc(591),Loc(469),NUM);
End;

{ͻ
                               SET POS TO 0                                 
 ͼ}

Procedure POS_TO_0;
Var A:Byte;
Begin
For A:=1 to 8 do Pos_ITM[A]:=0;{*Positions de Chaque Outils*}
End;

{ͻ
                               SET QTT TO 0                                 
 ͼ}

Procedure QTT_TO_0;
Var A:Byte;
Begin
For A:=1 to 8 do Qtt_ITM[A]:=0;{*Quantit de Chaque Outils*}
End;

{ͻ
               JUSTIFY A DROITE ET EN BAS LES ITEMS DE LA FENETRE           
 ͼ}

Procedure LEFT_JUSTIFY;                 {*Garde Proportions par Rapport Window*}
Var A:Byte;                             {*For Loop*}
    OffX,OffY:Integer;                  {*Variation  Corriger*}
Begin
If Test_Check_Point(M,2,3)=Off Then Exit;{*Pas de Justifications*}

OffX:=(W.X2-W.X1)-WSizeX;               {*Calcule Variations*}
OffY:=(W.Y2-W.Y1)-WSizeY;

WSizeX:=W.X2-W.X1;                      {*Stocke Nouvelle Taille*}
WSizeY:=W.Y2-W.Y1;

For A:=1 to Qtt_ITM[6] do Begin         {*Rajuste Bevels*}
   Inc(TBB[A].X2,OffX); Inc(TBB[A].Y2,OffY); End;
For A:=1 to Qtt_ITM[7] do Begin            {*Rajuste String Boxes*}
   Inc(TSB[A].X2,OffX); Inc(TSB[A].Y2,OffY); End;
For A:=1 to Qtt_ITM[8] do Begin            {*Rajuste Textes*}
   Inc(TXT[A].X1,OffX); Inc(TXT[A].Y1,OffY); End;
For A:=1 to Qtt_ITM[1] do Begin         {*Rajuste Boutons*}
   Inc(TBU[A].X1,(OffX Div 2));         {*Bouton Centr en X et Ajust en Y*}
   Inc(TBU[A].Y1,OffY) ;End;
For A:=1 to Qtt_ITM[2] do Begin            {*Rajuste Cyclers*}
   Inc(TCY[A].X1,(OffX Div 2));         {*Bouton Centr en X et Ajust en Y*}
   Inc(TCY[A].Y1,OffY) ;End;
For A:=1 to Qtt_ITM[4] do Begin            {*Rajuste Sliders*}
   Inc(TSL[A].X1,(OffX Div 2));         {*Bouton Centr en X et Ajust en Y*}
   Inc(TSL[A].Y1,OffY);
   Inc(TSL[A].X2,(OffX Div 2));
   Inc(TSL[A].Y2,OffY) ;End;
For A:=1 to Qtt_ITM[2] do                  {*Rajuste Commands*}
   Inc(TCO[A].T.Siz,OffX);
End;

{ͻ
                      REAFFICHE CONTENU FENETRE DE BASE                     
 ͼ}

Procedure REDRAW_WINDOW;                {*Raffiche le Contenu de Window*}
Var A     :Byte;                        {*For Loop*}
    OldHaF:Byte;                        {*Old Hauteur Fonte*}
    Tit   :Integer;                     {*Si Title Absent*}

Begin
If Gad_Exist=No Then Exit;              {*Pas de Gadgets  Afficher*}

Tit:=-4;                                {*Pas de Titre => Dcalage...*}
If W.IDCMP And $80=$80 Then Tit:=HaF1;
If BTST(W.IDCMP,13) Then W.Sw.Load(W.X1,W.Y1); {*BackTrans*}

Draw_Window(W);                         {*Affiche Fentre Test*}
If (W.X2-W.X1<>WSizeX) Or (W.Y2-W.Y1<>WSizeY) Then LEFT_JUSTIFY;{*Justify Dte*}

Clip_Window(On,W);                      {*Clipping des Gadgets*}
For A:=1 to Qtt_ITM[7] do                  {*Draw String Boxes*}
   String_Box(TSB[A].X1, TSB[A].Y1-Tit, TSB[A].X2,
   TSB[A].Y2-Tit, TSB[A].Style,TSB[A].Co,TSB[A].Cave);
For A:=1 to Qtt_ITM[6] do               {*Draw Bevels*}
   Bevel(TBB[A].X1, TBB[A].Y1-Tit, TBB[A].X2,
   TBB[A].Y2-Tit, TBB[A].Style,TBB[A].Co,TBB[A].Cave,TBB[A].Fill);
For A:=1 to Qtt_ITM[8] do Begin            {*Draw Texts*}
   SetColor(TXT[A].CP); DispG(TXT[A].X1, TXT[A].Y1-Tit, TXT[A].CB,TXT[A].Cin); End;
For A:=1 to Qtt_ITM[1] do Begin         {*Draw Buttons*}
   OldHaF:=HaF;
   If TBU[A].SY<>HaF+4 Then HaF:=TBU[A].SY-4;
   If TBU[A].VanillaKey<>0 Then Insert('_',TBU[A].B.TCT[1],TBU[A].VanillaKey);
   Button(TBU[A].X1, TBU[A].Y1-Tit, TBU[A].SX, TBU[A].B.CoP,
   TBU[A].B.CoB,TBU[A].B.Lock, TBU[A].B ,TBU[A].B.TCT[1]);
   If TBU[A].Freeze=On Then Freeze_Button(On,TBU[A].B);
   HaF:=OldHaF; End;
For A:=1 to Qtt_ITM[2] do Begin            {*Draw Cyclers*}
   OldHaF:=HaF;
   If TCY[A].SY<>HaF+4 Then HaF:=TCY[A].SY-5;
   If TCY[A].VanillaKey<>0 Then Insert('_',TCY[A].Cin,TCY[A].VanillaKey);
   Cycler(TCY[A].X1, TCY[A].Y1-Tit, TCY[A].SX, TCY[A].B.CyclVal,
   TCY[A].B.CoP,TCY[A].B.CoB, TCY[A].B ,TCY[A].Cin);
   If TCY[A].Freeze=On Then Freeze_Button(On,TCY[A].B);
   HaF:=OldHaF; End;
For A:=1 to Qtt_ITM[3] do Begin            {*Draw Radios*}
   Radio_Box(TRB[A].X1, TRB[A].Y1-Tit, TRB[A].R.Style, TRB[A].R.Status,TRB[A].R);
   If TRB[A].Freeze=On Then Freeze_Radio(On,TRB[A].R); End;
For A:=1 to Qtt_ITM[4] do Begin            {*Draw Sliders*}
   Slider(TSL[A].X1, TSL[A].Y1-Tit, TSL[A].X2, TSL[A].Y2-Tit,
   TSL[A].S.Qtt, TSL[A].S.Aff, TSL[A].S.Typ, TSL[A].S.GDep, TSL[A].S ,TSL[A].S.Psl);
   End;
For A:=1 to Qtt_ITM[5] do Begin            {*Draw Commands*}
   Command(TCO[A].X1, TCO[A].Y1-Tit, TCO[A].T.Siz, TCO[A].T.Len,
   TCO[A].T.CoB, TCO[A].T.Co2, TCO[A].T.Sty, $26, TCO[A].T ,TCO[A].Cin);
   If TCO[A].Freeze=On Then Freeze_Command(On,TCO[A].T); End;
Clip_Window(Off,W);                     {*Retour au Clipping Normal*}
End;

{ͻ
                       PROCEDURE  SAVE_MRECONFIG                            
 ͼ}

Procedure SAVE_MRE_CONFIG;
Var NUM:Integer;
    R,G,B:Byte;
    Fil1:Text;                          {*Fichier de Configuration*}

Begin
Assign(Fil1,'MRE.CFG');                 {*Ouvre la Configuration*}
{$I-}
Rewrite(Fil1);
{$I+}
If IOResult=0 Then Begin                {*Pas d'Erreurs ?*}
   Writeln(Fil1,Loc(592));
   Writeln(Fil1,Loc(593));
   Writeln(Fil1,Loc(594));
   Writeln(Fil1,Loc(595));
   Writeln(Fil1);

   Writeln(Fil1,Gen_Prog);              {*Save Booleans and Various Datas*}
   Writeln(Fil1,Gen_Rem);
   Writeln(Fil1,Gen_Menu);
   Writeln(Fil1,Name_Prog);
   Writeln(Fil1,Name_Proc);
   Writeln(Fil1,My_Grid);
   Writeln(Fil1,Grid_X);
   Writeln(Fil1,Grid_Y);
   Writeln(Fil1,Disp_Beep);
   Writeln(Fil1,Show_MCoo);
   Writeln(Fil1,Test_Check_Point(M,1,8));
   Writeln(Fil1,Test_Check_Point(M,6,7));
   For Num:=1 to 3 do
      Writeln(Fil1,Test_Check_Point(M,2,Num));
   Close(Fil1);
   Num:=4;                              {*Icne Information*}
   EZ_RequestG(Loc(461),Loc(596),'   _OK   |',NUM);
   End
   Else Begin
   Num:=1;                              {*Icne Warning*}
   EZ_RequestG(Loc(461),Loc(597),'   _OK   |',NUM);
   End;
End;

{ͻ
                        PROCEDURE INIT_MRE_CONFIG                           
 ͼ}

Procedure LOAD_MRE_CONFIG;              {*Load And Init MRE Constants*}
Var Col,NUM,E,Code:Integer;
    R,G,B:Byte;
    St:String;
    Fil1:Text;                          {*Fichier de Configuration*}

Begin
Assign(Fil1,'MRE.CFG');                 {*Ouvre la Configuration*}
{$I-}
Reset(Fil1);
{$I+}
If IOResult=0 Then Begin                {*Pas d'Erreurs ?*}
   For E:=1 to 5 do Readln(Fil1);       {*Read Entte*}

   Readln(Fil1,St); If Upper(St)='TRUE' Then Gen_Prog:=True Else Gen_Prog:=False;
   Readln(Fil1,St); If Upper(St)='TRUE' Then Gen_Rem:=True Else Gen_Rem:=False;
   Readln(Fil1,St); If Upper(St)='TRUE' Then Gen_Menu:=True Else Gen_Menu:=False;
   Readln(Fil1,Name_Prog);
   Readln(Fil1,Name_Proc);
   Readln(Fil1,St); If Upper(St)='TRUE' Then My_Grid:=True Else My_Grid:=False;
   Readln(Fil1,Grid_X);
   Readln(Fil1,Grid_Y);
   Readln(Fil1,St); If Upper(St)='TRUE' Then Disp_Beep:=Yes Else Disp_Beep:=No;
   Readln(Fil1,St); If Upper(St)='TRUE' Then Show_MCoo:=Yes Else Show_MCoo:=No;
   Readln(Fil1,St); If Upper(St)='TRUE' Then SET_ID_MENU(M,1,8,$0C) Else SET_ID_MENU(M,1,8,$04);
   Readln(Fil1,St);
   For Num:=1 to 3 do Begin
      Readln(Fil1,St); If Upper(St)='TRUE' Then SET_ID_MENU(M,2,Num,$0C) Else SET_ID_MENU(M,2,Num,$04);
      End;

   Close(Fil1);
   Num:=4;                              {*Icne Information*}
   EZ_RequestG(Loc(598),Loc(599),'   _OK   |',NUM);
   End;
End;

{ͻ
                          TOGGLE D'UN ITEM ENTOURE                          
 ͼ}

Procedure TOGGLE_ITEM(Ty:Byte);         {*Type et Numro (Implicite) Item*}
Var Nx1,Ny1,Nx2,Ny2:Integer;            {*Coordonnes du Box*}
    OffX,OffY:Integer;                  {*Dcalage Box for Sliders Buttons*}
    P:Byte;                             {*Numro de l'Item*}

Begin
P:=Pos_ITM[Ty];                         {*Get Numro de l'Item...*}
If P<1 Then Exit;                       {*Pas de Box  Effacer*}
SetLineStyle(0,0,3);                    {*Ligne Grosse*}
SetWriteMode(XorPut);
SetColor(7);

Case Ty of
   1: Begin
      Nx1:=TBU[P].X1;                   {*Coordonnes for Button Item*}
      Ny1:=TBU[P].Y1;
      Nx2:=TBU[P].X1+TBU[P].SX;
      Ny2:=TBU[P].Y1+TBU[P].SY;
      End;
   2: Begin
      Nx1:=TCY[P].X1;                   {*Coordonnes for Cycler Item*}
      Ny1:=TCY[P].Y1;
      Nx2:=TCY[P].X1+TCY[P].SX+18;
      Ny2:=TCY[P].Y1+TCY[P].SY;
      End;
   3: Begin
      Nx1:=TRB[P].X1;                   {*Coordonnes for Radio Box Item*}
      Ny1:=TRB[P].Y1;
      Nx2:=TRB[P].X1+19;
      Ny2:=TRB[P].Y1+4+HaF;
      End;
   4: Begin
      OffX:=0; OffY:=0;                 {*Coordonnes for Slider Item*}
      If TSL[P].S.GDep=On Then
         If TSL[P].S.Typ=0 Then OffX:=41 Else OffY:=30;
      Nx1:=TSL[P].X1;
      Ny1:=TSL[P].Y1;
      Nx2:=TSL[P].X2+OffX;
      Ny2:=TSL[P].Y2+OffY;
      End;
   5: Begin
      Nx1:=TCO[P].X1;                   {*Coordonnes for Command Item*}
      Ny1:=TCO[P].Y1;
      Nx2:=TCO[P].X1+TCO[P].T.Siz;
      Ny2:=TCO[P].Y1+4+HaF;
      End;
   6: Begin
      Nx1:=TBB[P].X1;                   {*Coordonnes for Bevel Box Item*}
      Ny1:=TBB[P].Y1;
      Nx2:=TBB[P].X2;
      Ny2:=TBB[P].Y2;
      End;
   7: Begin
      Nx1:=TSB[P].X1;                   {*Coordonnes for String Box Item*}
      Ny1:=TSB[P].Y1;
      Nx2:=TSB[P].X2;
      Ny2:=TSB[P].Y2;
      End;
   8: Begin
      Nx1:=TXT[P].X1-2;                 {*Coordonnes for Text Item*}
      Ny1:=TXT[P].Y1;
      Nx2:=TXT[P].X1+TextWidth(TXT[P].Cin)+2;
      Ny2:=TXT[P].Y1+2+HaF;
      End;
   End;

Nx1:=Nx1+W.X1;                          {*Add Coordonnes Window Project*}
Ny1:=Ny1+W.Y1;
Nx2:=Nx2+W.X1;
Ny2:=Ny2+W.Y1;

HideMouse;
Rectangle(Nx1, Ny1, Nx2, Ny2);          {*Toggle Box*}
ShowMouse;

SetWriteMode(NormalPut);
SetLineStyle(0,0,1);                    {*Return to Ligne Fine*}
End;

{ͻ
                          PROCEDURE DEFINE_BUTTONS                          
 ͼ}

Function DEFINE_BUTTONS(Pos:Byte):Boolean;
Var W1          :Win;                   {*Structure Fentre*}
    Even        :Byte;                  {*Rception Evenements Fentre*}
    Exit_Flg    :Boolean;               {*Flag de Sortie*}
    But0,But1,But2,
    But3,But4,But5:ButG;                {*Bouton Classique*}
    Co1,Co2,Co3,Co4,Co5,Co6,Co7:TCoReq; {*Structure Bevels Boxes*}
    Cin1,Cin2,Cin3,Cin4,
    Cin5,Cin6,Cin7:String;              {*String Rcupre*}
    Rad1,Rad2,Rad3:Rad;                 {*Pour Radio Evidement*}
    Code,Trans,I:Integer;
    Cancel      :Boolean;               {*Annulation Modifications*}
    X,Y         :Word;                  {*For Grid Parameters*}
    V1,V2       :Integer;               {*Couleurs TC/BGC*}
    DirSel,Filsel:String;               {*Gestion File Requester*}
    Size        :Longint;

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box(125,20,320,127,1,6,Off);
Button(LaF*12, 162,LaF*16,0,7,False,But0,'_OK');
Button(LaF*42, 162,LaF*16,0,7,False,But2,Loc(13));
Button(20, 115,95,11,9,False,But1,Loc(600));
Button(20, 95, 95,11,9,False,But5,Loc(773));

Button(140,28,110,11,9,False,But3,Loc(601));
Button(140,47,110,11,9,False,But4,Loc(602));

SetColor(Col[0]);
DispG(22,15,7,Loc(604));
DispG(22,35,7,Loc(605));
DispG(22,55,7,Loc(606));
DispG(22,75,7,Loc(607));
DispG(22,136,7,Loc(608));

DispG(140,68,7,Loc(609));
DispG(140,87,7,Loc(610));
DispG(140,106,7,Loc(611));

Radio_Box(279,67,1,Rad1.Status,Rad1);
Radio_Box(279,86,1,Rad2.Status,Rad2);
Radio_Box(279,105,1,Rad3.Status,Rad3);

Command(75,14,30,3,12,13,1,$26,Co1,Cin1);
Command(75,34,30,3,12,13,1,$26,Co2,Cin2);
Command(75,54,30,3,12,13,1,$26,Co3,Cin3);
Command(75,74,30,3,7,13,1,$26,Co4,Cin4);
Command(279,28,30,3,V1,13,1,$26,Co5,Cin5);
Command(279,47,30,3,V2,13,1,$26,Co6,Cin6);
Command(60,135,259,37,12,13,1,$27,Co7,Cin7);

If Rad3.Status=True Then Freeze_Command(On,Co4)    {*Gadget Autoris or No*}
                    Else Freeze_Command(Off,Co4);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Str(Pos,Cin1);                          {*For Button Number*}
Init_Window(30,140,376,322+HaF1,$51D9,Loc(612)+Cin1,W1);
Sup_Window(100,50,347,218,59,50,400,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Grid:=My_Grid;                          {*Grille Si elle Existe*}
If Test_Check_Point(M,2,2)=True Then Begin{*Adjust Position if Pref is Set*}
   X:=TBU[Pos].X1; Y:=TBU[Pos].Y1;      {*Calcul New Coordonnes With Steps*}
   Get_Grid_Coord(X,Y);
   TBU[Pos].X1:=X; TBU[Pos].Y1:=Y;
   X:=TBU[Pos].SX;
   Get_Grid_Coord(X,Y);
   TBU[Pos].SX:=X;
End;
Grid:=Off;                              {*Plus de Grille Gnrale*}
Gad_Exist:=True;                        {*Gadgets Existent*}

Str(TBU[Pos].X1,Cin1); Str(TBU[Pos].Y1,Cin2);{*Init Values*}
Str(TBU[Pos].SX,Cin3); Str(TBU[Pos].SY,Cin4);
Str(TBU[Pos].B.CoB,Cin5); Str(TBU[Pos].B.CoP,Cin6);
Cin7:=TBU[Pos].B.TCT[1];
Rad1.Status:=TBU[Pos].Freeze;           {*Init Radios*}
Rad2.Status:=TBU[Pos].B.Lock;
If TBU[Pos].SY<>HaF+4 Then Rad3.Status:=Off Else Rad3.Status:=On;
If TBU[Pos].VanillaKey<>0 Then          {*Remet Caractre Soulign*}
   Insert('_',Cin7,TBU[Pos].VanillaKey);

V1:=TBU[Pos].B.CoB; V2:=TBU[Pos].B.CoP; {*Couleurs Gadgets*}

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=Off; Cancel:=Off;             {*Flag de Sortie*}
DirSel:=Work_Dir;; FilSel:='';

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin
   If GetMsg_Button(But0,1) Then Exit_Flg:=True;
   If GetMsg_Button(But2,1) Then Cancel:=True;
   If GetMsg_Button(But1,1) Then BUTTON_ACTION(Pos);
   If GetMsg_Button(But3,1) Then Begin
      Palette_RequestG(80,100,Loc(518),1,V1);
      Str(V1,Cin5); REDRAW_FRAME
      End;
   If GetMsg_Button(But4,1) Then Begin
      Palette_RequestG(80,100,Loc(518),1,V2);
      Str(V2,Cin6); REDRAW_FRAME;
      End;
   If GetMsg_Button(But5,1) Then Begin  {*Slectionner une Icne*}
      Get_FileDir(60,14,282,Loc(260),Loc(162),'*.ICO',0,DirSel,FilSel,Size);
      Cin7:=DirSel+FilSel; REDRAW_FRAME;
      End;
   GetMsg_Command(Co1,Cin1); GetMsg_Command(Co2,Cin2);
   GetMsg_Command(Co3,Cin3); GetMsg_Command(Co4,Cin4);
   GetMsg_Command(Co5,Cin5); GetMsg_Command(Co6,Cin6);{*Fill Colors And Background*}
   GetMsg_Command(Co7,Cin7);
   GetMsg_Radio(Rad1,1);
   GetMsg_Radio(Rad2,1);
   If GetMsg_Radio(Rad3,1)= True Then
      If Rad3.Status=True
         Then Freeze_Command(On,Co4)    {*Gadget Autoris*}
         Else Freeze_Command(Off,Co4);
   End;

Even:=ACTIVE_WINDOW(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=Off Then Begin
   TBU[Pos].VanillaKey:=0;              {*De Base si il n'y en a pas*}
   For I:=1 to Length(Cin7) do
      If Copy(Cin7,I,1)='_' Then Begin
         TBU[Pos].VanillaKey:=I;
         End;
   If TBU[Pos].VanillaKey<>0 Then
      Cin7:=Copy(Cin7,1,TBU[Pos].VanillaKey-1)+Copy(Cin7,TBU[Pos].VanillaKey+1,Length(Cin7)-TBU[Pos].VanillaKey);

   Val(Cin1,TBU[Pos].X1,Code);          {*Transmet Values*}
   Val(Cin2,TBU[Pos].Y1,Code);
   Val(Cin3,TBU[Pos].SX,Code);
   Val(Cin4,TBU[Pos].SY,Code);
   TBU[Pos].B.CoB:=V1;
   TBU[Pos].B.CoP:=V2;
   TBU[Pos].B.TCT[1]:=Cin7;
   TBU[Pos].Freeze:=Rad1.Status;
   TBU[Pos].B.Lock:=Rad2.Status;
   BSET(Has_Changed,Num_Pro);           {*Une Modification a t Faite*}
   DEFINE_BUTTONS:=True;
   End Else DEFINE_BUTTONS:=False;

End;

{ͻ
                          PROCEDURE DEFINE_CYCLER                           
 ͼ}

Function DEFINE_CYCLERS(Pos:Byte):Boolean;
Var W1          :Win;                   {*Structure Fentre*}
    Even        :Byte;                  {*Rception Evenements Fentre*}
    Exit_Flg    :Boolean;               {*Flag de Sortie*}
    But0,But1,
    But2,But3   :ButG;                  {*Bouton Classique*}
    Co1,Co2,Co3,Co4,
    Co5,Co6,Co7,Co8:TCoReq;             {*Structure Bevels Boxes*}
    Cin1,Cin2,Cin3,Cin4,
    Cin5,Cin6,Cin7,Cin8:String;         {*String Rcupre*}
    Rad1,Rad2   :Rad;                   {*Pour Radio Evidement*}
    Code,Trans,I:Integer;
    Cancel      :Boolean;               {*Annulation Modifications*}
    X,Y         :Word;                  {*For Grid Parameters*}
    V1,V2       :Integer;               {*Couleurs TC/BGC*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box(125,20,320,127,1,6,Off);
Button(LaF*12, 162,LaF*16,0,7,False,But0,'_OK');
Button(LaF*42, 162,LaF*16,0,7,False,But1,Loc(13));
Button(140,28,110,11,9,False,But2,Loc(601));
Button(140,47,110,11,9,False,But3,Loc(602));

SetColor(Col[0]);
DispG(60,16,7,Loc(603));
DispG(22,35,7,Loc(604));
DispG(22,55,7,Loc(605));
DispG(22,75,7,Loc(606));
DispG(22,95,7,Loc(607));
DispG(22,136,7,Loc(608));
DispG(140,68,7,Loc(616));
DispG(140,87,7,Loc(617));
DispG(140,107,7,Loc(618));

Radio_Box(279,86,1,Rad2.Status,Rad2);
Radio_Box(279,106,1,Rad1.Status,Rad1);

Command(75, 34,30,3,12,13,1,$26,Co1,Cin1);
Command(75, 54,30,3,12,13,1,$26,Co2,Cin2);
Command(75, 74,30,3,12,13,1,$26,Co3,Cin3);
Command(75, 94,30,3,7,13,1,$26,Co4,Cin4);
Command(279,67,30,3,12,13,1,$26,Co8,Cin8);
Command(279,28,30,3,V1,13,1,$26,Co5,Cin5);
Command(279,47,30,3,V2,13,1,$26,Co6,Cin6);
Command(60, 135,259,255,12,13,1,$27,Co7,Cin7);

If Rad2.Status=True Then Freeze_Command(On,Co4)    {*Gadget Autoris or No*}
                    Else Freeze_Command(Off,Co4);
Freeze_Radio(On,Rad2);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Str(Pos,Cin1);                          {*For Item Number*}
Init_Window(30,140,376,322+HaF1,$51D9,Loc(619)+Cin1,W1);
Sup_Window(100,50,347,218,59,50,400,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Grid:=My_Grid;                          {*Grille Si elle Existe*}
If Test_Check_Point(M,2,2)=True Then Begin{*Adjust Position if Pref is Set*}
   X:=TCY[Pos].X1; Y:=TCY[Pos].Y1;      {*Calcul New Coordonnes With Steps*}
   Get_Grid_Coord(X,Y);
   TCY[Pos].X1:=X; TCY[Pos].Y1:=Y;
   X:=TCY[Pos].SX; Y:=TCY[Pos].SY;
   Get_Grid_Coord(X,Y);
   TCY[Pos].SX:=X; TCY[Pos].SY:=Y;
End;
Grid:=Off;                              {*Plus de Grille Gnrale*}
Gad_Exist:=True;                        {*Gadgets Existent*}

Str(TCY[Pos].X1,Cin1); Str(TCY[Pos].Y1,Cin2);{*Init Values*}
Str(TCY[Pos].SX,Cin3); Str(TCY[Pos].SY,Cin4);
Str(TCY[Pos].B.CoB,Cin5); Str(TCY[Pos].B.CoP,Cin6);
Cin7:=TCY[Pos].Cin;
Str(TCY[Pos].B.CyclVal,Cin8);
Rad1.Status:=TCY[Pos].Freeze;
Rad2.Status:=On;                        {*Init Radio*}
If TCY[Pos].VanillaKey<>0 Then          {*Remet Caractre Soulign*}
   Insert('_',Cin7,TCY[Pos].VanillaKey);

V1:=TCY[Pos].B.CoB; V2:=TCY[Pos].B.CoP; {*Couleurs Gadget*}

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=Off; Cancel:=Off;             {*Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin
   If GetMsg_Button(But0,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But1,1)=True Then Cancel:=True;
   If GetMsg_Button(But2,1) Then Begin
      Palette_RequestG(80,100,Loc(518),1,V1);
      Str(V1,Cin5); REDRAW_FRAME;
      End;
   If GetMsg_Button(But3,1) Then Begin
      Palette_RequestG(80,100,Loc(518),1,V2);
      Str(V2,Cin6); REDRAW_FRAME;
      End;
   GetMsg_Command(Co7,Cin7);
   GetMsg_Command(Co1,Cin1); GetMsg_Command(Co2,Cin2);
   GetMsg_Command(Co3,Cin3); GetMsg_Command(Co4,Cin4);
   GetMsg_Command(Co5,Cin5); GetMsg_Command(Co6,Cin6);{*Fill Colors And Background*}
   GetMsg_Command(Co8,Cin8);
   GetMsg_Radio(Rad1,1);
   If GetMsg_Radio(Rad2,1)= True Then
      If Rad2.Status=True
         Then Freeze_Command(On,Co4)    {*Gadget Autoris*}
         Else Freeze_Command(Off,Co4);
   End;

Even:=Active_Window(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=Off Then Begin                {*Modification Confirme*}
   TCY[Pos].VanillaKey:=0;              {*De Base si il n'y en a pas*}
   For I:=1 to Length(Cin7) do
      If Copy(Cin7,I,1)='_' Then Begin
         TCY[Pos].VanillaKey:=I;
         End;
   If TCY[Pos].VanillaKey<>0 Then
      Cin7:=Copy(Cin7,1,TCY[Pos].VanillaKey-1)+Copy(Cin7,TCY[Pos].VanillaKey+1,Length(Cin7)-TCY[Pos].VanillaKey);

   Val(Cin1,TCY[Pos].X1,Code);          {*Transmet Values*}
   Val(Cin2,TCY[Pos].Y1,Code);
   Val(Cin3,TCY[Pos].SX,Code);
   Val(Cin4,TCY[Pos].SY,Code);
   TCY[Pos].B.CoB:=V1;
   TCY[Pos].B.CoP:=V2;
   Val(Cin8,TCY[Pos].B.CyclVal,Code);
   TCY[Pos].Cin:=Cin7;
   TCY[Pos].B.Lock:=Rad2.Status;
   TCY[Pos].Freeze:=Rad1.Status;
   BSET(Has_Changed,Num_Pro);           {*Une Modification a t Faite*}
   DEFINE_CYCLERS:=True;
   End Else DEFINE_CYCLERS:=False;

End;

{ͻ
                           PROCEDURE DEFINE_RADIO                           
 ͼ}

Function DEFINE_RADIOS(Pos:Byte):Boolean;
Var W1          :Win;                   {*Structure Fentre*}
    Even        :Byte;                  {*Rception Evenements Fentre*}
    Exit_Flg    :Boolean;               {*Flag de Sortie*}
    But0,But1   :ButG;                  {*Bouton Classique*}
    Cyc0,Cyc1   :ButG;                  {*Bouton Cycler*}
    Co1,Co2,Co4 :TCoReq;                {*Structure Bevels Boxes*}
    Cin1,Cin2,Cin4:String;              {*String Rcupre*}
    Rad2        :Rad;                   {*Pour Radio Evidement*}
    Code,Trans,I:Integer;
    Cancel      :Boolean;               {*Annulation Modifications*}
    X,Y         :Word;                  {*For Grid Parameters*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box(125,20,325,107,1,6,Off);
Button(LaF*12, 122,LaF*16,0,7,False,But0,'_OK');
Button(LaF*42, 122,LaF*16,0,7,False,But1,Loc(13));
DispG(60, 16,7,Loc(603));
DispG(22, 35,7,Loc(604));
DispG(22, 55,7,Loc(605));
DispG(140,29,7,Loc(620));
DispG(140,48,7,Loc(621));
DispG(140,67,7,Loc(622));
DispG(140,86,7,Loc(623));

Radio_Box(230,66,1,Rad2.Status,Rad2);

Command(75, 34,30,3,12,13,1,$27,Co1,Cin1);
Command(75, 54,30,3,12,13,1,$26,Co2,Cin2);
Command(230,84,30,3,12,13,1,$26,Co4,Cin4);
Cycler(230, 28,70,Cyc0.CyclVal,0,7,Cyc0,Loc(624));
Cycler(230, 47,70,Cyc1.CyclVal,0,7,Cyc1,Loc(625));

If Cyc0.CyclVal=3 Then Freeze_Command(Off,Co4) Else Freeze_Command(On,Co4);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Str(Pos,Cin1);                          {*For Item Number*}
Init_Window(30,180,376,322+HaF1,$51D9,Loc(626)+Cin1,W1);
Sup_Window(100,50,347,218,59,50,400,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Grid:=My_Grid;                          {*Grille Si elle Existe*}
If Test_Check_Point(M,2,2)=True Then Begin{*Adjust Position if Pref is Set*}
X:=TRB[Pos].X1; Y:=TRB[Pos].Y1;         {*Calcul New Coordonnes With Steps*}
Get_Grid_Coord(X,Y);
TRB[Pos].X1:=X; TRB[Pos].Y1:=Y;
End;
Grid:=Off;                              {*Plus de Grille Gnrale*}
Gad_Exist:=True;                        {*Gadgets Existent*}

Str(TRB[Pos].X1,Cin1); Str(TRB[Pos].Y1,Cin2);{*Init Values*}
Str(TRB[Pos].Group,Cin4);
Rad2.Status:=TRB[Pos].Freeze;           {*Init Radios*}
Cyc0.CyclVal:=TRB[Pos].R.Style+1;
If TRB[Pos].R.Status=On Then Cyc1.CyclVal:=1 Else Cyc1.CyclVal:=2;

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=Off; Cancel:=Off;             {*Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin
   If GetMsg_Button(But0,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But1,1)=True Then Cancel:=True;
   GetMsg_Command(Co1,Cin1);
   GetMsg_Command(Co2,Cin2);
   GetMsg_Command(Co4,Cin4);
   If GetMsg_Button(Cyc0,1)=True Then
     If Cyc0.CyclVal=3 Then Freeze_Command(Off,Co4)
                       Else Freeze_Command(On,Co4);
   GetMsg_Button(Cyc1,1);
   GetMsg_Radio(Rad2,1);
   End;

Even:=ACTIVE_WINDOW(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=Off Then Begin
   Val(Cin1,TRB[Pos].X1,Code);          {*Transmet Values*}
   Val(Cin2,TRB[Pos].Y1,Code);
   Val(Cin4,TRB[Pos].Group,Code);
   TRB[Pos].R.Style:=Cyc0.CyclVal-1;
   If Cyc1.CyclVal=1 Then TRB[Pos].R.Status:=On Else TRB[Pos].R.Status:=Off;
   TRB[Pos].Freeze:=Rad2.Status;
   BSET(Has_Changed,Num_Pro);           {*Une Modification a t Faite*}
   DEFINE_RADIOS:=True;
   End Else DEFINE_RADIOS:=False;

End;

{ͻ
                          PROCEDURE DEFINE_SLIDERS                          
 ͼ}

Function DEFINE_SLIDERS(Pos:Byte):Boolean;
Var W1            :Win;                 {*Structure Fentre*}
    Even          :Byte;                {*Rception Evenements Fentre*}
    Exit_Flg      :Boolean;             {*Flag de Sortie*}
    But0,But1,But2:ButG;                {*Bouton Classique*}
    Cyc0          :ButG;                {*Bouton Cycler*}
    Co1,Co2,Co3,Co4,
    Co5,Co6,Co7   :TCoReq;              {*Structure Bevels Boxes*}
    Cin1,Cin2,Cin3,Cin4,
    Cin5,Cin6,Cin7:String;              {*String Rcupre*}
    Rad2          :Rad;                 {*Pour Radio Evidement*}
    Code,Trans,I  :Integer;
    Cancel        :Boolean;             {*Annulation Modifications*}
    X,Y           :Word;                {*For Grid Parameters*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box(125,20,325,127,1,6,Off);
Button(LaF*12, 142,LaF*16,0,7,False,But0,'_OK');
Button(LaF*42, 142,LaF*16,0,7,False,But1,Loc(13));
Button(20, 115,85,11,9,False,But2,Loc(600));

SetColor(Col[0]);
DispG(60, 16,7,Loc(603));
DispG(22, 35,7,Loc(604));
DispG(22, 55,7,Loc(605));
DispG(22, 75,7,Loc(627));
DispG(22, 95,7,Loc(628));
DispG(140,28,7,Loc(629));
DispG(140,47,7,Loc(630));
DispG(140,68,7,Loc(631));
DispG(140,87,7,Loc(632));
DispG(140,107,7,Loc(633));

Radio_Box(230,106,1,Rad2.Status,Rad2);

Command(75, 34,30,3,12,13,1,$27,Co1,Cin1);
Command(75, 54,30,3,12,13,1,$26,Co2,Cin2);
Command(75, 74,30,3,12,13,1,$26,Co3,Cin3);
Command(75, 94,30,3,12,13,1,$26,Co4,Cin4);
Command(230,28,30,3,12,13,1,$26,Co5,Cin5);
Command(230,47,30,3,12,13,1,$26,Co6,Cin6);
Command(230,68,30,3,12,13,1,$26,Co7,Cin7);
Cycler( 230,87,70,Cyc0.CyclVal,0,7,Cyc0,Loc(634));
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Str(Pos,Cin1);                          {*For Item Number*}
Init_Window(30,160,376,322+HaF1,$51D9,Loc(635)+Cin1,W1);
Sup_Window(100,50,347,218,59,50,400,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Grid:=My_Grid;                          {*Grille Si elle Existe*}
If Test_Check_Point(M,2,2)=True Then Begin{*Adjust Position if Pref is Set*}
X:=TSL[Pos].X1; Y:=TSL[Pos].Y1;         {*Calcul New Coordonnes With Steps*}
Get_Grid_Coord(X,Y);
TSL[Pos].X1:=X; TSL[Pos].Y1:=Y;
X:=TSL[Pos].X2; Y:=TSL[Pos].Y2;
Get_Grid_Coord(X,Y);
TSL[Pos].X2:=X; TSL[Pos].Y2:=Y;
End;
Grid:=Off;                              {*Plus de Grille Gnrale*}
Gad_Exist:=True;                        {*Gadgets Existent*}

Str(TSL[Pos].X1,Cin1); Str(TSL[Pos].Y1,Cin2);{*Init Values*}
Str(TSL[Pos].X2,Cin3); Str(TSL[Pos].Y2,Cin4);
Str(TSL[Pos].S.Qtt,Cin5); Str(TSL[Pos].S.Aff,Cin6);
Str(TSL[Pos].S.Psl,Cin7);
Rad2.Status:=TSL[Pos].S.GDep;           {*Init Radios*}
Cyc0.CyclVal:=TSL[Pos].S.Typ+1;

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=Off; Cancel:=Off;             {*Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin
   If GetMsg_Button(But0,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But1,1)=True Then Cancel:=True;
   If GetMsg_Button(But2,1)=True Then ASK_SLIDER_TO_COMMAND(Pos);
   GetMsg_Command(Co1,Cin1);
   GetMsg_Command(Co2,Cin2);
   GetMsg_Command(Co3,Cin3);
   GetMsg_Command(Co4,Cin4);
   GetMsg_Command(Co5,Cin5);            {*Prefs Fill Colors And Background*}
   GetMsg_Command(Co6,Cin6);
   GetMsg_Command(Co7,Cin7);
   GetMsg_Button(Cyc0,1);
   GetMsg_Radio(Rad2,1);
   End;

Even:=ACTIVE_WINDOW(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=Off Then Begin
   Val(Cin1,TSL[Pos].X1,Code);          {*Transmet Values*}
   Val(Cin2,TSL[Pos].Y1,Code);
   Val(Cin3,TSL[Pos].X2,Code);
   Val(Cin4,TSL[Pos].Y2,Code);
   Val(Cin5,TSL[Pos].S.Qtt,Code);
   Val(Cin6,TSL[Pos].S.Aff,Code);
   Val(Cin7,TSL[Pos].S.Psl,Code);
   TSL[Pos].S.Typ:=Cyc0.CyclVal-1;
   TSL[Pos].S.GDep:=Rad2.Status;
   BSET(Has_Changed,Num_Pro);           {*Une Modification a t Faite*}
   DEFINE_SLIDERS:=True;
   End Else DEFINE_SLIDERS:=False;

End;

{ͻ
                          PROCEDURE DEFINE_COMMANDS                         
 ͼ}

Function DEFINE_COMMANDS(Pos:Byte):Boolean;
Var W1          :Win;                   {*Structure Fentre*}
    Even        :Byte;                  {*Rception Evenements Fentre*}
    Exit_Flg    :Boolean;               {*Flag de Sortie*}
    But0,But1,
    But2,But3   :ButG;                  {*Bouton Classique*}
    Co1,Co2,Co3,Co4,Co5,Co6,Co7,Co8:TCoReq;{*Structure Bevels Boxes*}
    Cin1,Cin2,Cin3,Cin4,
    Cin5,Cin6,Cin7,Cin8:String;         {*String Rcupre*}
    Rad2        :Rad;                   {*Pour Radio Evidement*}
    Code,Trans,I:Integer;
    Cancel      :Boolean;               {*Annulation Modifications*}
    X,Y         :Word;                  {*For Grid Parameters*}
    V1,V2       :Integer;               {*Couleurs TC/BGC*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box(125,20,325,125,1,6,Off);
Button(LaF*12, 162,LaF*16,0,7,False,But0,'_OK');
Button(LaF*42, 162,LaF*16,0,7,False,But1,Loc(13));
Button(140,28,110,11,9,False,But2,Loc(636));
Button(140,47,110,11,9,False,But3,Loc(637));

SetColor(Col[0]);
DispG(60, 16,7,Loc(603));
DispG(22, 35,7,Loc(604));
DispG(22, 55,7,Loc(605));
DispG(22, 75,7,Loc(606));
DispG(22, 135,7,Loc(608));
DispG(140,68,7,Loc(638));
DispG(140,87,7,Loc(639));
DispG(140,106,7,Loc(640));

Radio_Box(270,105,1,Rad2.Status,Rad2);

Command(75, 34,30,3,12,13,1,$26,Co1,Cin1);
Command(75, 54,30,3,12,13,1,$26,Co2,Cin2);
Command(75, 74,30,3,12,13,1,$26,Co3,Cin3);
Command(270,28,30,3,V1,13,1,$26,Co5,Cin5);
Command(270,47,30,3,V2,13,1,$26,Co6,Cin6);
Command(270,66,30,3,12,13,1,$26,Co4,Cin4);
Command(270,86,30,3,12,13,1,$26,Co8,Cin8);
Command(60, 135,264,255,12,13,1,$27,Co7,Cin7);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Str(Pos,Cin1);                          {*For Item Number*}
Init_Window(30,140,376,322+HaF1,$51D9,Loc(641)+Cin1,W1);
Sup_Window(100,50,347,218,59,50,400,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Grid:=My_Grid;                          {*Grille Si elle Existe*}
If Test_Check_Point(M,2,2)=True Then Begin{*Adjust Position if Pref is Set*}
X:=TCO[Pos].X1; Y:=TCO[Pos].Y1;         {*Calcul New Coordonnes With Steps*}
Get_Grid_Coord(X,Y);
TCO[Pos].X1:=X; TCO[Pos].Y1:=Y;
X:=TCO[Pos].T.Siz;
Get_Grid_Coord(X,Y);
TCO[Pos].T.Siz:=X;
End;
Grid:=Off;                              {*Plus de Grille Gnrale*}
Gad_Exist:=True;                        {*Gadgets Existent*}

Str(TCO[Pos].X1,Cin1); Str(TCO[Pos].Y1,Cin2);{*Init Values*}
Str(TCO[Pos].T.Siz,Cin3); Str(TCO[Pos].T.Len,Cin4);
Str(TCO[Pos].T.CoB,Cin5); Str(TCO[Pos].T.Co2,Cin6);
Str(TCO[Pos].T.Sty,Cin8);

Cin7:=TCO[Pos].Cin;
Rad2.Status:=TCO[Pos].Freeze;           {*Init Radios*}

V1:=TCO[Pos].T.CoB; V2:=TCO[Pos].T.Co2; {*Couleurs Gadgets*}

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=Off; Cancel:=Off;             {*Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin
   If GetMsg_Button(But0,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But1,1)=True Then Cancel:=True;
   If GetMsg_Button(But2,1) Then Begin
      Palette_RequestG(80,100,Loc(518),1,V1);
      Str(V1,Cin5); REDRAW_FRAME;
      End;
   If GetMsg_Button(But3,1) Then Begin
      Palette_RequestG(80,100,Loc(518),1,V2);
      Str(V2,Cin6); REDRAW_FRAME;
      End;
   GetMsg_Command(Co7,Cin7);
   GetMsg_Command(Co1,Cin1); GetMsg_Command(Co2,Cin2);
   GetMsg_Command(Co3,Cin3);
   GetMsg_Command(Co5,Cin5); GetMsg_Command(Co6,Cin6);{*Fill Colors And Background*}
   GetMsg_Command(Co4,Cin4); GetMsg_Command(Co8,Cin8);
   GetMsg_Radio(Rad2,1);
   End;

Even:=ACTIVE_WINDOW(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Supprime Fentre*}

If Cancel=Off Then Begin
   Val(Cin1,TCO[Pos].X1,Code);          {*Transmet Values*}
   Val(Cin2,TCO[Pos].Y1,Code);
   Val(Cin3,TCO[Pos].T.Siz,Code);
   Val(Cin4,TCO[Pos].T.Len,Code);
   TCO[Pos].T.CoB:=V1;
   TCO[Pos].T.Co2:=V2;
   Val(Cin8,TCO[Pos].T.Sty,Code);
   TCO[Pos].Cin:=Cin7;
   TCO[Pos].Freeze:=Rad2.Status;
   BSET(Has_Changed,Num_Pro);           {*Une Modification a t Faite*}
   DEFINE_COMMANDS:=True;
   End Else DEFINE_COMMANDS:=False;

End;

{ͻ
                         PROCEDURE DEFINE_BEVEL_BOX                         
 ͼ}

Function DEFINE_BEVEL_BOX(Pos:Byte):Boolean;
Var W1          :Win;                   {*Structure Fentre*}
    Even        :Byte;                  {*Rception Evenements Fentre*}
    Exit_Flg    :Boolean;               {*Flag de Sortie*}
    But0,But1,But2,But3:ButG;           {*Bouton Classique*}
    Co1,Co2,Co3,Co4,Co5,Co6:TCoReq;     {*Structure Bevels Boxes*}
    Cin1,Cin2,Cin3,
    Cin4,Cin5,Cin6:String;              {*String Rcupre*}
    Rad1,Rad2   :Rad;                   {*Pour Radio Evidement*}
    Code        :Integer;
    Cancel      :Boolean;               {*Annulation Modifs*}
    X,Y         :Word;                  {*For Grid Parameters*}
    V1,V2       :Integer;               {*Couleur TC/BGC*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box(125,20,325,107,1,6,Off);
Button(LaF*12, 122,LaF*16,0,7,False,But0,'_OK');
Button(LaF*42, 122,LaF*16,0,7,False,But1,Loc(13));
Button(140,28,110,11,9,False,But3,Loc(643));
Button(140,48,110,11,9,False,But2,Loc(601));

SetColor(Col[0]);
DispG(80, 16,7,Loc(644));
DispG(22, 35,7,Loc(604));
DispG(22, 55,7,Loc(605));
DispG(22, 75,7,Loc(627));
DispG(22, 95,7,Loc(628));
DispG(140,68,7,Loc(645));
DispG(140,88,7,Loc(646));

Command(75, 34,30,3,12,13,1,$27,Co1,Cin1);
Command(75, 54,30,3,12,13,1,$26,Co2,Cin2);
Command(75, 74,30,3,12,13,1,$26,Co3,Cin3);
Command(75, 94,30,3,12,13,1,$26,Co4,Cin4);
Command(270,28,30,3,12,13,1,$26,Co5,Cin5);
Command(270,48,30,3,V1,13,1,$26,Co6,Cin6);

Radio_Box(270,68,1,Rad1.Status,Rad1);
Radio_Box(270,88,1,Rad2.Status,Rad2);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Str(Pos,Cin1);                          {*For Item Number*}
Init_Window(30,180,376,322+HaF1,$51D9,Loc(647)+Cin1,W1);
Sup_Window(100,50,347,218,59,50,400,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Grid:=My_Grid;                          {*Grille Si elle Existe*}
If Test_Check_Point(M,2,2)=True Then Begin{*Adjust Position if Pref is Set*}
X:=TBB[Pos].X1; Y:=TBB[Pos].Y1;         {*Calcul New Coordonnes With Steps*}
Get_Grid_Coord(X,Y);
TBB[Pos].X1:=X; TBB[Pos].Y1:=Y;
X:=TBB[Pos].X2; Y:=TBB[Pos].Y2;
Get_Grid_Coord(X,Y);
TBB[Pos].X2:=X; TBB[Pos].Y2:=Y;
End;
Grid:=Off;                              {*Plus de Grille Gnrale*}
Gad_Exist:=True;                        {*Gadgets Existent*}

Str(TBB[Pos].X1,Cin1); Str(TBB[Pos].Y1,Cin2);{*Init Values*}
Str(TBB[Pos].X2,Cin3); Str(TBB[Pos].Y2,Cin4);
Str(TBB[Pos].Style,Cin5); Str(TBB[Pos].Co,Cin6);
Rad1.Status:=TBB[Pos].Fill;             {*Init Radios*}
Rad2.Status:=TBB[Pos].Cave;

V1:=TBB[Pos].Co; V2:=TBB[Pos].Style;    {*Couleur/Pattern Gadget*}

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=False; Cancel:=Off;           {*Flag de Sortie*}

Repeat;
Main_Task;                              {*Gre Systme*}
If Window_Ready(W1) Then                {*Teste si Fentre Prte*}
   Begin
   If GetMsg_Button(But0,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But1,1)=True Then Cancel:=True;
   If GetMsg_Button(But2,1) Then Begin
      Palette_RequestG(80,100,Loc(518),1,V1);
      Str(V1,Cin6); REDRAW_FRAME;
      End;
   If GetMsg_Button(But3,1) Then Begin
      Pattern_RequestG(80,100,Loc(648),V2);
      Str(V2,Cin5); REDRAW_FRAME;
      End;

   GetMsg_Command(Co1,Cin1); GetMsg_Command(Co2,Cin2);
   GetMsg_Command(Co3,Cin3); GetMsg_Command(Co4,Cin4);
   GetMsg_Command(Co5,Cin5); GetMsg_Command(Co6,Cin6);{*Fill Colors And Background*}
   GetMsg_Radio(Rad1,1); GetMsg_Radio(Rad2,1);
   End;

Even:=ACTIVE_WINDOW(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Suprime Fentre*}

If Cancel=Off Then Begin
   Val(Cin1,TBB[Pos].X1,Code);          {*Transmet Values*}
   Val(Cin2,TBB[Pos].Y1,Code);
   Val(Cin3,TBB[Pos].X2,Code);
   Val(Cin4,TBB[Pos].Y2,Code);
   TBB[Pos].Style:=V2;
   TBB[Pos].Co:=V1;
   TBB[Pos].Fill:=Rad1.Status;
   TBB[Pos].Cave:=Rad2.Status;
   BSET(Has_Changed,Num_Pro);           {*Une Modification a t Faite*}
   DEFINE_BEVEL_BOX:=True;
   End Else DEFINE_BEVEL_BOX:=False;

End;

{ͻ
                        PROCEDURE DEFINE_STRING_BOX                         
 ͼ}

Function DEFINE_STRING_BOX(Pos:Byte):Boolean;
Var W1          :Win;                   {*Structure Fentre*}
    Even        :Byte;                  {*Rception Evenements Fentre*}
    Exit_Flg    :Boolean;               {*Flag de Sortie*}
    But0,But1,But2,But3:ButG;           {*Bouton Classique*}
    Co1,Co2,Co3,Co4,Co5,Co6:TCoReq;     {*Structure Bevels Boxes*}
    Cin1,Cin2,Cin3,
    Cin4,Cin5,Cin6:String;              {*String Rcupre*}
    Rad1        :Rad;                   {*Pour Radio Evidement*}
    Code        :Integer;
    Cancel      :Boolean;               {*Annulation Modifs*}
    X,Y         :Word;                  {*For Grid Parameters*}
    V1,V2       :Integer;               {*Couleur TC/BGC*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);
String_Box(125,20,325,90,1,6,Off);
Button(LaF*12, 122,LaF*16,0,7,False,But0,'_OK');
Button(LaF*42, 122,LaF*16,0,7,False,But1,Loc(13));
Button(139, 30,115,11,9,False,But3,Loc(643));
Button(139, 50,115,11,9,False,But2,Loc(601));

SetColor(Col[0]);
DispG(80, 16,7,Loc(644));
DispG(22, 35,7,Loc(604));
DispG(22, 55,7,Loc(605));
DispG(22, 75,7,Loc(627));
DispG(22, 95,7,Loc(628));
DispG(140,70,7,Loc(646));

Command(75, 34,30,3,12,13,1,$27,Co1,Cin1);
Command(75, 54,30,3,12,13,1,$26,Co2,Cin2);
Command(75, 74,30,3,12,13,1,$26,Co3,Cin3);
Command(75, 94,30,3,12,13,1,$26,Co4,Cin4);
Command(270,30,30,3,12,13,1,$26,Co5,Cin5);
Command(270,50,30,3,V1,13,1,$26,Co6,Cin6);

Radio_Box(270,70,1,Rad1.Status,Rad1);
Clip_Window(Off,W1);
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Str(Pos,Cin1);                          {*For Item Number*}
Init_Window(30,180,376,322+HaF1,$51D9,Loc(649)+Cin1,W1);
Sup_Window(100,50,347,218,59,50,400,250,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Grid:=My_Grid;                          {*Grille Si elle Existe*}
If Test_Check_Point(M,2,2)=True Then Begin{*Adjust Position if Pref is Set*}
X:=TSB[Pos].X1; Y:=TSB[Pos].Y1;         {*Calcul New Coordonnes With Steps*}
Get_Grid_Coord(X,Y);
TSB[Pos].X1:=X; TSB[Pos].Y1:=Y;
X:=TSB[Pos].X2; Y:=TSB[Pos].Y2;
Get_Grid_Coord(X,Y);
TSB[Pos].X2:=X; TSB[Pos].Y2:=Y;
End;
Grid:=Off;                              {*Plus de Grille Gnrale*}
Gad_Exist:=True;                        {*Gadgets Existent*}

Str(TSB[Pos].X1,Cin1); Str(TSB[Pos].Y1,Cin2);{*Init Values*}
Str(TSB[Pos].X2,Cin3); Str(TSB[Pos].Y2,Cin4);
Str(TSB[Pos].Style,Cin5); Str(TSB[Pos].Co,Cin6);
Rad1.Status:=TSB[Pos].Cave;             {*Init Radios*}

V1:=TSB[Pos].Co; V2:=TSB[Pos].Style;    {*Couleur/Pattern Gadget*}

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=Off; Cancel:=Off;             {*Flag de Sortie*}

Repeat;
MAIN_TASK;                              {*Gre Systme*}
If WINDOW_READY(W1) Then                {*Teste si Fentre Prte*}
   Begin
   If GetMsg_Button(But0,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But1,1)=True Then Cancel:=True;
   If GetMsg_Button(But2,1) Then Begin
      Palette_RequestG(80,100,Loc(518),1,V1);
      Str(V1,Cin6); REDRAW_FRAME;
      End;
   If GetMsg_Button(But3,1) Then Begin
      Pattern_RequestG(80,100,Loc(648),V2);
      Str(V2,Cin5); REDRAW_FRAME;
      End;

   GetMsg_Command(Co1,Cin1); GetMsg_Command(Co2,Cin2);
   GetMsg_Command(Co3,Cin3); GetMsg_Command(Co4,Cin4);
   GetMsg_Command(Co5,Cin5); GetMsg_Command(Co6,Cin6);
   GetMsg_Radio(Rad1,1);
   End;

Even:=ACTIVE_WINDOW(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Suprime Fentre*}

If Cancel=Off Then Begin
   Val(Cin1,TSB[Pos].X1,Code);          {*Transmet Values*}
   Val(Cin2,TSB[Pos].Y1,Code);
   Val(Cin3,TSB[Pos].X2,Code);
   Val(Cin4,TSB[Pos].Y2,Code);
   TSB[Pos].Style:=V2;
   TSB[Pos].Co:=V1;
   TSB[Pos].Cave:=Rad1.Status;
   BSET(Has_Changed,Num_Pro);           {*Une Modification a t Faite*}
   DEFINE_STRING_BOX:=True;
   End Else DEFINE_STRING_BOX:=False;

End;

{ͻ
                          PROCEDURE DEFINE_TEXT                             
 ͼ}

Function DEFINE_TEXT(Pos:Byte):Boolean;
Var W1          :Win;                   {*Structure Fentre*}
    Even        :Byte;                  {*Rception Evenements Fentre*}
    Exit_Flg    :Boolean;               {*Flag de Sortie*}
    But0,But1,But2,
    But3,But4,But5:ButG;                {*Bouton Classique*}
    Com1,Com2,Com3,
    Com4,Com5,Com6,Com7:TCoReq;         {*Structure Bevels Boxes*}
    Cin1,Cin2,Cin3,
    Cin4,Cin5,Cin6,Cin7:String;         {*String Rcupre*}
    Code        :Integer;
    Cancel      :Boolean;               {*Cancel Modifications*}
    X,Y         :Word;                  {*For Grid Parameters*}
    V1,V2       :Integer;               {*Couleurs TC/BGC*}
    FontT,FontS   :Integer;             {*Gestion Requester de Fontes*}

{************************* AFFICHE CONTENU FENETRE **************************}

Procedure REDRAW_FRAME;                 {*Dfinition Contenu Fentre*}
Begin
Clip_Window(On,W1);                     {*Clipping de la Fentre*}
String_Box( LaF*22+0, HaF*2+1, LaF*63+0, HaF*9+6,1,6,False);
SetColor(0);
DispG( LaF*8, HaF*1+7,7,Loc(650));
DispG( LaF*4, HaF*4+2,7,Loc(604));
DispG( LaF*4, HaF*6+2,7,Loc(605));
DispG( LaF*4, HaF*8+2,7,Loc(644));
DispG( LaF*4, HaF*10+8,7,Loc(642));

Button( LaF*26, HaF*3+1, LaF*24,11,9,False,But1,Loc(601));
Button( LaF*26, HaF*5+1, LaF*24,11,9,False,But2,Loc(602));
Button( LaF*26, HaF*7+1, LaF*24,11,9,False,But3,Loc(719));
Button( LaF*10, HaF*13+6,LaF*16,0,7,False,But4,'_OK');
Button( LaF*40, HaF*13+6,LaF*16,0,7,False,But5,Loc(13));
Command(LaF*14, HaF*4+2, LaF*6,4,12,13,1,$26,Com1,Cin1);
Command(LaF*14, HaF*6+2, LaF*6,4,12,13,1,$26,Com2,Cin2);
Command(LaF*14, HaF*8+2, LaF*6,4,13,13,1,$26,Com3,Cin3);
Command(LaF*11, HaF*10+7,LaF*52,255,12,13,1,$27,Com4,Cin4);
Command(LaF*54, HaF*3+2, LaF*6,3,V1,13,1,$26,Com5,Cin5);
Command(LaF*54, HaF*5+2, LaF*6,3,V2,13,1,$26,Com6,Cin6);
Command(LaF*54, HaF*7+2, LaF*6,5,12,13,1,$26,Com7,Cin7);
Clip_Window(Off,W1);                    {*Restore le Clipping Normal*}
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Str(Pos,Cin1);                          {*For Item Number*}
Init_Window(30,180,30+LaF*67+0,180+HaF1+HaF*15+6,$51D9,Loc(651)+Cin1,W1);
Sup_Window(100,50,250,200,59,50,639,479,0,5,$0A00,W1);{*Supplment*}
If NError<>0 Then Exit;                 {*Erreurs Initialisations ?*}
Draw_Window(W1);                        {*Affiche la Fentre*}

Grid:=My_Grid;                          {*Grille Si elle Existe*}
If Test_Check_Point(M,2,2)=True Then Begin{*Adjust Position if Pref is Set*}
X:=TXT[Pos].X1; Y:=TXT[Pos].Y1;         {*Calcul New Coordonnes With Steps*}
Get_Grid_Coord(X,Y);
TXT[Pos].X1:=X; TXT[Pos].Y1:=Y;
End;
Grid:=Off;                              {*Plus de Grille Gnrale*}
Gad_Exist:=True;                        {*Gadgets Existent*}

Str(TXT[Pos].X1,Cin1); Str(TXT[Pos].Y1,Cin2);{*Init Values*}
Cin4:=TXT[Pos].Cin; Str(TextWidth(Cin4),Cin3);
Str(TXT[Pos].CB,Cin5); Str(TXT[Pos].CP,Cin6);
Cin7:='ABC1';
FontT:=2; FontS:=4;                     {*Dfinition Fonte*}

V1:=TXT[Pos].CB; V2:=TXT[Pos].CP;       {*Couleurs Gadgets*}

REDRAW_FRAME;                           {*Affiche le Contenu de la Fentre*}
Exit_Flg:=Off; Cancel:=Off;             {*Flags de Sortie*}

Repeat;
MAIN_TASK;                              {*Gre Systme*}
If WINDOW_READY(W1) Then                {*Teste si Fentre Prte*}
   Begin
   If GetMsg_Button(But4,1)=True Then Exit_Flg:=True;
   If GetMsg_Button(But5,1)=True Then Cancel:=True;
   If GetMsg_Button(But3,1) Then
      Font_RequestG(80,100,Loc(518),FontT,FontS);
   If GetMsg_Button(But1,1) Then Begin
      Palette_RequestG(80,100,Loc(518),1,V1);
      Str(V1,Cin5); REDRAW_FRAME;
      End;
   If GetMsg_Button(But2,1) Then Begin
      Palette_RequestG(80,100,Loc(518),1,V2);
      Str(V2,Cin6); REDRAW_FRAME;
      End;
   GetMsg_Command(Com1,Cin1); GetMsg_Command(Com2,Cin2);
   GetMsg_Command(Com5,Cin5); GetMsg_Command(Com6,Cin6);
   If GetMsg_Command(Com4,Cin4)=True Then Begin
      Str(TextWidth(Cin4),Cin3);
      Command(W1.X1+LaF*14, W1.Y1+HaF1+HaF*8+2, LaF*6,255,13,13,1,$26+$40,Com3,Cin3);
      End;
   End;

Even:=ACTIVE_WINDOW(W1);
If Even=1 Then Cancel:=True;            {*Fentre Ferme => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Fentre Dplace => Rafficher Contenu*}
Until (Exit_Flg=On) Or (Cancel=On);     {*Flag de Sortie*}

Kill_Window(W1);                        {*Suprime Fentre*}
If Cancel=Off Then Begin
   Val(Cin1,TXT[Pos].X1,Code);          {*Transmet Values*}
   Val(Cin2,TXT[Pos].Y1,Code);
   TXT[Pos].Cin:=Cin4;
   TXT[Pos].CB:=V1;
   TXT[Pos].CP:=V2;
   BSET(Has_Changed,Num_Pro);           {*Une Modification a t Faite*}
   DEFINE_TEXT:=True;
   End Else DEFINE_TEXT:=False;

End;

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

{ͻ
                                 GERE_ITEMS                                 
 ͹
  IN.......: I (BYTE) = Numro (1  8) Correspondant au type de Gadget.     
 ͼ}

Procedure GERE_ITEMS(I:Byte);
Var Ac,Sc:Byte;
    NUM,A:Integer;
    TT:TBevel;                                   {*Pour Transfert Donnes*}
    Lb:LightB;                                   {*Pour Move Light Box*}
    OffX,OffY:Integer;                           {*Dcalage for Sliders Buttons*}
    Ga,Mi,Dr:Boolean;                            {*Param Souris*}
    Xm,Ym:Word;                                  {*Position actuelle souris*}
    Exit_Box:Boolean;                            {*Sortie du Move_Box*}
    Vx1,Vy1,Vx2,Vy2:Integer;                     {*Value pour BoxMouseG et Light Box*}
    CreaItem:Boolean;                            {*Cration ou Cancel Item*}
    Max_VAL:Byte;                                {*Se dbrouiller pour virer ca !*}
    Ok         :Boolean;                         {*Coord Box "Select by Mouse"*}
    I2,I3      :Integer;                         {*Counter Type Item*}

{*********************** CALCULE COORDONNEES SELON ITEM *********************}

Procedure CALC_COORD;                            {*Mode ou Type...*}
Begin
Case NType of
   1: With TBU[Pos_ITM[1]] do Begin              {*Button*}
      Vx1:=X1;
      Vy1:=Y1;
      Vx2:=X1+Sx;
      Vy2:=Y1+Sy;
      End;
   2: With TCY[Pos_ITM[2]] do Begin              {*Cycler*}
      Vx1:=X1;
      Vy1:=Y1;
      Vx2:=X1+Sx+18;
      Vy2:=Y1+Sy;
      End;
   3: With TRB[Pos_ITM[3]] do Begin              {*Radio Box*}
      Vx1:=X1;
      Vy1:=Y1;
      Vx2:=X1+19;
      Vy2:=Y1+4+HaF;
      End;
   4: With TSL[Pos_ITM[4]] do Begin              {*Slider Item*}
      Vx1:=X1;
      Vy1:=Y1;
      Vx2:=X2+OffX;
      Vy2:=Y2+OffY;
      End;
   5: With TCO[Pos_ITM[5]] do Begin              {*Command*}
      Vx1:=X1;
      Vy1:=Y1;
      Vx2:=X1+T.Siz;
      Vy2:=Y1+4+HaF;
      End;
   6: With TBB[Pos_ITM[6]] do Begin              {*Bevel Box Item*}
      Vx1:=X1;
      Vy1:=Y1;
      Vx2:=X2;
      Vy2:=Y2;
      End;
   7: With TSB[Pos_ITM[7]] do Begin              {*String Box Item*}
      Vx1:=X1;
      Vy1:=Y1;
      Vx2:=X2;
      Vy2:=Y2;
      End;
   8: With TXT[Pos_ITM[8]] do Begin              {*Text Item*}
      Vx1:=X1;
      Vy1:=Y1;
      Vx2:=X1+2+TextWidth(Cin);
      Vy2:=Y1+2+HaF;
      End;
   End;
End;

{************************ CODE DE D'EDITION D'UN ITEM ***********************}

Procedure EDIT_ITEM;
Begin
CREATE_UNDO;                               {*Cr un Fichier UNDO*}
TOGGLE_ITEM(NType);                        {*Entoure  Nouveau Item*}
Case NType of
   1: DEFINE_BUTTONS(Pos_ITM[1]);          {*Demande Modification Paramtres*}
   2: DEFINE_CYCLERS(Pos_ITM[2]);
   3: DEFINE_RADIOS (Pos_ITM[3]);
   4: DEFINE_SLIDERS(Pos_ITM[4]);
   5: DEFINE_COMMANDS(Pos_ITM[5]);
   6: DEFINE_BEVEL_BOX(Pos_ITM[6]);
   7: DEFINE_STRING_BOX(Pos_ITM[7]);
   8: DEFINE_TEXT(Pos_ITM[8]);
   End;
REDRAW_WINDOW;                             {*Raffiche All Gadgets in Window*}
TOGGLE_ITEM(NType);                        {*Entoure  Nouveau Item*}
End;

{*********************** CODE DE SUPPRESSION D'UN ITEM **********************}

Procedure DEL_ITEM;
Var A,B:Integer;
Begin
For A:=Pos_ITM[NType]+1 to Qtt_ITM[NType] do Begin
   B:=A-1;
   Case NType of                        {*Transfre Structure*}
      1: TBU[B]:=TBU[A];
      2: TCY[B]:=TCY[A];
      3: TRB[B]:=TRB[A];
      4: TSL[B]:=TSL[A];
      5: TCO[B]:=TCO[A];
      6: TBB[B]:=TBB[A];
      7: TSB[B]:=TSB[A];
      8: TXT[B]:=TXT[A];
      End;
   End;

Dec(Qtt_ITM[NType]);                    {*Dcrmente Compteurs*}
Dec(Pos_ITM[NType]);
If (Qtt_ITM[NType]>0) And (Pos_ITM[NType]<1) Then Pos_ITM[NType]:=1;
REDRAW_WINDOW;                          {*Raffiche All Gadgets in Window*}
TOGGLE_ITEM(NType);                     {*Entoure  Nouveau Item*}
End;

{********************************* MAIN CODE ********************************}

Begin
If (GetChar(Ac,Sc)=True) And (Qtt_ITM[NType]>0) Then {*Rotate Selected Gadget*}
   Begin
   If (Sc=80) Or (Sc=77) Or (Upper(Chr(Ac))='+') {*Touche '+' = Bas/Droite*}
   Then Begin
   If Pos_ITM[NType]<>0 Then TOGGLE_ITEM(NType); {*Desentoure l'Item*}
   Inc(Pos_ITM[NType]);                          {*Next Item vers le Haut*}
   If Pos_ITM[NType]>Qtt_ITM[NType] Then Pos_ITM[NType]:=1;  {*Last Item Atteint => ROT*}
   TOGGLE_ITEM(NType);                           {*Entoure  Nouveau Item*}
   TIC;                                          {*Petit Bip !*}
   End;

   If (Sc=72) Or (Sc=75) Or (Upper(Chr(Ac))='-') {*Touche '-' = Haut/Gauche*}
   Then Begin
   If Pos_ITM[NType]<>0 Then TOGGLE_ITEM(NType); {*Desentoure l'Item*}
   Dec(Pos_ITM[NType]);                          {*Next Item vers le Bas*}
   If Pos_ITM[NType]<1 Then Pos_ITM[NType]:=Qtt_ITM[NType];  {*Last Item Atteint => ROT*}
   TOGGLE_ITEM(NType);                           {*Entoure  Nouveau Item*}
   TIC;                                          {*Petit Bip !*}
   End;

{gotoxy(1,2); writeln(Ac,'    ');
gotoxy(1,3); writeln(Ntype,' ',NPos,'     ');}

   If (Ac=13) And (NType>0) And (NPos>0) Then    {*Touche ENTER Presse*}
      EDIT_ITEM;                                 {*Edition de l'item Correspondant*}

   If (Sc=83) And (NType>0) And (NPos>0) Then    {*Delete Item - Touche Suppr*}
      Begin
      Num:=3;                                    {*Icne Question*}
      EZ_RequestG(Loc(461),Loc(613),Loc(614),NUM);
      If NUM=1 Then Begin                        {*Go to Delete*}
         TOGGLE_ITEM(I);                         {*Entoure  Nouveau Item*}
         DEL_ITEM;                               {*Delete Item*}
         BSET(Has_Changed,Num_Pro);              {*Une Modification a t Faite*}
         End;
      End;
   End;

If I=4 Then                                      {==== Spcial SLIDER ====}
   Begin
   OffX:=0; OffY:=0;                             {*Init Offsets to 0 de Base*}
   If TSL[Pos_ITM[4]].S.GDep=On Then             {*Size+40 car Size des Boutons Move*}
      If TSL[Pos_ITM[4]].S.Typ=0 Then OffX:=41 Else OffY:=30;
   End;

If (Pos_ITM[I]>0) And                            {*Move Item*}
   ((Special_Key(0)) Or (Special_Key(1))) Then   {*SHIFT to Actionner*}
   Begin
   CALC_COORD;
   Lb.X1:=Vx1+W.X1;                              {*Add Coordonnes Window Project*}
   Lb.Y1:=Vy1+W.Y1;
   Lb.X2:=Vx2+W.X1;
   Lb.Y2:=Vy2+W.Y1;

   Grid:=My_Grid;                                {*Grille Si elle Existe*}
      Repeat
      Exit_Box:=False;
      If Move_Box(Lb,1)=True Then Begin          {*Move Box*}
         TOGGLE_ITEM(NType);                     {*Entoure  Nouveau Item*}
         CREATE_UNDO;                            {*Cr un Fichier UNDO*}
         A:=Pos_ITM[NType];                      {*Optimisations*}
         Case NType of                           {*Modif Parameters*}
            1: With TBU[A] do Begin
               X1:=Lb.X1-W.X1;                   {*Button*}
               Y1:=Lb.Y1-W.Y1;
               SX:=Lb.X2-W.X1-X1;
               SY:=Lb.Y2-W.Y1-Y1;
               End;
            2: With TCY[A] do Begin              {*Cycler*}
               X1:=Lb.X1-W.X1;
               Y1:=Lb.Y1-W.Y1;
               SX:=Lb.X2-W.X1-X1-18;
               SY:=Lb.Y2-W.Y1-Y1;
               End;
            3: Begin                             {*Radio Box*}
               TRB[A].X1:=Lb.X1-W.X1;
               TRB[A].Y1:=Lb.Y1-W.Y1;
               End;
            4: Begin                             {*Slider Item*}
               TSL[A].X1:=Lb.X1-W.X1;
               TSL[A].Y1:=Lb.Y1-W.Y1;
               TSL[A].X2:=Lb.X2-W.X1-OffX;
               TSL[A].Y2:=Lb.Y2-W.Y1-OffY;
               End;
            5: Begin                             {*Command*}
               TCO[A].X1:=Lb.X1-W.X1;
               TCO[A].Y1:=Lb.Y1-W.Y1;
               TCO[A].T.Siz:=Lb.X2-W.X1-TCO[A].X1;
               End;
            6: Begin                             {*Bevel Box Item*}
               TBB[A].X1:=Lb.X1-W.X1;
               TBB[A].Y1:=Lb.Y1-W.Y1;
               TBB[A].X2:=Lb.X2-W.X1;
               TBB[A].Y2:=Lb.Y2-W.Y1;
               End;
            7: Begin                             {*String Box Item*}
               TSB[A].X1:=Lb.X1-W.X1;
               TSB[A].Y1:=Lb.Y1-W.Y1;
               TSB[A].X2:=Lb.X2-W.X1;
               TSB[A].Y2:=Lb.Y2-W.Y1;
               End;
            8: Begin                             {*Text Item*}
               TXT[A].X1:=Lb.X1-W.X1+4;
               TXT[A].Y1:=Lb.Y1-W.Y1+1;
               End;
            End;
         REDRAW_WINDOW;                          {*Raffiche All Gadgets in Window*}
         TOGGLE_ITEM(NType);                     {*Entoure  Nouveau Item*}
         Exit_Box:=True;
         End;
      Until (Exit_Box=True) Or (LightB_Status=False);
   Grid:=Off;                                    {*Sucre Grille*}
   End;
                     {*SELECT ITEM BY MOUSE*}
GetMouseG(Xm,Ym,Ga,Mi,Dr);                       {*Rcupre Coord Souris*}
I2:=1;                                           {*Tous les 8 Types*}
Ok:=False;                                       {*De base pas Slectionn*}

If ((Xold<>Xm) Or (Yold<>Ym)) And (LightB_Status=False) Then
   Begin
   Repeat
      I3:=I2;
      If I2=6 Then I3:=8;                        {*Patch TEXT Before Boxes*}
      If I2=7 Then I3:=6;
      If I2=8 Then I3:=7;
      A:=Qtt_ITM[I3];                            {*Qtt d'items pour 1 Type*}
      While (Not Ok) And (A>=1) do               {*Fin dans 1 type d'Item*}
         Begin
         Case I3 of
            1: With TBU[A] do Begin              {*Button*}
               Vx1:=X1;
               Vy1:=Y1;
               Vx2:=X1+Sx;
               Vy2:=Y1+Sy;
               End;
            2: With TCY[A] do Begin              {*Cycler*}
               Vx1:=X1;
               Vy1:=Y1;
               Vx2:=X1+Sx+18;
               Vy2:=Y1+Sy;
               End;
            3: With TRB[A] do Begin              {*Radio Box*}
               Vx1:=X1;
               Vy1:=Y1;
               Vx2:=X1+19;
               Vy2:=Y1+4+HaF;
               End;
            4: With TSL[A] do Begin              {*Slider Item*}
               Vx1:=X1;
               Vy1:=Y1;
               Vx2:=X2;
               Vy2:=Y2;
               End;
            5: With TCO[A] do Begin              {*Command*}
               Vx1:=X1;
               Vy1:=Y1;
               Vx2:=X1+T.Siz;
               Vy2:=Y1+4+HaF;
               End;
            6: With TBB[A] do Begin              {*Bevel Box Item*}
               Vx1:=X1;
               Vy1:=Y1;
               Vx2:=X2;
               Vy2:=Y2;
               End;
            7: With TSB[A] do Begin              {*String Box Item*}
               Vx1:=X1;
               Vy1:=Y1;
               Vx2:=X2;
               Vy2:=Y2;
               End;
            8: With TXT[A] do Begin              {*Text Item*}
               Vx1:=X1;
               Vy1:=Y1;
               Vx2:=X1+TextWidth(Cin)+2;
               Vy2:=Y1+2+HaF;
               End;
            End;

         Vx1:=Vx1+W.X1;                          {*Add Coordonnes Window Project*}
         Vy1:=Vy1+W.Y1;
         Vx2:=Vx2+W.X1;
         Vy2:=Vy2+W.Y1;

         If (BoxMouseG(Vx1,Vy1,Vx2,Vy2,10)=True) Then
            Begin                                {*On est dans un Item*}
            NType:=I3;
            NPos:=A;
            Ok:=True;                            {*Item peut tre Slectionn*}
            End;
         Dec(A);                                 {*Next Item dans Type...*}
         End;                                    {*Fin dans 1 type d'Item*}

   Inc(I2);                                      {*Type d'Item Suivant...*}
   Until (Ok=True) Or (I2>8);                    {*Fin des Types d'Items*}

   If Ok Then Set_Pointer(P_Hand)                {*Affiche une Main Devant Item*}
         Else Set_Pointer(P_Current);

   If ((NPos<>OPos) Or (NType<>OType)) And (Ok) Then
      Begin
      TOGGLE_ITEM(OType);                        {*Dsentoure l'Item*}
      Pos_ITM[NType]:=NPos;
      TOGGLE_ITEM(NType);                        {*Entoure  Nouveau Item*}
      Xold:=Xm; Yold:=Ym; TIC;
      OPos:=NPos;                                {*Save Id Item Selected*}
      OType:=NType;
      End;
   End;                                          {*End Select Item by Mouse*}

                 { EDIT ITEM BY DOUBLE CLICK }
CALC_COORD;                                      {*Calcule Coord for Item*}
Vx1:=Vx1+W.X1;
Vy1:=Vy1+W.Y1;                                   {*Add Coordonnes Window Project*}
Vx2:=Vx2+W.X1;
Vy2:=Vy2+W.Y1;

If (BoxMouseG(Vx1,Vy1,Vx2,Vy2,10)=True) And (Double_Click) Then
   EDIT_ITEM;                                    {*Edition de l'item Correspondant*}

                 { CREATE NEW ITEM }
Case I of                                        {*Get Qtt Max for Item...*}
   1: Max_VAL:=Max_TBU;
   2: Max_VAL:=Max_TCY;
   3: Max_VAL:=Max_TRB;
   4: Max_VAL:=Max_TSL;
   5: Max_VAL:=Max_TCO;
   6: Max_VAL:=Max_TBB;
   7: Max_VAL:=Max_TSB;
   8: Max_VAL:=Max_TXT;
   End;
Grid:=My_Grid;                                   {*Utilise Grille si Existe*}
If (Light_Box(Lb1,1)=True) And
   (Lb1.X2-Lb1.X1<>0) Then                       {*Gestion Light_Box*}
   If Qtt_ITM[I]=Max_VAL Then ERROR_01           {*Tableau is Full !!!*}
   Else Begin
   CREATE_UNDO;                                  {*Cr un Fichier UNDO*}
   Inc(Qtt_ITM[I]);                              {*1 Bevel de plus*}
   TOGGLE_ITEM(I);                               {*Entoure  Nouveau Item*}
   Pos_ITM[I]:=Qtt_ITM[I];                       {*Edition du Dernier*}
   Vx1:=Lb1.X1-W.X1;                             {*Calcule True Coord Light Box*}
   Vy1:=Lb1.Y1-W.Y1;
   Vx2:=Lb1.X2-W.X1;
   Vy2:=Lb1.Y2-W.Y1;
   A:=Qtt_ITM[I];                                {*Optimisations*}
   Case I of
      1: Begin
         TBU[A].X1:=Vx1;
         TBU[A].Y1:=Vy1;
         TBU[A].SX:=Lb1.X2-Lb1.X1;
         End;
      2: Begin
         TCY[A].X1:=Vx1;
         TCY[A].Y1:=Vy1;
         TCY[A].SX:=Lb1.X2-Lb1.X1-18;            {*Size Less 18 for Image "Cycle"*}
         End;
      3: Begin
         TRB[A].X1:=Vx1;
         TRB[A].Y1:=Vy1;
         End;
      4: With TSL[A] do Begin                    {*Slider Item*}
         X1:=Vx1;
         Y1:=Vy1;
         X2:=Vx2-1;
         Y2:=Vy2-1;
         If Lb1.X2-Lb1.X1>Lb1.Y2-Lb1.Y1 Then S.Typ:=0
                                        Else S.Typ:=1;
         End;
      5: Begin                                   {*Command*}
         TCO[A].X1:=Vx1;
         TCO[A].Y1:=Vy1+1;
         TCO[A].T.Siz:=Lb1.X2-Lb1.X1;
         End;
      6: Begin                                   {*Bevel Box Item*}
         TBB[A].X1:=Vx1;
         TBB[A].Y1:=Vy1;
         TBB[A].X2:=Vx2;
         TBB[A].Y2:=Vy2;
         End;
      7: Begin                                   {*String Box Item*}
         TSB[A].X1:=Vx1+1;
         TSB[A].Y1:=Vy1+1;
         TSB[A].X2:=Vx2-1;
         TSB[A].Y2:=Vy2-1;
         End;
      8: Begin                                   {*Text Item*}
         TXT[A].X1:=Vx1;
         TXT[A].Y1:=Vy1+1;
         End;
      End;

   If (Test_Check_Point(M,2,1)=True) And (Qtt_ITM[I]>1){*Clone Gadgets*}
      Then Begin
      A:=Pos_ITM[I]-1;                           {*Optimisations*}
      Case I of
         1: With TBU[Pos_ITM[1]] do Begin        {*Button*}
               SY:=TBU[A].SY;
               B.CoB:=TBU[A].B.CoB;
               B.CoP:=TBU[A].B.CoP;
               Freeze:=TBU[A].Freeze;
               B.Lock:=TBU[A].B.Lock;
               B.TCT[1]:=TBU[A].B.TCT[1];
               VanillaKey:=TBU[A].VanillaKey;
               End;
         2: With TCY[Pos_ITM[2]] do Begin           {*Cycler*}
               SY:=TCY[A].SY;
               B.CoB:=TCY[A].B.CoB;
               B.CoP:=TCY[A].B.CoP;
               B.Lock:=TCY[A].B.Lock;
               Freeze:=TCY[A].Freeze;
               B.CyclVal:=TCY[A].B.CyclVal;
               Cin:=TCY[A].Cin;
               End;
         3: With TRB[Pos_ITM[3]] do Begin           {*Radio Box*}
               R.Style:=TRB[A].R.Style;
               R.Status:=TRB[A].R.Status;
               Freeze:=TRB[A].Freeze;
               Group:=TRB[A].Group;
               End;
         4: With TSL[Pos_ITM[4]] do Begin           {*Slider Item*}
               S.Qtt:=TSL[A].S.Qtt;
               S.Aff:=TSL[A].S.Aff;
               S.Psl:=TSL[A].S.Psl;
               S.GDep:=TSL[A].S.GDep;
               End;
         5: With TCO[Pos_ITM[5]] do Begin           {*Command*}
               T.Len:=TCO[A].T.Len;
               T.CoB:=TCO[A].T.CoB;
               T.Co2:=TCO[A].T.Co2;
               T.Sty:=TCO[A].T.Sty;
               Freeze:=TCO[A].Freeze;
               Cin:=TCO[A].Cin;
               End;
         6: With TBB[Pos_ITM[6]] do Begin           {*Bevel Box Item*}
               Style:=TBB[A].Style;
               Co:=TBB[A].Co;
               Fill:=TBB[A].Fill;
               Cave:=TBB[A].Cave;
               End;
         7: With TSB[Pos_ITM[7]] do Begin           {*String Box Item*}
               Style:=TSB[A].Style;
               Co:=TSB[A].Co;
               Cave:=TSB[A].Cave;
               End;
         8: With TXT[Pos_ITM[8]] do Begin           {*Text Item*}
               CB:=TXT[A].CB;
               CP:=TXT[A].CP;
               Cin:=TXT[A].Cin;
               End;
         End;
      End
   Else Begin
      Case I of
         1: With TBU[Qtt_ITM[1]] do Begin           {*Button*}
               SY:=HaF+4;
               B.CoB:=7;
               B.CoP:=0;
               Freeze:=Off;
               B.Lock:=Off;
               B.TCT[1]:=Loc(615);
               VanillaKey:=1;
               End;
         2: With TCY[Qtt_ITM[2]] do Begin           {*Cycler*}
               SY:=HaF+4;
               B.CoB:=7;
               B.CoP:=0;
               B.Lock:=Off;
               Freeze:=Off;
               B.CyclVal:=1;
               Cin:='LABEL 1|LABEL 2';
               End;
         3: With TRB[Pos_ITM[3]] do Begin           {*Radio Box*}
               R.Style:=1;
               R.Status:=On;
               Freeze:=Off;
               Group:=1;
               End;
         4: With TSL[Pos_ITM[4]] do Begin           {*Slider Item*}
               S.Qtt:=100;
               S.Aff:=10;
               S.Psl:=0;
               S.GDep:=On;
               End;
         5: With TCO[Pos_ITM[5]] do Begin           {*Command*}
               T.Len:=100;
               T.CoB:=12;
               T.Co2:=13;
               T.Sty:=0;
               Freeze:=Off;
               Cin:=Loc(642);
               End;
         6: With TBB[Pos_ITM[6]] do Begin           {*Bevel Box Item*}
               Style:=Bev_Style;
               Co:=Bev_Coul;
               Fill:=On;
               Cave:=Off;
               End;
         7: With TSB[Pos_ITM[7]] do Begin           {*String Box Item*}
               Style:=Bev_Style;
               Co:=Bev_Coul;
               Cave:=Off;
               End;
         8: With TXT[Pos_ITM[8]] do Begin           {*Text Item*}
               CB:=7;
               CP:=0;
               Cin:=Loc(642);
               End;
         End;
      End;

   Case I of
      1: CreaItem:=DEFINE_BUTTONS(Pos_ITM[1]);
      2: CreaItem:=DEFINE_CYCLERS(Pos_ITM[2]);
      3: CreaItem:=DEFINE_RADIOS (Pos_ITM[3]);
      4: CreaItem:=DEFINE_SLIDERS(Pos_ITM[4]);
      5: CreaItem:=DEFINE_COMMANDS(Pos_ITM[5]);
      6: CreaItem:=DEFINE_BEVEL_BOX(Pos_ITM[6]);
      7: CreaItem:=DEFINE_STRING_BOX(Pos_ITM[7]);
      8: CreaItem:=DEFINE_TEXT(Pos_ITM[8]);
      End;

   If CreaItem=False Then Begin                  {*Delete Item*}
      NType:=I; DEL_ITEM;                        {*NType = Type de Cration*}
      End
      Else Begin
      REDRAW_WINDOW;                             {*Raffiche All Gadgets in Window*}
      TOGGLE_ITEM(I);                            {*Entoure  Nouveau Item*}
      End;
   OType:=I;
   OPos:=Pos_ITM[I];
   End;
Grid:=Off;                                       {*Plus de Grille Gnrale*}
End;

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

Begin
End.
