{$F+} { Compiler Directive: Generate far calls: On } { Do Not Change! }

(*****************************************************************************

  Program: Draw demonstration program.

  Purpose:
    This program demonstrates the abilities of the various drawing units.

  Features:
    This program draws a screen design using the job utilities of the Draw
    unit and finally displays yet another design performed with simple lines.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compiler:
    Turbo Pascal versions 5.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Program Draw_Demonstration( Input, Output );

  Uses
    Draw,
    Screen,
    FillCode;

  Var
   { Used to space out line lines. }
    Count,
   { These two variables define particular coordinates on the screen. }
    YPiece,
    XPiece,
    Move_X,
    Move_Y: Integer;
   { Holds the default video mode. }
    Old_Mode: Byte;

  Begin
    WriteLn( 'Draw demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates the draw unit.  It draws a series of images' );
    WriteLn( 'using various features from the unit.  To continue on to the next image, ' );
    WriteLn( 'merely press the Enter key.' );
    WriteLn;
    WriteLn( 'Please press [enter] to start.' );
    ReadLn;

   { First set up the screen. }
    Get_Screen_Mode( Old_Mode );
    Set_Screen_Mode( 15 );

   { Set up for the next design. }
    Clear_Graphic_Screen;
    XPiece := ( GetMaxX div 12 );
    YPiece := ( GetMaxY div 2 );
   { Draw the interlaying circle design. }
    Clear_List;
    Draw_Elliptical_Arc_Job( XPiece * 3, YPiece, 0, 360, 140, 90 );
    Draw_Elliptical_Arc_Job( XPiece * 4, YPiece, 0, 360, 130, 80 );
    Draw_Elliptical_Arc_Job( XPiece * 5, YPiece, 0, 360, 120, 70 );
    Draw_Elliptical_Arc_Job( XPiece * 6, YPiece, 0, 360, 110, 60 );
    Draw_Elliptical_Arc_Job( XPiece * 7, YPiece, 0, 360, 100, 50 );
    Draw_Elliptical_Arc_Job( XPiece * 8, YPiece, 0, 360, 90, 40 );
    Draw_Elliptical_Arc_Job( XPiece * 9, YPiece, 0, 360, 80, 30 );
    Draw_Elliptical_Arc_Job( XPiece * 10, YPiece, 0, 360, 70, 20 );
    Draw_List;
    ReadLn;

   { Set up for the next screen. }
    Clear_Graphic_Screen;
    XPiece := ( GetMaxX div 2 );
    YPiece := ( GetMaxY div 2 );
   { Draw the line display. }
    Move_X := 0;
    Move_Y := 0;
    For Count := 1 to XPiece do
      Begin
        Draw_Line( XPiece, YPiece, Move_X, Move_Y );
        Inc( Move_X, 2 );
      End;
    For Count := 1 to YPiece do
      Begin
        Draw_Line( XPiece, YPiece, Move_X, Move_Y );
        Inc( Move_Y, 2 );
      End;
    For Count := 1 to XPiece do
      Begin
        Draw_Line( XPiece, YPiece, Move_X, Move_Y );
        Dec( Move_X, 2 );
      End;
    For Count := 1 to YPiece do
      Begin
        Draw_Line( XPiece, YPiece, Move_X, Move_Y );
        Dec( Move_Y, 2 );
      End;
    ReadLn;

   { Return to default graphical mode. }
    Set_Screen_Mode( Old_Mode );

  End.
