#include    "userrec.h"  

// set-up the stack 
extern  uint _stklen = 64000U;

extern  configrec     syscfg;            // holds info from config.dat 
extern  configoverrec syscfgovr;         // holds info from config.ovr
extern  mailu         u;                 // holds mailu 
extern  int           ansi,              // flag for ansi usage 
		      logoff,            // should the door logoff 
		      user_num;          // current user's number
extern  char          main_dir[MAXPATH], // start-up directory
		      syslog[MAXPATH];   // path to sysop's temp log
static  userrec       user;              // your userrec  
//===================================================================
void convert_to()
{
		// transfers your userrec info into my mailu structure 
		
		strcpy(u.name, user.name);
		u.screenlines     = user.screenlines;
		u.sl              = user.sl;
		u.dsl             = user.dsl;
		u.waiting         = user.waiting;
		u.age             = user.age;
		u.ar              = user.ar;
		u.dar             = user.dar;
		u.restrict        = user.restrict;
		u.msgpost         = user.msgpost;
		u.posttoday       = user.posttoday;
		u.daten           = user.daten;
		u.gold            = user.gold;
		u.postnet         = user.postnet;
		u.sex             = user.sex;
		u.sysstatus       = user.sysstatus;
		u.wwiv_regnum     = user.wwiv_regnum;
		u.defprot         = user.defprot;
}
//===================================================================
void convert_from()
{
		// transfers my mailu info to your userrec structure
		// BTW: WWIVMail/QWK only updates these fields, so the entire
		// userrec doesn't need to be updated 
		
		user.waiting         = u.waiting;
		user.msgpost         = u.msgpost,
		user.posttoday       = u.posttoday;
		user.gold            = u.gold;
		user.postnet         = u.postnet;
}
//===================================================================
int get_user
(
int num, 
userrec *user_data,
int *num_userrecs
)
{
	ulong pos;
	int   userfile, iret = 0;
	char  line[MAXPATH];


	// number of possible users found
	*num_userrecs = 0;

	// actually open the user file 
	sprintf(line, "%sUSER.LST", syscfg.datadir);
	if ((userfile = sh_open1(line, O_RDWR | O_BINARY)) != -1) {

		*num_userrecs = ((int)(filelength(userfile)/syscfg.userreclen) - 1);

		// goto and read a specific user
		pos = (long)num * syscfg.userreclen;
		if (lseek(userfile, pos, SEEK_SET) != -1L) { 
			if (read(userfile, user_data, syscfg.userreclen) > 0) {
				if (user_data->inact & inact_deleted)
					iret = 0;
				else
					iret = 1;
			}
		}
		close(userfile);
	}

	return(iret);
} 
//===================================================================
int put_user
(
int num, 
userrec *user_data
)
{
	ulong pos;
	int   userfile, iret = 0;
	char  line[MAXPATH];

	// actually open the user file 
	sprintf(line, "%sUSER.LST", syscfg.datadir);
	if ((userfile = sh_open1(line, O_RDWR | O_BINARY)) != -1) {

		// goto and write a specific user
		pos = (long)num * syscfg.userreclen;
		if (lseek(userfile, pos, SEEK_SET) != -1L) {
		   if (write(userfile, user_data, syscfg.userreclen) > 0)
				iret = 1;
		}
		close(userfile);
	}

	return(iret);
}
//===================================================================
void freshen_mailu_and_qscn
(
)
{
	// reads from your userrec and updates the mailu/qsc information
	int num_userrecs;

	if (get_user(user_num, &user, &num_userrecs)) {
		convert_to();
		Read_Qscn();
	} else
		user_num = 0;
}
//===================================================================
int read_user_info
(
char  *filepath,
ulong *cur_baud, 
ulong *com_speed
)
{
		// opens user file and config file to get info for userrec 

		int advance;
		char line[81];
		FILE *chain;

		// line 1 of chain.txt has user number 
		if ((filepath == NULL) || ((chain = fsh_open(filepath, "r")) <= 0))
			return(1);
		fgets(line, 80, chain);
		user_num = (int)atoi(line);

		// skip on down to ansi support line 
		for(advance = 1; advance < 14; advance++)
			fgets(line, 80, chain);
		ansi = atoi(line);

		// skip on down to sysop log filename
		for(advance = 1; advance < 6; advance++)
			fgets(line, 80, chain);
		strcpy(syslog, line);

		// skip on down to current baud rate 
		fgets(line, 80, chain);
		*cur_baud = (ulong)atol(line);

		// skip on down to current com_speed 
		for(advance = 1; advance < 12; advance++)
			fgets(line, 80, chain);
		*com_speed = (ulong)atol(line);

		fclose(chain);
		freshen_mailu_and_qscn(); 
		
		return(0);
}
//===================================================================
void write_user
(
int clean,
int email,
int update
)
{
		// Open the user file and update the last read pointers 

		cd_to(main_dir);

		if (clean && email && u.waiting) {
			print(cr, "Writing Updated E-Mail Pointer...");
			Write_Sysop("Writing Updated E-Mail Pointer...");
			delmail();
		}

		convert_from();
		put_user(user_num, &user);
		
		if (update) {
			print(cr, "Writing Updated Q-Scan Pointers...");
			Write_Sysop("Writing Updated Q-Scan Pointers...");
			Write_Qscn();
			Read_Qscn();
		}
		
		cd_to(syscfgovr.tempdir);
}
//===================================================================
void user_ssm
(
int un
)
{
		// tells a user that he/she has one more piece of
		// short message to read 

		userrec tempuser;
		int num_userrecs;
		
		if (get_user(un, &tempuser, &num_userrecs)) {        
			tempuser.sysstatus |= sysstatus_smw;
			put_user(un, &tempuser);
		}
}
//===================================================================
void user_import
(
int un
)
{
		// tells a user that he/she has one more piece of  e-mail to read 
		userrec tempuser;
		int num_userrecs;

		if (get_user(un, &tempuser, &num_userrecs)) {
			tempuser.waiting++;
			put_user(un, &tempuser);
		}
}
//===================================================================
void mail_forward
(
int un, 
ushort *touser, 
ushort *tosys, 
ushort *net_num
)
{
		// tells if a user has his/her e-mail forwarded 
		   
		userrec tempuser;
		int num_userrecs;
	
		*touser = *tosys = *net_num = 0;    
		if (get_user(un, &tempuser, &num_userrecs)) {
			*touser = tempuser.forwardusr;
			*tosys  = tempuser.forwardsys;
			*net_num = tempuser.net_num;
		}
}
//===================================================================
void get_user_name
(
int un,
char *name,
int *num_userrecs
)
{
		// returns a user's name...used for e-mail

		userrec tempuser;
	
		if (get_user(un, &tempuser, num_userrecs)) {
			strcpy(name, tempuser.name);
		} else
			name = '\0';
}
//===================================================================
void main(int argc, char *argv[])
{
	// this is a stub for the REAL main() routine. 

	realmain(argc, argv);
}
//===================================================================
