REM  COPYRIGHT 1993. DR. WARD DEUTSCHMAN, BRIARCLIFFE, ACADEMIC AFFAIRS
COLOR 1, 15
BEGIN:
CLS
GOSUB IDENT
LOCATE 2, 5: PRINT "This program is designed to assist in advising college students"
LOCATE 3, 5: PRINT "who have low overall averages (QPA generally less than 2.0)."
LOCATE 5, 5: PRINT "It is designed to answer two questions.  These are:"
LOCATE 7, 5: PRINT "1. What QPA will the student need to maintain in order to graduate"
LOCATE 8, 9: PRINT "with the minimum required number of credits?"
LOCATE 10, 5: PRINT "2. How many credits must the student take in order to achieve the"
LOCATE 11, 9: PRINT "minimum QPA necessary to graduate?"
LOCATE 13, 5: PRINT "3.  Information about this program."
LOCATE 15, 5: INPUT "Please select 1, 2, or 3.  Press <Enter> to stop. ", CHOICE$
        IF CHOICE$ = "" THEN GOTO FINISHED
        IF CHOICE$ = "1" THEN GOTO ONE
        IF CHOICE$ = "2" THEN GOTO TWO
        IF CHOICE$ = "3" THEN GOTO INFO
        GOTO BEGIN

ONE:
CLS
GOSUB IDENT
LOCATE 6, 5: INPUT "How many credits are required for the student's major? ", FINCRED
LOCATE 8, 5: INPUT "How many credits has the student successfully completed? ", CURCRED
IF CURCRED >= FINCRED THEN
        LOCATE 14, 5: PRINT "The student has enough credits to graduate. ": GOTO GETY
END IF
LOCATE 10, 5: INPUT "What is the student's current QPA? ", CURAVG
LOCATE 12, 5: INPUT "What is the minimum QPA required to graduate? ", FINAVG
IF CURAVG >= FINAVG THEN
        LOCATE 14, 5: PRINT "The student has a satisfactory average at present. ": GOTO GETY
END IF

CREDLEFT = FINCRED - CURCRED
QPLEFT = (FINCRED * FINAVG) - (CURCRED * CURAVG)
AVGLEFT = QPLEFT / CREDLEFT
IF CREDLEFT < 1 THEN
        LOCATE 14, 5: PRINT "The student has enough credits to graduate. ": GOTO GETY
END IF
OK1:
AVGLEFT = INT(AVGLEFT * 100 + .05) / 100
LOCATE 14, 5: PRINT "This student will need to maintain a QPA of"; AVGLEFT; "in all remaining"
LOCATE 15, 5: PRINT "courses, in order to successfully complete this degree program."
IF AVGLEFT > 4! THEN
        LOCATE 17, 5: PRINT "Since an average greater than 4.0 is not possible,"
        LOCATE 18, 5: PRINT "the student should explore other alternatives."
END IF
GOTO GETY


TWO:
CLS
GOSUB IDENT
LOCATE 6, 5: INPUT "How many credits has the student successfully completed? ", CURCRED
LOCATE 8, 5: INPUT "What is the student's current QPA? ", CURAVG
LOCATE 10, 5: INPUT "What is the minimum QPA required to graduate? ", FINAVG
IF CURAVG >= FINAVG THEN
        LOCATE 14, 5: PRINT "The student has a satisfactory average at present. ": GOTO GETY
END IF

LOCATE 12, 5: INPUT "What is the BEST QPA the student can carry? ", BESTAVG
IF BESTAVG <= FINAVG THEN
        LOCATE 14, 5: PRINT "Under these conditions the student cannot improve the QPA enough "
        LOCATE 15, 5: PRINT "to graduate.  Please retry with different assumptions."
        GOTO GETY
END IF
C1 = (CURCRED * CURAVG - FINAVG * CURCRED)
C2 = (FINAVG - BESTAVG)
CREDNEW = ABS(C1 / C2)
CREDNEW = INT(CREDNEW + .5)

LOCATE 14, 5: PRINT "In order to achieve a final QPA of"; FINAVG; " this student must complete"
LOCATE 15, 5: PRINT "an additional"; CREDNEW; "credits with a QPA of"; BESTAVG; ", beyond those already finished."
GOTO GETY

FINISHED:
END

GETY:
LOCATE 23, 5: INPUT "PRESS <ENTER> TO CONTINUE. ", Y$: GOTO BEGIN

IDENT:
LOCATE 25, 1
PRINT "Copyright 1993. Dr. Ward Deutschman, Briarcliffe, Office of Academic Affairs"
RETURN

INFO:
CLS
GOSUB IDENT
RESTORE 5
5 DATA "This program is designed to assist in advising students who may be in"
DATA"academic difficulty.  It can be used to calculate the cumulative average "
DATA"(Quality Point Average, or 'QPA') which the student must maintain throughout"
DATA"the student's remaining courses, in order to meet graduation requirements."
DATA "   "
DATA"In addition, the program addresses the need of the advisor who's student"
DATA"says 'I want to take a few extra courses in order to bring up my average.'"
DATA "   "
DATA"The program will allow you to show the student how many additional credits"
DATA"are needed to accomplish that goal."
DATA "   "
DATA "Please let me know how we can improve this program."
DATA "   Dr. Ward Deutschman"
DATA "   Briarcliffe"
DATA "   250 Crossways Park Drive."
DATA "   Woodbury, NY 11797"
LOCATE 5
FOR I = 1 TO 16: READ Y$:  PRINT Y$
NEXT I
GOSUB GETY
GOTO BEGIN

