PROGRAM Heart_Rate;

VAR
   min_rate, max_rate, age, resting_rate : REAL;

PROCEDURE Rate_1 (VAR min_rate: REAL; VAR max_rate: REAL;
                  age, resting_rate : REAL);
{ Based on calculations found on page 13 of Bicycling Magazine's
  FITNESS THROUGH CYCLING (c) 1985 Rodale Press Inc. }
BEGIN
   min_rate := ((220.0 - age) - resting_rate) * 0.6 + resting_rate;
   max_rate := ((220.0 - age) - resting_rate) * 0.8 + resting_rate;
END ; { Rate_1 }

PROCEDURE Rate_2 (VAR min_rate: REAL; VAR max_rate: REAL;
                  age : REAL);
{ Based on calculations found on page 6 of SPORTSPERFORMANCE
  CYCLING ENDURANCE AND SPEED (c) 1987 by Michael Shermer }
BEGIN
   min_rate := (220.0 - age) * 0.6;
   max_rate := (220.0 - age) * 0.8;
END ; { Rate_2 }

PROCEDURE Rate_3 (VAR min_rate: REAL;
                  age : REAL);
{ Based on calculations found on page 168 of
  THE PENGUIN BICYCLE HANDBOOK (c) 1983 Rob Van Der Plas }
BEGIN
   min_rate := 180.0 - age;
END ; { Rate_3 }

BEGIN
   ClrScr;
   writeln(' ':23, 'Your Training Heart Rate');
   writeln(' ':27, 'by Howard Gerber');
   writeln(' ':23, 'Two Wheelers Opus 106/88');
   writeln(' ':28, '713-682-6508');
   writeln; writeln;
   LowVideo; write(' ':16, 'Age: '); HighVideo; read( age );
   LowVideo; write('   Resting Pulse Rate: ');
   HighVideo; readln( resting_rate);
   writeln; writeln;
   LowVideo;
   writeln(' ':13, 'Reference                Minimum Rate   Maximum Rate');
   HighVideo;

   writeln;
   Rate_1( min_rate, max_rate, age, resting_rate);
   write(' ':5, 'Fitness Through Cycling', ' ':5);
   writeln(min_rate:13:0, max_rate:14:0);

   writeln;
   Rate_2( min_rate, max_rate, age);
   write(' ':5, 'Cycling Endurance and Speed ');
   writeln(min_rate:13:0, max_rate:14:0);

   writeln;
   Rate_3( min_rate, age );
   write(' ':5, 'The Penguin Bicycle Handbook');
   writeln(min_rate:13:0);
END.
