#include color.vc
#include wave.vs

studio {
        from 0 -5 0
        at 0 0 0
        up 0 0 1
        angle 45
        res 320 200
        threshold 4
        aspect 4/3
        antialias adaptive
        threshold 4
        background {
                greys.map
        }
        ambient white * .1
}

light {
        type point
        falloff 1
        position 1 -6 12
        color white*8
}

/* chrome objects */
surf {
        diff light_steel_blue
        spec white * .5
        shine 100
}

#define P00 (-0.1 -0.1 -0.2)
#define P01 (-0.1 0.1 -0.2)
#define P02 (0.1 0.1 -0.2)
#define P03 (0.1 -0.1 -0.2)
#define P04 (-0.1 -0.1 0.2)
#define P05 (-0.1 0.1 0.2)
#define P06 (0.1 0.1 0.2)
#define P07 (0.1 -0.1 0.2)

transform {
 rotate 0 0 WAVE_ZR1
 rotate 0 WAVE_YR 0
 rotate 0 0 WAVE_ZR2
 translate WAVE_X WAVE_Y WAVE_Z
}

polygon { points 4 vertex P00 vertex P03 vertex P02 vertex P01 }
polygon { points 4 vertex P00 vertex P01 vertex P05 vertex P04 }
polygon { points 4 vertex P01 vertex P02 vertex P06 vertex P05 }
polygon { points 4 vertex P02 vertex P03 vertex P07 vertex P06 }
polygon { points 4 vertex P03 vertex P00 vertex P04 vertex P07 }
polygon { points 4 vertex P04 vertex P05 vertex P06 vertex P07 }

#undef P00
#undef P01
#undef P02
#undef P03
#undef P04
#undef P05
#undef P06
#undef P07
