SP (Dave's Spline-Path Generator) beta Rel. 0.3 (09/26/92)

  SP is a command-line utility that creates spline paths for
  computer animations created with the Polyray, POV-Ray, and
  Vivid raytracers.

Syntax:
-------

  SP (path-filename) /F(frame) /T(totalframes) (optional switches)

Optional switches:
------------------

  /Q  (quiet mode, for use with batch files and other calling
      programs)
  /P  (Polyray output)
  /V  (Vivid output)
  /3  (3DV output)
  /W  (Wire 3D output)
  /O  (output filename - default is same as path-filename but
       with the extension .INC (or .VS, for Vivid))
  /X  (variable prefix - default is the same as the path-filename,
       but without the extension)

POV-Ray example:
----------------

  Create a text-file called ROCKET.PTH, that looks like this:

    -9.42216 -7.07522 -6.30948
    -2.40421 -4.41194 -4.23204
    4.81923 0.34273 -1.05244
    4.45349 3.63442 0.69991
    0.52174 5.18883 1.13800
    -2.31851 4.45669 0.43119
    -4.41580 2.15031 -2.72078
    -1.76498 0.02844 -7.61030
    2.25902 0.06842 -20.23333

  Each line represents a 3d point on a space curve.

  Type:

    sp rocket.pth /f15 /t100

  The /f parameter tells SP which frame we're working on and /t supplies
  the total-frames value.  SP will create a file called rocket.inc,
  that looks like this:

    #declare ROCKET_X = -0.83333
    #declare ROCKET_Y = -3.84774
    #declare ROCKET_Z = -3.79507
    #declare ROCKET_YR1 = -8.45789
    #declare ROCKET_ZR  = 70.38159
    #declare ROCKET_YR2 = 164.18573

  In your POV-Ray data file (which in this case is called rocket.pov)
  you'd need to include a line:

    #include "rocket.inc"

  Inside the declaration of the object that you want to sweep along
  the curve, you'd need to include these transformation lines:

    rotate <0 ROCKET_YR1 ROCKET_ZR>
    rotate <0 ROCKET_YR2 0>
    translate <ROCKET_X ROCKET_Y ROCKET_Z>

  The rotates align the object along the axis of the curve, and
  the translates position the object.

Vivid Notes:
------------

Stephen Coy's Vivid ray-tracer uses a different coordinate system
than Polyray or POV-Ray.  The Z axis is used to represent up-and-
down, instead of front-and-back.  Also, rotations work a bit
differently.

When you use SP with Vivid, you need to specify your coordinates
the same as you would with Polyray or POV-Ray, with the middle
value representing up-and-down.  The coordinates in the .VS file
that SP generates will be shuffled around so that Y and Z work
the way you're used to them.

Because of the coordinate-shuffling, you'll also need to specify
the transformations in your .V file differently, like this:

  transform {
    rotate 0 0 WAVE_ZR1
    rotate 0 WAVE_YR 0
    rotate 0 0 WAVE_ZR2
    translate WAVE_X WAVE_Y WAVE_Z
  }

Accelleration/Decelleration:
----------------------------

  In this path file:

    -5 -4 0
    -4 -2 0
    0 4 0 percent 50
    4 -2 0 percent 90
    5 -4 0

  The "percent 50" and "percent 90" tell SP that the object should be at
  coordinate 0,4,0 exactly halfway through the animation, and should be at
  4,0,0 when it's 90% through the animation.  So, your object will be
  moving at a pretty constant speed during the first half of the
  animation, then slow down for a while, and then speed up at the very
  end.

  Note: Percent is automatically set to 0 for the first coordinate,
  and 100 for the final coordinate.  These can't be modified.

Previewing a path:
------------------

  If you're not sure you've perfected a spline path, you can create
  a .3d file, like this:

    sp rocket.pth /t100 /3

  and then load the output file, rocket.3d into Oscar Garcia's 3DV
  program and get a graphic preview.  If there's an unsightly kink
  in a curve, it's nice to find out BEFORE you've wasted three days
  ray-tracing umpteen zillion .TGA files.

  Or, you if you use the /W switch instead of /3, SP will create
  a .FIG file for use with Matthias Grabiak's Wire 3D.

  Both of these programs (3DV and Wire 3D) are available on many
  bulletin board systems and also on the companion disk to
  the Waite Group's book Virtual Reality Playhouse, by Nicholas
  Lavroff.

  Thanks to Jeff Bowermaster for suggesting 3DV output.

Files included in this package:
-------------------------------------

  SP.EXE      - the program
  README.SP   - this file
  WHATSNEW.SP - SP version history file
  ROCKET.PTH  - sample path file
  ROCKET.POV  - sample POV data file (i'll include a sample Polyray
                data file with a future release of this program)
  ROCKET.BTM  - sample 4dos batch file
  ROCKET.BAT  - sample dos batch file - not as sophisticated as the
                4dos batch file, but it'll get the job done
  BOX.V       - sample Vivid data file
  VBOX.BTM    - another 4dos batch file, part of the Vivid example
  WAVE.PTH    - another sample path file, part of the Vivid example,
                shows off "percent" feature.
