#include "rocket.inc"
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "shapesq.inc"
#include "frminfo.inc"

camera {
   location <0 0 -18>
   look_at <0 0 0>
   up  <0.0 1.0 0.0>
   right <1.33333 0.0 0.0>
}

object {
   light_source { <-10 6 -20>
      colour White
   }
}

object {
   light_source { <20 6 -20>
      colour White
   }
}

#declare fire = texture { Luminous color Yellow alpha 0.7 }
#declare Steel = texture { Metal colour SteelBlue }

#declare seethru = texture {
   color red 1.0 green 1.0 blue 1.0 alpha 0.75
   ambient 0.25
   diffuse 0.75
}

#declare Cap = object {
  quartic { Piriform sturm
    translate <-0.75 0 0>
    rotate <0 0 -90>
    scale <1 3 1>
    translate <0 3 0>
    texture { Steel }
  }
  clipped_by { plane { <0.0 1.0 0.0> 0 inverse translate <0 3 0> } }
  bounded_by { box { <-0.7 3 -0.7> <0.7 5.5 0.7> } }
}

#declare Neck = object {
  quartic { Piriform sturm
    translate <-0.75 0 0>
    rotate <0 0 90>
    scale <1 10 1>
    translate <0 3 0>
    texture { Steel }
  }
  clipped_by {
    plane { <0.0 1.0 0.0> 0 translate <0 3 0> }
    plane { <0.0 1.0 0.0> 0 inverse translate <0 -2 0> }
  }
  bounded_by { box { <-0.7 -2 -0.7> <0.7 3 0.7> } }
}

#declare Engine = object {
  quartic { Piriform sturm
    translate <-0.40 0 0>
    rotate <0 0 90>
    scale <1 2.75 1>
    translate <0 -3.5 0>
    texture { Steel }
  }
  clipped_by {
    plane { <0.0 1.0 0.0> 0 inverse translate <0 -3.5 0> }
  }
  bounded_by { box { <-0.7 -3.5 -0.7> <0.7 -1.5 0.7> } }
}

#declare Fin = object {
   difference {
      intersection {
         quadric { Ellipsoid scale <1 2 0.25> }
         plane { <0.0 1.0 0.0> -0 inverse }
         plane { <1.0 0.0 0.0> -0 }
      }
      quadric { Ellipsoid scale <1 1 1> }
   }
   translate <-0.4 0 0>
   texture { Steel }
}

#declare Fins = composite {
  object { Fin rotate <0 0 0>   }
  object { Fin rotate <0 90 0>  }
  object { Fin rotate <0 180 0> }
  object { Fin rotate <0 270 0> }
  translate <0 -4.25 0>
  bounded_by { box { <-2 -4.25 -5> <2 -2.25 2> } }
}

#declare Flame = object {
  union {
    quartic { Piriform sturm texture { fire } }
    light_source { <0 0 0> color Yellow }
    translate <-0.40 0 0>
    rotate <0 0 90>
    scale <0.3 3 0.3>
    translate <0 -6 0>
  }
  bounded_by { box { <-0.5 -8 -0.5> <0.5 -4 0.5> } }
}

composite {
  object { Cap }
  object { Neck }
  object { Engine }
  composite { Fins }
  object { Flame }
  bounded_by { box { <-2 -8 -2> <2 5.5 2> } }
  scale <0.5 0.5 0.5>
  rotate <0 frame 0>
  rotate <0 ROCKET_YR1 ROCKET_ZR>
  rotate <0 ROCKET_YR2 0>
  translate <ROCKET_X ROCKET_Y ROCKET_Z>
}
