; ----- UARTTYPE: Report the UART type found when opening the comm port
;
;	Pgm: R. McGinnis; Chicago; 7/90
; ---------------------------------------------------------------------
;
;	Determine the UART type
;
   LEGEND " UART report - press any key to continue"
   S0 = "_UART"                 ; Fetch type
   S1 = "No UART detected"      ; Set dft msg
   SWITCH S0
	  CASE 0		; 0 -> not 16550(A) - 8250 or somesuch
	       S1 = "8250 UART (no FIFO buffering)"
	       ENDCASE
	  CASE 1		; 2 -> 16550
	       S1 = "16450 (1, no FIFO buffering)"
	       ENDCASE
	  CASE 2		; 2 -> 16550
	       S1 = "16450 (2, no FIFO buffering)"
	       ENDCASE
	  CASE 3		; 3 -> 16550A
	       S1 = "16550(A) (FIFO buffering)"
	       ENDCASE
    ENDSWITCH
    N0 = 11			; Port offset if not 300 baud
    IF STRCMP "_PARM"(0:2) "300" N0 = 10
    S1 = S1*" on "*"_PARM"(N0:14)  ; xxxx,e,7,1,comx
;
;	Report it
;
   WOPEN 9,10,11,70 (default) Exit
   ATSAY 10,12 (default) S1
   ATSAY 11,27 (default) " Press any key to continue "
   KEYGET S1			; Wait for a keypress
Exit:
   WCLOSE
   EXIT
