XCB 1 "May 6 1992" "X Version 11"
 NAME
xcb - X Cut Buffers - Pigeon holes for your cut and paste selections.
 SYNOPSIS
xcb
[Xt option]
[-l layout]
[-n count]
[-p|-s list]
[-r count]
 DESCRIPTION
Xcb provides easy access to the cut buffers built into every X server.
It allows the buffers to be manipulated either via the command line,
or with the mouse in a point and click manner.
The buffers can be used as holding pens to store and retrieve
arbitrary data fragments.
Any number of cut buffers may be created,
so any number of different pieces of data can be saved and recalled later.
By default, 8 cut buffers are created.
The program is designed primarily for use with textual data.

Xcb has two modes of operation.
Normally xcb provides an array of windows on your display,
one per cut buffer, tiled horizontally, vertically, or in some
user specified layout.
Each window displays the contents of its respective cut buffer.
Data can be cut from and pasted to the windows in a similar manner
to xterm.
The buffers can also be rotated.

In task mode, xcb lets you access the cut buffers from the command line.
Cut buffers can be loaded from stdin, copied or concatenated
to stdout, or rotated an arbitrary number of positions.
In this mode of operation, xcb performs the requested task
and then exits.
It does not create any windows and
has no interaction with the mouse or keyboard.
 OPTIONS
Xcb supports the full set of X Toolkit Intrinsics options,
as well as those listed below.
Xcb options can appear in any order.
The presence of the
-p,
-r or
-s
options causes xcb to execute in task mode,
described above.
 "-l layout"
This option controls the geometry arrangement of xcb's subwindows.
It is the command line equivalent of the .layout resource,
described below.

 "-n count"
Create count cut buffers.
Count can be any integer greater than zero.
This option is the command line equivalent of the .bufferCount
resource, described below.

 "-p list"
Print the contents of the listed buffer(s) on stdout.
The buffered data is printed exactly as it is stored in the server.
Selecting two or more buffers has the effect of concatenating
the data on stdout.
The cut buffers are numbered from 0... onwards.
The list can be either a single digit,
a comma separated list of digits,
a range of the form m-n,
or some combination of lists and ranges.
The buffers are printed in listed order,
so repeated numbers in the list can be used to 
duplicate buffer contents.

 "-r count"
Rotate the buffers by count positions.
Count can be any integer, positive or negative.
This option may be used in conjunction with the
-n count option to rotate
a specific number of buffers.
If the -n option is not used, xcb will rotate
the number of buffers given by the .bufferCount resource.

 "-s list"
Store the data from stdin in the listed buffer(s).
If two or more buffers are selected the input data is duplicated
in each buffer.
Refer to the -p option for the definition of a list.
 WIDGETS and RESOURCES
The xcb widget hierarchy consists of a collection of
custom buffer widgets contained within a single Athena form widget.

The name of the form widget is "container",
and its class name is "Form".
The names of the buffer widgets are "buffer0", "buffer1",
"buffer2", .... etc., and their class name is "Buffer".
Each buffer widget supports all the standard core widget
resources, plus the .foreground and .font resources.

Application wide resources are as follows:

  .bufferCount (default value 8)
 +8
This is the number of buffer widgets to create.
Any number of widgets (greater than zero) can be created.
 -8
 1
  .layout (default value "h")
 +8
Only the first character of the resource value is significant.
This is the geometry arrangement to apply in the form widget.
The layout can be "h" (horizontal), "v" (vertical), or some
other value to disable the geometry code and allow you to build
your own custom layout scheme.  An example is provided in the
application default resources file.
 -8

 EVENTS and TRANSLATIONS
Xcb's input semantics are coded into a Toolkit translation table.
The default bindings have been chosen to conform with the default
configuration of other cut and paste clients, such as xterm.
The bindings may be altered or overridden according to your needs.
The actions functions provided by xcb are:-

cut()	causes the contents of the chosen cut buffer to become
	the PRIMARY selection.  The window contents, if any,
	are highlighted, and can then be pasted into other
	cut buffers or applications.

paste()	causes the value of the PRIMARY selection to be
	converted into text and pasted into the chosen cut
	buffer, overwriting any previous buffer contents.
	If no PRIMARY selection is present, xcb pastes
	the contents of cut buffer zero into the chosen buffer.

clear()	clears the chosen cut buffer.

rotate(NN)	rotates the cut buffers by NN positions.  NN may
	be any positive or negative number.

refresh()	causes the cut buffer window to be cleared and redrawn.

selreq()	this action function handles paste requests
	from other clients, or other xcb windows.
	It should always be bound to SelectionRequest events.

selclear()	this action function responds to the loss of
	ownership of the PRIMARY selection property.
	It should always be bound to SelectionClear events.

quit()	causes xcb to terminate.

The default bindings are as follows:-

<Btn1Down>:		cut() \n\
Shift <Btn2Down>:	clear() \n\
<Btn2Down>:		paste() \n\
Shift <Btn3Down>:	rotate(-1) \n\
<Btn3Down>:		rotate(1) \n\
<Key>Left:		rotate(-1) \n\
<Key>Right:		rotate(1) \n\
<Key>Up:		rotate(-1) \n\
<Key>Down:		rotate(1) \n\
<Key>q:			quit() \n\
<SelReq>:		selreq() \n\
<SelClr>:		selclear()

 EXAMPLES
The following are some examples of xcb task mode usage:-

xcb -s 0-7 < /dev/null

This clears the first 8 cut buffers in your server.

echo "G'day." | xcb -display bigears:0.0 -s 1,3,5,7

This loads the string "G'day." into four of the cut buffers
on the display "bigears".

ls `xcb -p 2,3`

This produces a listing of all the files named in
cut buffers 2 and 3.


xcb -p 0-7 | xcb -s 0

This concatenates the values in the first 8 cut buffers, and places
the result back in cut buffer zero.

for i in 0 1 2 3 4 5 6 7
do
	xcb -p $i > $HOME/.xcb/$i
done
for i in 0 1 2 3 4 5 6 7
do
	xcb -s $i < $HOME/.xcb/$i
done

This first loop saves the contents of each of the cut buffers
in a separate file under your home directory.  The second loop
restores the cut buffer contents from those files.
When placed in your .logout and .login scripts respectively,
the commands are a simple method of preserving your cut buffers
across login sessions.

function g {
	echo "$1\\c" | xcb -s 7
	grep "$@"
}
function vg {
	vi +/`xcb -p 7` "$@"
}

These two shell functions exemplify a simple mechanism for saving and
reusing regular expressions.
The first function saves the regex used for grep-ing into
cut buffer 7.  The second function reuses the most recent
grep regex as a search command in vi.
There is considerable scope for expanding and improving these ideas.
 SEE ALSO
xterm(1), xcutsel(1), xclipboard(1), xprop(1)

Athena Widget Set - C Language Interface
 AUTHORS
Farrell McKay

E-mail: fbm@ptcburp.ptcbu.oz.au

XView modifications provided by Danny Vanderryn

E-mail: dvanderr@us.oracle.com

DESQview/X port done by Kris Williams or Quarterdeck Office Systems

E-mail: kris@qdeck.com

 COPYRIGHT
Copyright (C) 1992 by Farrell McKay.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.
.SH "BUGS  :-)"
Xlib's underlying protocol for moving selection data
between client and server can sometimes be slow,
depending on the amount of data involved.
Do not expect fast performance if your selections are
big or you want to store big files in your cut buffers!
("big" means, say, over 10k bytes - but your mileage
may vary).
