{$R-}    {Range checking off}
{$B-}    {Boolean complete evaluation off}
{$S-}    {Stack checking off}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

{ Program ASC2PAS (TM) source code Copyright (C) '88  Bruce L. Rosenberg.
  This program is being made available to individuals on a royalty-free
  basis for noncommercial use.  Contact the author for licensing information.
  For further information contact:
  Bruce L. Rosenberg, 23 N. Chelsea Ave., Atlantic City, NJ 08405,
  (609) 345-4712.
}

program ASC2PAS;   { completed 4-8-88 }

Uses
  Crt,
  Dos;

type
     ascii = set of 0..127;
     askstrtype = string[65];
     fnstrtype = string[14];
 var
     inf:         text;
     outf:        text;
     line:           string[80];
     LocOnLine,CharCount :  integer;
     infname:       fnstrtype;
     outfname:       fnstrtype;
     askstr : askstrtype;
     AskResp : char;
const
      PrnChars:     ascii = [32..126];
      newline:     ascii = [10,13];
{============================================================================}
procedure name_outfile(infname : fnstrtype; VAR outfname : fnstrtype);
var
dotpos,nl : integer;
tstr : string[8];
begin
  for nl := 1 to length(infname) do
    begin
      if ord(infname[nl]) = 46 then dotpos := nl;
    end;
  if dotpos <= length(infname) then tstr := copy(infname,1,dotpos-1)
  else
  tstr := infname;
  outfname := concat(tstr,'.pax');
end;
{---------------------------------------------------------------------------}
procedure prompt_user;
begin
  writeln(
  'PROGRAM ASC2PAS(C) 1988 BRUCE ROSENBERG,  NONCOMMERCIAL USE PERMITTED');
  writeln;
  writeln(
  'ATTENTION: This program appends a .PAX extension to converted files.');
   writeln;
   if paramcount = 0 then
   begin
     write('Enter name of ASCII file to convert to pascal: ');
     readln(infname);          { read entered name }
   end else infname := paramstr(1);
   name_outfile(infname,outfname);
end;
{---------------------------------------------------------------------------}
procedure wrapup;
begin
  writeln;
  writeln(
  'File ',infname,' was converted to a pascal source file ',outfname,'.');
  writeln;
  writeln(
  '        T H A N K S   F O R   U S I N G   A S C 2 P A S  ( TM )');
  writeln;
  writeln(
  'PROGRAM ASC2PAS (C) 1988 BRUCE ROSENBERG,  NONCOMMERCIAL USE PERMITTED');
 (*  for i := 1 to 5 do
          begin
          write(#7);  { beeps 5 times to signal p/o finished }
          delay (1000);
          end;
   *)
end;
{---------------------------------------------------------------------------}
procedure read_write;
begin
  assign(inf,infname); { assign that name to in }
  reset(inf); { set pointer to 0 (beginning of disk file)}
  assign(outf,outfname);
  rewrite(outf);
  writeln(outf,'BEGIN');
  writeln(outf,'clrscr;');
  while not eof(inf) do
  begin               { printing next line }
       LocOnLine := 1;  { position along the line (column) set to 1.}
       readln(inf,line);  { reads line of data from named disk file }
       if length(line) = 0 then writeln(outf,'writeln;');
       for CharCount := 1 to length(line) do
       begin
         if ord(line[CharCount]) in PrnChars then {Elim. form feeds, esc, etc.}
           begin
             if LocOnLine = 1 then
             begin
               writeln(outf,'writeln(');
               write(outf,'''');
             end;
             write(outf,line[CharCount]);   (* Does chars within line;      *)
             if ord(line[CharCount]) = 39 then write(outf,#39);
             (* above handles case of single quotes *)
             if CharCount = length(line) then writeln(outf,''');');
             LocOnLine := LocOnLine + 1
           end;
        end; { for-do line print }
  end;  { while not eof }
writeln(outf,
'{  File, ',infname,', was transformed into pascal source by ASC2PAS (TM). }');
writeln(outf,
'END.');
  close(inf);
  close(outf);
end;
{============================================================================}
begin    { main program ASC2PAS }
  clrscr;
  prompt_user;
  read_write;
  wrapup;
end.          { program ASC2PAS }
{============================================================================}
