program COMPRESS_FILE;
uses crt, memory, rw_io, hex_io, lzw_errs, LZW4P;

type
  String12 = String[12];
  AllocMemoryType = function(Size : Word) : Pointer;
  FreeMemoryType  = function(P : Pointer; Size : Word) : Integer;

Var
  InpFileName  : String12;
  OutFileName  : String12;
  MemoryP      : Pointer;
  AllocMemoryP : Pointer;
  FreeMemoryP  : Pointer;
  ReaderP      : Pointer;
  WriterP      : Pointer;
  Size   : Integer;
  Code   : Integer;
  i, x   : Integer;
begin
  (* get file names *)
  if ParamCount <> 2 then
    begin
      writeln('Usage: COMPRESS <infile> <outfile>');
      halt;
    end;
  InpFileName := ParamStr(1);
  OutFileName := ParamStr(2);
  (* get pointers *)
  AllocMemoryP := @AllocMemory;
  FreeMemoryP  := @FreeMemory;
  ReaderP := @Reader;
  WriterP := @Writer;
  (* Initialize LZW *)
  Code :=  InitLZW(AllocMemoryP);
  (* open input file *)
  Code := ReaderOpen(InpFileName);
  if Code <> 0 then
    begin
      writeln('Cannot open ',InpFileName,' for input');
      halt;
    end;
  (* open output *)
  Code := WriterOpen(OutFileName);
  if Code <> 0 then
    begin
      writeln('Cannot open ',OutFileName,' for output');
      halt;
    end;
  (* compress *)
  Code := Compress(ReaderP,WriterP);
  if Code < 0 then
    begin
      SayError(Code);
    end;
  (* close input *)
  Code := ReaderClose;
  (* close output *)
  Code := WriterClose;
  (* Terminate LZW *)
  Code := TermLZW(FreeMemoryP);
end.