Unit LZW_ERRS;

interface

procedure SayError(Code:Integer);

implementation

procedure SayError(Code:Integer);
const
 EXPANSION_ERROR  = -1;
 CANNOT_ALLOCATE  = -2;
 INTERNAL_ERROR   = -3;
 NOT_INITIALIZED  = -4;
begin
  case Code of
     EXPANSION_ERROR:
       writeln('Expansion Error: Can only expand a previously compressed file');
     CANNOT_ALLOCATE:
       writeln('Allocation Error: Could not allocate sufficient memory');
     INTERNAL_ERROR:
       writeln('Internal Error: LZW4P object code modified !');
     NOT_INITIALIZED:
       writeln('Not Initialized Error: Must run InitLZW() first');
  else writeln('Unknown error returned = ',Code);
  end;
end;

end.