program Movenow;  {Display moving messages on screen}
   uses crt, dos;

const
   TextSize = 100;                                      {Mod. #1}

type
   LineSize      = string[80];
   TextArrayType = array[1..TextSize] of LineSize;

var
   TextArray                                    : TextArrayType;
   J, K, LineCount, LeftX, RightX, Y, DelayTime : integer;
   Reply, Reply2                                : char;

{$I CursorOn.PSL}
{$I KeyHit.PSL}
{$I KeyTxt.PSL}
{$I Scroll.PSL}
{$I TextBox.PSL}
{$I WaitKey.PSL}

BEGIN
   textmode(bw80);
   clrscr;
   writeln('NewsWire - Create moving messages.');
   writeln;
   LeftX     := 2;                                      {Mod. #2}
   RightX    := 39;                                     {Mod. #2}
   Y         := 12;                                     {Mod. #2}
   DelayTime := 200;                                    {Mod. #3}
   LineCount := 0;
   KeyTxt(TextArray, LineCount);
   writeln;
   writeln('Press a key to start the news wire.');
   writeln('Once it begins, you can press any key to stop it.');
   waitkey;
   textmode(bw40);                                      {Mod. #4}
   textbox(LeftX - 1, Y - 1, RightX + 1, Y + 1);
   repeat
      for J := 1 to LineCount do
         for K := 1 to length(TextArray[J]) do
            begin
               CursorOn(false);
               gotoxy(RightX, Y);
               write(TextArray[J][K]);
               delay(DelayTime);
               scroll(LeftX, Y, RightX, Y, 0);
               if KeyHit(Reply, Reply2) then
                  begin
                     textmode(bw80);
                     CursorOn(true);
                     halt
                  end
            end
   until false
END.
