    
    ********************************************************************

    
    "D" - Directory, File, and Disk Information Tool        Version 2.11

    
    --------------------------------------------------------------------


    CONTENTS:
    
            (1) Introduction
            (2) "D" versus "DIR"
            (3) Syntax
            (4) Imbedded pattern matching
            (5) Multiple searchname patterns
            (6) Model
            (7) Case
            (8) Fuzzy
            (9) Hidden
           (10) Color
           (11) Detail
           (12) Archive
           (13) Subdir
           (14) Skan
           (15) Bonus switches (stats, change, actual) 
           (16) Miscellaneous "D" techniques
           (17) Versions
    

    ********************************************************************


    (1) INTRODUCTION:

    This documentation is to supplement the on-line documentation in "D"
    that you may view any time by typing "D/HELP" or "D/?".    "D"'s on-
    line documentation explains all features, and gives a few examples.

    This documentation avoids  repeating information exactly as the HELP
    screen presents it.  Your best success at using "D" will be achieved
    by reading both this documentation AND the on-line help.

    You may find some features are  elaborated on  a little more in this
    documentation since the  on-line screens  dictate a more brief pres-
    entation.

    Generally speaking, "D" is an enhanced alternative to the  DIR  com-
    mand.  It is  not limited  by the current directory  or by the usual
    limitations of DOS filename patterns.

    "D" displays the Directory entries first, then the Hidden files, and
    finally, the rest of the files.   They are always sorted alphabetic-
    ally, and  (if the Pretty switch is active)  displayed in  different
    colors based on the most common file extensions.

    When  using  either color  option  (Pretty or Color),  the directory
    entries are displayed in  Light Green;  the Hidden files,  which are
    also grouped together, are displayed in Light Magenta.  You will see
    that some file entries have the letter "A" appended to them in Light
    Blue.  This indicates that the archive bit is set.
    
    
    ********************************************************************

    
    (2) "D" VERSUS "DIR":

    "D" is first and foremost a replacement for the DIR command.  To be-
    come a skilled user of  "D"  you should first use it instead of DIR.
    You will see  the same information,  but it will be  more organized,
    and more informative.  Using  "D"  in this context will allow you to
    increase  your  level  of  information,  and  do  so in a more space
    efficient way than DIR provides.

    To use "D" as a simple replacement for the DIR command just type "D"
    followed by the searchname:
                                 D AUTOEXEC.BAT
    instead of using DIR, as in:
                                 DIR AUTOEXEC.BAT

    "D" will accept the same search arguments as  DIR  does, but removes
    the limitations by alowing you to imbed one or more asterisks in the
    searchname and by allowing you to specify  more than one  searchname
    at a time.

    By default  "D"  looks only in the  current directory  just like DIR
    does, but the searching may be increased to the current and all sub-
    ordinate directories, or to the entire disk  based on your choice in
    the form of a command line switch or an environmental variable.

    "D" will display any file or directory on your drive.  Using the DIR
    command can  cause you  to overlook  files and directories  that you
    were unable to see.  Hidden and archived files are  easily recogniz-
    able with "D".


    ********************************************************************


    (3) SYNTAX:

    D /switch(es) searchname(s)      OR      D searchname(s) /switch(es)

    The searchname is similar to the DOS standard filename with wildcard
    characters  allowed.   Imbedded  pattern matching  is supported, and
    multiple searchnames  can be specified  by connecting them with plus
    signs.

    Switch values are 1 character in length.  The  first switch  must be
    preceded by  a slash (/).   If more than 1 switch is specified,  the
    2nd through last switches cannot have spaces between them.  Switches
    can have the following values:

       Switch   Valid Values (Just use capitilized letter of Value)
       -------  -----------------------------------------------------
       model    LMTF  Large,      [M]edium,  Tiny,   best Fit
       case     UXW   Upper,      mi[X]ed,   loWer
       fuzzy    ZE    fu[Z]zy,    Exact
       hidden   HR    [H]idden,   Regular only
       color    PCB   [P]retty,   Color,     Black&white
       detail   OG    Omit files, Grand total only
       archive  A     Archive files only
       subdir   SD    Subdirectories, entire Disk
       skan     K     sKan target drive

       stats    %     display disk used/free as percentage (%)
       change   *     change to displayed directory (*)
       actual   #     display byte counts as actual bytes allocated (#)
    
    If you almost always specify a certain switch, you can save yourself
    some keystrokes by setting the environmental variable  DSET equal to
    the value of the switch(es).    For example,  if you would prefer to
    see the filenames displayed in upper case, then at the  DOS  prompt,
    you would type:
                    C:\> SET DSET=U

    The DSET values  override the  default values,  and the command line
    values will override the DSET values.


    ********************************************************************


    (4) IMBEDDED PATTERN MATCHING:

    If you don't quite remember the name of a file, but remember a frag-
    ment of it's name, you can use  D's imbedded pattern searching logic
    to help you remember.

    Let's say  you remember the file's name  had the string "YES" in it,
    but you can't remember if the "YES" was in the beginning, middle, or
    the end of the file's name. Also, to make things more difficult, you
    can't remember which directory it's in. "D" will take care of you if
    you type:
               D/D *YES

    If the fuZzy switch is in effect, this will have  the same effect as
    if you had typed D/D *YES*.*.

    Since the DIR command will only allow the "*" to be the last charac-
    ter in  a file  or  extension name, this feature should be a welcome
    alternative.

    Important definition:  "*"  <---- The asterisk says "zero or more of
    any character."

    You can mix asterisk's and other characters freely, for example:

                   D *U*O*X

    would find AUTOEXEC.BAT and UTOEXEC.BAT and AUTOEX.DAT

    Another definition:  "?"  <----- each question mark says "one of any
                                     character except when the "?" is at
                                     the end of the  searchname in which
                                     case it means zero or one character
                                     to comply with the DOS standard".


    ********************************************************************

    
    (5) MULTIPLE SEARCHNAME PATTERNS:

    "D" does not limit you to 1 SEARCHNAME!   Let's say you just want to
    select the .BAT files and the .EXE files. Type:
                                                    D *.BAT+*.EXE
    
    Use the plus sign  (+)  to connect the searchnames.   If you want to
    find all of the HELP files on your drive, you could do 2 searches:

                    D/D *H*LP
                    D/D *.HLP

    But you'd find all of the same files by typing:

                    D/D *H*LP+*.HLP

    Of course you don't need to use wildcards:

                    D AUTOEXEC.BAT+CONFIG.SYS

    There would be  no limit  to the  number of searchnames that you can 
    connect, but the DOS command line is only "so long" (128 characters,
    or something like that).   Do feel free to type as many names as you
    want to as long as there's room to type them!

    Limitation:  Only the first SEARCHNAME can refer to a disk/directory
                 path,  the second  through the Nth SEARCHNAMES are only
                 examined for their FILE and EXTENSION values.

                 In other words the target drive and/or directory is de-
                 termined solely by examining the first SEARCHNAME.
    

    ********************************************************************

    
    (6) MODEL:

    Use the model parameter to determine  how much  information you will
    see:
        L  = Filename, Extension, Size, Date & Time, Attribute
       [M] = Filename, Extension, Size, Attribute
        T  = Filename, Extension, Attribute

        F  = Best Fit.  The largest model that will fit all filenames on
             1 screen will be chosen.  If that is physically impossible,
             the Tiny model is chosen.

    
    ********************************************************************

    
    (7) CASE:

    Determines  whether  the  file  information  is  displayed in UPPER,
    lower, or Mixed case:

        U  = UPPER CASE
       [X] = Mixed Case
        L  = lower case
    

    ********************************************************************


    (8) FUZZY:

    Can be used to automatically make all searches look for whatever you
    type as your searchname  PLUS  anything else  that  starts with that 
    pattern.

    When fuzziness  is active,  typing  "D TEST"  is the same  as typing
    "D TEST*.*".     

    Also, typing "D TEST.B" is the same as typing "D TEST.B*".

    If you'd prefer to be consistant with the DOS standard which doesn't
    append "*"'s, use the E switch.

       [F] = Fuzzy
        E  = Exact
    
    
    ********************************************************************

    
    (9) HIDDEN:

    The Hidden switch decides if you see the hidden/system files of not.

    This also means that the total  files  and  bytes won't  reflect the
    totals of the hidden/system files.   Unless  you specify  the "O" or
    "G" parameter, only displayed files are totalled.

       [H] = Hidden and Regular
        R  = Regular only

    
    ********************************************************************

    
    (10) COLOR:

    The color option can be used  to enhance the readability of the dis-
    play.  If you have an LCD screen, use the  "B"  switch.   Otherwise,
    you'll probably want to choose between "P" or "C".    The "C" switch
    causes the display to be in plain color mode.    The "P" switch will
    show the files in different colors based on the file extension.

       [P] = Pretty
        C  = Color
        B  = Black & White (LCD)


    ********************************************************************


    (11) DETAIL:

    This option will eliminate  the filenames  from the display,  giving
    you just the counts and totals.    Using the "O" switch (omit files)
    is most useful if you are doing  a subdirectory or full disk search,
    and want to see the totals by directory.  To say "Omit files" is the
    same thing as saying "directory totals only."    To just see a grand
    total, use the  "G"  switch; you won't see totals by directory,  but
    you will get  a count  for number of directories in addition to file
    counts and byte quantities.

    If you are just focusing on 1 directory,  there is no practical dif-
    ference between using "G" and "O".

        O  = Omit Files (Directory Totals Only)
        G  = Grand Total Only


    ********************************************************************


    (12) ARCHIVE:

    When the  "A"  switch  is used,  only files with the archive bit set
    will be chosen.  If you regularly clear your archive bits by backing
    up  or  some  other  method,  this option will make it easy to track
    which files you've changed or added.   If you want to look at all of
    the archived files on your disk, type "D/AD".    If you just want to
    know the total of all archived files, type "D/ADG".

        A  = Only find archived files

    Archived files are indicated by the letter  "A"  to the right of the
    archived file.


    ********************************************************************


    (13) SUBDIR:

    Use the Subdir option to determine the scope of  your searches  rel-
    ative to the target directory.    Using "S" will cause the search to
    execute for  whatever the target directory is,  and extends into any
    directorys subordinate to (beneath) it.    If you want your searches
    to look over the entire disk, just use the "D" switch.

    These switches make it possible for you to find a file (or files) no
    matter where they exist.   They also make totalling and listing much
    more flexible.
                                  
        S  = Current and Subordinate Subdirectorys
        D  = Entire Disk


    ********************************************************************
   

    (14) SKAN:

    Yes, I know it's usually spelled differently, but the "C" switch was
    used up by the time I got to this one!

    Anyway, the skan option causes the file of  directory names  used by
    "D" to be updated or created.  There is one file for each drive ever
    skanned except for A: and B:.     The files have the .TRE extension,
    and are created and maintained in the  same directory  that contains
    "D.EXE".  The files are used for Subdirectory or Full Disk searches.

    The first time you search a disk with the  "S"  or  "D"  option, the
    file for that drive is created.    After that,  you must remember to 
    use this option whenever you add a new subdirectory. This might seem
    a little inconvenient, but saves you beaucoup time,  especially when
    searching the entire disk.  

        K  = Skan the drive being searched to
             rebuild the directory table.


    ********************************************************************

    
    (15) BONUS SWITCHES:

    Not much explanation needed for these  simple purpose  switches, but
    they sure do come in handy occasionally!

    Use "%" (stats) when you want  to see  the disk  used and free quan-
    tities expressed  as percentages  on the bottom line  instead of the
    default byte counts.  The  total quantity  for the disk is still ex-
    pressed as a byte count.

    Use  "*"  to (change) to the most recently viewed directory after it
    has been displayed.

    The "#" (actual) switch causes the byte counts on the top line,  and
    for each displayed file entry  to reflect the actual number of bytes
    allocated for the file on the target drive.   It is assumed that you
    understand that the smallest unit of allocation that  DOS can use is
    a cluster.  It then follows that all byte counts will be evenly div-
    isible by the cluster size of the target drive.


       % = display disk used/free as percentage 
       * = change to displayed directory 
       # = display byte counts as actual bytes allocated 
        
    
    ********************************************************************


    (16) MISCELLANEOUS "D" TECHNIQUES


    --------------------------------------------------------------------


    If you have a filename on drive C:, and you want to go to the direc-
    tory where it is, just type:
                                 D/*D searchname.ext

    It doesn't matter  which directory you're in,  you will be  taken to
    the directory where that file is.  If more  than one directory get's
    a "hit",  each one will be displayed,  and  you can terminate "D" by
    hitting the Esc key when your chosen directory is displayed.


    --------------------------------------------------------------------


    To get  the size of the current directory  in a 1 line display, just
    type: 
                          D/O

    To get the size of the current and all subdirectories, one line each
    directory, just type:
                          D/OS

    To get the size of the current and all sub directories, one line for
    number of directories, files, and bytes, type:

                          D/GS


    --------------------------------------------------------------------


    To find all of the archived files on your drive, type: D/AD


    ********************************************************************


    (17) "D" VERSIONS:

        1.10 - The original shareware Version
        1.11 - Colors added based on file extensions - ([P]retty Switch)
        1.12 - Colors refined based on actual feedback
        2.10 - Multiple Searchnames enabled
        2.11 - Option to display byte counts as bytes allocated
    
    
    ********************************************************************

