/***************************************************************************
*                                                                          *
*  Nifty James' Famous Disk Tidy Program                                   *
*                                                                          *
*  (C) Copyright 1987 by Mike Blaszczak All Rights Reserved                *
*                                                                          *
*  Version 1.00 of  7 December 1987                                        *
*  Version 1.10 of 18 December 1987                                        *
*  Version 2.00 of 19 January  1988                                        *
*  Version 2.10 of 26 January  1988                                        *
*  Version 3.00 of 20 February 1989                                        *
*  Version 3.10 of 20 August, 1992                                         *
*  Written for the Microsoft Optimizing C Compiler, Version 5.00           *
*        (Use the COMPACT model)                                           *
*  Built with the Microsoft Optimizing C/C++ Compiler, Version 7.00        *
*        (starting with Version 3.10)                                      *
*                                                                          *
***************************************************************************/

#include <dos.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>


#define  MAXEXT         64
#define  MAXSTACK       7168
#define  MAX_PATH_LEN   64

unsigned scrap;                           /* temporary var for _dos call   */
unsigned olddrive;                              /* current drive at start  */
unsigned drive;

char     *extlist[MAXEXT];                   /* list of extensions to del  */
int      topext = 0;                            /* first free ext entry    */
char		*ext;

int      deleteit;                              /* flag for work loop      */

char     *subdirlist[MAXSTACK];                 /* list of subdirectories  */
int      topdir = 1;                      /* first free subdirlist entry   */
int      worktop = 0;                        /* used as iteration counter  */

int      index;                                       /* loop variable     */
int      extents;                               /* loop through extensions */

char     tempname[MAX_PATH_LEN];          /* temporary name for file dels  */

long     deleted =0L;                           /* number of files deleted */
unsigned long totalbytes =0L;                   /* number of bytes freed   */

unsigned        result;                      /* result of _dos operations  */
struct  find_t  c_file;                         /* structure for _dos ops  */

int      nail_backups = 0;                /* set to 1 if we KEEP backups   */
int      keep_zeros = 0;                 /* set to 1 if we KEEP null files */
int      confirm_mode = 0;                   /* set to 1 if we should ask  */
int      returnval;                             /* return from deleteone() */

/* ---------------------------------------------------------------------- */ 

void shutdown(void)
{
   if(deleted == 0L)
      {
      puts("\nNo files were deleted\n");
      }
   else
      {
      printf("\n%ld file", deleted);
      if (deleted != 1)
         {
         printf("s were");
         }
      else
         {
         printf(" was");
         }

      printf(" deleted for a total of %lu bytes freed.\n", totalbytes);
      }

   _dos_setdrive(olddrive, &scrap);
   exit(0);
}


/* ---------------------------------------------------------------------- */ 

int deleteone(int n)
{
   register int tempval;
   int reply;
   int thischar;

   strcpy(tempname, subdirlist[n]);
   tempname[strlen(tempname)-3] = '\0';
   strcat(tempname, c_file.name);

   if (confirm_mode == 1)
   {
      printf("Delete file %s? (Y/N/Q)  ", tempname);
      while(1)
      {
         thischar = 0;
         while(thischar == 0)
            {
            thischar = getch();
            thischar = toupper(thischar);
            if (thischar != 'N' && thischar != 'Y' &&
               thischar != 'Q')
               {
               thischar = 0;
               continue;
               }
            reply = thischar;
            break;
            }

         switch (reply)
            {
            case 'Q' :  printf("Quit");
                        break;
            case 'Y' :  printf("Yes");
                        break;
            case 'N' :  printf("No");
                        break;
            }

         thischar = 0;
         while(thischar == 0 && thischar != '\r')
            {
            thischar = getch();
            if (thischar == '\r')
               goto gotanswer;

            if (thischar == '\b')
               {
               printf("\b\b  \b\b");
               if (reply == 'Y')
                  printf("\b \b");
               if (reply == 'Q')
                  printf("\b\b  \b\b");
               reply = 0;
               continue;
               }
            }
      }
gotanswer:
      if (reply == 'N')
         {
         putch('\n');
         return(-1);
         }
      if (reply == 'Q')
         {
         putch('\n');
         return(-2);
         }
   }
   else
		{
      printf("Deleting file %c:%s", drive+'@', tempname);
		}
   tempval = remove(tempname);

   if(tempval == -1)
      printf(" (couldn't remove file) ");

   return(tempval);
}


/* ---------------------------------------------------------------------- */ 

void memerror()
{
   puts("NJTIDY: Out of memory error\n");
   exit(1);
}


/* ---------------------------------------------------------------------- */ 

void main(int argc, char *argv[])
{
   puts("Nifty James' Famous Disk Tidier");
   puts("Version 3.10 of 20 August, 1992");
   puts("(C)Copyright 1987-1992 by Mike Blaszczak\n");

   _dos_getdrive(&olddrive);
	drive = olddrive;

   subdirlist[0] = "\\*.*";

   for(extents = 1; extents<argc; extents++)
      {
      strupr(argv[extents]);

      if (*argv[extents] == '-' || *argv[extents] == '/')
         {
         if (argv[extents][1] == 'P')
            {
            confirm_mode = 1;
            continue;
            }
         else if (*argv[extents] == '0')
            {
            keep_zeros = 1;
            continue;
            }
         else if (*argv[extents] == 'B')
            {
            nail_backups = 0;
            continue;
            }
         else
            {
showusage:  puts("Usage:\n\t");
            puts("NJTIDY <drivespec> [/P] [/B] [/0] <extlist>\n");
            puts("\t/P - prompt before deleting");
            puts("\t/B - don't delete .BAK files");
            puts("\t/0 - avoid deleting zero-byte files");
            exit(1);
            }
         }

      if (strchr(argv[extents], ':') != NULL)
         {
			drive = *argv[extents]-'A'+1;
         _dos_setdrive(drive, &scrap);
         _dos_getdrive(&scrap);
         if (scrap != drive)
            {
            printf("NJTIDY: Invalid drive name: \"%s\"\n", argv[extents]);
            exit(1);
            }
         continue;
         }

      if (argv[extents][0] == '.')
         {
         if (topext == MAXEXT)
            {
            memerror();
            }

         if (NULL == (extlist[topext] = (char *) malloc(strlen(argv[extents])+5)) )
            {
            memerror();
            }

         strcpy(extlist[topext++], argv[extents]);
         }
		else
			{
			printf("NJTIDY: Unrecognized parameter: \"%s\"\n", argv[extents]);
			}
      }

   if (nail_backups == 1)
      {
      if (topext == MAXEXT)
         {
         memerror();
         }

      if (NULL == (extlist[topext] = (char *) malloc(strlen(argv[extents])+5)) )
         {
         memerror();
         }

      strcpy(extlist[topext++], ".BAK");
      }

   if (topext == 0 && keep_zeros == 1)
      {
      puts("NJTIDY: Nothing to delete!");
      exit(1);
      }

   printf("NJTIDY: Confirm mode is ");
   if (confirm_mode == 1)
      {
      puts("on.");
      }
   else
      {
      puts("off.");
      }

   printf("NJTIDY: ");
   if (keep_zeros == 1)
      {
      printf("Not d");
      }
   else
      {
      printf("D");
      }
   puts("eleting zero-length files.");

   while(worktop<topdir)
      {  
      result = _dos_findfirst(subdirlist[worktop], _A_SUBDIR, &c_file);

      while(result == 0)
         {
         if (c_file.name[0] != '.' &&
             c_file.attrib == _A_SUBDIR)
            {
            if ( topdir == MAXSTACK ||
                  (subdirlist[topdir] = (char *) malloc(MAX_PATH_LEN)) == NULL )
               memerror();
            strcpy(subdirlist[topdir], subdirlist[worktop]);
            subdirlist[topdir][strlen(subdirlist[topdir])-3] = '\0';
            strcat(subdirlist[topdir], c_file.name);
            strcat(subdirlist[topdir++], "\\*.*");
            }
         result = _dos_findnext(&c_file);
         }
      worktop++;
      }

   for(index = 0; index < topdir; index++)
      {
      result = _dos_findfirst(subdirlist[index], _A_NORMAL, &c_file);

      while(result == 0)
         {
         deleteit = 0;

         if (c_file.attrib != _A_SUBDIR)
            {
            if (c_file.size == 0L && keep_zeros == 0)
               {
               deleteit = 1;
               }
            else
               {
               for (extents = 0; extents < topext; extents++)
                  {
						ext = strchr(c_file.name, '.');
						if (ext != NULL)
							{
							if (strcmp(ext, extlist[extents]) == 0)
      	               {
         	            deleteit = 1;
            	         break;
               	      }
							}
                  }
               }
            }

         if (deleteit == 1)
            {
            returnval = deleteone(index);
            if (returnval == -1)
               ;     /* nothin in particular... */
            if (returnval == -2)
               {
               shutdown();
               }
            if (returnval == 0)
               {
               putchar('\n');
               deleted++;
               totalbytes += c_file.size;
               }
            }
         result = _dos_findnext(&c_file);
      }
   }     
   shutdown();
}


