' ManyThng.BAS -- This is my attempt at a variable screen saver
'   It is based on an example in "Learn Programming and Visual Basic 2.0"
'   by John Socha and Sybex Inc., (highly recommended)

' first written 4-15-93 Bruce McLean
'
Option Explicit

Declare Function ShowCursor Lib "USER" (ByVal fShow As Integer) As Integer

'routines for reading profile data in 'CONTROL.INI'
Declare Function GetPrivateProfileInt Lib "KERNEL" (ByVal lpszSectionName As String, ByVal lpszKeyName As String, ByVal nDefault As Integer, ByVal lpszFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "KERNEL" (ByVal lpszSectionName As String, ByVal lpszKeyName As String, ByVal nString As String, ByVal lpszFileName As String) As Integer

'
' These variables support saving the maximum number of lines
' in the CONTROL.INI file, which is where the Windows 3.1
' screen savers save setup information.
'
Global MaxLines As Integer      ' Lines to show before CLS
Global RepeatCount As Integer   ' # of lines the same color
Global MaxChangeMinutes As Integer   ' minutes to go before changing color
Global MaxCums As Integer      ' total number of lines before clearing screen

Global Const iniName = "CONTROL.INI"
Global Const secName = "Screen Saver.Many Things"
Global Const keyName = "MaxLines"
Global Const RepeatName = "RepeatCount"
Global Const ChangeMinutesName = "MaxChangeMinutes"
Global Const MaxCumsName = "MaxCumLines"

' windows defines
Type RECT
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

' routines for capturing screen
Declare Sub BitBlt Lib "GDI" (ByVal DestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal BWidth As Integer, ByVal BHeight As Integer, ByVal SourceDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal Constant As Long)
Declare Function CopyRect Lib "User" (lpDestRect As RECT, lpSourceRect As RECT) As Integer
Declare Function CreateDC Lib "GDI" (ByVal Driver As Any, ByVal Dev As Any, ByVal O As Any, ByVal Init As Any) As Integer
Declare Sub DeleteDC Lib "GDI" (ByVal hDC As Integer)
Declare Sub DrawIcon Lib "User" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal hIcon As Integer)
Declare Function GetCursor Lib "User" () As Integer
Declare Sub GetCursorPos Lib "User" (lpPNT As Integer)
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer
Declare Function LockResource Lib "Kernel" (ByVal hRes As Integer) As Long
Declare Sub UnlockResource Lib "Kernel" Alias "GlobalUnlock" (ByVal hRes As Integer)

' variables and constants to be used for screen capture
Dim ScrnW As Integer, ScrnH As Integer
Dim RECT(3) As Integer
Const HORZRES = 8
Const VERTRES = 10

Sub EndScrnsave ()
    ShowMouse                   ' Make mouse pointer visible again
    End                         ' And exit
End Sub

Sub HideMouse ()
    While ShowCursor(False) >= 0
    Wend
End Sub

Sub Main ()
    
    Dim i As Integer
    Dim DC As Integer

    ' check if first instance of program so we can be sure that only one is running
    If App.PrevInstance Then End

    ' first capture screen into Form 'Original' for later use
    DC = CreateDC("DISPLAY", 0&, 0&, 0&)
    ScrnW = GetDeviceCaps(DC, HORZRES)
    ScrnH = GetDeviceCaps(DC, VERTRES)
    BitBlt Original.hDC, 0, 0, ScrnW, ScrnH, DC, 0, 0, &HCC0020
    DeleteDC DC

    '
    ' This next line of code gets a number from the CONTROL.INI
    ' file in your Windows directory.  This number is the maximum
    ' number of lines to draw before clearing the screen.
    '
    MaxLines = GetPrivateProfileInt(secName, keyName, 100, iniName)
    RepeatCount = GetPrivateProfileInt(secName, RepeatName, 30, iniName)
    MaxChangeMinutes = GetPrivateProfileInt(secName, ChangeMinutesName, 1, iniName)
    MaxCums = GetPrivateProfileInt(secName, MaxCumsName, 500, iniName)
    
    ' Check to see if we should blank the screen, or display
    ' the Setup dialog box.
    '
    If InStr(Command$, "/c") Then
        SetupForm.Show 1
    ElseIf InStr(Command$, "/s") Then
        BackGround.Show
    End If

    'Randomize

    '
    ' Wait until there are no form visible, then quit.
    '
    While DoEvents() > 0        ' Loop until no forms visible
    Wend
End Sub

Sub ShowMouse ()
    While ShowCursor(True) < 0
    Wend
End Sub

