/*******

  Description: console color program
  Title: CONCOL
  Rev.:  Date:     Features:
         92-09-16	 Showing the possible colors on the console
  v1.0:  92-10-07  Setting the console colors via commandline

*******/

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <windows.h>

HANDLE     hConsole;

main(int argc, char *argv[])
{
WORD i, j;
CONSOLE_SCREEN_BUFFER_INFO csbi;	/* console screen buffer info	*/

  /* get/create output handle */
  hConsole = CreateFile("CONOUT$", 
  GENERIC_WRITE | GENERIC_READ,
  FILE_SHARE_READ | FILE_SHARE_WRITE,
		0L, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,
		0L);
  if(hConsole== INVALID_HANDLE_VALUE) {
    printf("\nError: %s is unable to open output console.\n", argv[0]);
    return( 0 );
  }
  /* checking for commandline parameter */
  if (argc==2) {  
	  /* one parameter passed on commandline */
    SetConsoleTextAttribute(hConsole, (WORD)atoi(argv[1])); 
  } else {
	  /* no commandline parameter: Show title, syntax, possible colors */
    printf("\nSet Console Color\t\tVersion 1.00 (Oct) by O.Dippel\n");
    /* Get current Color-Attributes */
    GetConsoleScreenBufferInfo(hConsole, &csbi);
    /* no parameter passed: Syntax - info , Show all color combinations */
    SetConsoleTextAttribute(hConsole, 30);
    printf("Usage: %s [<console color>]\n", argv[0]);
    printf("choose one of the following numbers as <console color>\n");
    SetConsoleTextAttribute(hConsole, csbi.wAttributes);
    printf("\n");
    for(i=0;i<16;i++) {
      for(j=0;j<16;j++) {
        SetConsoleTextAttribute(hConsole, (WORD)(i<<4 | j));
        printf("%4d", i*16 + j);
      }
      /* set stored color for CR/LF */
      SetConsoleTextAttribute(hConsole, csbi.wAttributes);
      printf("\n");
    }
    SetConsoleTextAttribute(hConsole, csbi.wAttributes);
  }
  /* everyting is ok - Goodbye */    
  return(0);
}
