
/****************************************************************************

    Convert 'BASIC MKS$' format to 'C long' format

****************************************************************************/
long mkstol(long mks)
{
    return(((mks & 0xFFFFFFL) | 0x800000L) >> (24 - ((mks >> 24) & 0x7F)));
}

/****************************************************************************

    Convert 'C long' format to 'BASIC MKS$' format

****************************************************************************/
long ltomks(long clong)
{
    int shift_count;
    long exp;

    shift_count = 0;
    while (!(clong & 0x00800000L)) {
	shift_count++;
	clong <<= 1;
    }
    exp = ((long)(24 - shift_count + 128)) << 24;
    return( exp | clong & 0xFF7FFFFFL );
}
