#ifndef DEFINE

#define DEFINE

#define TURBOC
#define VROOM

// #define HOST
// #define PROGNAME  "GT1800.OVL"
// #define PROGNAME  "GTO1800.OVL"
// #define PROGNAME  "GT1800A.OVL"
// #define PROGNAME  "GTO1800A.OVL"

// #define OEM
// #define DEBUG
 #define UTILITY

#include "dram.h"
#include "turboc.h"
#include "writef.h"

// #define MOTHERS_ID        536    // GT  POWER - XT
// #define MOTHERS_ID        537    // GTO POWER - XT
// #define MOTHERS_ID        538    // GT  POWER - AT
// #define MOTHERS_ID        539    // GTO POWER - AT

#define pcjr              253
#define BLOCK_CURSOR      1
#define SKINNY_CURSOR     0
#define SLOW              1
#define FAST              0
#define TRUE              1
#define FALSE             0
#define MAXINT            32767
#define MAXCLK            1000
#define BAD_UART          4
#define STRING_TYPE       0
#define INTEGER_TYPE      1
#define PARITY_TYPE       2
#define MENU_TYPE         3
#define CHAR_TYPE         4
#define NULL_TYPE         5
#define LONG_TYPE         6
#define EXTPRO_TYPE       7
#define SB_ROWS           100
#define SB_COLS           80
#define MAX_MESSAGE_SIZE  99
#define MAX_PANES         14
#define MAX_FAR_TEXT      237
#ifdef HOST
    #define MAX_PROMPTS   374
#endif
#define MAX_EXT_PROTO     18
#define MAX_INT_PROTO     12
#define MAX_PROTO         (MAX_EXT_PROTO + MAX_INT_PROTO)
#define MAX_FUNC_KEY      12
#define NUM_FUNC_KEYS     48
#ifdef HOST
    #define CMD_STK_SIZE      120
    #define CMD_STK_SIZE_1    128
#endif
#define WHEN_MAX          6
#define WHMAX             31
#define MAX_ANS           75
#define SIN_BUF_DEFAULT   7168
#define SOUT_BUF_DEFAULT  2560
#define CAPTURE_BUF_SIZE  1024
#define MAX_MEGAWIN       0x7FF0
#define NUL               0
#define SOH               1
#define STX               2
#define ETX               3
#define EOT               4
#define ENQ               5
#define ACK               6
#define BEL               7
#define BS                8
#define HT                9
#define LF                10
#define VT                11
#define FF                12
#define CR                13
#define SO                14
#define SI                15
#define DLE               16
#define DC1               17
#define DC3               19
#define NAK               21
#define SYN               22
#define ETB               23     // 128
#define CAN               24
#define EM                25     // 512
#define ESC               27
#define RS                30
#define ATS               '@'    // 1024
#define ASTR              '*'    // 2048
#define EQL               '='    // 3072
#define SUB               26     // 4096
#define CARET             '^'    // 6144
#define GRT               '>'    // 8192
#define OMEGA             234    // 16384
#define DEL               127
#define UP_ARROW          'A'
#define DOWN_ARROW        'B'
#define RIGHT_ARROW       'C'
#define LEFT_ARROW        'D'
#define END_CURSOR        'E'
#define HOME_CURSOR       'H'
#define INS_CURSOR        'N'
#define CURSOR_REPORT     'R'
#define CTRL_END_CURSOR   'S'
#ifdef HOST
    #define month_len         306001L
    #define year_len          36525L
#endif
#define test_esc_cr(n)    ((n!=CR)&&(n!=ESC))

typedef char bool;
typedef unsigned char byte;

struct screen_ptr_rec {
    char *screen_ptr_line;
    int   screen_ptr_type;
    char *screen_ptr_data;
};

struct screen_struct {
    struct screen_ptr_rec (*ScrArray)[];
    int ScrDescWidth;
    int ScrDataWidth[3];
    int ScrColLength;
    int ScrMaxEntries;
    int ScrIndentRight;
    int ScrIndentDown;
    int ScrDeltaX;
};

extern byte *copy(byte *,byte *,int,int);
extern void delete(byte *,int,int);
extern void insert(byte *,byte *,int);
extern int pos(byte *,byte *);
extern int ucpos(byte *,byte *);
extern unsigned _cdecl bit_reverse(unsigned);
extern void _fastcall ccitt_crc_calc(unsigned);
extern void _fastcall ccitt_crc32_calc(unsigned);
#ifdef DEBUG
    extern void stack_probe(void);
    extern void stack_report(void);
#endif

#endif
