#define TURBOC  1
#define TRUE    1
#define FALSE   0

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <dir.h>
#include <fcntl.h>
#include <io.h>
#include <conio.h>
#include "dram.h"

unsigned _ovrbuffer;
int ems_flag;
unsigned crc_reg_lo;
unsigned crc_reg_hi;
static int delete_stack[10];
static int delete_stack_ptr = 0;

extern unsigned _stklen  = 32768U;
extern unsigned _heaplen = 0;
extern void _fastcall ccitt_crc32_calc(unsigned);

void main(int,char *[]);
void delete_msg(char *,int,int);

int strip_nl(char *s,int imax)
{
    int j, lmax;

    lmax = imax - 1;
    j = 0;
    while ((s[j]) && (s[j] != '\n') && (s[j] != '\r') && (j < lmax))
	j++;
    s[j] = 0;
    return(j);
}

int chg_dir(char *p)
{
    char temp[82];
    char wrk[82];
    int j, deslash_it;

    if (! p[0])
	return(0);
    getcwd(temp,79);
    strcpy(wrk,p);
    strupr(wrk);
    deslash_it = 1;
    if (wrk[1] == ':') {
	setdisk((wrk[0] - 'A'));
	if (! wrk[2]) {
	    strcat(wrk,"\\");
	    deslash_it = 0;
	}
    }
    if (deslash_it)
        if ((j = strlen(wrk) - 1) > 0)
	    if (wrk[j] == '\\')
	        wrk[j] = 0;
    if (chdir(wrk)) {
	chg_dir(temp);
	return(-1);
    }
    return(0);
}

int fgets_p(char *s,int imax,FILE *f)
{
    char *p;

    p = fgets(s,(imax - 3),f);
    if ((p==NULL)||(s[0]==0x1a)) {
        s[0]=0;
        return(-1);
    }
    return((strip_nl(s,imax)));
}

long filesize(FILE *fptr)
{
    long length;

    fseek(fptr,0L,SEEK_END);
    length = ftell(fptr);
    fseek(fptr,0L,SEEK_SET);
    return(length);
}

char *build_date(int m,int d,int y)
{
    static char function[16];

    if (y > 1999) y -= 2000;
    if (y > 1900) y -= 1900;
    sprintf(function,"%2d-%02d-%02d",m,d,y);
    return(function);
}

char *date(void)
{
    static char function[16];
    union REGS regs;

    regs.x.ax = 0x2a00;
    intdos(&regs,&regs);
    strcpy(function,build_date(regs.h.dh,regs.h.dl,regs.x.cx));
    return(function);
}

static long month_length = 306001L;                     /*  30.6001 */
static long year_length  =  36525L;                     /* 365.2500 */

long daynumber(char *s)
{
    long ydays, mdays;
    int year, month, day, j, k, t;
    char inp[82];

    strcpy(inp,s);
    j = 2;
    t = j - 1;
    if ((inp[t]=='-') || (inp[t]=='/'))     j = t;
    k = j + 3;
    t = k - 1;
    if ((inp[t]=='-') || (inp[t]=='/'))     k = t;
    inp[k++] = 0;
    inp[j++] = 0;
    month = atoi(inp);
    day   = atoi(&inp[j]);
    year  = atoi(&inp[k]);

    if ((year<0)||(year>2070)||(month<0)||(month>12))
	return(0L);

    if (year<71)
	year += 2000;
    if ((year>70)&&(year<100))
	year += 1900;

    if (month<3) {
	month += 12;
	year--;
    }

    ydays = year_length * ((long) year);
    mdays = month_length * (((long) month) + 1L);

    return( ((ydays / 100L) + (mdays / 10000L) + ((long) day) - 694037L) );
}

void message_stack_killer(char *msg_path)
{
    unsigned csub;
    FILE *t_handle;
    FILE *msg_handle;
    char tname[82];
    char fname[82];
    char text[262];
    void *buffer1;
    void *buffer2;
    int ramt, j, skipper;
    unsigned base, line;

    base = ((delete_stack[0] - 1) / 10) + 1;
    for (j=0; j<delete_stack_ptr; j++)
	delete_stack[j] = (delete_stack[j] - 1) % 10;
    buffer1 = malloc(4100);
    buffer2 = malloc(4100);
    sprintf(fname,"%sGTMSGS\\%05u.MES",msg_path,base);
    sprintf(tname,"%sGTMSGS\\%05u.$$$",msg_path,base);
    if ((msg_handle = fopen(fname,"rt")) == NULL)
	goto Finish;
    setvbuf(msg_handle,buffer1,_IOFBF,4096);
    if ((t_handle = fopen(tname,"wt")) == NULL) {
	fclose(msg_handle);
	goto Finish;
    }
    setvbuf(t_handle,buffer2,_IOFBF,4096);
    skipper =
      line = 0;
    do {
	if ((ramt = fgets_p(text,260,msg_handle)) >= 0) {
	    if ((ramt==5)&&(text[0]==24)&&(text[1]=='S')&&(text[2]=='O')&&(text[3]=='M')) {
		skipper = 0;
		csub = text[4] - 48;
		for (j=0; j<delete_stack_ptr; j++) {
		    if (csub == delete_stack[j]) {
			skipper = 1;
			break;
		    }
		}
	    }
	    if (! skipper) {
		fprintf(t_handle,"%s\n",text);
		line++;
	    }
	}
    } while (ramt >= 0);
    fclose(msg_handle);
    fclose(t_handle);
    unlink(fname);
    if (line)
        rename(tname,fname);
    else
	unlink(tname);
Finish:
    free(buffer1);
    free(buffer2);
    delete_stack_ptr = 0;
}

void cleanup_delete_stack(char *msg_path)
{
    char fname[82];
    unsigned base;

    if (delete_stack_ptr < 10) {
	message_stack_killer(msg_path);
	return;
    }
    base = ((delete_stack[0] - 1) / 10) + 1;
    sprintf(fname,"%sGTMSGS\\%05u.MES",msg_path,base);
    unlink(fname);
    delete_stack_ptr = 0;
}

void delete_msg(char *msg_path,int m_number,int stack_them)
{
    int final;

    if (stack_them) {
	if (delete_stack_ptr) {
	    final = (delete_stack[0] / 10) + 1;
	    final *= 10;
	    if (m_number > final)
		cleanup_delete_stack(msg_path);
	}
	delete_stack[delete_stack_ptr++] = m_number;
	return;
    }
    delete_stack[0] = m_number;
    delete_stack_ptr = 1;
    message_stack_killer(msg_path);
}

long msg_size(char *msg_path,int m_number)
{
    FILE *msg_handle;
    char fname[82];
    char text[262];
    void *buffer;
    long res;
    int ramt, j, this_one, ch;
    unsigned base, sub;

    res = 0;
    j = m_number - 1;
    base = (j / 10) + 1;
    sub = j % 10;
    buffer = malloc(4100);
    sprintf(fname,"%sGTMSGS\\%05u.MES",msg_path,base);
    if ((msg_handle = fopen(fname,"rt")) == NULL)
	goto Finish;
    setvbuf(msg_handle,buffer,_IOFBF,4096);
    this_one = 0;
    do {
	if ((ramt = fgets_p(text,260,msg_handle)) > 0) {
	    if ((ramt==5)&&(text[0]==24)&&(text[1]=='S')&&(text[2]=='O')&&(text[3]=='M')) {
		if ((text[4] - 48) >= sub) {
		    this_one++;
		    continue;
		}
	    }
	    if (this_one) {
                switch (text[0]) {
                case ';':
                    goto NextLoop;
                case ' ':
                    if (!strnicmp(&text[1]," Route: ",8))
                        goto EarlyStop;
                    if (text[2]==' ') {
                        ch = text[1] & 0x00FF;
                        if ((ch=='*')||(ch==0x00FE))
                            goto EarlyStop;
                    }
                    break;
                case '_':
                    if (!strncmp(&text[1],"__ ",3))
                        goto EarlyStop;
                    break;
                case '#':
                    if ((!strnicmp(&text[1],"#MM",3))||(!strnicmp(&text[1],"#RD",3))||(!strnicmp(&text[1],"#FA",3)))
                        goto EarlyStop;
                    break;
                case '.':
                case '*':
                    if (!strnicmp(&text[1],"ORIG",4))
                        goto EarlyStop;
                    break;
                case '-':
                    if (!strncmp(&text[1],"--",2))
                        goto NextLoop;
                    break;
                }
		res += ramt;
            }
	}
NextLoop:
        ;
    } while ((ramt >= 0) && (this_one < 2));
EarlyStop:
    fclose(msg_handle);
Finish:
    free(buffer);
    return(res);
}

struct DupRec {
    int dup_msg_number;
    unsigned long dup_crc;
};

void delete_duplicates(char *msg_path)
{
#define MAX_DUP_CHECK 4096
    char curr_directory[82];
    char home_directory[82];
    struct DupRec dr[MAX_DUP_CHECK];
    int dr_ptr, no_dups, base_num, ramt;
    long msg_daynumber, day2, delta_amt;
    char ws[160];
    unsigned crc_input;
    long flen, fpos1, fpos2, size1, size2;
    int msg_control_file, j, k;
    struct msg_record mcr1;
    struct msg_record mcr2;

    delete_stack_ptr = 0;
    getcwd(home_directory,79);
    strcpy(curr_directory,msg_path);
    strupr(curr_directory);
    if (chg_dir(curr_directory)) {
	printf("\nCannot access %s",curr_directory);
	sleep(1);
	return;
    }
    if ((msg_control_file = _open("MESSAGE.CTL",O_RDWR)) < 0) {
	printf("\nCannot find %s%s\n",curr_directory,"MESSAGE.CTL");
	return;
    }
    flen = filelength(msg_control_file) - 128L;
    if (!((int) (flen / ((long) sizeof(struct msg_record))))) {
	printf("\nNo messages in found in %s\n",curr_directory);
	goto Delexit;
    }
    printf("\nDelete duplicates from %s\n",curr_directory);
    printf("\nPlease wait... building message info table...\n");
    _read(msg_control_file,(char*) &mcr1,sizeof(struct msg_record));
    base_num = mcr1.msg_number;
    dr_ptr = 0;
    do {
	if ((ramt = _read(msg_control_file,(char*) &mcr1,sizeof(struct msg_record))) == sizeof(struct msg_record)) {
	    if (dr_ptr >= MAX_DUP_CHECK) {
		printf("\n\nToo many messages to run delete dups, 4096 is the maximum.");
		printf(  "\nDelete some messages, then try to re-run this function.\n");
		goto Delexit;
	    }
	    if (! mcr1.msg_deleted) {
		dr[dr_ptr].dup_msg_number = mcr1.msg_number;
		msg_daynumber = daynumber(mcr1.msg_date);
		sprintf(ws,"%06ld%s%s%s%s",
		    msg_daynumber,
		    mcr1.msg_sender,
		    mcr1.msg_addressee,
		    mcr1.msg_topic,
		    mcr1.msg_time);
		crc_reg_hi = crc_reg_lo = 0xffff;
		for (j=0; (crc_input = ws[j]); j++)
		    ccitt_crc32_calc(crc_input);
		ccitt_crc32_calc(0);
		ccitt_crc32_calc(0);
		ccitt_crc32_calc(0);
		ccitt_crc32_calc(0);
		dr[dr_ptr++].dup_crc = ((((unsigned long)crc_reg_hi)<<16)|((unsigned long)crc_reg_lo));
	    }
	}
    } while (ramt == sizeof(struct msg_record));
    no_dups = 1;
    printf("\nOkay... now searching table for duplicates...\n");
    for (j=0; j<dr_ptr; j++) {
	if (dr[j].dup_msg_number>0) {
	    for (k=(j+1); k<dr_ptr; k++) {
		if ((dr[k].dup_msg_number>0)&&(dr[j].dup_crc==dr[k].dup_crc)) {
		    fpos1 = ((long)(dr[j].dup_msg_number - base_num)) * ((long)sizeof(struct msg_record));
		    lseek(msg_control_file,fpos1,SEEK_SET);
		    _read(msg_control_file,(char*) &mcr1,sizeof(struct msg_record));
		    fpos2 = ((long)(dr[k].dup_msg_number - base_num)) * ((long)sizeof(struct msg_record));
		    lseek(msg_control_file,fpos2,SEEK_SET);
		    _read(msg_control_file,(char*) &mcr2,sizeof(struct msg_record));
		    day2 = daynumber(mcr2.msg_date);
		    if (((daynumber(mcr1.msg_date))==day2)                &&
			(!strcmp(mcr1.msg_sender,mcr2.msg_sender))        &&
			(!strcmp(mcr1.msg_addressee,mcr2.msg_addressee))  &&
			(!strcmp(mcr1.msg_topic,mcr2.msg_topic))          &&
			(!strcmp(mcr1.msg_time,mcr2.msg_time))) {
			    size1 = msg_size(curr_directory,mcr1.msg_number);
			    size2 = msg_size(curr_directory,mcr2.msg_number);
                            delta_amt = size2 - size1;
                            if (delta_amt < 0)
                                delta_amt *= (-1L);
			    if (delta_amt <= 10L) {
				mcr2.msg_deleted = 1;
				lseek(msg_control_file,fpos2,SEEK_SET);
				_write(msg_control_file,(char*) &mcr2,sizeof(struct msg_record));
				delete_msg(curr_directory,mcr2.msg_number,0);
				mcr1.msg_sender[23]=mcr2.msg_sender[23]=0;
				no_dups = 0;
				dr[k].dup_msg_number = (-1);
				printf("\n        %5d %s %-23s %s",
				    mcr1.msg_number,
				    mcr1.msg_date,
				    mcr1.msg_sender,
				    mcr1.msg_topic);
				printf("\nDEL DUP %5d %s %-23s %s\n",
				    mcr2.msg_number,
				    mcr2.msg_date,
				    mcr2.msg_sender,
				    mcr2.msg_topic);
			    }
                            else {
                                printf("\nPossible dups, but messages are different size!");
                                printf("\n  %5d = %ld bytes    %5d = %ld bytes\n",
                                    mcr1.msg_number,
                                    size1,
                                    mcr2.msg_number,
                                    size2);
                            }
		    }
		}
	    }
	}
    }
    if (no_dups)
	printf("\nNo duplicates found.\n");
Delexit:
    _close(msg_control_file);
    chg_dir(home_directory);
}

void delete_messages(
    char *msg_path,
    int retain_amount,
    long max_msg_age,
    int dont_delete_recvd)
{
#define MAX_STICKY 1024
    char name[82];
    char curr_directory[82];
    char home_directory[82];
    char wrks[262];
    long mloc, flen, fast_offset, m_offset, woffset, fpos;
    char msg_recvd;
    char sticky_name[82];
    FILE *in_fileh;
    FILE *out_fileh;
    char *buffer1;
    char *buffer2;
    char *rbuf;
    int sticky_cnt, spt, sticky_base, prior_sticky_base, sticky_sub;
    int new_base, new_sub, fast_base, csub;
    int eof_char1, eof_char2, som_ptr, som_size;
    int sticky_num[MAX_STICKY];
    int msg_control_file;
    int temp_msg_control_file;
    int new_low, old_low, high_msg;
    int first_delete, last_delete;
    int first_file, last_file, old_file, not_end_of_file;
    int curr_msg, new_msg_num, old_msg_num;
    char backspaces[82];
    int delnum, j, ramt, msgnum, k, slen, aged_low;
    long curr_daynumber, day_override;
    struct msg_record msg_control_rec;

    rbuf =
      buffer1 =
        buffer2 = NULL;
    aged_low = delete_stack_ptr = 0;
    getcwd(home_directory,79);
    strcpy(curr_directory,msg_path);
    strupr(curr_directory);
    curr_daynumber = daynumber(date());
    if (chg_dir(curr_directory)) {
	printf("\nCannot access %s",curr_directory);
	sleep(1);
	return;
    }
    if ((msg_control_file = _open("MESSAGE.CTL",O_RDWR)) < 0) {
	printf("\nCannot find %s%s\n",curr_directory,"MESSAGE.CTL");
	goto Delexit;
    }
    flen = filelength(msg_control_file) - 128L;
    if (!(msgnum = (int) (flen / ((long) sizeof(struct msg_record))))) {
	printf("\nNo messages in found in %s\n",curr_directory);
	goto Delexit;
    }
    printf("\nThere are %d messages in %s\n",msgnum,curr_directory);
    day_override = max_msg_age;
    delnum = msgnum - retain_amount;
    delnum = (delnum / 10) * 10;
    ramt = _read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
    old_low = msg_control_rec.msg_number;
    if ((day_override > 10000) && (dont_delete_recvd))
	goto Sage;
    printf("\nSearching for out-of-date");
    if (dont_delete_recvd)
	printf(" messages.\n");
    else {
	printf(" and/or RECV'D messages.\n");
	printf("\nThe '*' indicates a RECV'D message.\n");
    }
    fpos = (long) sizeof(struct msg_record);
    do {
	if ((ramt = _read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record))) == sizeof(struct msg_record)) {
	    if (!aged_low)
		aged_low = msg_control_rec.msg_number;
	    msg_recvd = ' ';
	    if (! msg_control_rec.msg_deleted) {
		if (msg_control_rec.msg_flags & 0x0001)
		    goto SkipSticky;
		if (msg_control_rec.msg_received & 0x0f)
		    msg_recvd = '*';
		if ((curr_daynumber - daynumber((char*)msg_control_rec.msg_date)) > day_override) {
Thekill:
		    msg_control_rec.msg_deleted = 1;
		    lseek(msg_control_file,fpos,SEEK_SET);
		    _write(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
		    delete_msg(curr_directory,msg_control_rec.msg_number,1);
		    msg_control_rec.msg_sender[23]=0;
		    printf("\nDEL %5d  %s  %c%-23s  %-s",
			msg_control_rec.msg_number,
			msg_control_rec.msg_date,
			msg_recvd,
			msg_control_rec.msg_sender,
			msg_control_rec.msg_topic);
		    msg_recvd = ' ';
		}
	    }
	    if (msg_recvd == '*')
		if (! dont_delete_recvd) 
		    goto Thekill;
	    if (msg_control_rec.msg_deleted) {
		if ((aged_low + 1) == msg_control_rec.msg_number)
		    aged_low++;
	    }
	}
SkipSticky:
	fpos += ((long) sizeof(struct msg_record));
    } while (ramt == sizeof(struct msg_record));
    if (delete_stack_ptr)
	cleanup_delete_stack(curr_directory);
    printf("\n");
Sage:
    if (retain_amount > 32700)
	goto Delexit;
    high_msg = old_low + msgnum;
    if ((new_low = old_low + delnum) < aged_low)
	new_low = aged_low;
    new_low = (new_low / 10) * 10;
    delnum = new_low - old_low;
    first_delete = old_low + 1;
    last_delete = old_low + delnum;
    printf("\nCurrent low message number: %d\n",first_delete);
    if (delnum > 0)
        printf("The new low message number: %d\n",(last_delete + 1));
    printf("The highest message number: %d\n",high_msg);
    if (delnum > 0)
        printf("\nThe number of messages deleted will be: %d\n",delnum);
    else {
	printf("\nNo messages need to be deleted!\n");
Delexit:
	sleep(1);
        _close(msg_control_file);
        goto Delx;
    }
    if ((temp_msg_control_file = _creat("MESSAGE.$$$",0)) < 0) {
	printf("\nERROR: cannot create %s%s\n",curr_directory,"MESSAGE.$$$");
	goto Delexit;
    }
/*** start sticky processing ***/
    sticky_cnt = 0;
    lseek(msg_control_file,((long) sizeof(struct msg_record)),SEEK_SET);
    printf("\nSearching for sticky messages.");
    do {
	_read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
	curr_msg = msg_control_rec.msg_number;
	if (!msg_control_rec.msg_deleted)
	    if (msg_control_rec.msg_flags & 0x0001)
	        sticky_num[sticky_cnt++] = curr_msg;
    } while ((curr_msg < last_delete)&&(sticky_cnt < MAX_STICKY));
    lseek(msg_control_file,0L,SEEK_SET);
    ramt = _read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
    if ((new_low -= sticky_cnt) < 0) {
	_close(temp_msg_control_file);
	unlink("MESSAGE.$$$");
	printf("ERROR: too many sticky messages, cannot delete any messages.\n");
	goto Delexit;
    }
    msg_control_rec.msg_number = new_low;
    ramt = _write(temp_msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
    if (! sticky_cnt) {
	printf("   No sticky messages found!\n");
    }
    else {
	printf("\nMoving sticky messages to a safe place.");
	prior_sticky_base = 0;
        for (spt=0; spt < sticky_cnt; spt++) {
	    mloc = (((long) (sticky_num[spt] - old_low)) * ((long) sizeof(struct msg_record)));
	    lseek(msg_control_file,mloc,SEEK_SET);
	    _read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
            msg_control_rec.msg_number = new_low + spt + 1;
	    _write(temp_msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
	    if ((sticky_base=(((sticky_num[spt]-1)/10)+1))!=prior_sticky_base){
                prior_sticky_base = sticky_base;
	        sprintf(wrks,"%sGTMSGS\\%05d.MES",curr_directory,sticky_base);
		sprintf(sticky_name,"%sGTMSGS\\%05d.STK",curr_directory,sticky_base);
		rename(wrks,sticky_name);
		printf("\n    Renaming  %05d.MES -> %05d.STK",sticky_base,sticky_base);
	    }
        }
    }
/*** end sticky processing ***/
    rbuf = malloc(4100);
    mloc = (((long) (last_delete + 1 - old_low)) * ((long) sizeof(struct msg_record)));
    lseek(msg_control_file,mloc,SEEK_SET);
    do {
	if ((ramt = _read(msg_control_file,rbuf,4096)) > 0)
            _write(temp_msg_control_file,rbuf,ramt);
    } while (ramt > 0);
    free(rbuf);
    rbuf = NULL;
    j = (first_delete - 1);
    first_file = (j / 10) + 1;
    j = (last_delete - 1);
    last_file = (j / 10) + 1;
    printf("\nFiles to be deleted are: %05d.MES - %05d.MES\n",first_file,last_file);
    _close(temp_msg_control_file);
    _close(msg_control_file);
    last_file++;
    sprintf(name,"%sGTMSGS\\00000.MES",curr_directory);
    printf("\nDELETE: %s",name);
    slen = strlen(name);
    for (k=0; k < slen; k++)
	backspaces[k] = '\x08';
    backspaces[slen] = 0;
    for (j=first_file; j < last_file; j++) {
	sprintf(name,"%sGTMSGS\\%05d.MES",curr_directory,j);
	printf("%s%s",backspaces,name);
	unlink(name);
    }
    if (sticky_cnt) {
        buffer1 = malloc(4100);
        buffer2 = malloc(4100);
	printf("\nRestoring sticky messages.");
	fast_offset = fast_base = 0;
        for (spt=0; spt < sticky_cnt; spt++) {
	    old_msg_num = sticky_num[spt];
	    k = old_msg_num - 1;
	    sticky_base = (k / 10) + 1;
	    sticky_sub  = (k % 10);
            new_msg_num = new_low + spt + 1;
	    k = new_msg_num - 1;
	    new_base = (k / 10) + 1;
	    new_sub  = (k % 10);
	    sprintf(wrks,"%sGTMSGS\\%05d.MES",curr_directory,new_base);
	    sprintf(sticky_name,"%sGTMSGS\\%05d.STK",curr_directory,sticky_base);
	    printf("\n    Copying message  %05d -> %05d",old_msg_num,new_msg_num);
	    if ((in_fileh = fopen(sticky_name,"rt")) == NULL) {
		printf("\nERROR: cannot open %s\n",wrks);
	        sleep(1);
	        goto Delx;
	    }
	    setvbuf(in_fileh,buffer1,_IOFBF,4096);
            old_file = 1;
	    if ((out_fileh = fopen(wrks,"r+t")) == NULL) {
		old_file = 0;
		if ((out_fileh = fopen(wrks,"wt")) == NULL) {
		    printf("\nERROR: cannot create %s\n",wrks);
		    fclose(in_fileh);
		    sleep(1);
		    goto Delx;
	        }
            }
            setvbuf(out_fileh,buffer2,_IOFBF,4096);
	    if ((sticky_base == fast_base) && (fast_offset > 0))
                fseek(in_fileh,fast_offset,SEEK_SET);
            if (old_file) {
	        if ((m_offset = filesize(out_fileh) - 2L) > 0L) {
                    fseek(out_fileh,m_offset,SEEK_SET);
                    eof_char1 = fgetc(out_fileh);
		    eof_char2 = fgetc(in_fileh);
		    m_offset += 2;
		    if ((eof_char2 == 26)||(eof_char2 == EOF))
			m_offset--;
		    fseek(out_fileh,m_offset,SEEK_SET);
		    if ((eof_char1 != 10) && (eof_char1 != 13)) {
			if ((eof_char2 != 10) && (eof_char2 != 13)) {
			    fprintf(out_fileh,"\n");
			}
		    }
		}
	    }
	    fprintf(out_fileh,"\x18SOM%u\n",new_sub);
	    csub = 0xFFFF;
	    not_end_of_file = 1;
            do {
	        if ((ramt = fgets_p(wrks,260,in_fileh)) < 0)
                    not_end_of_file = wrks[0] = 0;
		if (ramt > 0) {
                    som_ptr = 4;
                    som_size = 8;
                    if (csub == (-1)) {
		        if ((ramt==4)&&(wrks[0]=='S')&&(wrks[1]=='O')&&(wrks[2]=='M')&&(wrks[3]>='0')&&(wrks[3]<='9')) {
                            som_ptr = 3;
                            som_size = 7;
                            goto ProcessSOM;
                        }
                    }
		    if ((ramt==5)&&(wrks[0]==24)&&(wrks[1]=='S')&&(wrks[2]=='O')&&(wrks[3]=='M')) {
ProcessSOM:
			if ((woffset = ftell(in_fileh) - som_size) > 0) {
		            fast_base = sticky_base;
		            fast_offset = woffset;
		        }
		        if ((csub = wrks[som_ptr] - 48) > sticky_sub)
			    not_end_of_file = 0;
		        goto Denl;
	            }
		}
		if ((not_end_of_file) && (csub == sticky_sub))
		    fprintf(out_fileh,"%s\n",wrks);
Denl:           ;
            } while (not_end_of_file);
	    fclose(out_fileh);
	    fclose(in_fileh);
	}
	for (spt=0; spt < sticky_cnt; spt++) {
	    sticky_base = (((sticky_num[spt]-1)/10)+1);
	    sprintf(wrks,"%sGTMSGS\\%05d.STK",curr_directory,sticky_base);
	    unlink(wrks);
	}
        free(buffer1);
        free(buffer2);
        buffer1 =
          buffer2 = NULL;
    }
    printf("\n");
    unlink("MESSAGE.BAK");
    rename("MESSAGE.CTL","MESSAGE.BAK");
    rename("MESSAGE.$$$","MESSAGE.CTL");
    unlink("MESSAGE.BAK");
Delx:
    if (buffer1 != NULL)
        free(buffer1);
    if (buffer2 != NULL)
        free(buffer2);
    if (rbuf != NULL)
        free(rbuf);
    chg_dir(home_directory);
    return;
}

int cvt_number(
		 int prior,
		 int cross_base,
		 int renum_base,
		 int highest_old,
		 int highest_new,
		 int cross_num[],
		 int backtrack
	      )
{
    int new_msg_num, k;

    new_msg_num = 0;
    if (prior < cross_base) {
	if (backtrack)
	    new_msg_num = renum_base - 1;
	return(new_msg_num);
    }
    if (prior > highest_old) {
	if (backtrack)
	    new_msg_num = highest_new;
	return(new_msg_num);
    }
    k = prior - cross_base;
    new_msg_num = cross_num[k];
    if (backtrack) {
	while ((k>0)&&(new_msg_num<0))
	    new_msg_num = cross_num[--k];
    }
    if ((new_msg_num<renum_base)||(new_msg_num>highest_new))
	new_msg_num = 0;
    return(new_msg_num);
}

void renumber_messages(char *msg_path,int r_base)
{
#define RENUM_MAX_MSGS 4096
#define MAX_USER_MSG 128
#define MAX_MSG_CTL 32
    char curr_directory[82];
    char home_directory[82];
    char wrks[262];
    int msg_control_file, ramt, j, k, highest_old, highest_new;
    int temp_msg_control_file, prior, i, m, renum_base;
    USER_MSG_RECORD uma[MAX_USER_MSG];
    struct msg_record in_mcr[MAX_MSG_CTL];
    struct msg_record out_mcr[MAX_MSG_CTL];
    int mcr_amt, mcr_cnt, mcr_ptr, out_mcr_cnt, out_mcr_amt;
    char *buffer1;
    char *buffer2;
    char backspaces[82];
    int old_file, not_end_of_file, no_find, jnum, do_msg_move;
    struct msg_record msg_control_rec;
    int msg_cnt, old_num[RENUM_MAX_MSGS];
    int cross_num[RENUM_MAX_MSGS], cross_base;
    int old_msg_num, new_msg_num, lowest_base;
    FILE *old_msg_file;
    int old_base, old_sub;
    FILE *new_msg_file;
    int new_base, new_sub, csub;
    long m_offset, fpos;
    int eof_char1, eof_char2;
    int uma_cnt, user_msg_file, uma_amt, temp_user_msg_file;
    long fast_offset, woffset;
    int fast_base, found_delete;

    buffer1 =
      buffer2 = NULL;
    renum_base = r_base;
    fast_offset = fast_base = found_delete = 0;
    getcwd(home_directory,79);
    strcpy(curr_directory,msg_path);
    strupr(curr_directory);
    if (chg_dir(curr_directory)) {
	printf("\nCannot access %s",curr_directory);
	sleep(1);
	return;
    }
    if ((msg_control_file = _open("MESSAGE.CTL",O_RDWR)) < 0) {
	printf("\nCannot find %s%s",curr_directory,"MESSAGE.CTL");
	sleep(1);
	goto Renx;
    }
    ramt = _read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
    if ((temp_msg_control_file = _creat("MESSAGE.$$$",0)) < 0) {
	printf("\nERROR: cannot create %s%s",curr_directory,"MESSAGE.$$$");
	_close(msg_control_file);
	sleep(1);
	goto Renx;
    }
    lowest_base = cross_base = (msg_control_rec.msg_number + 1);
    mcr_amt = (sizeof(struct msg_record) * MAX_MSG_CTL);
/****************************************************************************/
    no_find = 1;
    do {
	if ((ramt = _read(msg_control_file,(char*) &in_mcr,mcr_amt)) > 0) {
	    mcr_cnt = (ramt / sizeof(struct msg_record));
	    for (mcr_ptr = 0; mcr_ptr < mcr_cnt; mcr_ptr++) {
		if (! in_mcr[mcr_ptr].msg_deleted) {
		    cross_base = in_mcr[mcr_ptr].msg_number;
		    no_find = 0;
		    break;
		}
	    }
	}
    } while ((ramt > 0) && (no_find));
    if (no_find) {
	_close(msg_control_file);
	goto NoRenum;
    }
    fpos = ((long) sizeof(struct msg_record));
    lseek(msg_control_file,fpos,SEEK_SET);
    if ((renum_base < 1)||(renum_base > 32700)) {
	printf("\nLowest message number ... %d",lowest_base);
	printf("\nNatural message base .... %d\n",cross_base);
	renum_base = cross_base;
    }
/****************************************************************************/
    printf("\nRenumbering %s",curr_directory);
    msg_cnt = -1;
    msg_control_rec.msg_number = (renum_base - 1);
    ramt = _write(temp_msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
    for (j=0; j < RENUM_MAX_MSGS; j++)
	cross_num[j] = -1;
    do_msg_move = 
     highest_new =
      highest_old = 0;
    do {
	if ((ramt = _read(msg_control_file,(char*) &in_mcr,mcr_amt)) > 0) {
	    mcr_cnt = (ramt / sizeof(struct msg_record));
	    out_mcr_cnt = 0;
	    for (mcr_ptr = 0; mcr_ptr < mcr_cnt; mcr_ptr++) {
		jnum = in_mcr[mcr_ptr].msg_number;
		if (in_mcr[mcr_ptr].msg_deleted) {
		    found_delete = 1;
		    if (jnum > cross_base)
			do_msg_move = 1;
		}
	        else {
		    if (++msg_cnt >= RENUM_MAX_MSGS) {
		        printf("\nERROR: too many messages to renumber, %d maximum.",RENUM_MAX_MSGS);
		        printf("\n       Delete some messages, then retry renumbering.");
		        sleep(1);
		        _close(temp_msg_control_file);
		        _close(msg_control_file);
		        goto Renx;
		    }
		    j = jnum - cross_base;
		    highest_old =
			old_num[msg_cnt] = jnum;
		    highest_new = cross_num[j] =
		        in_mcr[mcr_ptr].msg_number = (renum_base + msg_cnt);
                    out_mcr[out_mcr_cnt++] = in_mcr[mcr_ptr];
	        }
	    }
	    if ((out_mcr_amt = (out_mcr_cnt * sizeof(struct msg_record))) > 0)
                _write(temp_msg_control_file,(char *) &out_mcr,out_mcr_amt);
	}
    } while (ramt > 0);
    _close(temp_msg_control_file);
    _close(msg_control_file);
    printf("\n");
    if (! found_delete) {
	if (cross_base == renum_base) {
NoRenum:
	    unlink("MESSAGE.$$$");
	    printf("\nThis msg base does not need to be renumbered!");
	    sleep(1);
	    goto Renx;
	}
    }
    if ((! do_msg_move) && (cross_base == renum_base))
	goto InstallMessage;
    printf("Renumbering message  ");
    strcpy(wrks,"00000 of 00000 -> 00000");
    k = strlen(wrks);
    for (j=0; j < k; j++)
	backspaces[j] = '\x08';
    printf(wrks);
    backspaces[k] = 0;
    buffer1 = malloc(4100);
    buffer2 = malloc(4100);
    for (j=0; j <= msg_cnt; j++) {
	old_msg_num = old_num[j];
	new_msg_num = renum_base + j;
        k = (old_msg_num - 1);
        old_base = (k / 10) + 1;
        old_sub = k % 10;
	k = (new_msg_num - 1);
	new_base = (k / 10) + 1;
	new_sub = k % 10;
	printf(backspaces);
	printf("%05d of %05d -> %05d",old_msg_num,highest_old,new_msg_num);
	sprintf(wrks,"%sGTMSGS\\%05u.MES",curr_directory,old_base);
	if ((old_msg_file = fopen(wrks,"rt")) == NULL) {
	    printf("\nERROR: cannot open %s",wrks);
	    sleep(1);
	    goto Renx;
	}
	setvbuf(old_msg_file,buffer1,_IOFBF,4096);
	if ((old_base == fast_base) && (fast_offset > 0))
            fseek(old_msg_file,fast_offset,SEEK_SET);
        sprintf(wrks,"%sGTMSGS\\%05u.NEW",curr_directory,new_base);
        old_file = 1;
        if ((new_msg_file = fopen(wrks,"r+t")) == NULL) {
            old_file = 0;
            if ((new_msg_file = fopen(wrks,"wt")) == NULL) {
		printf("\nERROR: cannot create %s",wrks);
		fclose(old_msg_file);
		sleep(1);
		goto Renx;
	    }
        }
        setvbuf(new_msg_file,buffer2,_IOFBF,4096);
        if (old_file) {
	    if ((m_offset = filesize(new_msg_file) - 2L) > 0L) {
                fseek(new_msg_file,m_offset,SEEK_SET);
                eof_char1 = fgetc(new_msg_file);
		eof_char2 = fgetc(new_msg_file);
		m_offset += 2;
		if (eof_char2 == 26)
		    m_offset--;
		fseek(new_msg_file,m_offset,SEEK_SET);
		if ((eof_char1 != 10) && (eof_char1 != 13)) {
		    if ((eof_char2 != 10) && (eof_char2 != 13)) {
			fprintf(new_msg_file,"\n");
		    }
		}
	    }
        }
        fprintf(new_msg_file,"\x18SOM%u\n",new_sub);
	not_end_of_file = 1;
	csub = 0xFFFF;
        do {
	    if ((ramt = fgets_p(wrks,260,old_msg_file)) < 0)
                not_end_of_file = wrks[0] = 0;
	    if (ramt > 0) {
                if ((ramt==5)&&(wrks[0]==24)&&(wrks[1]=='S')&&(wrks[2]=='O')&&(wrks[3]=='M')) {
		    if ((woffset = ftell(old_msg_file) - 8) > 0) {
			fast_base = old_base;
			fast_offset = woffset;
		    }
		    if ((csub = wrks[4] - 48) > old_sub)
			not_end_of_file = 0;
		    goto RenLoop;
	        }
	    }
            if ((not_end_of_file) && (csub == old_sub))
                fprintf(new_msg_file,"%s\n",wrks);
RenLoop:    ;
	} while (not_end_of_file);
	fclose(new_msg_file);
	fclose(old_msg_file);
    }
    free(buffer1);
    free(buffer2);
    buffer1 =
      buffer2 = NULL;
    printf("\nRenumbering the USER_MSG.CTL file");
    if ((user_msg_file = _open("USER_MSG.CTL",O_RDWR)) < 0) {
	printf("\nCannot find %s%s",curr_directory,"USER_MSG.CTL");
	sleep(1);
	goto Renx2;
    }
    if ((temp_user_msg_file = _creat("USER_MSG.$$$",0)) < 0) {
	printf("\nERROR: cannot create %s%s",curr_directory,"USER_MSG.$$$");
	sleep(1);
	_close(user_msg_file);
	goto Renx2;
    }
    ramt = _read(user_msg_file,(char*) &msg_control_rec,sizeof(USER_MSG_RECORD));
    _write(temp_user_msg_file,(char*) &msg_control_rec,ramt);
    uma_amt = sizeof(USER_MSG_RECORD) * MAX_USER_MSG;
    do {
	if ((ramt = _read(user_msg_file,(char*) &uma,uma_amt)) > 0) {
	    uma_cnt = (ramt / sizeof(USER_MSG_RECORD));
            for (j=0; j < uma_cnt; j++) {
		if (!(uma[j].user_msg_deleted)) {
		/****/
		    uma[j].user_msg_prior_read = cvt_number(
				      uma[j].user_msg_prior_read,
				      cross_base,
				      renum_base,
				      highest_old,
				      highest_new,
				      cross_num,
				      TRUE
					    );
		/****/
		    uma[j].user_msg_highest_scan = cvt_number(
				      uma[j].user_msg_highest_scan,
				      cross_base,
				      renum_base,
				      highest_old,
				      highest_new,
				      cross_num,
				      TRUE
					    );
		/****/
		    for (i=0; i<2; i++) {
			uma[j].user_msg_marked[i] = cvt_number(
				      uma[j].user_msg_marked[i],
				      cross_base,
				      renum_base,
				      highest_old,
				      highest_new,
				      cross_num,
				      FALSE
					    );
		    }
		/****/
		}
	    }
	    _write(temp_user_msg_file,(char*) &uma,ramt);
	}
    } while (ramt > 0);
    _close(user_msg_file);
    _close(temp_user_msg_file);
    if ((msg_control_file = _open("MESSAGE.$$$",O_RDWR)) < 0) {
	printf("\nERROR: cannot find %s%s",curr_directory,"MESSAGE.$$$");
	sleep(1);
	goto Renx;
    }
    fpos = ((long) sizeof(struct msg_record));
    lseek(msg_control_file,fpos,SEEK_SET);
    printf("\nRenumbering the reply numbers.");
    mcr_amt = (sizeof(struct msg_record) * MAX_MSG_CTL);
    do {
	if ((ramt = _read(msg_control_file,(char*) &in_mcr,mcr_amt)) > 0) {
	    mcr_cnt = (ramt / sizeof(struct msg_record));
	    for (j=0; j<mcr_cnt; j++) {
		m = 0;
		for (i=0; i<3; i++) {
 	            prior = in_mcr[j].msg_reply_no[i];
		    in_mcr[j].msg_reply_no[i] = 0;
		    if (prior) {
			new_msg_num = cvt_number(
					  prior,
					  cross_base,
					  renum_base,
					  highest_old,
					  highest_new,
					  cross_num,
					  FALSE
						);
			if (new_msg_num)
			    in_mcr[j].msg_reply_no[m++] = new_msg_num;
		    }
		}
		in_mcr[j].msg_orig_no = cvt_number(
					    in_mcr[j].msg_orig_no,
					    cross_base,
					    renum_base,
					    highest_old,
					    highest_new,
					    cross_num,
					    FALSE
						  );
	    }
	    lseek(msg_control_file,fpos,SEEK_SET);
            _write(msg_control_file,(char*) &in_mcr,ramt);
	    fpos += ((long) ramt);
	}
    } while (ramt > 0);
    _close(msg_control_file);
    printf("\nInstalling the new USER_MSG.CTL file");
    unlink("USER_MSG.BAK");
    rename("USER_MSG.CTL","USER_MSG.BAK");
    rename("USER_MSG.$$$","USER_MSG.CTL");
    unlink("USER_MSG.BAK");
Renx2:
    sprintf(wrks,"DEL  %sGTMSGS\\?????.MES",curr_directory);
    printf("\n%s",wrks);
    system(wrks);
    sprintf(wrks,"REN  %sGTMSGS\\?????.NEW  ?????.MES",curr_directory);
    printf("\n%s",wrks);
    system(wrks);
InstallMessage:
    printf("\nInstalling the new MESSAGE.CTL file");
    unlink("MESSAGE.BAK");
    rename("MESSAGE.CTL","MESSAGE.BAK");
    rename("MESSAGE.$$$","MESSAGE.CTL");
    unlink("MESSAGE.BAK");
Renx:
    printf("\n");
    if (buffer1 != NULL)
        free(buffer1);
    if (buffer2 != NULL)
        free(buffer2);
    chg_dir(home_directory);
}

void process_pathname(char *p)
{
    unsigned lgth;

    if (p[0]) {
        strupr(p);
        lgth = strlen(p) - 1;
        if (p[lgth] == '\n')
	    p[lgth--] = 0;
	if (p[lgth] == '\r')
	    p[lgth--] = 0;
        if (p[lgth++] != '\\') {
            p[lgth++] = '\\';
            p[lgth] = 0;
	}
    }
}

void main(int argc,char *argv[])
{
    char msg_base_path[128];
    char batch_amount[128];
    char option[128], age_str[128];
    int batch_count, cnt, dont_delete_recvd;
    long max_age;

    printf("DELREN 2.0");
    printf("\n(C) 1990,1991, P&M Software Co.");
    printf("\nAll Rights Reserved");
    printf("\n");
    dont_delete_recvd = 1;
    max_age = 32767;
    if (argc >= 4) {
	cnt = 2;
	while (++cnt < argc) {
	    strcpy(age_str,argv[cnt]);
	    strupr(age_str);
	    if (age_str[0]=='/') {
		if ((age_str[1]=='R')&&(age_str[2]=='X')) 
		    dont_delete_recvd = 0;
		if (age_str[1]=='D') {
		    age_str[0]=age_str[1]='0';
		    if (age_str[2]==':')
			age_str[2]='0';
		    if (!(max_age = atol(age_str)))
			max_age = 32767;
		}
	    }
	}
    }
    if (argc < 3) {
	printf(  "\nUsage is:  DELREN  opt  pathname  [number]  [/Dnnnn]  [/RX]");
	printf("\n\n   Where:\n\n      opt ....... /R = renumber messages");
	printf(               "\n                  /C = compress messages");
	printf(               "\n                  /D = delete messages");
	printf(               "\n                  /B = both delete & renumber");
	printf(               "\n                  /U = delete duplicate messages");
	printf(             "\n\n      pathname .. the path to the message base");
	printf(             "\n\n      number .... with opt = /R, the renumbering base");
	printf(               "\n                  with opt = /D or /B, the number of messages retained");
	printf(             "\n\n      /Dnnnn .... with opt = /D, /B or /C, delete old messages,");
	printf(               "\n                  where 'nnnn' is the max age in days.");
	printf(             "\n\n      /RX ....... with opt = /D or /C, to delete RECV'D messages");
	printf("\n");
	exit(1);
    }
    strcpy(option,argv[1]);
    strcpy(msg_base_path,argv[2]);
    strcpy(batch_amount,argv[3]);
    process_pathname(msg_base_path);
    batch_amount[5] = 0;
    batch_count = atoi(batch_amount);
    if (batch_count < 1)
	batch_count = 32767;
    strupr(option);
    if (option[0]=='/') { 
	if (option[1]=='U') 
	    delete_duplicates(msg_base_path);
	if (option[1]=='C') {
	    delete_messages(msg_base_path,32767,max_age,dont_delete_recvd);
	    renumber_messages(msg_base_path,0);
	}
	if ((option[1]=='D')||(option[1]=='B'))
	    delete_messages(msg_base_path,batch_count,max_age,dont_delete_recvd);
	if ((option[1]=='R')||(option[1]=='B')) {
	    if (option[1]=='B') 
		batch_count = 1;
	    renumber_messages(msg_base_path,batch_count);
	}
    }
    printf("+=============================================================================+");
    exit(0);
}
