#include "define.h"
#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <string.h>
#include <ctype.h>
#include <alloc.h>
#include <sys\stat.h>
#include <errno.h>
#include "futil.h"

#ifdef DEBUG
    extern void stack_probe(void);
#endif

extern unsigned char lan_path[];
extern INTEGER crc_calc(DRAM far *);
extern void start_hash(void);
extern void fetch_dat_rec(DRAM far *);
extern INTEGER next_hash(void);

STRING    copyright1[]   = "(C) Copyright 1993, P&M Software Co";
STRING    copyright2[]   = "All Rights Reserved";
#ifdef HOST
    INTEGER   crc_reg_hi;
    INTEGER   begin_prime   = 503;
    INTEGER   prime[]       = { 503U,2017U,4127U,8123U,16127U,32749U,65521U };
    INTEGER   crc_reg_lo;
#endif
INTEGER  hash_value, delta_hash, hash_first, hash_crc, search, hash_max;

STRING   dat_file[80];
STRING   idx_file[80];
STRING   dat_rec[256];

#ifdef HOST
/*****

	The function 'dram_close()' is used to close an open fcb.  Please
	note that associated memory allocation is not released.  This must
	be done separately after the close is accomplished.

*****/
int dram_close(DRAM far *fcb,int func)
{
    REGISTER res;

    res = 4;
    if (! fcb->dram_status)
	goto Cex;
    unlock_idx(fcb);
    unlock_dat(fcb);
    close(fcb->dat_handle);
    close(fcb->idx_handle);
    res = fcb->dram_status = 0;
Cex:
    return(res);
}

/*****

	The function 'allocate_fcb()' is used to allocate memory on the
	far heap for the various structures used by the DRAM functions
	associated with fcb's.  This must be done prior to opening an fcb.

*****/
DRAM far *allocate_fcb(void)
{
    DRAM far *fcb;

    fcb = (DRAM far *) farmalloc(sizeof(DRAM));
    FARmemset((char far *) fcb,0,sizeof(DRAM));
    fcb->user_rec = (USER_RECORD far *) farmalloc(sizeof(USER_RECORD));
    fcb->user_msg_rec  = (USER_MSG_RECORD far *) farmalloc(sizeof(USER_MSG_RECORD));
    fcb->idx_rec  = (IDX_RECORD far *) farmalloc(sizeof(IDX_RECORD));
    return(fcb);
}

/*****

	The function 'release_fcb()' is used to return allocated memory
	to the far heap after the fcb has been closed.

*****/
void release_fcb(DRAM far *fcb)
{
    if (fcb != NULL) {
	farfree(fcb->idx_rec);
	farfree(fcb->user_msg_rec);
	farfree(fcb->user_rec);
	farfree(fcb);
    }
}

/*****

	The function 'dram()' is the main entry point to all the DRAM
	functions (the ones usable by outside programs).  It is recommended
	for debugging purposes, that all calls to DRAM routines go thru this
	entry point.

	The various 'func' values are listed in the DRAM.H file.

	CREATE 		0
	OPEN		1
	CLOSE		2
	ADD		3
	READ		4
	PURGE		5
	APPEND		6
	HASH_READ	7
	DELETE		8
	UNDELETE	9

*****/

typedef int (*dramfunc)(DRAM far *,int);

static dramfunc dfunc[] = {
	 /* 0 */     dram_create,
	 /* 1 */     dram_open,
	 /* 2 */     dram_close,
	 /* 3 */     dram_add,
	 /* 4 */     dram_read,
	 /* 5 */     re_org,
	 /* 6 */     dram_add,
	 /* 7 */     dram_read,
	 /* 8 */     dram_delete,
	 /* 9 */     dram_undelete
		   };

static char dramcode[] = { 0,0,0,0,0,0,1,1,0,0 };

int dram(int func,DRAM far *fcb)
{
    return((dfunc[func](fcb,dramcode[func])));
}

/*****

	The function 'srch_del()' is used when an addition to the
	CTL file is requested.  This function searches the IDX file
	looking for deleted entries which may be re-issued to another
	caller.  The fcb must be open prior to entry.

*****/
LONGINTEGER srch_del(DRAM far *fcb)
{
    INTEGER     j;
    REGISTER    k;
    INTEGER     block_size;
    LONGINTEGER idxflen, dfpos;
    IDX_RECORD  idx_buffer[128];

    idxflen = filelength(fcb->idx_handle);
    hash_max = ((INTEGER) (idxflen / ((LONGINTEGER) sizeof(IDX_RECORD)))) - 1;
    block_size = 128 * sizeof(IDX_RECORD);
    k = 128 - 1;
    for (j = 1; j < hash_max; j++) {
	if (++k == 128) {
	    fcb->idxfpos = (((LONGINTEGER) j) * ((LONGINTEGER) sizeof(IDX_RECORD)));
	    seekfile(fcb->idx_handle,fcb->idxfpos,SEEK_SET);
	    readfile(fcb->idx_handle,(STRING far *) &idx_buffer[0],block_size);
	    k = 0;
	}
	if ((idx_buffer[k].hash_del_flg) && (! idx_buffer[k].hash_re_used)) {
	    idx_buffer[k].hash_re_used = 1;
	    fcb->idxfpos = (((LONGINTEGER) j) * ((LONGINTEGER) sizeof(IDX_RECORD)));
	    seekfile(fcb->idx_handle,fcb->idxfpos,SEEK_SET);
	    writefile(fcb->idx_handle,(STRING far *) &idx_buffer[k],sizeof(IDX_RECORD));
	    dfpos = (((LONGINTEGER) idx_buffer[k].hash_ptr) * ((LONGINTEGER) fcb->dat_recsize));
	    return(dfpos);
	}
    }
    return(0L);
}

/*****

	The function 'dram_add()' is used to add data records to the CTL
	file.  The fcb must be open prior to entry.  The 'append' flag is
	used to control whether records are added at the end of the file
	or if a deleted record search is to be performed -- so that deleted
	records can be re-used.  When building the files from scratch, with
	no deleted records, the 'append' flag is very good at making the
	routine run faster.  The fcb must be filled with valid key information
	and a data record provided -- there is a pointer provided in the fcb
	for this purpose.

*****/
int dram_add(DRAM far *fcb,int append)
{
    int res, old_rec, rdamt;
    INTEGER entryno, max_entryno, add_ptr;
    LONGINTEGER idxflen, datflen, add_idxfpos, add_datfpos;
    STRING string_key2[80];
    LONGINTEGER binary_key2;
    USER_RECORD far *p;
    IDX_RECORD  far *xp;

    res = (-1);
    if (! fcb->dram_status)
	return(res);
    p  = fcb->user_rec;
    xp = fcb->idx_rec;
    lock_dat(fcb,0L,fcb->dat_recsize);
    lock_idx(fcb,0L,sizeof(IDX_RECORD));
    datflen = filelength(fcb->dat_handle);
    idxflen = filelength(fcb->idx_handle);
    hash_max = ((INTEGER) (idxflen / ((LONGINTEGER) sizeof(IDX_RECORD)))) - 1;
    max_entryno = ((INTEGER)((((LONGINTEGER) hash_max) * 3L) / 4L));
    seekfile(fcb->idx_handle,0L,SEEK_SET);
    readfile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
    entryno = xp->hash_code;
    add_ptr = 0;
    hash_crc = crc_calc(fcb);
    start_hash();
    do {
	fcb->idxfpos = ((((LONGINTEGER) hash_value) + 1L) * ((LONGINTEGER) sizeof(IDX_RECORD)));
	seekfile(fcb->idx_handle,fcb->idxfpos,SEEK_SET);
	rdamt = readfile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
	if ((!(xp->hash_ptr)) || (rdamt < sizeof(IDX_RECORD)))
	    search = 0;
	else {
	    if (hash_crc != xp->hash_code) {
		if ((xp->hash_del_flg) && (! xp->hash_re_used) && (! add_ptr)) {
		    add_ptr = xp->hash_ptr;
		    add_idxfpos = fcb->idxfpos;
		}
	    }
	    else {
		fetch_dat_rec(fcb);
		old_rec = 0;
		if (!(fcb->dat_keytype)) {
		    strcpy((char *) string_key2,(char *) &dat_rec[(fcb->dat_keypos)]);
		    strupr((char *) string_key2);
		    if (! FARstrcmp((char far *) string_key2,(char far *) (fcb->string_key)))
			old_rec = 1;
		}
		else {
		    FARmemmove((char far *) &binary_key2,(char far *) &dat_rec[(fcb->dat_keypos)],4);
		    if (fcb->binary_key == binary_key2)
			old_rec = 1;
		}
		if (old_rec) {
		    if (xp->hash_del_flg) {
			add_ptr = xp->hash_ptr;
			add_idxfpos = fcb->idxfpos;
			goto Ait;
		    }
		    goto Aex;
		}
	    }
	    search = next_hash();
	}
    } while (search);
Ait:
    if (! add_ptr) {
	add_idxfpos = fcb->idxfpos;
	add_datfpos = 0L;
	if (! append)
	    add_datfpos = srch_del(fcb);
	if (add_datfpos == 0L) {
	    add_datfpos = datflen;
	    entryno++;
	}
    }
    else {
	add_datfpos = (((LONGINTEGER) add_ptr) * ((LONGINTEGER) fcb->dat_recsize));
    }
    fcb->datfpos = add_datfpos;
    seekfile(fcb->dat_handle,fcb->datfpos,SEEK_SET);
    if (!(fcb->dat_keytype)) {
	p->user_hash_code = hash_crc;
	writefile(fcb->dat_handle,(STRING far *) p,(fcb->dat_recsize));
	xp->hash_del_flg = p->user_deleted;
    }
    else {
	fcb->user_msg_rec->user_msg_hash_code = hash_crc;
	writefile(fcb->dat_handle,(STRING far *) (fcb->user_msg_rec),(fcb->dat_recsize));
	xp->hash_del_flg = fcb->user_msg_rec->user_msg_deleted;
    }
    xp->hash_re_used = 0;
    xp->hash_code = hash_crc;
    xp->hash_ptr = ((INTEGER) (fcb->datfpos / ((LONGINTEGER) fcb->dat_recsize)));
    fcb->idxfpos = add_idxfpos;
    seekfile(fcb->idx_handle,fcb->idxfpos,SEEK_SET);
    writefile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
    xp->hash_code = entryno;
    xp->hash_ptr = xp->hash_del_flg = xp->hash_re_used = 0;
    seekfile(fcb->idx_handle,0L,SEEK_SET);
    writefile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
    if (entryno > max_entryno)
	idx_expand(fcb);
    res = 0;
Aex:
    unlock_idx(fcb);
    unlock_dat(fcb);
    return(res);
}
#endif

/*****

	The function 'readfile()' reads data from the indicated file, using
	the file handle provided. This is a replacement for the library
	routine '_read()', with the exception of the fact that 'fbuf' is
	a 'far *'.  The routine does some attempts at error trapping and
	retries the read for a period of time to try and get all the
	requested information.

	   fd ..... a valid, open file handle.
	   fbuf ... a far pointer to a buffer area.
	   nbr .... the amount of data, in characters, to be read.

*****/
int readfile(int fd,STRING far *fbuf,int nbr)
{
   int accum, rdc, ramt, dc, loop;
   char rbuf[4112];

#ifdef DEBUG
   stack_probe();
#endif
   accum =
     loop = 0;
   ramt = 4096;
   while (accum < nbr) {
      if ((dc = nbr - accum) < ramt)
	 ramt = dc;
      if ((rdc = _read(fd,rbuf,ramt)) > 0) {
	  FARmemmove((char far *) &fbuf[accum],(char far *) rbuf,rdc);
	  accum += rdc;
	  continue;
      }
      if (rdc < 0) {
	  if ((++loop > 30) || (!lan_path[0]))
	      return(rdc);
	  delay(750);
	  continue;
      }
      break;
   }
   return(accum);
}

/*****

	The function 'writefile()' writes data to the indicated file, using
	the file handle provided. This is a replacement for the library
	routine '_write()', with the exception of the fact that 'fbuf' is
	a 'far *'.  The routine does some attempts at error trapping and
	retries the write for a period of time to try and record all the
	requested information.

	   fd ..... a valid, open file handle.
	   fbuf ... a far pointer to a buffer area.
	   nbr .... the amount of data, in characters, to be written.

*****/
int writefile(int fd,STRING far *fbuf,int nbr)
{
   int cp, wrdc;
   int wramt, dc, loop;
   char wrbuf[512];

   cp = loop = 0;
   wramt = 512;
   while (cp < nbr) {
      if ((dc = nbr - cp) < wramt)
	 wramt = dc;
      FARmemmove((char far *) wrbuf,(char far *) &fbuf[cp],wramt);
      wrdc = _write(fd,wrbuf,wramt);
      if (wrdc > 0) {
	  cp += wrdc;
	  continue;
      }
      if (wrdc < 0) {
	  if (++loop > 30)
	      return(wrdc);
	  delay(750);
	  continue;
      }
      break;
   }
   return(cp);
}

/*****

	The function 'seekfile()' is a direct replacement for the 'lseek()'
	library function.  The reason for its existence is to provide a
	common point to control various aspects of this function if trouble
	occur in a LAN environment.

*****/
int seekfile(int fh,LONGINTEGER offset,int oflag)
{
    int res;

    res = 0;
    if ((lseek(fh,offset,oflag)) < 0L)
	res = (-1);
    return(res);
}

void gen_locker(
    int hndl,
    LONGINTEGER offset,
    LONGINTEGER lgth,
    unsigned code
    )
{
    union REGS regs;
    int j;

    for (j = 0; j < 20; j++) {
	regs.x.ax = 0x5c00 | code;
	regs.x.bx = hndl;
	regs.x.cx = FP_SEG(offset);
	regs.x.dx = FP_OFF(offset);
	regs.x.si = FP_SEG(lgth);
	regs.x.di = FP_OFF(lgth);
/*****
	if (!code) {
	    wf_printf("\r\nDEBUG: AX = %04X  CX:DX = %04X:%04X  SI:DI = %04X:%04X",
		regs.x.ax,
		regs.x.cx,regs.x.dx,
		regs.x.si,regs.x.di);
	    WinDelay(5000);
	}
*****/
	intdos(&regs,&regs);
	if (!regs.x.cflag) {
/*****
	    if (!code)
		wf_puts("\r\nLock successful!");
*****/
	    return;
	}
	regs.x.ax = 0x5900;
	regs.x.bx = 0;
	intdos(&regs,&regs);
	if (regs.h.bl > 0x02)
	    return;
	sleep(1);
    }
}

void lock_g(
    int hndl,
    LONGINTEGER offset,
    LONGINTEGER lgth
    )
{
    gen_locker(hndl,offset,lgth,0);
}

void unlock_g(
    int hndl,
    LONGINTEGER offset,
    LONGINTEGER lgth
    )
{
    gen_locker(hndl,offset,lgth,1);
}

#ifdef HOST
/*****

	The function 'lock_dat()' applies a record lock to the CTL file
	indicated by the fcb.  This is a direct replacement for the library
	function 'lock()' and is implemented to provide a common point for
	the recording of open locks (which must be released prior to close
	of the file.

*****/
void lock_dat(
    DRAM far *fcb,
    LONGINTEGER offset,
    LONGINTEGER lgth
    )
{
    if (fcb->record_locking) {
	fcb->dat_lock_active = 1;
	fcb->dat_lock_offset = offset;
	fcb->dat_lock_lgth = lgth;
	lock_g(fcb->dat_handle,offset,lgth);
    }
}

/*****

	The function 'unlock_dat()' is the reverse for the above function.

*****/
void unlock_dat(DRAM far *fcb)
{
    if (fcb->dat_lock_active)
	unlock_g(fcb->dat_handle,fcb->dat_lock_offset,fcb->dat_lock_lgth);
    fcb->dat_lock_active = 0;
}

/*****

	The function 'lock_idx()' applies a record lock to the IDX file
	indicated by the fcb.  This is a direct replacement for the library
	function 'lock()' and is implemented to provide a common point for
	the recording of open locks (which must be released prior to close
	of the file.

*****/
void lock_idx(
    DRAM far *fcb,
    LONGINTEGER offset,
    LONGINTEGER lgth
    )
{
    if (fcb->record_locking) {
	fcb->idx_lock_active = 1;
	fcb->idx_lock_offset = offset;
	fcb->idx_lock_lgth = lgth;
	lock_g(fcb->idx_handle,offset,lgth);
    }
}

/*****

	The function 'unlock_idx()' is the reverse for the above function.

*****/
void unlock_idx(DRAM far *fcb)
{
    if (fcb->idx_lock_active)
	unlock_g(fcb->idx_handle,fcb->idx_lock_offset,fcb->idx_lock_lgth);
    fcb->idx_lock_active = 0;
}
#endif
