#include "define.h"
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <dos.h>
#include <sys\stat.h>
#include <errno.h>
#include "futil.h"

extern INTEGER hash_max;
extern INTEGER hash_crc;
extern INTEGER hash_value;
extern INTEGER delta_hash;
extern INTEGER hash_first;

extern INTEGER delta_calc(void);
extern INTEGER next_hash(void);

/*****

	The function 'prt_error()' is called when an error is returned
	by the I/O library.

	   fs ..... type of error, OPEN, CLOSE, etc.

	   ns ..... name of file causing error.

*****/
void prt_error(char *fs,char *ns)
{
    char work[82];

    strncpy(work,ns,78);
    work[78]=0;
#ifdef UTILITY
    printf(
#else
    wf_printf(
#endif
	"\r\n\nERROR: unable to %s: %s\r\n\n",fs,work
    );
    sleep(1);
}

/*****

	The function 'createfile()' is used to open files for creation.
	It handles some errors that might be encountered on LANs and
	returns a valid file handle or -1 on error.

	   name ..... the name of the file to be created.

*****/
int createfile(char *name)
{
    int loop, handle;

    handle = loop = -1;
    while (handle < 0) {
	if ((handle = _creat(name,0)) < 0) {
	    if ((++loop > 30) || (errno == ENOENT) || (errno == EMFILE)) {
		prt_error("create",name);
		return(-1);
	    }
	    sleep(1);
	}
    }
    return(handle);
}

/*****

       The function 'closefile()' is used to close files.  Error processing
       is done if the file cannot be closed.

	  handle ..... the file handle to be closed.

	  name ....... the name of the file to be closed.

*****/
int closefile(int handle,char *name)
{
    int res;

    if ((res = close(handle)) < 0)
	prt_error("close",name);
    return(res);
}

/*****

	The function 're_org()' is used to remove orphaned hash pointers
	from the IDX files.  Pointers in these files become orphaned as
	delete records in the CTL file are re-used.  Thus it is needed to
	re-organize the HASH TABLE from time-to-time (depends on how many
	deleted records you have accumulated).  The fcb must be open prior
	to entry.

*****/
#ifdef HOST
int re_org(DRAM far *fcb,int func)
{
    LONGINTEGER odxfpos, odxflen, ndxfpos;
    INTEGER j;
    int ndx_handle;
    char temp1[80], temp2[80];
    STRING odx_file[80];
    STRING ndx_file[80];
    IDX_RECORD ndx_rec;
    IDX_RECORD far *xp;

    lock_dat(fcb,0,fcb->dat_recsize);
    xp = fcb->idx_rec;
    dram_slasher(fcb);
    FARstrcpy((char far *)temp1,(char far *)fcb->dram_path);
    FARstrcpy((char far *)temp2,(char far *)fcb->dram_fname);
    sprintf(odx_file,"%s%s.IDX",temp1,temp2);
    sprintf(ndx_file,"%s%s.NDX",temp1,temp2);
    odxflen = filelength(fcb->idx_handle);
    hash_max = ((INTEGER) (odxflen / ((LONGINTEGER) sizeof(IDX_RECORD)))) - 1;
    ndx_handle = createfile(ndx_file);
    FARmemset((char far *) xp,0,sizeof(IDX_RECORD));
    for (j = 0; j <= hash_max; j++)
	writefile(ndx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
    closefile(ndx_handle,ndx_file);
    ndx_handle = _open(ndx_file,o_mode(O_RDWR));
    seekfile(fcb->idx_handle,0L,SEEK_SET);
    readfile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
    seekfile(ndx_handle,0L,SEEK_SET);
    writefile(ndx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
    for (j = 1; j <= hash_max; j++) {
	odxfpos = (((LONGINTEGER) j) * ((LONGINTEGER) sizeof(IDX_RECORD)));
	seekfile(fcb->idx_handle,odxfpos,SEEK_SET);
	readfile(fcb->idx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
	if (! xp->hash_re_used) {
	    hash_crc = xp->hash_code;
	    hash_value = hash_crc % hash_max;
	    ndxfpos = ((((LONGINTEGER) hash_value) + 1L) * ((LONGINTEGER) sizeof(IDX_RECORD)));
	    seekfile(ndx_handle,ndxfpos,SEEK_SET);
	    readfile(ndx_handle,(STRING far *) &ndx_rec,sizeof(IDX_RECORD));
	    if (ndx_rec.hash_ptr) {
		delta_hash = delta_calc();
		hash_first = hash_value;
		do {
		    next_hash();
		    ndxfpos = ((((LONGINTEGER) hash_value) + 1L) * ((LONGINTEGER) sizeof(IDX_RECORD)));
		    seekfile(ndx_handle,ndxfpos,SEEK_SET);
		    readfile(ndx_handle,(STRING far *) &ndx_rec,sizeof(IDX_RECORD));
		} while ((ndx_rec.hash_ptr) && (ndxfpos != hash_first));
	    }
	    seekfile(ndx_handle,ndxfpos,SEEK_SET);
	    writefile(ndx_handle,(STRING far *) xp,sizeof(IDX_RECORD));
	}
    }
    close(ndx_handle);
    close(fcb->idx_handle);
    backup_idx(fcb);
    fcb->idx_handle = _open(odx_file,o_mode(O_RDWR));
    unlock_dat(fcb);
    return(0);
}
#endif
