#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <dir.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <math.h>
#include "dram.h"
#include "futil.h"

#define TRUE 1
#define FALSE 0

extern void up_gets(char *);
extern int strip_nl(STRING *,int);
extern int chg_dir(STRING *);
extern STRING *date(void);
extern STRING *gttime(void);
extern INTEGER daynumber(char *);

extern STRING gtpath[80];
extern STRING lan_path[80];
extern STRING bbs_path[80];

int fgets_p(STRING *s,int imax,FILE *f)
{
    char *p;

    p = fgets(s,(imax - 3),f);
    if ((p==NULL)||(s[0]==0x1a)) {
        s[0]=0;
        return(-1);
    }
    return((strip_nl(s,imax)));
}

long filesize(FILE *fptr)
{
    long length;

    fseek(fptr,0L,SEEK_END);
    length = ftell(fptr);
    fseek(fptr,0L,SEEK_SET);
    return(length);
}

void prt_line(void)
{
    printf("\n");
}

void make_a_msg_sticky(STRING *msg_path)
{
    STRING curr_directory[80];
    STRING home_directory[80];
    STRING wrks[80], inps[80];
    unsigned sticky_bit, hold_flags;
    int msg_control_file, highest, lowest;
    struct msg_record msg_control_rec;
    int msgnum;
    long mloc, flen;

    getcwd(home_directory,79);
    strcpy(curr_directory,msg_path);
    strupr(curr_directory);
    if (chg_dir(curr_directory)) {
	printf("\nCannot access %s",curr_directory);
	sleep(1);
	return;
    }
    if ((msg_control_file = _open("MESSAGE.CTL",O_RDWR)) < 0) {
	printf("\nCannot find %s%s",curr_directory,"MESSAGE.CTL");
	sleep(1);
	goto Stkx;
    }
    clrscr();
    printf("Toggle message sticky bit in %s\n",curr_directory);
    flen = filelength(msg_control_file) - 128L;
    _read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
    lowest = msg_control_rec.msg_number;
    highest = (int) (flen / ((long) sizeof(struct msg_record)));
    highest += lowest;
    printf("\nAvailable messages are: %d - %d\n",(lowest + 1),highest);
    do {
        printf("\nEnter message number to toggle : ");
        gets(wrks);
        if (wrks[0]) {
	    msgnum = atoi(wrks);
	    if ((msgnum <= lowest)||(msgnum > highest)) {
		printf("\nThat message number is out of range.  Try again.\n");
	    }
	    else {
		mloc = ((long) (msgnum - lowest)) * ((long) sizeof(struct msg_record));
		lseek(msg_control_file,mloc,SEEK_SET);
		_read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
		printf("\nMessage #%d",msgnum);
		if (msg_control_rec.msg_flags & 0x0001)
		    printf("  (STICKY)");
		if (msg_control_rec.msg_deleted)
		    printf("  (DELETED)");
		printf("\nFrom  : %s",msg_control_rec.msg_sender);
		printf("\nTo    : %s",msg_control_rec.msg_addressee);
		printf("\nTopic : %s",msg_control_rec.msg_topic);
		printf("\nDate  : %s",msg_control_rec.msg_date);
		printf("\nTime  : %s",msg_control_rec.msg_time);
                printf("\n\nIs this the correct message? [Y/n]  ");
		up_gets(inps);
		if (inps[0] != 'N') {
		    hold_flags = msg_control_rec.msg_flags;
		    sticky_bit = (hold_flags & 0x0001) ^ 0x0001;
		    hold_flags = (hold_flags & 0x00FE);
		    hold_flags = (hold_flags | sticky_bit);
		    msg_control_rec.msg_flags = hold_flags;
		    lseek(msg_control_file,mloc,SEEK_SET);
		    _write(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
	 	    if (sticky_bit)
		        printf("\nMessage number %d is now sticky.\n",msgnum);
		    else
		        printf("\nMessage number %d is no longer sticky.\n",msgnum);
		}
	    }
	}
    } while (wrks[0]);
    _close(msg_control_file);
Stkx:
    chg_dir(home_directory);
}

static int delete_stack[10];
static int delete_stack_ptr = 0;

void delete_msg(char *,int,int);

void cleanup_delete_stack(char *msg_path)
{
    char fname[82];
    unsigned base, j;

    if (delete_stack_ptr < 10) {
	for (j=0; j<delete_stack_ptr; j++) 
	    delete_msg(msg_path,delete_stack[j],0);
	goto CleanEx;
    }
    base = ((delete_stack[0] - 1) / 10) + 1;
    sprintf(fname,"%sGTMSGS\\%05u.MES",msg_path,base);
    unlink(fname);
CleanEx:
    delete_stack_ptr = 0;
}

void delete_msg(char *msg_path,int m_number,int stack_them)
{
    unsigned k, csub;
    FILE *t_handle;
    FILE *msg_handle;
    char tname[82];
    char fname[82];
    char text[262];
    void *buffer1;
    void *buffer2;
    int not_new_file, not_end_of_file, ramt;
    unsigned base, sub, line;

    k = (m_number - 1);
    base = (k / 10) + 1;
    sub = k % 10;
    if (stack_them) {
	if (sub) {
	    if (! delete_stack_ptr)
		goto ContDel;
	    if (sub != delete_stack_ptr) {
		cleanup_delete_stack(msg_path);
		goto ContDel;
	    }
	    goto Stacker;
	}
	if (delete_stack_ptr) 
	    cleanup_delete_stack(msg_path);
Stacker:
	delete_stack[delete_stack_ptr++] = m_number;
	goto Finish;
    }
ContDel:
    buffer1 = malloc(8208);
    buffer2 = malloc(8208);
    sprintf(fname,"%sGTMSGS\\%05u.MES",msg_path,base);
    sprintf(tname,"%sGTMSGS\\%05u.$$$",msg_path,base);
    not_new_file = 1;
    if ((msg_handle = fopen(fname,"rt")) == NULL)
	not_new_file = 0;
    else
	setvbuf(msg_handle,buffer1,_IOFBF,8192);
    if ((t_handle = fopen(tname,"wt")) == NULL) {
	not_new_file = 0;
	if (msg_handle != NULL) {
	    fclose(msg_handle);
	    msg_handle = NULL;
	}
    }
    else
	setvbuf(t_handle,buffer2,_IOFBF,8192);
    line = 0;
    if (not_new_file) {
	csub = 0;
	not_end_of_file = 1;
        do {
	    if ((ramt = fgets_p(text,260,msg_handle)) < 0)
                not_end_of_file = text[0] = 0;
	    if (ramt > 0) {
                if ((ramt==5)&&(text[0]==24)&&(text[1]=='S')&&(text[2]=='O')&&(text[3]=='M')) {
		    if ((csub = text[4] - 48) > sub)
			not_end_of_file = 0;
	        }
	    }
            if ((not_end_of_file) && (csub < sub)) {
                fprintf(t_handle,"%s\n",text);
		line++;
	    }
        } while (not_end_of_file);
    }
    if (msg_handle != NULL) {
	not_end_of_file = 1;
	if (text[0]==24) {
	    fprintf(t_handle,"%s\n",text);
	    line++;
	}
	do {
	    if ((fgets_p(text,260,msg_handle)) < 0)
                not_end_of_file = 0;
	    else {
                fprintf(t_handle,"%s\n",text);
		line++;
	    }
	} while (not_end_of_file);
	fclose(msg_handle);
        unlink(fname);
    }
    fclose(t_handle);
    if (line)
        rename(tname,fname);
    else
	unlink(tname);
    free(buffer1);
    free(buffer2);
Finish:
    return;
}

void delete_messages(STRING *msg_path)
{
#define MAX_STICKY 1024
    int dont_delete_recvd, som_ptr, som_size;
    STRING name[80];
    STRING curr_directory[80];
    STRING home_directory[80];
    STRING wrks[262];
    STRING inps[80];
    long mloc, flen, fast_offset, m_offset, woffset, fpos;
    STRING sticky_name[80];
    FILE *in_fileh;
    FILE *out_fileh;
    char buffer1[4100], buffer2[4100];
    int sticky_cnt, spt, sticky_base, prior_sticky_base, sticky_sub;
    int new_base, new_sub, fast_base, csub;
    int eof_char1, eof_char2;
    int sticky_num[MAX_STICKY];
    int msg_control_file;
    char msg_recvd;
    int temp_msg_control_file;
    int new_low, old_low, high_msg;
    int first_delete, last_delete;
    int first_file, last_file, old_file, not_end_of_file;
    int curr_msg, new_msg_num, old_msg_num;
    STRING backspaces[80];
    int delnum, j, ramt, msgnum, k, slen;
    INTEGER curr_daynumber;
    int day_override, msg_age;
    struct msg_record msg_control_rec;
    STRING rbuf[8200];

    delete_stack_ptr = 0;
    getcwd(home_directory,79);
    strcpy(curr_directory,msg_path);
    strupr(curr_directory);
    curr_daynumber = daynumber(date());
    if (chg_dir(curr_directory)) {
	printf("\nCannot access %s",curr_directory);
	prt_line();
	sleep(1);
	return;
    }
    if ((msg_control_file = _open("MESSAGE.CTL",O_RDWR)) < 0) {
	printf("\nCannot find %s%s",curr_directory,"MESSAGE.CTL");
	sleep(1);
	goto Delx;
    }
    flen = filelength(msg_control_file) - 128L;
    if (!(msgnum = (int) (flen / ((long) sizeof(struct msg_record))))) {
	printf("\nNo messages in found in %s",curr_directory);
	goto Delx2;
    }
    printf("\nThere are %d messages in %s\n",msgnum,curr_directory);
    dont_delete_recvd = 1;
    printf("\nDo you want to delete RECV'D messages? [y/N]  ");
    up_gets(wrks);
    if (wrks[0] == 'Y')
	dont_delete_recvd = 0;
Get1:
    printf("\nHow many days do you want to keep messages?   ");
    day_override = 32767;
    wrks[0] = 0;
    gets(wrks);
    if (wrks[0]) {
	if ((day_override = atoi(wrks)) < 14) {
	    strcpy(inps,"days");
	    if (day_override == 1)
		strcpy(inps,"day");
	    printf("\nAre you sure?  Keep only %d %s? [y/N]  ",day_override,inps);
	    up_gets(wrks);
	    if (wrks[0] != 'Y')
	        goto Get1;
	}
    }
    printf("\nHow many total messages do you want to keep?  ");
    wrks[0] = 0;
    gets(wrks);
    if (! wrks[0]) {
	if ((! dont_delete_recvd) || (day_override < 10000))
	    strcpy(wrks,"32767");
    }
    if (! wrks[0]) {
Delx2:
	_close(msg_control_file);
	goto Delx;
    }
    delnum = atoi(wrks);
    delnum = msgnum - delnum;
    delnum = (delnum / 10) * 10;
    ramt = _read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
    old_low = msg_control_rec.msg_number;
    if ((day_override > 10000) && (dont_delete_recvd))
	goto Sage;
    printf("\nSearching for out-of-date");
    if (dont_delete_recvd)
	printf(" messages.\n");
    else {
	printf(" and/or RECV'D messages.\n");
	printf("\nThe '*' indicates a RECV'D message.\n");
    }
    fpos = (long) sizeof(struct msg_record);
    do {
	if ((ramt = _read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record))) > 0) {
	    msg_recvd = ' ';
	    if (! msg_control_rec.msg_deleted) {
		if (msg_control_rec.msg_flags & 0x0001)
		    goto SkipSticky;
		if (msg_control_rec.msg_received & 0x0f)
		    msg_recvd = '*';
		strcpy(inps,msg_control_rec.msg_date);
		msg_age = (int)(curr_daynumber - daynumber(inps));
		if (msg_age > day_override) {
Thekill:
		    msg_control_rec.msg_deleted = 1;
		    lseek(msg_control_file,fpos,SEEK_SET);
		    _write(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
		    delete_msg(curr_directory,msg_control_rec.msg_number,1);
		    msg_control_rec.msg_sender[23]=0;
		    printf("\nDEL%5d  %s  %c%-23s  %-s",
			msg_control_rec.msg_number,
			msg_control_rec.msg_date,
			msg_recvd,
			msg_control_rec.msg_sender,
			msg_control_rec.msg_topic);
		    msg_recvd = ' ';
		}
	    }
	    if (msg_recvd == '*') {
		if (! dont_delete_recvd) 
		    goto Thekill;
	    }
	}
SkipSticky:
	fpos += ((long) sizeof(struct msg_record));
    } while (fpos <= flen);
    if (delete_stack_ptr)
	cleanup_delete_stack(curr_directory);
    printf("\n");
Sage:
    high_msg = old_low + msgnum;
    new_low = old_low + delnum;
    new_low = (new_low / 10) * 10;
    delnum = new_low - old_low;
    first_delete = old_low + 1;
    last_delete = old_low + delnum;
    printf("\nCurrent low message number: %d\n",first_delete);
    if (delnum > 0)
        printf("The new low message number: %d\n",(last_delete + 1));
    printf("The highest message number: %d\n",high_msg);
    if (delnum > 0) {
        printf("\nThe number of messages deleted will be: %d\n",delnum);
        printf("\nAre you sure you want to delete these messages? [y/N]  ");
	up_gets(wrks);
    }
    else {
	printf("\nNo messages need to be deleted!");
	goto Delexit;
    }
    if (wrks[0] != 'Y') {
Delexit:
        _close(msg_control_file);
        goto Delx;
    }
    if ((temp_msg_control_file = _creat("MESSAGE.$$$",0)) < 0) {
	printf("\nERROR: cannot create %s%s",curr_directory,"MESSAGE.$$$");
	sleep(7);
	goto Delexit;
    }
/*** start sticky processing ***/
    curr_msg = first_delete;
    sticky_cnt = 0;
    lseek(msg_control_file,((long) sizeof(struct msg_record)),SEEK_SET);
    printf("\nSearching for sticky messages.");
    do {
	_read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
	if (!msg_control_rec.msg_deleted)
	    if (msg_control_rec.msg_flags & 0x0001)
	        sticky_num[sticky_cnt++] = curr_msg;
    } while ((++curr_msg < last_delete)&&(sticky_cnt < MAX_STICKY));
    lseek(msg_control_file,0L,SEEK_SET);
    ramt = _read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
    if ((new_low -= sticky_cnt) < 0) {
	_close(temp_msg_control_file);
	unlink("MESSAGE.$$$");
	goto Delexit;
    }
    msg_control_rec.msg_number = new_low;
    ramt = _write(temp_msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
    if (! sticky_cnt) {
	printf("   No sticky messages found!\n");
    }
    else {
	printf("\nMoving sticky messages to a safe place.");
	prior_sticky_base = 0;
        for (spt=0; spt < sticky_cnt; spt++) {
	    mloc = (((long) (sticky_num[spt] - old_low)) * ((long) sizeof(struct msg_record)));
	    lseek(msg_control_file,mloc,SEEK_SET);
	    _read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
            msg_control_rec.msg_number = new_low + spt + 1;
	    _write(temp_msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
	    if ((sticky_base=(((sticky_num[spt]-1)/10)+1))!=prior_sticky_base){
                prior_sticky_base = sticky_base;
	        sprintf(wrks,"%sGTMSGS\\%05d.MES",curr_directory,sticky_base);
		sprintf(sticky_name,"%sGTMSGS\\%05d.STK",curr_directory,sticky_base);
		rename(wrks,sticky_name);
		printf("\n    Renaming  %05d.MES -> %05d.STK",sticky_base,sticky_base);
	    }
        }
    }
/*** end sticky processing ***/
    mloc = (((long) (last_delete + 1 - old_low)) * ((long) sizeof(struct msg_record)));
    lseek(msg_control_file,mloc,SEEK_SET);
    do {
	if ((ramt = _read(msg_control_file,rbuf,8192)) > 0)
            _write(temp_msg_control_file,rbuf,ramt);
    } while (ramt > 0);
    j = (first_delete - 1);
    first_file = (j / 10) + 1;
    j = (last_delete - 1);
    last_file = (j / 10) + 1;
    printf("\nFiles to be deleted are: %05d.MES - %05d.MES\n",first_file,last_file);
    _close(temp_msg_control_file);
    _close(msg_control_file);
    last_file++;
    sprintf(name,"%sGTMSGS\\00000.MES",curr_directory);
    printf("\nDELETE: %s",name);
    slen = strlen(name);
    for (k=0; k < slen; k++)
	backspaces[k] = '\x08';
    backspaces[slen] = 0;
    for (j=first_file; j < last_file; j++) {
	sprintf(name,"%sGTMSGS\\%05d.MES",curr_directory,j);
	printf("%s%s",backspaces,name);
	unlink(name);
    }
    if (sticky_cnt) {
	printf("\nRestoring sticky messages.");
	fast_offset = fast_base = 0;
        for (spt=0; spt < sticky_cnt; spt++) {
	    old_msg_num = sticky_num[spt];
	    k = old_msg_num - 1;
	    sticky_base = (k / 10) + 1;
	    sticky_sub  = (k % 10);
            new_msg_num = new_low + spt + 1;
	    k = new_msg_num - 1;
	    new_base = (k / 10) + 1;
	    new_sub  = (k % 10);
	    sprintf(wrks,"%sGTMSGS\\%05d.MES",curr_directory,new_base);
	    sprintf(sticky_name,"%sGTMSGS\\%05d.STK",curr_directory,sticky_base);
	    printf("\n    Copying message  %05d -> %05d",old_msg_num,new_msg_num);
	    if ((in_fileh = fopen(sticky_name,"rt")) == NULL) {
	        printf("\nERROR: cannot open %s",wrks);
	        sleep(7);
	        goto Delx;
	    }
	    if ((sticky_base == fast_base) && (fast_offset > 0))
                fseek(in_fileh,fast_offset,SEEK_SET);
            old_file = 1;
	    if ((out_fileh = fopen(wrks,"r+t")) == NULL) {
		old_file = 0;
		if ((out_fileh = fopen(wrks,"wt")) == NULL) {
		    printf("\nERROR: cannot create %s",wrks);
		    fclose(in_fileh);
		    sleep(7);
		    goto Delx;
	        }
            }
	    setvbuf(in_fileh,buffer1,_IOFBF,4096);
            setvbuf(out_fileh,buffer2,_IOFBF,4096);
            if (old_file) {
	        if ((m_offset = filesize(out_fileh) - 2L) > 0L) {
                    fseek(out_fileh,m_offset,SEEK_SET);
                    eof_char1 = fgetc(out_fileh);
		    eof_char2 = fgetc(out_fileh);
		    m_offset += 2;
		    if ((eof_char2 == 26)||(eof_char2 == EOF))
			m_offset--;
		    fseek(out_fileh,m_offset,SEEK_SET);
		    if ((eof_char1 != 10) && (eof_char1 != 13)) {
                        if ((eof_char2 != 10) && (eof_char2 != 13)) {
			    fprintf(out_fileh,"\n");
	                }
                    }
	        }
            }
	    fprintf(out_fileh,"\x18SOM%u\n",new_sub);
	    csub = 0xFFFF;
	    not_end_of_file = 1;
            do {
	        if ((ramt = fgets_p(wrks,260,in_fileh)) < 0)
                    not_end_of_file = wrks[0] = 0;
	        if (ramt > 0) {
                    som_ptr = 4;
                    som_size = 8;
                    if (csub == (-1)) {
		        if ((ramt==4)&&(wrks[0]=='S')&&(wrks[1]=='O')&&(wrks[2]=='M')&&(wrks[3]>='0')&&(wrks[3]<='9')) {
                            som_ptr = 3;
                            som_size = 7;
                            goto ProcessSOM;
                        }
                    }
                    if ((ramt==5)&&(wrks[0]==24)&&(wrks[1]=='S')&&(wrks[2]=='O')&&(wrks[3]=='M')) {
ProcessSOM:
			if ((woffset = ftell(in_fileh) - som_size) > 0) {
		            fast_base = sticky_base;
		            fast_offset = woffset;
		        }
		        if ((csub = wrks[som_ptr] - 48) > sticky_sub)
			    not_end_of_file = 0;
		        goto Denl;
	            }
	        }
                if ((not_end_of_file) && (csub == sticky_sub))
		    fprintf(out_fileh,"%s\n",wrks);
Denl:           ;
            } while (not_end_of_file);
	    fclose(out_fileh);
	    fclose(in_fileh);
        }
	for (spt=0; spt < sticky_cnt; spt++) {
	    sticky_base = (((sticky_num[spt]-1)/10)+1);
	    sprintf(wrks,"%sGTMSGS\\%05d.STK",curr_directory,sticky_base);
	    unlink(wrks);
	}
    }
    printf("\n");
    unlink("MESSAGE.BAK");
    rename("MESSAGE.CTL","MESSAGE.BAK");
    rename("MESSAGE.$$$","MESSAGE.CTL");
    unlink("MESSAGE.BAK");
Delx:
    chg_dir(home_directory);
    prt_line();
}

int cvt_number(
		 int prior,
		 int cross_base,
		 int renum_base,
		 int highest_old,
		 int highest_new,
		 int cross_num[],
		 int backtrack
	      )
{
    int new_msg_num, k;

    new_msg_num = 0;
    if (prior < cross_base) {
	if (backtrack)
	    new_msg_num = renum_base - 1;
	return(new_msg_num);
    }
    if (prior > highest_old) {
	if (backtrack)
	    new_msg_num = highest_new;
	return(new_msg_num);
    }
    k = prior - cross_base;
    new_msg_num = cross_num[k];
    if (backtrack) {
	while ((k>0)&&(new_msg_num<0))
	    new_msg_num = cross_num[--k];
    }
    if ((new_msg_num<renum_base)||(new_msg_num>highest_new))
	new_msg_num = 0;
    return(new_msg_num);
}

void renumber_messages(STRING *msg_path)
{
#define RENUM_MAX_MSGS 4096
#define MAX_USER_MSG 128
#define MAX_MSG_CTL 32
    STRING curr_directory[82];
    STRING home_directory[82];
    STRING wrks[262];
    int msg_control_file, ramt, j, k, highest_old, highest_new;
    int temp_msg_control_file, prior, i, m, jnum;
    USER_MSG_RECORD uma[MAX_USER_MSG];
    struct msg_record in_mcr[MAX_MSG_CTL];
    struct msg_record out_mcr[MAX_MSG_CTL];
    int mcr_amt, mcr_cnt, mcr_ptr, out_mcr_cnt, out_mcr_amt;
    char buffer1[8200], buffer2[8200];
    char backspaces[82];
    int old_file, not_end_of_file;
    struct msg_record msg_control_rec;
    int msg_cnt, old_num[RENUM_MAX_MSGS], renum_base, no_find;
    int cross_num[RENUM_MAX_MSGS], cross_base, do_msg_move;
    int old_msg_num, new_msg_num;
    FILE *old_msg_file;
    int old_base, old_sub;
    FILE *new_msg_file;
    int new_base, new_sub, csub;
    long m_offset, fpos;
    int eof_char1, eof_char2;
    int uma_cnt, user_msg_file, uma_amt, temp_user_msg_file;
    long fast_offset, woffset;
    int fast_base, found_delete;

    fast_offset = fast_base = found_delete = 0;
    renum_base = 1;
    getcwd(home_directory,79);
    strcpy(curr_directory,msg_path);
    strupr(curr_directory);
    if (chg_dir(curr_directory)) {
	printf("\nCannot access %s",curr_directory);
	prt_line();
	sleep(1);
	return;
    }
    if ((msg_control_file = _open("MESSAGE.CTL",O_RDWR)) < 0) {
	printf("\nCannot find %s%s",curr_directory,"MESSAGE.CTL");
	prt_line();
	sleep(1);
	goto Renx;
    }
    ramt = _read(msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
    if ((temp_msg_control_file = _creat("MESSAGE.$$$",0)) < 0) {
	printf("\nERROR: cannot create %s%s",curr_directory,"MESSAGE.$$$");
	sleep(7);
	_close(msg_control_file);
	goto Renx;
    }
    cross_base = (msg_control_rec.msg_number + 1);
    mcr_amt = (sizeof(struct msg_record) * MAX_MSG_CTL);
/****************************************************************************/
    no_find = 1;
    do {
	if ((ramt = _read(msg_control_file,(char*) &in_mcr,mcr_amt)) > 0) {
	    mcr_cnt = (ramt / sizeof(struct msg_record));
	    for (mcr_ptr = 0; mcr_ptr < mcr_cnt; mcr_ptr++) {
		if (! in_mcr[mcr_ptr].msg_deleted) {
		    cross_base = in_mcr[mcr_ptr].msg_number;
		    no_find = 0;
		    break;
		}
	    }
	}
    } while ((ramt > 0) && (no_find));
    if (no_find) {
	_close(msg_control_file);
	goto NoRenum;
    }
    fpos = ((long) sizeof(struct msg_record));
    lseek(msg_control_file,fpos,SEEK_SET);
    printf(  "\nThe current low message number in %s: %d",curr_directory,cross_base);
    printf("\n\nEnter the the desired low message number: ");
    gets(wrks);
    if (wrks[0]) {
	renum_base = atoi(wrks);
	if ((renum_base < 1)||(renum_base > 32000))
	    renum_base = 1;
    }
/****************************************************************************/
    printf("\nRenumbering %s",curr_directory);
    msg_cnt = -1;
    msg_control_rec.msg_number = (renum_base - 1);
    ramt = _write(temp_msg_control_file,(char*) &msg_control_rec,sizeof(struct msg_record));
    for (j=0; j < RENUM_MAX_MSGS; j++)
	cross_num[j] = -1;
    do_msg_move = 
     highest_new =
      highest_old = 0;
    do {
	if ((ramt = _read(msg_control_file,(char*) &in_mcr,mcr_amt)) > 0) {
	    mcr_cnt = (ramt / sizeof(struct msg_record));
	    out_mcr_cnt = 0;
	    for (mcr_ptr = 0; mcr_ptr < mcr_cnt; mcr_ptr++) {
		jnum = in_mcr[mcr_ptr].msg_number;
		if (in_mcr[mcr_ptr].msg_deleted) {
		    found_delete = 1;
		    if (jnum > cross_base)
			do_msg_move = 1;
		}
		else {
		    if (++msg_cnt >= RENUM_MAX_MSGS) {
		        printf("\nERROR: too many messages to renumber, %d maximum.",RENUM_MAX_MSGS);
		        printf("\n       Delete some messages, then retry renumbering.");
		        sleep(7);
		        _close(temp_msg_control_file);
		        _close(msg_control_file);
		        goto Renx;
		    }
		    j = jnum - cross_base;
		    highest_old =
		     old_num[msg_cnt] = jnum;
		    highest_new =
		     cross_num[j] =
		      in_mcr[mcr_ptr].msg_number = (renum_base + msg_cnt);
                    out_mcr[out_mcr_cnt++] = in_mcr[mcr_ptr];
	        }
	    }
	    if ((out_mcr_amt = (out_mcr_cnt * sizeof(struct msg_record))) > 0)
                _write(temp_msg_control_file,(char *) &out_mcr,out_mcr_amt);
	}
    } while (ramt > 0);
    _close(temp_msg_control_file);
    _close(msg_control_file);
    printf("\n");
    if (! found_delete) {
	if (cross_base == renum_base) {
NoRenum:
	    unlink("MESSAGE.$$$");
	    printf("\nThe %s msg base does not need to be renumbered!",curr_directory);
	    sleep(1);
	    goto Renx;
	}
    }
    if ((! do_msg_move) && (cross_base == renum_base))
	goto InstallMessage;
    printf("Renumbering message  ");
    strcpy(wrks,"00000 of 00000 -> 00000");
    k = strlen(wrks);
    for (j=0; j < k; j++)
	backspaces[j] = '\x08';
    printf(wrks);
    backspaces[k] = 0;
    for (j=0; j <= msg_cnt; j++) {
	old_msg_num = old_num[j];
	new_msg_num = renum_base + j;
        k = (old_msg_num - 1);
        old_base = (k / 10) + 1;
        old_sub = k % 10;
	k = (new_msg_num - 1);
	new_base = (k / 10) + 1;
	new_sub = k % 10;
	printf(backspaces);
	printf("%05d of %05d -> %05d",old_msg_num,highest_old,new_msg_num);
	sprintf(wrks,"%sGTMSGS\\%05u.MES",curr_directory,old_base);
	if ((old_msg_file = fopen(wrks,"rt")) == NULL) {
	    printf("\nERROR: cannot open %s",wrks);
	    sleep(7);
	    goto Renx;
	}
	if ((old_base == fast_base) && (fast_offset > 0))
            fseek(old_msg_file,fast_offset,SEEK_SET);
        sprintf(wrks,"%sGTMSGS\\%05u.NEW",curr_directory,new_base);
        old_file = 1;
	if ((new_msg_file = fopen(wrks,"r+b")) == NULL) {
	    old_file = 0;
	    if ((new_msg_file = fopen(wrks,"wb")) == NULL) {
		printf("\nERROR: cannot create %s",wrks);
		fclose(old_msg_file);
		sleep(7);
		goto Renx;
	    }
        }
	setvbuf(old_msg_file,buffer1,_IOFBF,8192);
        setvbuf(new_msg_file,buffer2,_IOFBF,8192);
        if (old_file) {
	    if ((m_offset = filesize(new_msg_file) - 2L) > 0L) {
                fseek(new_msg_file,m_offset,SEEK_SET);
                eof_char1 = fgetc(new_msg_file);
		eof_char2 = fgetc(new_msg_file);
		m_offset += 2;
		if ((eof_char2 == 26)||(eof_char2 == EOF))
		    m_offset--;
		fseek(new_msg_file,m_offset,SEEK_SET);
		if ((eof_char1 != 10) && (eof_char1 != 13)) {
		    if ((eof_char2 != 10) && (eof_char2 != 13)) {
			fprintf(new_msg_file,"\r\n");
		    }
		}
	    }
        }
	fprintf(new_msg_file,"\x18SOM%u\r\n",new_sub);
	csub = 0xFFFF;
	not_end_of_file = 1;
        do {
	    if ((ramt = fgets_p(wrks,260,old_msg_file)) < 0)
                not_end_of_file = wrks[0] = 0;
	    if (ramt > 0) {
                if ((ramt==5)&&(wrks[0]==24)&&(wrks[1]=='S')&&(wrks[2]=='O')&&(wrks[3]=='M')) {
		    if ((woffset = ftell(old_msg_file) - 8) > 0) {
		        fast_base = old_base;
		        fast_offset = woffset;
		    }
		    if ((csub = wrks[4] - 48) > old_sub)
			not_end_of_file = 0;
		    goto Renl;
	        }
	    }
            if ((not_end_of_file) && (csub == old_sub))
		fprintf(new_msg_file,"%s\r\n",wrks);
Renl:       ;
        } while (not_end_of_file);
	fclose(new_msg_file);
	fclose(old_msg_file);
    }
    printf("\nRenumbering the USER_MSG.CTL file");
    if ((user_msg_file = _open("USER_MSG.CTL",O_RDWR)) < 0) {
	printf("\nCannot find %s%s",curr_directory,"USER_MSG.CTL");
	sleep(1);
	goto Renx2;
    }
    if ((temp_user_msg_file = _creat("USER_MSG.$$$",0)) < 0) {
	printf("\nERROR: cannot create %s%s",curr_directory,"USER_MSG.$$$");
	sleep(7);
	_close(user_msg_file);
	goto Renx2;
    }
    ramt = _read(user_msg_file,(char*) &msg_control_rec,sizeof(USER_MSG_RECORD));
    _write(temp_user_msg_file,(char*) &msg_control_rec,ramt);
    uma_amt = sizeof(USER_MSG_RECORD) * MAX_USER_MSG;
    do {
	if ((ramt = _read(user_msg_file,(char*) &uma,uma_amt)) > 0) {
	    uma_cnt = (ramt / sizeof(USER_MSG_RECORD));
            for (j=0; j < uma_cnt; j++) {
		if (!(uma[j].user_msg_deleted)) {
		/****/
		    uma[j].user_msg_prior_read = cvt_number(  
					    uma[j].user_msg_prior_read,
					    cross_base,
					    renum_base,
					    highest_old,
					    highest_new,
					    cross_num,
					    TRUE
						);
		/****/
		    uma[j].user_msg_highest_scan = cvt_number(  
					    uma[j].user_msg_highest_scan,
					    cross_base,
					    renum_base,
					    highest_old,
					    highest_new,
					    cross_num,
					    TRUE
						);
		/****/
		    for (i=0; i<2; i++) {
			uma[j].user_msg_marked[i] = cvt_number(  
					    uma[j].user_msg_marked[i],
					    cross_base,
					    renum_base,
					    highest_old,
					    highest_new,
					    cross_num,
					    FALSE
						);
		    }
		/****/
		}
	    }
	    _write(temp_user_msg_file,(char*) &uma,ramt);
	}
    } while (ramt > 0);
    _close(user_msg_file);
    _close(temp_user_msg_file);
    if ((msg_control_file = _open("MESSAGE.$$$",O_RDWR)) < 0) {
	printf("\nERROR: cannot find %s%s",curr_directory,"MESSAGE.$$$");
	sleep(1);
	goto Renx;
    }
    fpos = ((long) sizeof(struct msg_record));
    lseek(msg_control_file,fpos,SEEK_SET);
    printf("\nRenumbering the reply numbers.");
    do {
	if ((ramt = _read(msg_control_file,(char*) &in_mcr,mcr_amt)) > 0) {
	    mcr_cnt = (ramt / sizeof(struct msg_record));
	    for (j=0; j<mcr_cnt; j++) {
	        m = 0;
		for (i=0; i<3; i++) {
 	            prior = in_mcr[j].msg_reply_no[i];
		    in_mcr[j].msg_reply_no[i] = 0;
		    if (prior) {
			new_msg_num =  cvt_number(  
					   prior,
					   cross_base,
					   renum_base,
					   highest_old,
					   highest_new,
					   cross_num,
					   FALSE
						 );
			if (new_msg_num)
			    in_mcr[j].msg_reply_no[m++] = new_msg_num;
		    }
		}
		in_mcr[j].msg_orig_no = cvt_number(  
					    in_mcr[j].msg_orig_no,
					    cross_base,
					    renum_base,
					    highest_old,
					    highest_new,
					    cross_num,
					    FALSE
						 );
	    }
	    lseek(msg_control_file,fpos,SEEK_SET);
            _write(msg_control_file,(char*) &in_mcr,ramt);
	    fpos += ((long) ramt);
	}
    } while (ramt > 0);
    _close(msg_control_file);
    printf("\nInstalling the new USER_MSG.CTL file");
    unlink("USER_MSG.BAK");
    rename("USER_MSG.CTL","USER_MSG.BAK");
    rename("USER_MSG.$$$","USER_MSG.CTL");
    unlink("USER_MSG.BAK");
Renx2:
    sprintf(wrks,"DEL  %sGTMSGS\\?????.MES",curr_directory);
    printf("\n%s",wrks);
    system(wrks);
    sprintf(wrks,"REN  %sGTMSGS\\?????.NEW  ?????.MES",curr_directory);
    printf("\n%s",wrks);
    system(wrks);
InstallMessage:
    printf("\nInstalling the new MESSAGE.CTL file");
    unlink("MESSAGE.BAK");
    rename("MESSAGE.CTL","MESSAGE.BAK");
    rename("MESSAGE.$$$","MESSAGE.CTL");
    unlink("MESSAGE.BAK");
Renx:
    chg_dir(home_directory);
    prt_line();
}

void global_access_lvl_chg()
{
    LONGINTEGER fpos, flen;
    int inp_fileh, logging;
    char old_level, new_level;
    STRING inp_file[80];
    FILE *sysop_log;
    STRING inp[128];
    USER_RECORD p;

    clrscr();
    logging = 0;
    printf(  "Global Access Level Change\n");
    printf("\nOld access level : ");
    gets(inp);
    old_level = inp[0];
    printf(  "New access level : ");
    gets(inp);
    new_level = inp[0];
    printf("\nChange all occurences of '%c' to '%c'.  Are you sure? [y/N]  ",old_level,new_level);
    up_gets(inp);
    if (inp[0] != 'Y')
	return;
    printf("\nLog changes to SYSOP.LOG? [y/N]  ");
    up_gets(inp);
    if (inp[0] == 'Y') {
	logging = 1;
	sprintf(inp_file,"%sSYSOP.LOG",gtpath);
	if ((sysop_log = fopen(inp_file,"at")) == NULL) {
	    printf("\nERROR: cannot open %s",inp_file);
	    sleep(7);
	    return;
	}
	strcpy(inp,gttime());
	inp[5] = 0;
	fprintf(sysop_log,"%s %s GLOBAL ACCESS LEVEL CHANGE\n\n",date(),inp);
    }
    printf("\nUpdating %sUSER.CTL file\n\n",lan_path);
    sprintf(inp_file,"%sUSER.CTL",lan_path);
    if ((inp_fileh = _open(inp_file,O_RDWR)) < 0) {
        printf("\nERROR: cannot access %sUSER.CTL",lan_path);
	sleep(7);
	if (logging)
	    fclose(sysop_log);
        return;
    }
    flen = filelength(inp_fileh);
    fpos = (LONGINTEGER) sizeof(USER_RECORD);
    _read(inp_fileh,(char*) &p,sizeof(USER_RECORD));
    while (fpos < flen) {
        _read(inp_fileh,(char*) &p,sizeof(USER_RECORD));
        if (p.user_privel == old_level) {
	    p.user_privel = new_level;
	    sprintf(inp,"    %c -> %c   %-30s  %s",old_level,p.user_privel,p.user_name,p.user_home);
	    if (logging)
	        fprintf(sysop_log,"%s\n",inp);
	    printf("\n%s",inp);
	    lseek(inp_fileh,fpos,SEEK_SET);
	    _write(inp_fileh,(char*) &p,sizeof(USER_RECORD));
	}
	fpos += (LONGINTEGER) sizeof(USER_RECORD);
    }
    if (logging)
        fclose(sysop_log);
    printf("\n");
    sleep(2);
    _close(inp_fileh);
}
