/*****************************************************************************
                 Use LARGE memory model for this program
******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <dos.h>
#include <dir.h>
#include <fcntl.h>
#include <io.h>
#include <conio.h>
#include "dram.h"
#include "futil.h"

extern void _fastcall ccitt_crc32_calc(unsigned);

extern unsigned _stklen = 8192;

int ems_flag            = 0;
unsigned _ovrbuffer     = 0;
long file_counter_max   = 25;
long file_counter       = 0;

char lan_path[80];
char bbs_path[80];
char gtpath[80];

struct fdir {
    char   fd_path[61];
    char   fd_bbs[61];
    BYTE   fd_privel[8];
    BYTE   fd_cdrom;
    BYTE   fd_free_area;
    struct fdir *next_fd;
};

struct dcache {
    int  dc_date;
    long dc_size;
    char dc_name[14];
};

#define MAX_DCACHE 1630
struct dcache dir_table[MAX_DCACHE];

int dc_cnt             = 0;
int dc_ptr             = 0;
long cache_hit_count   = 0L;
long cache_miss_count  = 0L;
long dup_file_count    = 0L;
int fd_cnt             = 0;
struct fdir *first_fd  = NULL;
struct fdir *last_fd   = NULL;

void WinDelay(int t)
{
    delay(t);
}

void wf_printf(char *fmt,...)
{
    va_list argptr;

    va_start(argptr,fmt);
    vprintf(fmt,argptr);
    va_end(argptr);
}

int strip_nl(char *s,int imax)
{
    int j, lmax;

    lmax = imax - 1;
    j = 0;
    while ((s[j]) && (s[j] != '\n') && (s[j] != '\r') && (j < lmax))
	j++;
    s[j] = 0;
    return(j);
}

int chg_dir(char *p)
{
    char temp[80];
    char wrk[80];
    int j, deslash_it;

    if (! p[0])
	return(0);
    getcwd(temp,79);
    strcpy(wrk,p);
    strupr(wrk);
    deslash_it = 1;
    if (wrk[1] == ':') {
	setdisk((wrk[0] - 'A'));
	if (! wrk[2]) {
	    strcat(wrk,"\\");
	    deslash_it = 0;
	}
    }
    if (deslash_it)
        if ((j = strlen(wrk) - 1) > 0)
	    if (wrk[j] == '\\')
	        wrk[j] = 0;
    if (chdir(wrk)) {
	chg_dir(temp);
	return(-1);
    }
    return(0);
}

int fgets_p(char *s,int imax,FILE *f)
{
    char *p;

    p = fgets(s,(imax - 4),f);
    if ((p==NULL)||(s[0]==0x1a)) {
        s[0]=0;
        return(-1);
    }
    return((strip_nl(s,imax)));
}

void backup_file(char *pth,char *fn,char *ext)
{
    char wrk1[80];
    char wrk2[128];
    char fnm[80];
    char n_fnm[80];
    char n_fn[14];

    sprintf(n_fn,"O%s",fn);
    sprintf(fnm,"%s%s",pth,fn);
    sprintf(n_fnm,"%s%s",pth,n_fn);
    sprintf(wrk1,"%s.%s",n_fnm,ext);
    if (fexist(wrk1))
	unlink(wrk1);
    sprintf(wrk2,"REN  %s.%s  %s.%s",fnm,ext,n_fn,ext);
    printf("%s\n",wrk2);
    system(wrk2);
}

void process_pathname(char *p)
{
    unsigned lgth;

    if (p[0]) {
	strupr(p);
	lgth = strlen(p) - 1;
	if (p[lgth] == '\n')
	    p[lgth--] = 0;
	if (p[lgth] == '\r')
	    p[lgth--] = 0;
	if (p[lgth++] != '\\') {
	    p[lgth++] = '\\';
	    p[lgth] = 0;
	}
    }
}

void delete(char *destin,int start,int size)
{
    unsigned j, m, k;

    k = strlen(destin);
    if (k) {
	j = start - 1;
	destin[j] = 0;
	m = j + size;
	if (m < k)
	    strcpy(&destin[j],&destin[m]);
    }
}

static unsigned bitset[8] = { 0x0080,
			      0x0040,
			      0x0020,
			      0x0010,
			      0x0008,
			      0x0004,
			      0x0002,
			      0x0001 };

void set_privel_bits(struct fdir *cp,int cprivel,int char1)
{
    int ptr, pfrom, pto;
    int mp, sp;
    unsigned locp;

    if (cprivel >= 97) {
	ptr = cprivel - 61;
	goto SetBit;
    }
    if (cprivel >= 65) {
	ptr = cprivel - 55;
	goto SetBit;
    }
    if (cprivel < 48)
	return;
    ptr = cprivel - 48;
SetBit:
    if (ptr > 62)
	ptr = 62;
    pfrom = 0;
    if (char1 == '=')
	pfrom = ptr;
    pto = (ptr + 1);
    for (ptr=pfrom; ptr<pto; ptr++) {
	mp = (ptr / 8);
	sp = (ptr % 8);
	locp = ((unsigned) cp->fd_privel[mp]) | bitset[sp];
	cp->fd_privel[mp] = locp;
    }
}

void copy_p(char *ds,char *ss,int k)
{
    int i, j;

    j = k - 1;
    for (i=0;i<j;i++) {
	if (!(ds[i] = ss[i]))
	    return;
    }
    ds[j] = 0;
}

int pos(char *searchtag,char *fulltag)
{
    int i,j,lensrch;

    lensrch = strlen(searchtag);
    if (lensrch) {
	j = strlen(fulltag) - lensrch + 1;
	for (i = 0; i < j; i++) {
	    if (! strncmp(searchtag,&fulltag[i],lensrch))
		return(i);
	}
	return(-1);
    }
    return(0);
}

int load_fd_table(char *p,int override)
{
    struct fdir *cp;
    struct fdir *fp;
    char curr_path[161];
    char curr_bbs[61];
    char curr_tag[31];
    int curr_privel;
    int char_1st, cdrom, free_area;
    int found_path, alloc_amt;
    int ch, i, j, k;

    curr_privel =
      cdrom =
        free_area = 0;
    char_1st =
      ch = p[0];
    while ((ch) && (ch != ' ')) {
	if (((ch >= 'A') && (ch <= 'Z'))||
	    ((ch >= 'a') && (ch <= 'z'))||
	    ((ch >= '0') && (ch <= '9')))
		curr_privel = ch;
	delete(p,1,1);
	ch = p[0];
    }
    if ((!ch) || (!curr_privel))
	return(0);
    while ((ch) && (ch == ' ')) {
	delete(p,1,1);
	ch = p[0];
    }
    if (!ch)
	return(0);
    k = 0;
    while ((ch) && (ch != ' '))
	ch = p[++k];
    if (ch)
	p[k] = 0;
    if (p[0] == '') {
        free_area = 1;
        delete(p,1,1);
    }
    p[160] =
      curr_tag[0] =
	curr_bbs[0] = 0;
    strcpy(curr_path,p);
    if ((j = pos(",",curr_path)) > 0) {
	i = j + 1;
	curr_path[j] = ';';
	if ((k = pos(",",curr_path)) > 0) {
	    curr_path[k++] = 0;
	    copy_p(curr_bbs,&curr_path[k],60);
	}
	curr_path[j] = 0;
	copy_p(curr_tag,&curr_path[i],30);
    }
    process_pathname(curr_path);
    if (curr_bbs[0]) {
	strupr(curr_bbs);
	if ((k = pos(",",curr_bbs)) > 0) {
	    if ((curr_bbs[(k+1)] == 'C')&&(curr_bbs[(k+2)] == 'D'))
		cdrom = 1;
	    curr_bbs[k] = 0;
	}
    }
    else {
	sprintf(curr_bbs,"%sFILES.BBS",curr_path);
    }
    cp = first_fd;
    found_path = 0;
    while (cp != NULL) {
	if (!stricmp(cp->fd_path,curr_path)) {
	    found_path = 1;
	    fp = cp;
	    break;
	}
	cp = cp->next_fd;
    }
    if (override) {
	curr_privel = override;
	char_1st = '=';
    }
    if (!found_path) {
	alloc_amt = sizeof(struct fdir) + 8;
	cp = (struct fdir *) malloc(alloc_amt);
	if (first_fd == NULL)
	    first_fd = cp;
	if (cp == NULL)
	    return(1);
	memset(cp,0,alloc_amt);
	strcpy(cp->fd_path,curr_path);
	strcpy(cp->fd_bbs,curr_bbs);
	set_privel_bits(cp,curr_privel,char_1st);
	cp->fd_cdrom = cdrom;
        cp->fd_free_area = free_area;
	cp->next_fd = NULL;
	fd_cnt++;
	if (last_fd != NULL)
	    last_fd->next_fd = cp;
	last_fd = cp;
    }
    else {
	set_privel_bits(fp,curr_privel,char_1st);
    }
    if (char_1st == '=')
	printf("\n%c%c   ",char_1st,curr_privel);
    else
	printf("\n%c    ",curr_privel);
    printf("%s",curr_path);
    return(0);
}

int dcache_lookup(char *name)
{
    int starting_point;

    if (!dc_cnt)
	return(0);
    dc_ptr -= 10;
    if (dc_ptr < 0)
	dc_ptr = dc_cnt + dc_ptr - 1;
    if (dc_ptr < 0)
	dc_ptr = 0;
    starting_point = dc_ptr;
    do {
	if (!strcmp(dir_table[dc_ptr].dc_name,name)) {
	    cache_hit_count++;
	    return(1);
	}
	if (++dc_ptr >= dc_cnt)
	    dc_ptr = 0;
    } while (dc_ptr != starting_point);
    cache_miss_count++;
    return(0);
}

INTEGER fn_hash(char *fn)
{
    int j;

    crc_reg_lo =
      crc_reg_hi = 0xFFFF;
    for (j=0; ((fn[j])&&(fn[j]!='.')); j++)
        ccitt_crc32_calc(fn[j]);
    for (j=0; j<4; j++)
        ccitt_crc32_calc(0);
    return( (crc_reg_hi ^ crc_reg_lo) % 5 );
}

void add_files_db(
    char *fn,
    struct fdir *cp,
    DRAM *fcb[],
    char *fdef,
    long *file_no,
    int cdrom,
    int free_area
    )
{
    FILES_RECORD *p;
    int handle;
    char fname[128];
    struct ftime file_time;
    int k, is_in_cache, cache_date;
    INTEGER db_cnt;

    db_cnt = fn_hash(fn);
    p = (FILES_RECORD *) fcb[db_cnt]->user_rec;
    p->files_deleted = 0;
    strcpy(p->files_name,fn);
    strcpy(p->files_path,cp->fd_path);
    is_in_cache = dcache_lookup(fn);
    if (is_in_cache) {
	cache_date = dir_table[dc_ptr].dc_date;
	p->files_month   = ((cache_date & 0x01e0) >> 5);
	p->files_day     = cache_date & 0x001f;
	p->files_year    = ((cache_date & 0xfe00) >> 9) + 1980;
	p->files_size    = dir_table[dc_ptr].dc_size;
	p->files_offline = 0;
    }
    else {
	sprintf(fname,"%s%s",cp->fd_path,fn);
        strupr(fname);
	if ((handle = _open(fname,O_RDONLY)) < 0) {
	    if (fdef[41] == '*') {
		fdef[35] =
		  fdef[38] = ' ';
		p->files_month   = atoi(&fdef[33]);
		p->files_day     = atoi(&fdef[36]);
		p->files_year    = atoi(&fdef[38]);
		p->files_size    = atol(&fdef[12]);
		p->files_offline = 7;
	    }
	    else {
		printf("\nUnable to locate: %s",fname);
		return;
	    }
	}
	else {
	    getftime(handle,&file_time);
	    p->files_month   = file_time.ft_month;
	    p->files_day     = file_time.ft_day;
	    p->files_year    = file_time.ft_year + 1980;
	    p->files_size    = filelength(handle);
	    p->files_offline = 0;
	    _close(handle);
	}
    }
    for (k=0; k<8; k++)
	p->files_privel[k] = cp->fd_privel[k];
    p->files_cdrom = cdrom;
    p->files_free_area = free_area;
    strcpy(fcb[db_cnt]->string_key,fn);
    fcb[db_cnt]->binary_key = file_no[db_cnt]++;
    if (dram(APPEND,fcb[db_cnt])) {
	printf("\nUnable to add %s%s to database, possible duplicate.",p->files_path,p->files_name);
	dup_file_count++;
	return;
    }
    file_counter++;
    if (!(file_counter % file_counter_max))
	printf("\n%5ld.  %s%s",file_counter,p->files_path,p->files_name);
}

long file_length(char *pth,char *fn,char *ext)
{
    int handle;
    long bsize;
    char fname[80];

    bsize = 0L;
    sprintf(fname,"%s%s.%s",pth,fn,ext);
    if ((handle = _open(fname,o_mode(O_RDONLY))) > 0) {
	bsize = filelength(handle);
	close(handle);
    }
    return(bsize);
}

void get_cdrom_records(
    DRAM *fcb[],
    long *file_no
    )
{
    int inp_fileh;
    FILES_RECORD *p;
    INTEGER db_cnt;
    LONGINTEGER fpos, flen;
    char inp_file[80];

    for (db_cnt=0; db_cnt<5; db_cnt++) {
        p = (FILES_RECORD *) fcb[db_cnt]->user_rec;
        sprintf(inp_file,"%sOFILES_%u.CTL",lan_path,db_cnt);
        if ((inp_fileh = _open(inp_file,O_RDONLY)) < 0)
	    return;
        flen = filelength(inp_fileh);
        fpos = (LONGINTEGER) sizeof(FILES_RECORD);
        while (fpos < flen) {
	    seekfile(inp_fileh,fpos,SEEK_SET);
	    readfile(inp_fileh,(char far *) p,sizeof(FILES_RECORD));
	    if (p->files_cdrom) {
	        strcpy(fcb[db_cnt]->string_key,p->files_name);
	        fcb[db_cnt]->binary_key = file_no[db_cnt]++;
	        if (dram(APPEND,fcb[db_cnt]))
		    printf("\nCDROM: Unable to add %s%s to database.",
                        p->files_path,
                          p->files_name);
	        else {
		    file_counter++;
		    if (!(file_counter % file_counter_max))
		        printf("\n%5ld:  %s%s",file_counter,p->files_path,p->files_name);
	        }
	    }
	    fpos += (LONGINTEGER) sizeof(FILES_RECORD);
        }
        _close(inp_fileh);
    }
}

int process_fn(char *fn)
{
    int k, pp, uc, lc, ch;

    ch = fn[0];
    if ((ch < ' ')||(ch > 'z'))
	return(0);
    if ((ch=='=')||(ch=='-')||(ch=='_')) {
	if ((fn[1]==ch)&&(fn[2]==ch))
	    return(0);
    }
    lc =
      uc =
	pp =
	  k = 0;
    while (ch = (fn[k++] & 0x00ff)) {
	if ((ch==' ')||(ch=='\t')||(ch==0x00ff))
	    goto CheckMixedCase;
	if ((ch==0x00e0)||(ch==0x00e1))
	    continue;
	if ((ch < ' ')||(ch > 'z'))
	    return(0);
	if (
	   (ch==':')  ||
	   (ch==';')  ||
	   (ch=='/')  ||
	   (ch=='\\') ||
	   (ch=='[')  ||
	   (ch==']')  ||
	   (ch=='>')  ||
	   (ch=='<')  ||
	   (ch=='*')
	   )
	       return(0);
	if (ch == '.') {
	    pp++;
	    continue;
	}
	if ((ch >= 'A')&&(ch <= 'Z')) {
	    uc = 1;
	    continue;
	}
	if ((ch >= 'a')&&(ch <= 'z')) {
	    lc = 1;
	    continue;
	}
    }
CheckMixedCase:
    if ((uc)&&(lc))
	return(0);
    if (--k > 12) {
	return(0);
    }
    if (pp > 1)
	return(0);
    fn[12] =
      fn[k] = 0;
    return(1);
}

void pre_load_dcache(struct fdir *cp)
{
    char far *dta;
    char pathname[80];
    char buffer[260];
    struct ffblk ffblk;
    int attrib;
    int done;
    int test_value;

    dc_ptr =
      dc_cnt = 0;
    test_value = (FA_SYSTEM | FA_LABEL | FA_DIREC);
    memset(buffer,0,256);
    dta = getdta();
    setdta(buffer);
    sprintf(pathname,"%s*.*",cp->fd_path);
    done = findfirst(pathname,&ffblk,0);
    while ((! done) && (dc_cnt < MAX_DCACHE)) {
	if (ffblk.ff_name[0] != '.') {
	    attrib = ffblk.ff_attrib & test_value;
	    if (! attrib) {
		dir_table[dc_cnt].dc_date = ffblk.ff_fdate;
		dir_table[dc_cnt].dc_size = ffblk.ff_fsize;
		ffblk.ff_name[12] = 0;
		strcpy(dir_table[dc_cnt].dc_name,ffblk.ff_name);
		dc_cnt++;
	    }
	}
	done = findnext(&ffblk);
    }
    setdta(dta);
}

void process_files_bbs(
    char   *files_fname,
    struct fdir *cp,
    DRAM   *fcb[],
    long   *file_no
    )
{
    FILE *text;
    char wrk[520];
    char fname[80];
    int ramt, is_fname;

    if ((text = fopen(files_fname,"rt")) != NULL) {
	do {
	    if ((ramt = fgets_p(wrk,512,text)) > 0) {
		if (wrk[0] == ';') {
		    if (!strnicmp(&wrk[1],"PATH",4)) {
			delete(wrk,1,6);
			wrk[60] = 0;
			process_pathname(wrk);
			strcpy(cp->fd_path,wrk);
			pre_load_dcache(cp);
		    }
		    goto NextLoop;
		}
		if (wrk[0] == 6) {
		    delete(wrk,1,1);
		    strupr(wrk);
		    printf("\nProcessing ^F include: %s",wrk);
		    process_files_bbs(wrk,cp,fcb,file_no);
		    goto NextLoop;
		}
		if ((wrk[0]!=' ')&&(wrk[0]!='\t')) {
		    wrk[79] = 0;
		    strcpy(fname,wrk);
		    is_fname = process_fn(fname);
		    if (is_fname) {
			strupr(fname);
			add_files_db(fname,cp,fcb,wrk,file_no,cp->fd_cdrom,cp->fd_free_area);
		    }
		    else {
			printf("\nIs not valid filename: %s",fname);
		    }
		}
	    }
NextLoop:
	    ;
	} while (ramt >= 0);
	fclose(text);
    }
}

void squeeze_blanks(char *s)
{
    int j, k;

    for (j=0; (k = s[j++]); ) {
	if (k == ' ')
	    delete(s,j,1);
    }
}

void main(int argc,char *argv[])
{
    char wrk[516];
    char *ep;
    char files_fname[80];
    char dir_fname[80];
    char cnf_fname[80];
    FILE *text;
    long file_no[5];
    struct fdir *cp;
    DRAM *fcb[5];
    FILES_RECORD *p;
    INTEGER est_files_cnt, db_cnt;
    int override, ramt, j, k, optimize_cdrom, loaderror;

    optimize_cdrom = 0;
    est_files_cnt = 1051;
    prime[0] = 313U;
    prime[1] = 1051U;
    prime[2] = 4127U;
    prime[3] = 8123U;
    prime[4] = 16127U;
    prime[5] = 24121U;
    prime[6] = 65521U;
    for (j=1; j<argc; j++) {
	strcpy(wrk,argv[j]);
	strupr(wrk);
	if (!stricmp(wrk,"/CD"))
	    optimize_cdrom = 1;
	if ((wrk[0] >= '0') && (wrk[0] <= '9')) {
	    est_files_cnt = (INTEGER) atol(wrk);
	}
    }
    printf("FILES_DB 3.0");
    printf("\n(C)opyright 1993, P&M Software Co.");
    printf("\nAll Rights Reserved");
    printf("\n");
    if ((ep = getenv("GTPATH")) != NULL)
	strcpy(gtpath,ep);
    else
	getcwd(gtpath,79);
    process_pathname(gtpath);
    strcpy(bbs_path,gtpath);
    strcpy(lan_path,gtpath);
    sprintf(cnf_fname,"%sGT.CNF",gtpath);
    if ((text = fopen(cnf_fname,"rt")) != NULL) {
	do {
	    if ((ramt = fgets_p(wrk,512,text)) > 0) {
		strupr(wrk);
		if ((wrk[2] == '=')&&(wrk[3] >= 'A')&&(wrk[3] <= 'Z')) {
		    if ((wrk[0] == 'B') && (wrk[1] == 'B')) {
			strcpy(bbs_path,&wrk[3]);
			process_pathname(bbs_path);
			continue;
		    }
		    if ((wrk[0] == 'L') && (wrk[1] == 'R')) {
			strcpy(lan_path,&wrk[3]);
			process_pathname(lan_path);
		    }
		}
	    }
	} while (ramt >= 0);
	fclose(text);
    }
    sprintf(dir_fname,"%sGTDIR.BBS",gtpath);
    if ((text = fopen(dir_fname,"rt")) == NULL) {
	sprintf(dir_fname,"%sGTDIR.BBS",bbs_path);
	if ((text = fopen(dir_fname,"rt")) == NULL) {
	    printf("\nERROR: cannot open %sGTDIR.BBS",gtpath);
	    printf("\n                or %sGTDIR.BBS\n",bbs_path);
	    exit(1);
	}
    }
    override =
      loaderror =
	ramt =
	  fd_cnt = 0;
    while ((ramt >= 0) && (!loaderror)) {
	if ((ramt = fgets_p(wrk,512,text)) > 0) {
	    if (wrk[0]=='.') {
		squeeze_blanks(wrk);
		override = 0;
		if (wrk[1]=='=')
		    override = ((int) wrk[2]) & 0x00FF;
	    }
	    else {
		if ((wrk[0]!=' ')&&(wrk[0]!='\t')) {
		    loaderror = load_fd_table(wrk,override);
		    if (loaderror)
			printf("\nLOADERROR at %s",wrk);
		}
	    }
	}
    }
    fclose(text);
    if (! fd_cnt) {
	printf("\nCannot find any files to process!\n");
	exit(0);
    }
//      idx_length = file_length(lan_path,"FILES","IDX");
//      begin_prime = ((INTEGER) (idx_length / ((long) sizeof(IDX_RECORD))));
//      if (begin_prime > 100)
//	    begin_prime -= 100;
//      if (begin_prime < est_files_cnt)
//	    begin_prime = est_files_cnt;
    begin_prime = est_files_cnt / 5;
    if (begin_prime < prime[0])  begin_prime = prime[0];
    if (begin_prime > prime[6])  begin_prime = prime[6];
    k = 0;
    while ((begin_prime > prime[k]) && (k < 6))
	k++;
    begin_prime = prime[k];
    printf("\n\n");
    printf("\nInitializing new database...\n");
    for (db_cnt = 0; db_cnt < 5; db_cnt++) {
        sprintf(wrk,"FILES_%u",db_cnt);
        backup_file(lan_path,wrk,"CTL");
        backup_file(lan_path,wrk,"IDX");
        fcb[db_cnt] = allocate_fcb();
        p = (FILES_RECORD *) fcb[db_cnt]->user_rec;
        fcb[db_cnt]->dat_recsize = sizeof(FILES_RECORD);
        fcb[db_cnt]->dat_keypos = 1;
        fcb[db_cnt]->dat_keytype = 0;
        strcpy(fcb[db_cnt]->dram_path,lan_path);
        dram_slasher(fcb[db_cnt]);
        strcpy(fcb[db_cnt]->dram_fname,wrk);
        if (dram(CREATE,fcb[db_cnt])) {
	    printf("\nERROR: cannot create DRAM index and data file: %s%s\n",
                fcb[db_cnt]->dram_path,
                  wrk);
	    exit(1);
        }
        memset((char *) p,0,sizeof(FILES_RECORD));
        seekfile(fcb[db_cnt]->dat_handle,0L,SEEK_SET);
        writefile(fcb[db_cnt]->dat_handle,(char *) p,sizeof(FILES_RECORD));
	file_no[db_cnt] = 0L;
    }
    cache_hit_count =
      cache_miss_count =
	dup_file_count =
	  file_counter = 0L;
    if (optimize_cdrom) {
//	file_counter_max = 10L;
	printf("\nLoading CD-ROM files from old database");
	get_cdrom_records(fcb,file_no);
    }
    cp = first_fd;
    while (cp != NULL) {
	printf("\nProcessing directory: %s",cp->fd_path);
	if ((! optimize_cdrom)||(! cp->fd_cdrom)) {
//	    file_counter_max = 25L;
//	    if (cp->fd_cdrom)
//		file_counter_max = 50L;
	    strcpy(files_fname,cp->fd_bbs);
	    pre_load_dcache(cp);
	    process_files_bbs(files_fname,cp,fcb,file_no);
	}
	cp = cp->next_fd;
    }
    printf("\n\n%5ld Files processed.",file_counter);
    printf(  "\n%5ld Cache hit count.",cache_hit_count);
    printf(  "\n%5ld Cache miss count.",cache_miss_count);
    printf(  "\n%5ld Duplicate File Count.\n",dup_file_count);
    for (db_cnt = 0; db_cnt < 5; db_cnt++) {
        p = (FILES_RECORD *) fcb[db_cnt]->user_rec;
        seekfile(fcb[db_cnt]->dat_handle,0L,SEEK_SET);
        readfile(fcb[db_cnt]->dat_handle,(char *) p,sizeof(FILES_RECORD));
        p->files_size = file_no[db_cnt];
        seekfile(fcb[db_cnt]->dat_handle,0L,SEEK_SET);
        writefile(fcb[db_cnt]->dat_handle,(char *) p,sizeof(FILES_RECORD));
        dram(CLOSE,fcb[db_cnt]);
        release_fcb(fcb[db_cnt]);
        fcb[db_cnt] = NULL;
    }
    cp = first_fd;
    while (cp != NULL) {
	first_fd = cp->next_fd;
	free(cp);
	cp = first_fd;
    }
    exit(0);
}
