#include <stdio.h>
#include <alloc.h>
#include <mem.h>
#include <process.h>
#include <conio.h>

unsigned _ovrbuffer;
unsigned ems_flag;

#define NUM 3
#define MAX ( NUM * 1024000L )
#define SIZ 64000U

typedef unsigned char parray[SIZ];
typedef unsigned long longint;

void main(int,char *[]);
void clrprime(longint);

extern int directvideo = 1;

parray *prime[NUM];

#define PRIME(j)  (((char*)prime[((int)(j/1024000L))])+((int)((j%1024000L)>>4)))

unsigned int getmask[8] = { 0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01 };
unsigned int clrmask[8] = { 0x7F,0xBF,0xDF,0xEF,0xF7,0xFB,0xFD,0xFE };

void clrprime(j)
longint j;
{
    char *p;

    p = PRIME(j);
    *p = clrmask[((int) ((j >> 1) % 8))] & (*p);
}

void main(argc,argv)
int argc;
char *argv[];
{
    longint j, k, ln, cnt, d, number;
    int i;

    if (argc < 2) {
	printf("\r\nUsage: \"SIEVE n\"");
	printf("\r\n    Where \"n\" is the biggest integer to examine.");
	printf("\r\n    The biggest possible integer is %lu.\r\n",MAX);
	exit(1);
    }
    sscanf(argv[1],"%I",&number);
    if ((number < 10) || (number > MAX)) {
	printf("\r\nThe integer value must be in the range 10 - %lu.\r\n",MAX);
	exit(1);
    }
    for (i = 0; i < NUM; i++)
        prime[i] = (parray *) malloc(SIZ);
    if ((prime[0] == NULL) || (prime[1] == NULL)) {
	printf("\r\nNot enough memory to build the sieve.\r\n");
	exit(1);
    }
    printf("\r\nList of Primes: 1 - %lu\r\n\n",number);
    memset((void *) prime[0],0xff,SIZ);
    memset((void *) prime[1],0xff,SIZ);
    printf("%6d ",1);
    printf("%6d ",2);
    ln = 2;
    cnt = 2;
    for (k = 3; k < number; k += 2) {
	if ( (getmask[((int) ((k >> 1) % 8))] & (*PRIME(k))) ) {
	    printf("%6lu ",k);
	    cnt++;
	    if (++ln == 10) {
		printf("\r\n");
		ln = 0;
	    }
	    d = (k << 1);
            for (j = (d + k); j < number; j += d )
	        clrprime(j);
	}
    }
    for (i = 0; i < NUM; i++)
        free(prime[i]);
    if (ln) 
	printf("\r\n");
    printf("\r\nNUMBER OF PRIMES FOUND = %lu\r\n",cnt);
}
