#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <dir.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <time.h>
#include <alloc.h>
#include "dram.h"
#include "futil.h"

#define MAXINT 32767
#define TRUE  1
#define FALSE 0

extern directvideo = 0;

unsigned _ovrbuffer;
int ems_flag;

LONGINTEGER loops_per_ms;
LONGINTEGER loops_per_char;

extern void make_a_msg_sticky(char *);
extern void delete_messages(char *);
extern void renumber_messages(char *);
extern void prt_line(void);
extern void global_access_lvl_chg(void);
extern int fgets_p(char *,int,FILE *);

void main(void);
void find_user(int,char *);
void add_user(void);
void delete_user(void);
void process_city_state(DRAM far *);
void build_ctl(void);
void build_user_ctl(void);
int import_user_msg(char *);
void import_msg(char *);
void trim(char far *);
void delete(char far *,int,int);
void insert(char *,char far *,int);
void proper(char far *);
void pas_to_c(char far *cstr,char *,int);
void copy_p(char *,char far *,int);
int pos(char *,char far *);
int integer_input(char *);
void integer_ed(char *,unsigned far *,int);
void string_ed(char *,char far *,int);
char bool_input(char *);
char *bool_print(char);
char char_input(char *);
void process_pathname(char *);
void import_error(char *,char *);
void build_error(char *,char *,BOOLEAN);
void re_organize(void);
void examine_lost(void);
char *backup_file(char *,char *,char *,char *);
void pause_to_read(BOOLEAN);
int strip_nl(char *,int);
int chg_dir(char *);
void expand_msg_idx(char *);
void clean_up_user_msg_file(char *,int);
void clean_up_board_joins(char *);
void up_gets(char *);

extern unsigned _stklen = 32768U;

struct old_user_record old_user_rec;
char default_msg_path[80];
char gtpath[80];
char bbs_path[80];
char lan_path[80];

struct tnode {
    LONGINTEGER CallerNumber;
    INTEGER HashCode;
    struct tnode far *left;
    struct tnode far *right;
};

static struct tnode far *root          = NULL;
static int join_file                   = 0;

struct tnode far *talloc(void)
{
    return((struct tnode far *) farmalloc(sizeof(struct tnode)));
}

struct tnode far *tree(struct tnode far *p,LONGINTEGER cn,INTEGER hc)
{
    if (p == NULL) {
	p = talloc();
	p->CallerNumber = cn;
	p->HashCode = hc;
	p->left = NULL;
	p->right = NULL;
    }
    else {
	if (cn < p->CallerNumber) {
	    p->left = tree(p->left,cn,hc);
	}
	else {
	    if (cn > p->CallerNumber)
		p->right = tree(p->right,cn,hc);
	}
    }
    return(p);
}

void tree_erase(struct tnode far *p)
{
    if (p != NULL) {
	tree_erase(p->left);
	tree_erase(p->right);
	farfree(p);
    }
}

struct join_record {
    LONGINTEGER CallerNumber;
    INTEGER HashCode;
    INTEGER SlackBytes;
};

struct join_record callers[256];
static int caller_count                = 0;
static char joins_dir[]                = "JOINS";

void add_board(LONGINTEGER cn,INTEGER hc)
{
    callers[caller_count].CallerNumber = cn;
    callers[caller_count].HashCode     = hc;
    callers[caller_count].SlackBytes   = 0;
    if (++caller_count > 255) {
	_write(join_file,&callers,2048);
	caller_count = 0;
	memset(&callers,0,2048);
    }
}

void traverse(struct tnode far *p)
{
    if (p != NULL) {
	add_board(p->CallerNumber,p->HashCode);
	traverse(p->right);
	traverse(p->left);
    }
}

void select_path(char *s)
{
    if (lan_path[0])
	sprintf(s,"%s%s",lan_path,joins_dir);
     else
	sprintf(s,"%s%s",gtpath,joins_dir);
}

void WinDelay(int t)
{
    delay(t);
}

void create_board_join(char *board_name)
{
    char bd_name[80];
    char f_name[80];
    char j_dname[80];

#ifdef DEBUG
    stack_probe();
#endif
    caller_count = 0;
    memset(&callers,0,2048);
    if ((!board_name[0]) || (board_name[0]==' '))
	return;
    strcpy(bd_name,board_name);
    bd_name[8] = 0;
    strupr(bd_name);
    select_path(j_dname);
    mkdir(j_dname);
    sprintf(f_name,"%s\\%s.CTL",j_dname,bd_name);
    join_file = _creat(f_name,0);
    if (join_file < 0)
	return;
    traverse(root);
    if (caller_count)
	_write(join_file,&callers,2048);
    _close(join_file);
}

char *build_time(int h,int m)
{
    static char function[16];

    sprintf(function,"%2d:%02d",h,m);
    return(function);
}

char *build_date(int m,int d,int y)
{
    static char function[16];

    if (y > 1999)
	y -= 2000;
    if (y > 1900)
	y -= 1900;
    if (y > 99)
	y -= 100;
    sprintf(function,"%2d-%02d-%02d",m,d,y);
    return(function);
}

long TZone = 0L;

void TZ(void)
{
    char *ep;
    int k;
    char tzstr[82];

    daylight = 0;
    timezone = 0L;
    if ((ep = getenv("TZ")) == NULL) {
Default:
	TZone = 28800L;
	return;
    }
    strcpy(tzstr,ep);
    if ((k = strlen(tzstr) - 1) < 3)
	goto Default;
    TZone = atol(&tzstr[3]) * 3600L;
    if ((tzstr[k] < '0')||(tzstr[k] > '9'))
	TZone -= 3600L;
}

long GMT(long local)
{
    return( local + TZone );
}

struct tm LCT(long gmt)
{
    struct tm local;
    time_t wk;

    wk = gmt - TZone;
    local = *(gmtime(&wk));
    return(local);
}

char *calcdate(INTEGER dt)
{
    long gmt;
    struct tm dos_tm;
    static char ws[16];

    if (! dt)
	return("");
    gmt = GMT( ((((long)dt)-25569L+29221L)*86400L) );
    dos_tm = LCT(gmt);
    strcpy(ws,build_date((dos_tm.tm_mon+1),dos_tm.tm_mday,dos_tm.tm_year));
    trim((char far *) ws);
    return(ws);
}

INTEGER daynumber(char *s)
{
    char inp[16];
    int month, day, year, slen, j, k, t;
    struct tm dos_tm;

    if (((slen = strlen(s)) < 7) || (slen > 10))
	return(0);
    strcpy(inp,s);
    j = 2;
    t = j - 1;
    if ((inp[t] == '-')||(inp[t] == '/'))
	j = t;
    k = j + 3;
    t = k - 1;
    if ((inp[t] == '-')||(inp[t] == '/'))
	k = t;
    inp[k++] = 0;
    inp[j++] = 0;
    month = atoi(inp);
    day   = atoi(&inp[j]);
    year  = atoi(&inp[k]);
    if ((month < 1)||(month > 12)||(year < 0)||(day < 1)||(day > 31))
	return(0);
    if (year < 80)
	year += 100;
    if (year > 1900)
	year -= 1900;
    if ((year < 80) || (year > 179))
	return(0);
    dos_tm.tm_year = year;
    dos_tm.tm_mon  = month - 1;
    dos_tm.tm_mday  = day;
    dos_tm.tm_hour =
     dos_tm.tm_min  =
      dos_tm.tm_sec  =
       dos_tm.tm_isdst =
	dos_tm.tm_wday =
	 dos_tm.tm_yday = 0;
    timezone = daylight = 0;
    return( ((INTEGER)((mktime(&dos_tm)/86400L)+25569L-29221L)) );
}

int my_getkey(int bksp)
{
    int ky;

    if ((ky = getch()) == 8) {
	if (! bksp)
	    printf("\x08 \x08");
    }
    else
	printf("%c",ky);
    return(ky);
}

int chg_dir(char *p)
{
    char temp[80];
    char wrk[80];
    int j, deslash_it;

    if (! p[0])
	return(0);
    getcwd(temp,78);
    strcpy(wrk,p);
    strupr(wrk);
    deslash_it = 1;
    if (wrk[1] == ':') {
	setdisk((wrk[0] - 'A'));
	if (! wrk[2]) {
	    strcat(wrk,"\\");
	    deslash_it = 0;
	}
    }
    if (deslash_it) {
	if ((j = strlen(wrk) - 1) > 0)
	    if (wrk[j] == '\\')
		wrk[j] = 0;
    }
    if (chdir(wrk)) {
	chg_dir(temp);
	return(-1);
    }
    return(0);
}

char *backup_file(char *pth,char *fn,char *ext,char *n_fn)
{
    static char wrk3[80];
    char wrk1[128];
    char wrk2[128];
    char fnm[80];
    char n_fnm[80];

    sprintf(fnm,"%s%s",pth,fn);
    sprintf(n_fnm,"%s%s",pth,n_fn);
    sprintf(wrk1,"%s.%s",n_fnm,ext);
    if (fexist(wrk1))
	unlink(wrk1);
    sprintf(wrk2,"REN  %s.%s  %s.%s",fnm,ext,n_fn,ext);
    printf("%s\n",wrk2);
    system(wrk2);
    sprintf(wrk3,"%s%s.%s",pth,n_fn,ext);
    return(wrk3);
}

void process_pathname(char *p)
{
    REGISTER lgth;

    if (p[0]) {
	strupr(p);
	lgth = strlen(p) - 1;
	if (p[lgth] == '\n')
	    p[lgth--] = 0;
	if (p[lgth] == '\r')
	    p[lgth--] = 0;
	if (p[lgth++] != '\\') {
	    p[lgth++] = '\\';
	    p[lgth] = 0;
	}
	if (p[0] == '\\')
	    return;
	while ( (p[0]) && ((p[0] < 'A') || (p[0] > 'Z')) )
	    delete((char far *) p,1,1);
    }
}

void pas_to_c(char far *cstr,char *pstr,int imax)
{
    int j;

    if ((j = pstr[0]) > imax)
	j = imax;
    FARmemmove(cstr,(char far *) &pstr[1],j);
    cstr[j] = 0;
}

void pause_to_read(BOOLEAN pse)
{
    char estr[80];

    if (pse) {
	printf("\nPress [enter] to continue...");
	gets(estr);
    }
}

void import_error(char *iname,char *ipath)
{

    printf("\nERROR: The %s%s.IDX file cannot be found.",ipath,iname);
    printf("\n       Perhaps an import needs to be performed.\n");
    pause_to_read(TRUE);
}

void build_error(char *bpath,char *bname,BOOLEAN pse)
{
    printf("\nERROR: The %s%s file cannot be opened.",bpath,bname);
    printf("\n       This message base is probably not initialized.\n");
    pause_to_read(pse);
}

void process_city_state(DRAM far *fcb)
{
    char wrk_string[80];
    int j;
    USER_RECORD far *p;

    p = fcb->user_rec;
    proper(p->user_home);
    FARstrcpy((char far *) wrk_string,(char far *) (p->user_home));
    wrk_string[4] = 0;
    strupr(wrk_string);
    if ((! strcmp(wrk_string,"HOU "))
	|| (! strcmp(wrk_string,"HOU."))
	    || (! strcmp(wrk_string,"HOU,"))) {
		FARstrcpy((char far *) (p->user_home),(char far *) "Houston, Tx");
		return;
    }
    if ((j = pos("Texa",p->user_home)) > 1) {
	p->user_home[j] = 0;
	FARstrcat((char far *) (p->user_home),(char far *) "Tx");
	return;
    }
    if ((j = pos("Calif",p->user_home)) > 1) {
	p->user_home[j] = 0;
	FARstrcat((char far *) (p->user_home),(char far *) "Ca");
	return;
    }
    if ((j = pos("Ohio",p->user_home)) > 1) {
	p->user_home[j] = 0;
	FARstrcat((char far *) (p->user_home),(char far *) "Oh");
	return;
    }
    if ((j = pos("Utah",p->user_home)) > 1) {
	p->user_home[j] = 0;
	FARstrcat((char far *) (p->user_home),(char far *) "Ut");
	return;
    }
    if ((j = pos("Illi",p->user_home)) > 1) {
	p->user_home[j] = 0;
	FARstrcat((char far *) (p->user_home),(char far *) "Il");
	return;
    }
    if ((j = pos("Flori",p->user_home)) > 1) {
	p->user_home[j] = 0;
	FARstrcat((char far *) (p->user_home),(char far *) "Fl");
	return;
    }
    if (strcmp(wrk_string,"WASH")) {
	trim(p->user_home);
	j = FARstrlen((char far *) (p->user_home)) - 1;
	if ((p->user_home[j] == '.') || (p->user_home[j] == ',')) {
	    p->user_home[j] = 0;
	    proper(p->user_home);
	}
    }
}

void build_user_ctl(void)
{
    LONGINTEGER fpos, flen;
    int inp_fileh;
    LONGINTEGER callerno;
    char inp_file[80];
    DRAM far *fcb;
    USER_RECORD far *p;

    clrscr();
    printf("\nImporting: %sGTMAIL.CTL -> %sUSER.CTL\n\n",default_msg_path,lan_path);
    sprintf(inp_file,"%sGTMAIL.CTL",default_msg_path);
    if ((inp_fileh = _open(inp_file,O_RDWR)) < 0) {
	build_error(default_msg_path,"GTMAIL.CTL",TRUE);
	return;
    }
    fcb = allocate_fcb();
    p = fcb->user_rec;
    fcb->dat_recsize = sizeof(USER_RECORD);
    fcb->dat_keypos = 1;
    fcb->dat_keytype = 0;
    FARstrcpy((char far *) (fcb->dram_path),(char far *) lan_path);
    dram_slasher(fcb);
    FARstrcpy((char far *) (fcb->dram_fname),(char far *) "USER");
    if (dram(CREATE,fcb)) {
	printf("\nERROR: Cannot create DRAM index and data file: %Fs%s\n",fcb->dram_path,"USER");
	pause_to_read(TRUE);
	goto Bex;
    }
    flen = filelength(inp_fileh);
    fpos = (LONGINTEGER) sizeof(old_user_rec);
    callerno = 0;
    readfile(inp_fileh,(char far *) &old_user_rec,sizeof(old_user_rec));
    FARmemset((char far *) p,0,sizeof(USER_RECORD));
    p->user_deleted = old_user_rec.old_user_deleted;
    pas_to_c(p->user_name,old_user_rec.old_user_name,30);
    p->user_charges = old_user_rec.old_user_charges;
    p->user_accum_time = old_user_rec.old_user_accum_time;
    pas_to_c(p->user_first_date,old_user_rec.old_user_date,8);
    trim(p->user_first_date);
    pas_to_c(p->user_first_time,old_user_rec.old_user_time,5);
    seekfile(fcb->dat_handle,0L,SEEK_SET);
    writefile(fcb->dat_handle,(char far *) p,sizeof(USER_RECORD));
    while (fpos < flen) {
	seekfile(inp_fileh,fpos,SEEK_SET);
	readfile(inp_fileh,(char far *) &old_user_rec,sizeof(old_user_rec));
	FARmemset((char far *) p,0,sizeof(USER_RECORD));
	p->user_deleted = old_user_rec.old_user_deleted;
	pas_to_c(p->user_name,old_user_rec.old_user_name,30);
	proper(p->user_name);
	pas_to_c(p->user_last_date,old_user_rec.old_user_date,8);
	trim(p->user_last_date);
	p->user_credit = old_user_rec.old_user_credit;
	pas_to_c(p->user_last_time,old_user_rec.old_user_time,5);
	p->user_charges = old_user_rec.old_user_charges;
	p->user_times_on = old_user_rec.old_user_times_on;
	p->user_banned = old_user_rec.old_user_banned;
	if (p->user_banned)
	    p->user_deleted = 0;
        p->user_expert = old_user_rec.old_user_expert;
        p->user_more = old_user_rec.old_user_more;
        pas_to_c(p->user_home,old_user_rec.old_user_home,30);
	process_city_state(fcb);
        pas_to_c(p->user_password,old_user_rec.old_user_password,20);
        pas_to_c(p->user_phone,old_user_rec.old_user_phone,10);
        p->user_privel = old_user_rec.old_user_privel;
	p->user_day_calls = old_user_rec.old_user_day_calls;
        p->user_accum_time = old_user_rec.old_user_accum_time;
        FARstrcpy((char far *) (p->user_first_date),(char far *) (p->user_last_date));
	FARstrcpy((char far *) (p->user_first_time),(char far *) (p->user_last_time));
	p->user_protocol = ' ';
	p->user_screen_lgth = 24;
	p->user_caller_no = (callerno + 1);
	FARstrcpy((char far *) (fcb->string_key),(char far *) (p->user_name));
	fcb->binary_key = p->user_caller_no;
	if (dram(APPEND,fcb)) {
	    printf("Unable to add \"%Fs\", possible duplicate record.\n",p->user_name);
	    sleep(1);
	}
	else {
	    if (!(++callerno % 25)) {
                printf("%5ld.  %-32Fs%-32Fs\n",callerno,p->user_name,p->user_home);
	    }
	}
	fpos += (LONGINTEGER) sizeof(old_user_rec);
    }
    seekfile(fcb->dat_handle,0L,SEEK_SET);
    readfile(fcb->dat_handle,(char far *) p,sizeof(USER_RECORD));
    p->user_caller_no = callerno;
    seekfile(fcb->dat_handle,0L,SEEK_SET);
    writefile(fcb->dat_handle,(char far *) p,sizeof(USER_RECORD));
    dram(CLOSE,fcb);
Bex:
    release_fcb(fcb);
    fcb=NULL;
    _close(inp_fileh);
}

void import_msg(char *msg_path)
{
    LONGINTEGER fpos, flen;
    int inp_fileh, out_fileh;
    char inp_file[80], out_file[80];
    struct msg_record old_msg_rec;
    struct msg_record new_msg_rec;

    printf("\nImporting: %sGTMESSAG.CTL -> %sMESSAGE.CTL\n\n",msg_path,msg_path);
    sprintf(inp_file,"%sGTMESSAG.CTL",msg_path);
    sprintf(out_file,"%sMESSAGE.CTL",msg_path);
    if ((inp_fileh = _open(inp_file,O_RDWR)) < 0) {
        build_error(msg_path,"GTMESSAG.CTL",FALSE);
        return;
    }
    if ((out_fileh = createfile(out_file)) < 0) {
	build_error(msg_path,"MESSAGE.CTL",TRUE);
	return;
    }
    fpos = 0L;
    flen = filelength(inp_fileh);
    while (fpos < flen) {
        seekfile(inp_fileh,fpos,SEEK_SET);
        readfile(inp_fileh,(char far *) &old_msg_rec,sizeof(old_msg_rec));
        new_msg_rec.msg_deleted = old_msg_rec.msg_deleted;
        new_msg_rec.msg_number  = old_msg_rec.msg_number;
	if (!(old_msg_rec.msg_number % 25))
	    printf("Processing message number %d.\n",old_msg_rec.msg_number);
        pas_to_c(new_msg_rec.msg_sender,old_msg_rec.msg_sender,30);
        pas_to_c(new_msg_rec.msg_addressee,old_msg_rec.msg_addressee,30);
        pas_to_c(new_msg_rec.msg_topic,old_msg_rec.msg_topic,30);
        pas_to_c(new_msg_rec.msg_date,old_msg_rec.msg_date,8);
        new_msg_rec.msg_dest_net = old_msg_rec.msg_dest_net;
        if (old_msg_rec.msg_time[0] > 5)
	    old_msg_rec.msg_time[0] -= 3;
        pas_to_c(new_msg_rec.msg_time,old_msg_rec.msg_time,5);
	new_msg_rec.msg_weekday =
	  new_msg_rec.msg_filler =
	   new_msg_rec.msg_flags = 0;
	new_msg_rec.msg_dest_node = old_msg_rec.msg_dest_node;
	new_msg_rec.msg_perm_priv = old_msg_rec.msg_perm_priv;
	new_msg_rec.msg_received  = old_msg_rec.msg_received;
	new_msg_rec.msg_reply_no[0] = old_msg_rec.msg_reply_no[0];
	new_msg_rec.msg_reply_no[1] = old_msg_rec.msg_reply_no[1];
	new_msg_rec.msg_reply_no[2] = old_msg_rec.msg_reply_no[2];
	new_msg_rec.msg_orig_no     = old_msg_rec.msg_orig_no;
	writefile(out_fileh,(char far *) &new_msg_rec,sizeof(new_msg_rec));
	fpos += (LONGINTEGER) sizeof(old_msg_rec);
    }
    _close(inp_fileh);
    closefile(out_fileh,out_file);
}

int import_user_msg(char *msg_path)
{
    LONGINTEGER fpos, flen;
    int inp_fileh, recno, res;
    char inp_file[80];
    DRAM far *mfcb;
    DRAM far *ufcb;
    USER_MSG_RECORD far *mp;
    USER_RECORD far *up;

    res = 0;
    printf("\nImporting: %sGTMAIL.CTL -> %sUSER_MSG.CTL\n\n",msg_path,msg_path);
    sprintf(inp_file,"%sGTMAIL.CTL",msg_path);
    if ((inp_fileh = _open(inp_file,O_RDWR)) < 0) {
	build_error(msg_path,"GTMAIL.CTL",FALSE);
	return(1);
    }
    mfcb = allocate_fcb();
    mp = mfcb->user_msg_rec;
    mfcb->dat_recsize = sizeof(USER_MSG_RECORD);
    mfcb->dat_keypos = 5;
    mfcb->dat_keytype = 1;
    FARstrcpy((char far *) (mfcb->dram_path),(char far *) msg_path);
    dram_slasher(mfcb);
    FARstrcpy((char far *) (mfcb->dram_fname),(char far *) "USER_MSG");
    if (dram(CREATE,mfcb)) {
	printf("\nERROR: Cannot create DRAM index and data file: %Fs%s",mfcb->dram_path,"USER_MSG");
	printf("\n       This can be caused by multiple entries in the GTMDIR.BBS file for the");
	printf("\n       same message base, or by files left from a previous conversion attempt.");
      printf("\n\n       If multiple attempts at import are made, you should erase all of the");
	printf("\n       USER.* and USER_MSG.* partially created by previous attempts.\n\n");
	sleep(5);
	res = 1;
	goto IMex;
    }
    ufcb = allocate_fcb();
    up = ufcb->user_rec;
    ufcb->dat_recsize = sizeof(USER_RECORD);
    ufcb->dat_keypos = 1;
    ufcb->dat_keytype = 0;
    FARstrcpy((char far *) (ufcb->dram_path),(char far *) lan_path);
    dram_slasher(ufcb);
    FARstrcpy((char far *) (ufcb->dram_fname),(char far *) "USER");
    if (dram(OPEN,ufcb)) {
	printf("\nERROR: Cannot open DRAM index and data file: %Fs%s\n",ufcb->dram_path,"USER");
	sleep(5);
	res = 1;
	goto IMex;
    }
    flen = filelength(inp_fileh);
    fpos = (LONGINTEGER) sizeof(old_user_rec);
    recno = 0;
    while (fpos < flen) {
	recno++;
	seekfile(inp_fileh,fpos,SEEK_SET);
	readfile(inp_fileh,(char far *) &old_user_rec,sizeof(old_user_rec));
	pas_to_c(ufcb->string_key,old_user_rec.old_user_name,30);
	proper(ufcb->string_key);
	if (! dram(READ,ufcb)) {
	    mp->user_msg_deleted = 0;
	    mp->user_msg_prior_read = old_user_rec.old_user_msg_number;
	    mp->user_msg_highest_scan = old_user_rec.old_user_msg_number;
	    mp->user_msg_banned = old_user_rec.old_user_banned;
	    mp->user_msg_caller_no = up->user_caller_no;
	    mp->user_msg_hash_code = up->user_hash_code;
	    mp->user_msg_marked[0] =
	      mp->user_msg_marked[1] = 0;
	    if (!(recno % 25))
		printf("%5d.  %-32Fs%-32Fs\n",recno,up->user_name,up->user_home);
	    FARstrcpy((char far *) (mfcb->string_key),(char far *) (up->user_name));
	    mfcb->binary_key = up->user_caller_no;
	    root = tree(root,up->user_caller_no,up->user_hash_code);
	    dram(APPEND,mfcb);
	}
	fpos += (LONGINTEGER) sizeof(old_user_rec);
    }
    dram(CLOSE,ufcb);
    dram(CLOSE,mfcb);
IMex:
    _close(inp_fileh);
    release_fcb(ufcb);
    ufcb=NULL;
    release_fcb(mfcb);
    mfcb=NULL;
    return(res);
}

int strip_nl(char *s,int imax)
{
    register int j, lmax;

    lmax = imax - 1;
    j = 0;
    while ((s[j]) && (s[j] != '\n') && (s[j] != '\r') && (j < lmax))
	j++;
    s[j] = 0;
    return(j);
}

void scan_msg_bases(int typ)
{
    REGISTER j;
    int rebuild_board_joins;
    char gtmdir[80], msg_path[80], wrk[262], group_name[80];
    char previous_msg_path[80], inp[80];
    FILE *fd;

    rebuild_board_joins = 0;
    if (typ == 3) {
	printf("\nDo you wish to rebuild the Board Join files?  [y/N] ");
	up_gets(inp);
	if (inp[0] == 'Y')
	    rebuild_board_joins = 1;
    }
    root = NULL;
    group_name[0] = 0;
    sprintf(gtmdir,"%sGTMDIR.BBS",gtpath);
    if ((fd = fopen(gtmdir,"rt")) == NULL) {
	sprintf(gtmdir,"%sGTMDIR.BBS",bbs_path);
	if ((fd = fopen(gtmdir,"rt")) == NULL) {
	    printf("\nCannot find the %s file.\n",gtmdir);
	    sleep(5);
	    return;
	}
    }
    clrscr();
    previous_msg_path[0] = 0;
    while (! feof(fd)) {
	if (fgets(wrk,260,fd) == NULL)
	    goto ScanExit;
	if ((strip_nl(wrk,260)) > 5) {
	    if (wrk[0] == '.') {
		if ((typ == 0) || (rebuild_board_joins)) {
		    if (root != NULL) {
			create_board_join(group_name);
			tree_erase(root);
		    }
		    root = NULL;
		}
		while ((wrk[0] != ' ') && (wrk[0]))
		    delete((char far *) wrk,1,1);
		while (wrk[0] == ' ')
		    delete((char far *) wrk,1,1);
		if ((j = pos(" ",wrk)))
		    wrk[j] = 0;
		wrk[79] = 0;
		strcpy(group_name,wrk);
		strupr(group_name);
		if ((typ == 3)&&(!rebuild_board_joins))
		    clean_up_board_joins(group_name);
	    }
	    else {
		if (wrk[0] > ' ') {
		    while ((wrk[0] != ' ') && (wrk[0]))
			delete((char far *) wrk,1,1);
		    while (wrk[0] == ' ')
			delete((char far *) wrk,1,1);
		    if ((j = pos(" ",wrk)))
			wrk[j] = 0;
		    if ((j = pos(",",wrk)))
			wrk[j] = 0;
		    wrk[79] = 0;
		    strcpy(msg_path,wrk);
		    process_pathname(msg_path);
		    if (! strcmp(previous_msg_path,msg_path))
			continue;
		    strcpy(previous_msg_path,msg_path);
		    switch (typ) {
		    case 0:
			if ((import_user_msg(msg_path)) == 0)
			    import_msg(msg_path);
			break;
		    case 1:
			delete_messages(msg_path);
			break;
		    case 2:
			renumber_messages(msg_path);
			break;
		    case 3:
			clean_up_user_msg_file(msg_path,rebuild_board_joins);
			break;
		    }
		}
	    }
	}
    }
ScanExit:
    if ((typ == 0) || (rebuild_board_joins)) {
	if (root != NULL) {
	    create_board_join(group_name);
	    tree_erase(root);
	}
	root = NULL;
    }
    fclose(fd);
}

void up_gets(char *s)
{
    gets(s);
    strupr(s);
}

void build_ctl(void)
{
    char wrk[80];

    printf("\nDo you wish to import the user control file? ");
    up_gets(wrk);
    if (wrk[0] == 'Y')
	build_user_ctl();
    printf("\nDo you wish to import the message control files? ");
    up_gets(wrk);
    if (wrk[0] == 'Y')
	scan_msg_bases(0);
}

void insert(char *addstring,char far *newstring,int index)
{
    char temp[512];
    REGISTER k;

    temp[0] = 0;
    if ((! newstring[0]) || (index > FARstrlen(newstring)))
	;
    else  {
        k = index - 1;
        copy_p(temp,(newstring + k),510);
        newstring[k] = 0;
    }
    FARstrcat(newstring,(char far *) addstring);
    FARstrcat(newstring,(char far *) temp);
}

void delete(char far *destin,int start,int size)
{
    REGISTER j, m, k;

    if (k = FARstrlen(destin)) {
        j = start - 1;
	destin[j] = 0;
        m = j + size;
	if (m < k)
            FARstrcpy(&destin[j],&destin[m]);
    }
}

void trim(char far *st)
{
    REGISTER i;

    i = 0;
    while (st[i] <= ' ')
       i++;
    if (i)
	delete(st,1,i);
    i = FARstrlen(st);
    do {
       st[i--] = 0;
    } while ((i >= 0) && (st[i] <= ' '));
}

int pos(char *searchtag,char far *fulltag)
{
    REGISTER i, j;
    int lensrch;

    if (lensrch = strlen(searchtag)) {
	j = FARstrlen(fulltag) - lensrch + 1;
	for (i = 0; i < j; i++) {
	    if (! FARstrncmp((char far *) searchtag,(char far *) (fulltag + i),lensrch))
		return(i);
        }
	return(-1);
    }
    return(0);
}

void copy_p(char *ds,char far *ss,int k)
{
    REGISTER i, j;

    i = 0;
    j = k - 1;
    do {
	if (! (ds[i] = ss[i])) return;
    } while (++i < j);
    ds[j] = 0;
}

void proper(char far *s)
{
    REGISTER i, j, k, m;

    trim(s);
    if (!s[0])
	return;
    for (i = 0; s[i]; i++) {
	if ((s[i]<32) || (s[i]==';') || (s[i]=='%'))
	    s[i] = ' ';
    }
    FARstrupr(s);
    i = 0;
    while (s[++i]) {
	if ((s[i] >= 'A') && (s[i] <= 'Z')) {
	    if (s[i] == 'D') {
		j = i - 1;
		k = j - 1;
		m = k - 1;
		if (m >= 0) {
		    if ((s[m]=='M') && (s[k]=='a') && (s[j]=='c'))
			goto ProperLoop;
		}
	    }
	    s[i] = _tolower(s[i]);
	    goto McCheck;
	}
	switch (s[i]) {
	case ',':
	    insert(" ",s,(i+2));
	    break;
	case '-':
	case '_':
	    goto UpperMc;
	case '.':
	    j = i - 1;
	    k = j - 1;
	    if (k >= 0) {
		k = toupper(s[k]);
		if ((k >= 'A') && (k <= 'Z'))
		    break;
	    }
	    s[j] = toupper(s[j]);
	    break;
	case ' ':
	case 39:
	    j = i + 1;
	    while (s[j] == ' ')
		delete(s,(j+1),1);
	    k = FARstrlen(s);
	    if (j < k) {
		s[j] = toupper(s[j]);
		i = j;
	    }
	    break;
	default:
McCheck:
	    if (s[i] == 'c') {
		j = i - 1;
		if (j >= 0) {
		    if (s[j] == 'M')
			goto UpperMc;
		}
	    }
	}
	goto ProperLoop;
UpperMc:
	i++;
	s[i] = toupper(s[i]);
ProperLoop:
	;
    }
}

char *gttime(void)
{
    static char function[16];
    int hr;
    union REGS regs;

    regs.x.ax = 0x2c00;
    intdos(&regs,&regs);
    hr = regs.h.ch;
    if (! hr) hr = 24;
    strcpy(function,build_time(hr,regs.h.cl));
    function[5] = 0;
    return(function);
}

char *date(void)
{
    static char function[16];
    union REGS regs;

    regs.x.ax = 0x2a00;
    intdos(&regs,&regs);
    strcpy(function,build_date(regs.h.dh,regs.h.dl,regs.x.cx));
    return(function);
}

int integer_input(char *p)
{
    char input_string[80];
    int result;

    printf("%s",p);
    gets(input_string);
    trim((char far *)input_string);
    result = atoi(input_string);
    return(result);
}

char bool_input(char *p)
{
    char input_string[80];

    printf("%s",p);
    up_gets(input_string);
    trim((char far *)input_string);
    if ((input_string[0] == 'T') || (input_string[0] == 'Y'))
	return(1);
    return(0);
}

char *bool_print(char bc)
{
    if (bc)
	return("TRUE");
    return("FALSE");

}

char char_input(char *p)
{
    char input_string[80];

    printf("%s",p);
    gets(input_string);
    trim((char far *)input_string);
    return(input_string[0]);
}

void str_input(char far *d,char *p,int n)
{
    char input_string[512];

    printf("%s",p);
    gets(input_string);
    input_string[n] = 0;
    FARstrcpy(d,(char far *) input_string);
}

int extract_number(char *s,int *p)
{
    int result, j, ch;

    j = (*p);
    result = 0;
    while (((ch = s[j]) < '0') || (ch > '9')) {
	if (! ch)
	    return(MAXINT);
	j++;
    }
    while (((ch = s[j]) >= '0') && (ch <= '9')) {
	result = (result * 10) + ch - '0';
	j++;
    }
    *p = j;
    return(result);
}

void date_input(char far *dst,char *p)
{
    char input_string[512];
    int m, d, y, i;

    printf("%s",p);
    gets(input_string);
    if (input_string[0]==' ') {
	if ((input_string[1]==0)||(input_string[1]==' ')) {
	    dst[0]=' ';
	    dst[1]=0;
	    return;
	}
    }
    trim((char far *) input_string);
    input_string[10] = 0;
    i = 0;
    m = extract_number(input_string,&i);
    if ((m > 0) && (m < 13)) {
	d = extract_number(input_string,&i);
	if ((d > 0) && (d < 32)) {
	    y = extract_number(input_string,&i);
	    if ((y >= 0) && (y < 3000))
		strcpy(input_string,build_date(m,d,y));
	}
    }
    input_string[8] = 0;
    FARstrcpy(dst,(char far *) input_string);
}

void add_user(void)
{
    LONGINTEGER caller_no;
    char cname[31], dwrk[16];
    DRAM far *fcb;
    USER_RECORD far *p;
    IDX_RECORD  far *xp;

    fcb = allocate_fcb();
    p  = fcb->user_rec;
    xp = fcb->idx_rec;
    fcb->dat_recsize = sizeof(USER_RECORD);
    fcb->dat_keypos = 1;
    fcb->dat_keytype = 0;
    FARstrcpy((char far *) (fcb->dram_path),(char far *) lan_path);
    dram_slasher(fcb);
    FARstrcpy((char far *) (fcb->dram_fname),(char far *) "USER");
    if (dram(OPEN,fcb)) {
	import_error("USER",lan_path);
	return;
    }
    seekfile(fcb->dat_handle,0L,SEEK_SET);
    readfile(fcb->dat_handle,(char far *) p,sizeof(USER_RECORD));
    caller_no = p->user_caller_no;
    clrscr();
    printf("Add new user records:\n");
    do {
	printf("\nEnter new caller's name : ");
	gets(cname);
	if (! cname[0])
	    goto Loop;
	FARstrcpy((char far *) (fcb->string_key),(char far *) cname);
	if (! dram(READ,fcb)) {
	    clrscr();
	    printf("Already registered!\n\n");
	    printf("Record Number ... %u\n",xp->hash_ptr);
	    printf("Caller Name ..... %Fs\n",p->user_name);
	    printf("City & State .... %Fs\n",p->user_home);
	    printf("Phone Number .... %Fs\n",p->user_phone);
            printf("Password ........ %Fs\n",p->user_password);
            printf("Access Level .... %c\n",p->user_privel);
            printf("First -Date ..... %Fs\n",p->user_first_date);
	    printf("First -Time ..... %Fs\n",p->user_first_time);
            printf("No. of Calls .... %d\n",p->user_times_on);
            printf("Last -Date ...... %Fs\n",p->user_last_date);
            printf("Last -Time ...... %Fs\n",p->user_last_time);
            printf("Netmail Credit .. %d\n",p->user_credit);
            printf("Netmail Charges . %d\n",p->user_charges);
	    printf("Deleted Flag .... %s\n",bool_print(p->user_deleted));
	    printf("Banned Flag ..... %s\n",bool_print(p->user_banned));
	    printf("Expire Date ..... %s\n",calcdate(p->user_expire_date));
	    goto Loop;
	}
        FARmemset((char far *) p,0,sizeof(USER_RECORD));
        p->user_deleted = 0;
        FARstrcpy((char far *) (p->user_name),(char far *) cname);
        proper(p->user_name);
	printf("\nCaller Name ........ %Fs\n",p->user_name);
        str_input(p->user_home,"City & State ....... ",30);
	proper(p->user_home);
        str_input(p->user_phone,"Phone Number ....... ",10);
        str_input(p->user_password,"Password ........... ",20);
	FARstrupr((char far *) (p->user_password));
        p->user_privel =       char_input("Access Level ....... ");
        FARstrcpy((char far *) (p->user_last_date),(char far *) date());
	trim(p->user_last_date);
	FARstrcpy((char far *) (p->user_last_time),(char far *) gttime());
	FARstrcpy((char far *) (p->user_first_date),(char far *) (p->user_last_date));
	FARstrcpy((char far *) (p->user_first_time),(char far *) (p->user_last_time));
        p->user_credit =    integer_input("Netmail Credit ..... ");
	p->user_banned =       bool_input("Banned Flag ........ ");
	dwrk[0] = 0;
	date_input((char far *) dwrk,"Expire Date ........ ");
	p->user_expire_date = daynumber(dwrk);
	p->user_protocol = toupper(char_input("Transfer Protocol .. "));
	if (p->user_protocol == 0)
	    p->user_protocol = ' ';
        p->user_screen_lgth = integer_input("Screen Length ...... ");
	if ((p->user_screen_lgth < 1) || (p->user_screen_lgth > 999))
	    p->user_screen_lgth = 24;
	p->user_caller_no = (++caller_no);
	FARstrcpy((char far *) (fcb->string_key),(char far *) (p->user_name));
	fcb->binary_key = p->user_caller_no;
	dram(ADD,fcb);
        seekfile(fcb->dat_handle,0L,SEEK_SET);
        readfile(fcb->dat_handle,(char far *) p,sizeof(USER_RECORD));
        p->user_caller_no = caller_no;
        seekfile(fcb->dat_handle,0L,SEEK_SET);
        writefile(fcb->dat_handle,(char far *) p,sizeof(USER_RECORD));
Loop:
        ;
    } while (cname[0]);
    dram(CLOSE,fcb);
    release_fcb(fcb);
    fcb=NULL;
}

void integer_ed(char *msk,unsigned far *i,int il)
{
    register int k,j;
    char s[80];
    char sp[50];

    strcpy(sp,"                                                 ");
    k = (strlen(msk) - 4);
    sp[k] = 0;
    printf(msk,*i);
    j=(*i);
    itoa(j,s,10);
    str_input((char far *) s,sp,il);
    if (s[0])
	*i = atoi(s);
}

void string_ed(char *msk,char far *is,int il)
{
    REGISTER k;
    char s[80];
    char sp[50];

    strcpy(sp,"                                                 ");
    k = (strlen(msk) - 4);
    sp[k] = 0;
    printf(msk,is);
    FARstrcpy((char far *) s,is);
    str_input((char far *) s,sp,il);
    if (s[0]) {
	s[il] = 0;
	FARstrcpy(is,(char far *) s);
    }
}

void date_ed(char *msk,char *is)
{
    REGISTER k;
    char s[80];
    char sp[50];

    strcpy(sp,"                                                 ");
    k = (strlen(msk) - 3);
    sp[k] = 0;
    printf(msk,is);
    strcpy(s,is);
    date_input((char far *) s,sp);
    if ((s[1]==0)&&(s[0]==' ')) 
	is[0]=0;
    else
	if (s[0]) 
	    strcpy(is,s);
}

char *edit_user(int item,DRAM far *fcb)
{
    char s[82];
    char dwrk[32];
    USER_RECORD far *p;
    IDX_RECORD  far *xp;
    unsigned cnum;

    if (! item)
	return("");
    p  = fcb->user_rec;
    xp = fcb->idx_rec;
    printf("\n");
    switch (item) {
    case 1:
	string_ed("1. City & State .. %Fs\n",p->user_home,30);
	process_city_state(fcb);
	break;
    case 2:
	string_ed("2. Phone Number .. %Fs\n",p->user_phone,10);
	break;
    case 3:
	string_ed("3. Password .. %Fs\n",p->user_password,20);
	FARstrupr((char far *) (p->user_password));
	break;
    case 4:
	printf("4. Access Level .. %c\n",p->user_privel);
	s[0] = p->user_privel;
	s[1] = 0;
	str_input((char far *) s,"                   ",1);
	if (s[0])
	    p->user_privel = s[0];
	break;
    case 5:
	string_ed("5. First Call -Date .. %Fs\n",p->user_first_date,8);
	break;
    case 6:
	string_ed("6. First Call -Time .. %Fs\n",p->user_first_time,5);
	break;
    case 7:
	integer_ed("7. No. of Calls .. %Fu\n",&(p->user_times_on),5);
	break;
    case 8:
	string_ed("8. Last Call -Date .. %Fs\n",p->user_last_date,8);
	break;
    case 9:
	string_ed("9. Last Call -Time .. %Fs\n",p->user_last_time,5);
	break;
    case 10:
	integer_ed("10. Netmail Credits .. %Fu\n",&(p->user_credit),5);
	break;
    case 11:
	integer_ed("11. Netmail Charges .. %Fu\n",&(p->user_charges),5);
	break;
    case 12:
	if (p->user_banned)
	    return("Cannot change the \"Deleted Flag\".  This caller is banned!");
	else {
	    strcpy(s,bool_print(p->user_deleted));
	    printf("12. Deleted Flag .. %s\n",s);
	    str_input((char far *) s,"                    ",5);
	    if (s[0]) {
		strupr(s);
		p->user_deleted = 0;
		if ((s[0] == 'Y') || (s[0] == 'T')) {
		    p->user_deleted = 1;
		}
		seekfile(fcb->idx_handle,fcb->idxfpos,SEEK_SET);
		readfile(fcb->idx_handle,(char far *) xp,sizeof(IDX_RECORD));
		xp->hash_del_flg = p->user_deleted;
		seekfile(fcb->idx_handle,fcb->idxfpos,SEEK_SET);
		writefile(fcb->idx_handle,(char far *) xp,sizeof(IDX_RECORD));
	    }
	}
	break;
    case 13:
	if (p->user_deleted)
	    return("Cannot change the \"Banned Flag\".  This caller is deleted!");
	else {
	    strcpy(s,bool_print(p->user_banned));
	    printf("13. Banned Flag .. %s\n",s);
	    str_input((char far *) s,"                   ",5);
	    if (s[0]) {
		strupr(s);
		p->user_banned = 0;
		if ((s[0] == 'Y') || (s[0] == 'T')) {
		    p->user_banned = 1;
		}
	    }
	}
	break;
    case 14:
	s[0] = p->user_protocol;
	s[1] = 0;
	printf("14. Transfer Protocol .. %s\n",s);
	str_input((char far *) s,"                         ",1);
	if (s[0]) {
	    p->user_protocol = toupper(s[0]);
	}
	break;
    case 15:
	integer_ed("15. Screen Length .. %Fu\n",&(p->user_screen_lgth),2);
	break;
    case 16:
	integer_ed("16. Upload K .. %Fu\n",&(p->user_upload_k),5);
	break;
    case 17:
	integer_ed("17. Files Uploaded .. %Fu\n",&(p->user_upload_files),5);
	break;
    case 18:
	integer_ed("18. Download K .. %Fu\n",&(p->user_dnload_k),5);
	break;
    case 19:
	integer_ed("19. Files Downloaded .. %Fu\n",&(p->user_dnload_files),5);
	break;
    case 20:
	strcpy(s,bool_print(p->user_more));
	printf("20. Continuous Output .. %s\n",s);
	str_input((char far *) s,"                         ",5);
	if (s[0]) {
	    strupr(s);
	    p->user_more = 0;
	    if ((s[0] == 'Y') || (s[0] == 'T')) {
		p->user_more = 1;
	    }
	}
	break;
    case 21:
	strcpy(s,bool_print(p->user_expert));
	printf("20. Expert Mode .. %s\n",s);
	str_input((char far *) s,"                   ",5);
	if (s[0]) {
	    strupr(s);
	    p->user_expert = 0;
	    if ((s[0] == 'Y') || (s[0] == 'T')) {
		p->user_expert = 1;
	    }
	}
	break;
    case 22:
	cnum = (unsigned) p->user_caller_no;
	integer_ed("22. Caller Number .. %Fu\n",(unsigned far *) &cnum,5);
	p->user_caller_no = cnum;
	break;
    case 23:
	cnum = (unsigned) p->user_day_calls;
	integer_ed("23. Calls Today .. %Fu\n",(unsigned far *) &cnum,2);
	p->user_day_calls = cnum;
	break;
    case 24:
	strcpy(dwrk,calcdate(p->user_expire_date));
	date_ed("24. Expire Date .. %s\n",dwrk);
	p->user_expire_date = daynumber(dwrk);
	break;
    case 25:
	integer_ed("25. Download K Today .. %Fu\n",&(p->user_day_dnload_k),5);
	break;
    case 26:
	integer_ed("26. Time Bank .. %Fd\n",(unsigned far *) &(p->user_time_bank),5);
	break;
    case 27:
	string_ed("27. CB Handle .. %Fs\n",p->user_cb_handle,10);
	break;
    }
    return("");
}

void display_record(USER_RECORD far *up,unsigned rp)
{
    printf("\nCaller Name : %-32Fs Record Number : %u\n\n",up->user_name,rp);
    printf(" 1. City & State ...... %Fs\n",up->user_home);
    printf(" 2. Phone Number ...... %-20Fs 15. Screen Length .... %u\n",up->user_phone,up->user_screen_lgth);
    printf(" 3. Password .......... %-20Fs 16. Upload K ......... %u\n",up->user_password,up->user_upload_k);
    printf(" 4. Access Level ...... %-20c 17. Files Uploaded ... %u\n",up->user_privel,up->user_upload_files);
    printf(" 5. First -Date ....... %-20Fs 18. Download K ....... %u\n",up->user_first_date,up->user_dnload_k);
    printf(" 6. First -Time ....... %-20Fs 19. Files Downloaded . %u\n",up->user_first_time,up->user_dnload_files);
    printf(" 7. No. of Calls ...... %-20u 20. Continuous Output  %s\n",up->user_times_on,bool_print(up->user_more));
    printf(" 8. Last -Date ........ %-20Fs 21. Expert Mode ...... %s\n",up->user_last_date,bool_print(up->user_expert));
    printf(" 9. Last -Time ........ %-20Fs 22. Caller Number .... %lu\n",up->user_last_time,up->user_caller_no);
    printf("10. Netmail Credit .... %-20u 23. Calls Today ...... %d\n",up->user_credit,up->user_day_calls);
    printf("11. Netmail Charges ... %-20u 24. Expire Date ...... %s\n",up->user_charges,calcdate(up->user_expire_date));
    printf("12. Deleted Flag ...... %-20s 25. Download K Today . %u\n",bool_print(up->user_deleted),up->user_day_dnload_k);
    printf("13. Banned Flag ....... %-20s 26. Time Bank ........ %d\n",bool_print(up->user_banned),up->user_time_bank);
    printf("14. Transfer Protocol . %-20c 27. CB Handle ........ %Fs\n\n",up->user_protocol,up->user_cb_handle);
}

void find_user(int direct,char *msg_path)
{
    LONGINTEGER datflen;
    int action, edit_allowed, go_to, item, w;
    char cname[31], cmd[82];
    char *edit_error;
    int no_record;
    BOOLEAN msg_ban;
    DRAM far *ufcb;
    DRAM far *mfcb;
    USER_RECORD far *up;
    IDX_RECORD far *uxp;
    IDX_RECORD far *mxp;
    USER_MSG_RECORD far *mp;

    ufcb = allocate_fcb();
    up  = ufcb->user_rec;
    uxp = ufcb->idx_rec;
    ufcb->dat_recsize = sizeof(USER_RECORD);
    ufcb->dat_keypos = 1;
    ufcb->dat_keytype = 0;
    FARstrcpy((char far *) (ufcb->dram_path),(char far *) lan_path);
    dram_slasher(ufcb);
    FARstrcpy((char far *) (ufcb->dram_fname),(char far *) "USER");
    if (dram(OPEN,ufcb)) {
	import_error("USER",lan_path);
	return;
    }
    mfcb = allocate_fcb();
    mp = mfcb->user_msg_rec;
    mxp = mfcb->idx_rec;
    mfcb->dat_recsize = sizeof(USER_MSG_RECORD);
    mfcb->dat_keypos = 5;
    mfcb->dat_keytype = 1;
    FARstrcpy((char far *) (mfcb->dram_path),(char far *) msg_path);
    dram_slasher(mfcb);
    FARstrcpy((char far *) (mfcb->dram_fname),(char far *) "USER_MSG");
    if (dram(OPEN,mfcb)) {
	import_error("USER_MSG",msg_path);
	return;
    }
    if (direct) goto DAccess;
Loop:
    printf("\nEnter caller's name : ");
    edit_allowed = 0;
    gets(cname);
    if (! cname[0])
	goto Lexit;
Locate1:
    edit_error = "";
Locate2:
    FARstrcpy((char far *) (ufcb->string_key),(char far *) cname);
    if (! dram(READ,ufcb)) {
	FARstrcpy((char far *) (mfcb->string_key),(char far *) (up->user_name));
	mfcb->binary_key = up->user_caller_no;
	no_record = 0;
	if (dram(READ,mfcb)) {
	    FARmemset((char far *) mp,0,sizeof(USER_MSG_RECORD));
	    no_record = 1;
	}
        clrscr();
	printf("%s\n",edit_error);
	display_record(up,uxp->hash_ptr);
	if (no_record) {
	    printf("\n     No message base record on file for this caller.\n");
	}
	else {
	    printf("     Prior message read    %-5d      Highest message Scanned     %-5d\n",
	        mp->user_msg_prior_read,mp->user_msg_highest_scan);
	    printf("     Message base ban      %-5s      Message base Caller Number  %-5lu\n",
	        bool_print(mp->user_msg_banned),mp->user_msg_caller_no);
	}
	printf("\n(1-26)Edit  (T)oggle Msg Ban  ");
	edit_allowed = 1;
    }
    else {
        printf("\nNot found!\n\n");
    }
    printf("(L)ookup  (F)rwd  (B)kwrd  (G)oto  (Q)uit: ");
cBksp:
    cmd[0] = my_getkey(1);
    cmd[1] = 0;
    if (cmd[0]=='\x08')
	goto cBksp;
    strupr(cmd);
    action = cmd[0];
    item = 0;
    if ((action >= '1') && (action <= '9')) {
	w = 0;
	item = action - '0';
	action = 'E';
	if ((item == 1) || (item == 2)) {
	    cmd[1] = my_getkey(0);
	    cmd[2] = 0;
	    if (cmd[1]=='\x08')
		goto cBksp;
	    w = cmd[1];
	    if ((w >= '0') && (w <= '9')) {
		item = (item * 10) + w - '0';
	    }
	}
    }
    printf("\n");
    switch (action) {
	case 'Q':
	    goto Lexit;
	case 'T':
	    if (edit_allowed) {
		msg_ban = 1;
		if (mp->user_msg_banned)
		    msg_ban = 0;
		mp->user_msg_banned = msg_ban;
		mfcb->datfpos = (((LONGINTEGER) mxp->hash_ptr) * ((LONGINTEGER) sizeof(USER_MSG_RECORD)));
		seekfile(mfcb->dat_handle,mfcb->datfpos,SEEK_SET);
		writefile(mfcb->dat_handle,(char far *) mp,sizeof(USER_MSG_RECORD));
		goto Locate2;
	    }
	case 'E':
	    if (edit_allowed) {
		edit_error = edit_user(item,ufcb);
		ufcb->datfpos = (((LONGINTEGER) uxp->hash_ptr) * ((LONGINTEGER) sizeof(USER_RECORD)));
		trim(up->user_first_date);
		trim(up->user_last_date);
		seekfile(ufcb->dat_handle,ufcb->datfpos,SEEK_SET);
		writefile(ufcb->dat_handle,(char far *) up,sizeof(USER_RECORD));
		goto Locate2;
	    }
	    break;
	case 'N':
	case 'F':
	case '+':
	case '=':
	    uxp->hash_ptr++;
            ufcb->datfpos = (((LONGINTEGER) uxp->hash_ptr) * ((LONGINTEGER) sizeof(USER_RECORD)));
	    datflen = filelength(ufcb->dat_handle);
	    if (ufcb->datfpos >= datflen) {
		ufcb->datfpos = ((LONGINTEGER) sizeof(USER_RECORD));
	    }
	    seekfile(ufcb->dat_handle,ufcb->datfpos,SEEK_SET);
	    readfile(ufcb->dat_handle,(char far *) up,sizeof(USER_RECORD));
	    FARstrcpy((char far *) cname,(char far *) (up->user_name));
	    goto Locate1;
	case 'P':
	case 'B':
	case '-':
	case '_':
	    uxp->hash_ptr--;
            ufcb->datfpos = (((LONGINTEGER) uxp->hash_ptr) * ((LONGINTEGER) sizeof(USER_RECORD)));
	    if (ufcb->datfpos <= 0) {
		datflen = filelength(ufcb->dat_handle);
		ufcb->datfpos = (datflen - ((LONGINTEGER) sizeof(USER_RECORD)));
            }
	    seekfile(ufcb->dat_handle,ufcb->datfpos,SEEK_SET);
	    readfile(ufcb->dat_handle,(char far *) up,sizeof(USER_RECORD));
	    FARstrcpy((char far *) cname,(char far *) (up->user_name));
	    goto Locate1;
	case 'G':
DAccess:
	    go_to = integer_input("\nEnter record number : ");
            ufcb->datfpos = (((LONGINTEGER) go_to) * ((LONGINTEGER) sizeof(USER_RECORD)));
	    datflen = filelength(ufcb->dat_handle);
	    if ((ufcb->datfpos > 0) && (ufcb->datfpos < datflen)) {
		seekfile(ufcb->dat_handle,ufcb->datfpos,SEEK_SET);
		readfile(ufcb->dat_handle,(char far *) up,sizeof(USER_RECORD));
		FARstrcpy((char far *) cname,(char far *) (up->user_name));
		goto Locate1;
	    }
	    break;
	case 'L':
	    break;
	default:
	    break;
    }
    goto Loop;
Lexit:
    dram(CLOSE,mfcb);
    dram(CLOSE,ufcb);
    release_fcb(mfcb);
    mfcb=NULL;
    release_fcb(ufcb);
    ufcb=NULL;
}

void delete_user(void)
{
    char cname[80];
    DRAM far *fcb;
    USER_RECORD far *p;

    fcb = allocate_fcb();
    p  = fcb->user_rec;
    fcb->dat_recsize = sizeof(USER_RECORD);
    fcb->dat_keypos = 1;
    fcb->dat_keytype = 0;
    FARstrcpy((char far *) (fcb->dram_path),(char far *) lan_path);
    dram_slasher(fcb);
    FARstrcpy((char far *) (fcb->dram_fname),(char far *) "USER");
    if (dram(OPEN,fcb)) {
	import_error("USER",lan_path);
	return;
    }
    clrscr();
    printf("Delete user records:\n");
Loop:
    printf("\nEnter the caller's name to delete : ");
    gets(cname);
    if (! cname[0])
	goto Dex;
    FARstrcpy((char far *) (fcb->string_key),(char far *) cname);
    if (dram(READ,fcb)) {
	printf("\nNot found!\n");
	goto Loop;
    }
    printf("\n");
    printf("Caller Name  : %Fs\n",p->user_name);
    printf("City & State : %Fs",p->user_home);
    if (p->user_banned)
	printf("\n\nCannot delete.  This caller is banned!\n");
    else {
	dram(DELETE,fcb);
        printf("\n\nDeleted!\n");
    }
    goto Loop;
Dex:
    dram(CLOSE,fcb);
    release_fcb(fcb);
    fcb=NULL;
}

void examine_lost(void)
{
    DRAM far *fcb;
    char cns[80];
    unsigned cnum;
    LONGINTEGER snum;
    USER_RECORD far *p;

    fcb = allocate_fcb();
    p  = fcb->user_rec;
    fcb->dat_recsize = sizeof(USER_RECORD);
    fcb->dat_keypos = 1;
    fcb->dat_keytype = 0;
    FARstrcpy((char far *) (fcb->dram_path),(char far *) lan_path);
    dram_slasher(fcb);
    FARstrcpy((char far *) (fcb->dram_fname),(char far *) "USER");
    if (dram(OPEN,fcb)) {
	import_error("USER",lan_path);
	return;
    }
    printf("\nEnter the record # of interest: ");
    gets(cns);
    if (cns[0]) {
	clrscr();
	cnum=atoi(cns);
	snum=(((LONGINTEGER) cnum) * ((LONGINTEGER) sizeof(USER_RECORD)));
	seekfile(fcb->dat_handle,snum,SEEK_SET);
	readfile(fcb->dat_handle,(char far *) p,sizeof(USER_RECORD));
	printf("\nRecord Offset : %ld",snum);
	display_record(p,cnum);
	pause_to_read(TRUE);
    }
    dram(CLOSE,fcb);
    release_fcb(fcb);
    fcb=NULL;
}

int flake_scan(char *inp)
{
    int j, c;

    for (j=0; (c = (inp[j] & 0x00FF)); j++) {
	if ((c==0x7B)||(c==0x7F)||(c==0xFB)||(c==0xAE)||(c==0xAF)||(c==0xDB)||(c==0xFE))
	    return(1);
    }
    return(0);
}

void clean_up_user_file(void)
{
    LONGINTEGER fpos, flen;
    int inp_fileh, remove_dels, trash_removal, bad_one;
    int date_purge, remove_expired;
    unsigned call_override;
    INTEGER curr_daynumber;
    int expire_limit, day_override, expire_daynumber, user_daynumber;
    char privel_override;
    LONGINTEGER callerno;
    char inp_file[80];
    char inp[80];
    DRAM far *fcb;
    USER_RECORD far *p;

    clrscr();
    curr_daynumber = daynumber(date());
    printf("\nDo you wish to purge deleted records?   [y/N]  ");
    up_gets(inp);
    remove_dels = 0;
    if (inp[0] == 'Y')
	remove_dels = 1;
    printf("\nDo you wish to scan trashed records?    [y/N]  ");
    up_gets(inp);
    trash_removal = 0;
    if (inp[0] == 'Y')
	trash_removal = 1;
    printf("\nDo you wish to remove expired records?  [y/N]  ");
    up_gets(inp);
    remove_expired = 0;
    if (inp[0] == 'Y')
	remove_expired = 1;
    expire_limit = 30;
    if (remove_expired) {
	printf("\n    Max number of days since expiration     : ");
	gets(inp);
	if (inp[0]) 
	    expire_limit = atoi(inp);
    }
Oldies:
    printf("\nDo you wish to purge inactive records?  [y/N]  ");
    up_gets(inp);
    date_purge =
      privel_override = 0;
    day_override =
      call_override = 32767;
    if (inp[0] == 'Y') {
	date_purge = 1;
	printf("\n    Max number of days since last call      : ");
	gets(inp);
	if (inp[0]) {
	    if ((day_override = atoi(inp)) < 90) {
		printf("\nRemove users that have been inactive for %d days?? [y/N]  ",day_override);
		up_gets(inp);
		if (inp[0] != 'Y')
		    goto Oldies;
		printf("\n");
	    }
	}
	printf(  "    Access level to override removal        : ");
	gets(inp);
	if (inp[0] >= '0')
	    privel_override = inp[0];
	printf("    Number of calls to override removal     : ");
	gets(inp);
	if (inp[0])
	    call_override = atoi(inp);
	printf("\nAre you sure? [Y/n]  ");
	up_gets(inp);
	if (inp[0] == 'N')
	    goto Oldies;
	printf("\n");
    }
    backup_file(lan_path,"USER","IDX","O_USER");
    backup_file(lan_path,"USER","CTL","O_USER");
    printf(  "\nIf this process does not complete successfully, the USER files can be");
    printf(  "\nrecovered by copying files as shown below:");
    printf("\n\n                       COPY  O_USER.CTL  USER.CTL");
    printf(  "\n                       COPY  O_USER.IDX  USER.IDX");
    sleep(5);
    printf("\n\nConstructing new index: %sUSER.IDX\n\n",lan_path);
    sprintf(inp_file,"%sO_USER.CTL",lan_path);
    if ((inp_fileh = _open(inp_file,O_RDWR)) < 0) {
	build_error(lan_path,"O_USER.CTL",TRUE);
	return;
    }
    fcb = allocate_fcb();
    p = fcb->user_rec;
    fcb->dat_recsize = sizeof(USER_RECORD);
    fcb->dat_keypos = 1;
    fcb->dat_keytype = 0;
    FARstrcpy((char far *) (fcb->dram_path),(char far *) lan_path);
    dram_slasher(fcb);
    FARstrcpy((char far *) (fcb->dram_fname),(char far *) "USER");
    if (dram(CREATE,fcb)) {
	printf("ERROR: Cannot create DRAM index and data file: %Fs%Fs",fcb->dram_path,fcb->dram_fname);
	pause_to_read(TRUE);
	goto Conex;
    }
    flen = filelength(inp_fileh);
    fpos = (LONGINTEGER) sizeof(USER_RECORD);
    callerno = 0;
    seekfile(inp_fileh,0L,SEEK_SET);
    readfile(inp_fileh,(char far *) p,sizeof(USER_RECORD));
    p->user_deleted = 0;
    FARstrcpy((char far *) (p->user_name),(char far *) "SYS CTL");
    FARstrcpy((char far *) (p->user_first_date),(char far *) date());
    FARstrcpy((char far *) (p->user_first_time),(char far *) gttime());
    /*** p->user_caller_no = 0; ***/
    seekfile(fcb->dat_handle,0L,SEEK_SET);
    writefile(fcb->dat_handle,(char far *) p,sizeof(USER_RECORD));
    while (fpos < flen) {
	seekfile(inp_fileh,fpos,SEEK_SET);
	readfile(inp_fileh,(char far *) p,sizeof(USER_RECORD));
	if ((remove_dels) && (p->user_deleted))
	    goto Skip_user;
	expire_daynumber = 0;
	if (p->user_expire_date)
	    expire_daynumber = (int)(p->user_expire_date - curr_daynumber);
	FARstrcpy((char far *) inp,(char far *) (p->user_last_date));
	user_daynumber = (int)(curr_daynumber - daynumber(inp));
	if (remove_expired) {
	    if ((expire_daynumber<0)&&((abs(expire_daynumber))>expire_limit)){
		strcpy(inp,"calls");
		if (p->user_times_on==1)
		    inp[4]=0;
		printf("EXPIRED: %-31Fs %5d days ago  %3d %s\n",p->user_name,user_daynumber,p->user_times_on,inp);
		delay(1000);
		goto Skip_user;
	    }
	}
	if (trash_removal) {
	    bad_one = 0;
	    if ((p->user_privel < '0')||(p->user_privel > 'z'))
		bad_one++;
	    FARstrcpy((char far *) inp,(char far *) (p->user_password));
	    if ((strlen(inp)) < 4)
		bad_one++;
	    FARstrcpy((char far *) inp,(char far *) (p->user_home));
	    if ((strlen(inp)) < 5)
		bad_one++;
	    FARstrcpy((char far *) inp,(char far *) (p->user_name));
	    if ((strlen(inp)) < 5)
		bad_one++;
	    if (expire_daynumber < (-30))
		bad_one++;
	    FARstrcpy((char far *) inp,(char far *) (p->user_password));
	    bad_one += flake_scan(inp);
	    FARstrcpy((char far *) inp,(char far *) (p->user_name));
	    bad_one += flake_scan(inp);
	    FARstrcpy((char far *) inp,(char far *) (p->user_home));
	    if (flake_scan(inp)) {
		if (!bad_one) {
		    printf("\nCaller Name  : %Fs",p->user_name);
		    printf("\nCity & State : %Fs",p->user_home);
		    printf("\n Correction? : ");
		    gets(inp);
		    printf("\n");
		    if (inp[0]) {
			FARstrcpy((char far *) (p->user_home),(char far *) inp);
			proper(p->user_home);
		    }
		    else {
			bad_one = 1;
		    }
		}
		else {
		    bad_one++;
		}
	    }
	    if (bad_one) {
		printf("\n\nCaller Name  : %Fs",p->user_name);
		printf(  "\nPassword     : %Fs",p->user_password);
		printf(  "\nAccess Level : %c",p->user_privel);
		printf(  "\nCity & State : %Fs",p->user_home);
		printf(  "\nExpire Date  : %s",calcdate(p->user_expire_date));
		if (expire_daynumber < 0)
		    printf("      EXPIRED!");
		printf("\n\nDo you wish to remove this user record? [y/N]  ");
		up_gets(inp);
		printf("\n");
		if (inp[0] == 'Y')
		    goto Skip_user;
	    }
	}
	if (date_purge) {
	    if ((p->user_banned)
		|| (p->user_privel <= privel_override)
		    || (p->user_times_on >= call_override))
			goto Keeper;
	    if (user_daynumber <= day_override)
		goto Keeper;
	    strcpy(inp,"calls");
	    if (p->user_times_on == 1)
		inp[4]=0;
	    printf("INACTIVE: %-31Fs %5d days ago  %3d %s\n",p->user_name,user_daynumber,p->user_times_on,inp);
	    goto Skip_user;
	}
Keeper:
	/*** p->user_caller_no = (callerno + 1); ***/
	FARstrcpy((char far *) (fcb->string_key),(char far *) (p->user_name));
	fcb->binary_key = p->user_caller_no;
	if (dram(APPEND,fcb))
	    printf("Unable to add \"%Fs\", possible duplicate record.\n",p->user_name);
	else {
	    if (!(++callerno % 25))
		printf("%5ld.  %-32Fs%-32Fs\n",callerno,p->user_name,p->user_home);
	}
Skip_user:
	fpos += (LONGINTEGER) sizeof(USER_RECORD);
    }
/*****
    seekfile(fcb->dat_handle,0L,SEEK_SET);
    readfile(fcb->dat_handle,(char far *) p,sizeof(USER_RECORD));
    p->user_caller_no = callerno;
    seekfile(fcb->dat_handle,0L,SEEK_SET);
    writefile(fcb->dat_handle,(char far *) p,sizeof(USER_RECORD));
*****/
    dram(CLOSE,fcb);
Conex:
    release_fcb(fcb);
    fcb=NULL;
    _close(inp_fileh);
}

void generate_user_msg_report(char *msg_path)
{
    LONGINTEGER fpos, flen;
    int inp_fileh, banned;
    unsigned recno;
    char inp[80];
    char inp_file[80];
    char home_directory[80];
    char curr_directory[80];
    FILE *user_report;
    char user_report_fname[80];
    DRAM far *ufcb;
    USER_RECORD far *up;
    USER_MSG_RECORD mp;

    ufcb=NULL;
    getcwd(home_directory,78);
    strcpy(curr_directory,msg_path);
    strupr(curr_directory);
    if (chg_dir(curr_directory)) {
	printf("\nCannot access %s",curr_directory);
	sleep(5);
	return;
    }
    sprintf(inp_file,"%sUSER_MSG.CTL",msg_path);
    if ((inp_fileh = _open(inp_file,O_RDWR)) < 0) {
	printf("\nCannot access %s",inp_file);
	sleep(5);
	goto Conex3;
    }
    ufcb = allocate_fcb();
    up = ufcb->user_rec;
    ufcb->dat_recsize = sizeof(USER_RECORD);
    ufcb->dat_keypos = 1;
    ufcb->dat_keytype = 0;
    FARstrcpy((char far *) (ufcb->dram_path),(char far *) lan_path);
    dram_slasher(ufcb);
    FARstrcpy((char far *) (ufcb->dram_fname),(char far *) "USER");
    if (dram(OPEN,ufcb)) {
	printf("\nERROR: Cannot open index and data file: %Fs%s\n",ufcb->dram_path,"USER");
	sleep(5);
	goto Conex2;
    }
    sprintf(user_report_fname,"%sUSER_MSG.RPT",msg_path);
    if ((user_report = fopen(user_report_fname,"wt")) == NULL) {
	printf("\nERROR: cannot open %s",user_report_fname);
	sleep(5);
	return;
    }
    strcpy(inp,gttime());
    inp[5] = 0;
    printf("\nReport is going to file %s",user_report_fname);
    fprintf(user_report,"User Msg List  %s %s\n\n",date(),inp);
    fprintf(user_report,
" No.      Caller Name                    City-State                  1st Call\n");
    fprintf(user_report,
"----   ------------------------------ ------------------------------ --------\n");
    flen = filelength(inp_fileh);
    fpos = (LONGINTEGER) sizeof(USER_MSG_RECORD);
    seekfile(inp_fileh,0L,SEEK_SET);
    readfile(inp_fileh,(char far *) &mp,sizeof(USER_MSG_RECORD));
    recno = 0;
    while (fpos < flen) {
        seekfile(inp_fileh,fpos,SEEK_SET);
	readfile(inp_fileh,(char far *) &mp,sizeof(USER_MSG_RECORD));
	if (!(mp.user_msg_deleted)) {
	    if (!(++recno % 25))
		printf(".");
	    ufcb->hash_key = mp.user_msg_hash_code;
	    ufcb->binary_key = mp.user_msg_caller_no;
	    if (! dram(HASH_READ,ufcb)) {
		banned = ' ';
		if (mp.user_msg_banned)
		    banned = '*';
		fprintf(user_report,"%4u. %c%-31Fs%-31Fs%8Fs\n",
		    recno,
		     banned,
		      up->user_name,
		       up->user_home,
			up->user_first_date);
	    }
	}
	fpos += (LONGINTEGER) sizeof(USER_MSG_RECORD);
    }
    dram(CLOSE,ufcb);
    fclose(user_report);
Conex2:
    release_fcb(ufcb);
    ufcb=NULL;
    _close(inp_fileh);
Conex3:
    chg_dir(home_directory);
}

void generate_user_report(char *msg_path)
{
    LONGINTEGER fpos, flen;
    int inp_fileh, detailed, subscription_report;
    int minimum_days;
    unsigned counter, usr_banned, ratio_k, ratio_f;
    FILE *user_report;
    INTEGER curr_daynumber;
    int days_left;
    char inp_file[82], user_report_fname[82], inp[128];
    USER_RECORD p;

    clrscr();
    curr_daynumber = daynumber(date());
    printf("\nDo you want the message area report?  [y/N] ");
    up_gets(inp);
    if (inp[0]=='Y') {
	generate_user_msg_report(msg_path);
	return;
    }
    subscription_report = detailed = 0;
    printf("\nDo you want a detailed report?        [y/N] ");
    up_gets(inp);
    if (inp[0]=='Y') {
	detailed=1;
	printf("\nDo you want a subscription report?    [y/N] ");
	up_gets(inp);
	if (inp[0]=='Y') {
	    subscription_report = 1;
	    printf("\n    How near the expiration date in days?  ");
	    gets(inp);
	    minimum_days = atoi(inp);	
	}
    }
    if (subscription_report)
	sprintf(user_report_fname,"%sSUBS.RPT",gtpath);
    else
	sprintf(user_report_fname,"%sUSER.RPT",gtpath);
    if ((user_report = fopen(user_report_fname,"wt")) == NULL) {
	printf("\nERROR: cannot open %s",user_report_fname);
	sleep(5);
	return;
    }
    strcpy(inp,gttime());
    counter =
     inp[5] = 0;
    printf("\nReport is going to file %s",user_report_fname);
    if (subscription_report)
	fprintf(user_report,"\nNear Expiration Date Report      %s %s\n\n",
	    date(),inp);
    else
	fprintf(user_report,"\nUser List      %s %s\n\n",date(),inp);
    fprintf(user_report,
" No.     Caller Name                    City-State                  1st Call\n");
    fprintf(user_report,
"----  ------------------------------ ------------------------------ --------\n");
    sprintf(inp_file,"%sUSER.CTL",lan_path);
    if ((inp_fileh = _open(inp_file,o_mode(O_RDWR))) < 0) {
	build_error(lan_path,"USER.CTL",TRUE);
	fclose(user_report);
	return;
    }
    flen = filelength(inp_fileh);
    fpos = (LONGINTEGER) sizeof(USER_RECORD);
    while (fpos < flen) {
        seekfile(inp_fileh,fpos,SEEK_SET);
	readfile(inp_fileh,(char far *) &p,sizeof(USER_RECORD));
	if (p.user_deleted)
	    goto Loop_user;
	if (!(++counter % 25))
	    printf(".");
	if (subscription_report) {
	    if (! p.user_expire_date) 
		goto Loop_user;
	    days_left = (int)(p.user_expire_date - curr_daynumber);
	    if (days_left > minimum_days)
		goto Loop_user;
	}
	fprintf(user_report,
	    "%4u. %-31s%-31s%8s\n",
	    counter,
	    p.user_name,
	    p.user_home,
	    p.user_first_date);
	if (! detailed)
	    goto Loop_user;
	usr_banned = 'F';
	if (p.user_banned)
	    usr_banned = 'T';
	fprintf(user_report,"      Class:%c  Phone:%-10s  Pwd:%-12s  Calls:%-4u  Banned:%c\n",
	       p.user_privel,
	       p.user_phone,
	       p.user_password,
	       p.user_times_on,
	       usr_banned);
	ratio_k = p.user_dnload_k;
	ratio_f = p.user_dnload_files;
	if ((p.user_upload_k > 0) && (p.user_upload_files > 0)) {
	    ratio_k = p.user_dnload_k / p.user_upload_k;
	    ratio_f = p.user_dnload_files / p.user_upload_files;
	}
	fprintf(user_report,"      Net Credits:%5u  D/L: Kilo=%5u  Files=%5u  D/L Ratios: Kilo=%u\n",
	       p.user_credit,
	       p.user_dnload_k,
	       p.user_dnload_files,
	       ratio_k);
	fprintf(user_report,"      Net Charges:%5u  U/L: Kilo=%5u  Files=%5u              File=%u\n",
	       p.user_charges,
	       p.user_upload_k,
	       p.user_upload_files,
	       ratio_f);
	if (p.user_expire_date) {
	    days_left = (int)(p.user_expire_date - curr_daynumber);
	    fprintf(user_report,"      Expire Date:%s    Days left:%d\n",calcdate(p.user_expire_date),days_left);
	}
	fprintf(user_report,"\n");
Loop_user:
	fpos += (LONGINTEGER) sizeof(USER_RECORD);
    }
Conex:
    _close(inp_fileh);
    fclose(user_report);
    sleep(2);
}

void issue_exp_dates(void)
{
    LONGINTEGER fpos, flen;
    int inp_fileh, override, ch;
    int default_days, cvt_count;
    char match_privel;
    char user_buffer[180];
    char inp_file[82], inp[82], *cp;
    USER_RECORD p;

    clrscr();
    printf("\nWhich access level to process?                    (*=ALL)  ");
    gets(inp);
    trim((char far *)inp);
    if (! inp[0])
	return;
    match_privel = inp[0];
TryAgain:
    printf("\nHow many days from LAST CALL to give as subscription?      ");
    gets(inp);
    trim((char far *)inp);
    if (! inp[0])
	return;
    default_days = atoi(inp);
    if (default_days < 30) {
	printf("\n      Are you sure?  Only %d days!   [y/N]  ",default_days);
	up_gets(inp);
	if (inp[0] != 'Y')
	    goto TryAgain;
    }
    override = 0;
    printf("\nDo you wish to override existing expiration dates?  [y/N]  ");
    up_gets(inp);
    trim((char far *)inp);
    if (inp[0] == 'Y')
	override = 1;
    sprintf(inp_file,"%sUSER.CTL",lan_path);
    if ((inp_fileh = _open(inp_file,o_mode(O_RDWR))) < 0) {
	build_error(lan_path,"USER.CTL",TRUE);
	return;
    }
    flen = filelength(inp_fileh);
    fpos = (LONGINTEGER) sizeof(USER_RECORD);
    cvt_count = 0;
    while (fpos < flen) {
        seekfile(inp_fileh,fpos,SEEK_SET);
	readfile(inp_fileh,(char far *) &p,sizeof(USER_RECORD));
	memcpy(user_buffer,&p,176);
/**********
    INTEGER      user_expire_date;               166    
    int          user_time_bank;                 168
    INTEGER      user_day_dnload_amt;            170    
    int          user_day_time_deposits;         172    
    int          user_day_time_withdrawals;      174
**********/
	ch = user_buffer[166];
	if ((ch == ' ')||((ch >= '0')&&(ch <= '9'))) {
	    cvt_count++;
	    cp = (char *) &p;
	    memset(&cp[166],0,10);
	    p.user_expire_date = daynumber(&user_buffer[166]);	    
	    seekfile(inp_fileh,fpos,SEEK_SET);
	    writefile(inp_fileh,(char far *) &p,sizeof(USER_RECORD));
	}
	if (p.user_deleted) 
	    goto Issue_Loop;
	if ((p.user_expire_date) && (!override))
	    goto Issue_Loop;
	if ((match_privel!='*')&&(p.user_privel!=match_privel)) 
	    goto Issue_Loop;
	p.user_expire_date = daynumber(p.user_last_date) + default_days;
	seekfile(inp_fileh,fpos,SEEK_SET);
	writefile(inp_fileh,(char far *) &p,sizeof(USER_RECORD));
Issue_Loop:
	fpos += (LONGINTEGER) sizeof(USER_RECORD);
    }
    _close(inp_fileh);
    if (cvt_count) {
	printf("\n\n%d expiration dates converted.\n",cvt_count);
	delay(4000);
    }
}

void clean_up_user_msg_file(char *msg_path,int rebuild_board_joins)
{
    LONGINTEGER fpos, flen;
    int inp_fileh, recno;
    char *p;
    char inp[80];
    char inp_file[80];
    char home_directory[80];
    char curr_directory[80];
    char old_user_msg_idx[80];
    char old_user_msg_ctl[80];
    DRAM far *ufcb;
    USER_RECORD far *up;
    DRAM far *mfcb;
    USER_MSG_RECORD far *mp;

    ufcb =
      mfcb = NULL;
    getcwd(home_directory,78);
    strcpy(curr_directory,msg_path);
    strupr(curr_directory);
    if (chg_dir(curr_directory)) {
	printf("\nCannot access %s",curr_directory);
	prt_line();
	sleep(1);
	return;
    }
    printf("\n");
    p = backup_file(msg_path,"USER_MSG","IDX","O_USRMSG");
    strcpy(old_user_msg_idx,p);
    p = backup_file(msg_path,"USER_MSG","CTL","O_USRMSG");
    strcpy(old_user_msg_ctl,p);
    printf(  "\nIf this process does not complete successfully, the USER_MSG files can");
    printf(  "\nbe recovered by copying files as shown below:");
    printf("\n\n                   COPY  O_USRMSG.CTL  USER_MSG.CTL");
    printf(  "\n                   COPY  O_USRMSG.IDX  USER_MSG.IDX");
    printf("\n\nThese files are located in the subdirectory: %s",msg_path);
    sleep(2);
    printf("\n\nConstructing new index: %sUSER_MSG.IDX\n",msg_path);
    sprintf(inp_file,"%sO_USRMSG.CTL",msg_path);
    if ((inp_fileh = _open(inp_file,O_RDWR)) < 0) {
	build_error(msg_path,"O_USRMSG.CTL",FALSE);
	sleep(5);
	goto Conex3;
    }
    mfcb = allocate_fcb();
    mp = mfcb->user_msg_rec;
    mfcb->dat_recsize = sizeof(USER_MSG_RECORD);
    mfcb->dat_keypos = 5;
    mfcb->dat_keytype = 1;
    FARstrcpy((char far *) (mfcb->dram_path),(char far *) msg_path);
    dram_slasher(mfcb);
    FARstrcpy((char far *) (mfcb->dram_fname),(char far *) "USER_MSG");
    if (dram(CREATE,mfcb)) {
	printf("ERROR: Cannot create DRAM index and data file: %Fs%Fs",mfcb->dram_path,mfcb->dram_fname);
	sleep(5);
	goto Conex2;
    }
    ufcb = allocate_fcb();
    up = ufcb->user_rec;
    ufcb->dat_recsize = sizeof(USER_RECORD);
    ufcb->dat_keypos = 1;
    ufcb->dat_keytype = 0;
    FARstrcpy((char far *) (ufcb->dram_path),(char far *) lan_path);
    dram_slasher(ufcb);
    FARstrcpy((char far *) (ufcb->dram_fname),(char far *) "USER");
    if (dram(OPEN,ufcb)) {
	printf("\nERROR: Cannot open DRAM index and data file: %Fs%s\n",ufcb->dram_path,"USER");
	dram(CLOSE,mfcb);
	sleep(5);
	goto Conex2;
    }
    flen = filelength(inp_fileh);
    fpos = (LONGINTEGER) sizeof(USER_MSG_RECORD);
    seekfile(inp_fileh,0L,SEEK_SET);
    readfile(inp_fileh,(char far *) mp,sizeof(USER_MSG_RECORD));
    seekfile(mfcb->dat_handle,0L,SEEK_SET);
    writefile(mfcb->dat_handle,(char far *) mp,sizeof(USER_MSG_RECORD));
    recno = 0;
    while (fpos < flen) {
	seekfile(inp_fileh,fpos,SEEK_SET);
	readfile(inp_fileh,(char far *) mp,sizeof(USER_MSG_RECORD));
	if (!(mp->user_msg_deleted)) {
	    ufcb->hash_key = mp->user_msg_hash_code;
	    ufcb->binary_key = mp->user_msg_caller_no;
	    if (! dram(HASH_READ,ufcb)) {
		if (!(++recno % 25))
		    printf("\n%5d.  %-32Fs%-32Fs",recno,up->user_name,up->user_home);
		if (mp->user_msg_banned) {
		    printf("\n\nCaller Name  : %Fs",up->user_name);
		    printf(  "\nPassword     : %Fs",up->user_password);
		    printf(  "\nAccess Level : %c",up->user_privel);
		    printf(  "\nCity & State : %Fs",up->user_home);
		    printf("\n\nRemove the msg base ban from this user in %s? [y/N]  ",curr_directory);
		    up_gets(inp);
		    printf("\n");
		    if (inp[0] == 'Y')
			mp->user_msg_banned = 0;
		}
		FARstrcpy((char far *)(mfcb->string_key),(char far *)(up->user_name));
		mfcb->binary_key = up->user_caller_no;
		if (rebuild_board_joins)
		    root = tree(root,up->user_caller_no,up->user_hash_code);
		dram(APPEND,mfcb);
	    }
	}
	fpos += (LONGINTEGER) sizeof(USER_MSG_RECORD);
    }
    dram(CLOSE,ufcb);
    dram(CLOSE,mfcb);
    unlink(old_user_msg_idx);
    unlink(old_user_msg_ctl);
Conex2:
    release_fcb(ufcb);
    release_fcb(mfcb);
    ufcb =
      mfcb = NULL;
    _close(inp_fileh);
Conex3:
    chg_dir(home_directory);
    prt_line();
}

void clean_up_board_joins(char *board_name)
{
    DRAM far *ufcb;
    char bd_name[80];
    char f_name[80];
    char j_dname[80];
    int data_changed;
    int read_amt, max_callers, join_file, j;
    long seek_adr;
    INTEGER counter;

    if ((!board_name[0]) || (board_name[0]==' '))
	return;
    strcpy(bd_name,board_name);
    bd_name[8] = 0;
    data_changed = FALSE;
    strupr(bd_name);
    select_path(j_dname);
    sprintf(f_name,"%s\\%s.CTL",j_dname,bd_name);
    join_file = _open(f_name,o_mode(O_RDWR));
    if (join_file < 0)
	return;
    seek_adr = 0L;
    ufcb = NULL;
    ufcb = allocate_fcb();
    ufcb->dat_recsize = sizeof(USER_RECORD);
    ufcb->dat_keypos = 1;
    ufcb->dat_keytype = 0;
    FARstrcpy((char far *)(ufcb->dram_path),(char far *) lan_path);
    dram_slasher(ufcb);
    FARstrcpy((char far *)(ufcb->dram_fname),(char far *) "USER");
    if (dram(OPEN,ufcb)) {
	printf("\nERROR: Cannot open DRAM index and data file: %Fs%s\n",ufcb->dram_path,"USER");
	sleep(5);
	goto CleanJoinEx;
    }
    printf("\nCleaning up the joins for the %s board.\n",board_name);
    counter = 0;
    do {
	read_amt = _read(join_file,&callers,2048);
	if (read_amt > 0) {
	    max_callers = (read_amt >> 3);
	    for (j=0; j<max_callers; j++) {
		if (!(++counter % 25))
		    printf(".");
		if (callers[j].CallerNumber != 0L) {
		    ufcb->hash_key = callers[j].HashCode;
		    ufcb->binary_key = callers[j].CallerNumber;
		    if (dram(HASH_READ,ufcb)) {
			callers[j].CallerNumber = 0L;
			callers[j].HashCode = 0;
			callers[j].SlackBytes = 0;
			data_changed = TRUE;
			printf("-");
		    }
		}
	    }
	    if (data_changed) {
		lseek(join_file,seek_adr,SEEK_SET);
		_write(join_file,&callers,read_amt);
		data_changed = FALSE;
	    }
	}
	seek_adr += 2048L;
    } while (read_amt > 0);
    _close(join_file);
    dram(CLOSE,ufcb);
    printf("\n");
CleanJoinEx:
    release_fcb(ufcb);
    ufcb = NULL;
}

void re_organize(void)
{
    DRAM far *fcb;

    fcb = allocate_fcb();
    fcb->dat_recsize = sizeof(USER_RECORD);
    fcb->dat_keypos = 1;
    fcb->dat_keytype = 0;
    FARstrcpy((char far *) (fcb->dram_path),(char far *) lan_path);
    dram_slasher(fcb);
    FARstrcpy((char far *) (fcb->dram_fname),(char far *) "USER");
    if (dram(OPEN,fcb)) {
	import_error("USER",lan_path);
	return;
    }
    dram(PURGE,fcb);
    dram(CLOSE,fcb);
    release_fcb(fcb);
    fcb=NULL;
}

void expand_msg_idx(char *msg_path)
{
    DRAM far *fcb;

    fcb = allocate_fcb();
    fcb->dat_recsize = sizeof(USER_MSG_RECORD);
    fcb->dat_keypos = 5;
    fcb->dat_keytype = 1;
    FARstrcpy((char far *) (fcb->dram_path),(char far *) msg_path);
    dram_slasher(fcb);
    FARstrcpy((char far *) (fcb->dram_fname),(char far *) "USER_MSG");
    if (dram(OPEN,fcb)) {
	import_error("USER_MSG",msg_path);
	return;
    }
    idx_expand(fcb);
    dram(CLOSE,fcb);
    release_fcb(fcb);
    fcb=NULL;
}

void main(void)
{
    FILE *text;
    char wrk[514];
    char inp[80];
    char curr_msg_path[80];
    char *ep;
    int ramt, j;

    TZ();
    default_msg_path[0] = 0;
    if ((ep = getenv("GTPATH")) != NULL)
	strcpy(gtpath,ep);
    else
	getcwd(gtpath,78);
    process_pathname(gtpath);
    strcpy(bbs_path,gtpath);
    strcpy(lan_path,gtpath);
    sprintf(wrk,"%sGT.CNF",gtpath);
    if ((text = fopen(wrk,"rt")) != NULL) {
	do {
	    if ((ramt = fgets_p(wrk,512,text)) > 0) {
		strupr(wrk);
		if ((wrk[2] == '=') && (wrk[3] >= 'A') && (wrk[3] <= 'Z')) {
		    if ((wrk[0] == 'M') && (wrk[1] == 'P')) {
		        strcpy(default_msg_path,&wrk[3]);
		        process_pathname(default_msg_path);
			continue;
                    }
		    if ((wrk[0] == 'B') && (wrk[1] == 'B')) {
			strcpy(bbs_path,&wrk[3]);
			process_pathname(bbs_path);
			continue;
		    }
		    if ((wrk[0] == 'L') && (wrk[1] == 'R')) {
			strcpy(lan_path,&wrk[3]);
			process_pathname(lan_path);
			continue;
		    }
		}
	    }
	} while (ramt >= 0);
	fclose(text);
    }
    clrscr();
    printf("\nGT POWER Sysop Program 3.1");
    printf("\n(C) 1988, 1993 P&M Software Company");
    printf("\nAll Rights Reserved");
    printf("\n");
    for (j=0; j<3000; j++) {
	delay(1);
	if (kbhit()) {
	    getch();
	    break;
	}
    }
    strcpy(curr_msg_path,default_msg_path);
    strupr(curr_msg_path);
    inp[0]=0;
    while (inp[0] != 'Q') {
	clrscr();
        printf(  "Main Menu                            GTPATH  : %s",gtpath);
	printf("\n---------                            Msg Base: %s\n",curr_msg_path);
	printf("\n 1.  (I)mport control files from 13.00 or 14.xx.");
	printf("\n 2.  (A)dd user records.");
	printf("\n 3.  Delete (U)ser records.");
	printf("\n 4.  (D)elete messages.");
	printf("\n 5.  (R)enumber messages.");
	printf("\n 6.  (L)ookup/edit user records.");
	printf("\n 7.  (G)oto/edit user records.");
	printf("\n 8.  Re-(O)rganize USER index file.");
	printf("\n 9.  (E)xamine lost user record.");
	printf("\n10.  Expand USER_MSG index file.");
	printf("\n11.  Clean-up USER control file.");
	printf("\n12.  Clean-up USER_MSG index file.");
	printf("\n13.  Global access level (C)hange.");
	printf("\n14.  Make a message (S)ticky.");
	printf("\n15.  Mass issue E(x)piration dates.");
	printf("\n16.  Change the msg base (P)ath.");
	printf("\n17.  Ge(n)erate User Reports.");
	printf("\n18.  (Q)uit the program.");
	printf("\n\nWhich command? ");
Bksp:
	inp[0] = my_getkey(1);
	inp[1] = 0;
	strupr(inp);
	if (inp[0] == '\x08')
	    goto Bksp;
	if (inp[0] == '1') {
	    inp[1] = my_getkey(0);
	    inp[2] = 0;
	    if (inp[1] == '\x08')
		goto Bksp;
	}
	printf("\n");
	if ((! strcmp(inp,"1"))||(inp[0]=='I')) {
	    build_ctl();
	    continue;
	}
	if ((! strcmp(inp,"2"))||(inp[0]=='A')) {
	    add_user();
	    continue;
	}
	if ((! strcmp(inp,"3"))||(inp[0]=='U')) {
	    delete_user();
	    continue;
	}
	if ((! strcmp(inp,"4"))||(inp[0]=='D')) {
            scan_msg_bases(1);
	    continue;
	}
	if ((! strcmp(inp,"5"))||(inp[0]=='R')) {
	    scan_msg_bases(2);
	    continue;
	}
	if ((! strcmp(inp,"6"))||(inp[0]=='L')) {
	    find_user(0,curr_msg_path);
	    continue;
	}
	if ((! strcmp(inp,"7"))||(inp[0]=='G')) {
	    find_user(1,curr_msg_path);
	    continue;
	}
	if ((! strcmp(inp,"8"))||(inp[0]=='O')) {
	    re_organize();
	    continue;
	}
	if ((! strcmp(inp,"9"))||(inp[0]=='E')) {
	    examine_lost();
	    continue;
	}
	if (! strcmp(inp,"10")) {
	    expand_msg_idx(curr_msg_path);
	    continue;
	}
	if (! strcmp(inp,"11")) {
	    clean_up_user_file();
	    continue;
	}
	if (! strcmp(inp,"12")) {
	    scan_msg_bases(3);
	    continue;
	}
	if ((! strcmp(inp,"13"))||(inp[0]=='C')) {
	    global_access_lvl_chg();
	    continue;
	}
	if ((! strcmp(inp,"14"))||(inp[0]=='S')) {
	    make_a_msg_sticky(curr_msg_path);
	    continue;
	}
	if ((! strcmp(inp,"15"))||(inp[0]=='X')) {
	    issue_exp_dates();
	    continue;
	}
	if ((! strcmp(inp,"16"))||(inp[0]=='P')) {
	    getcwd(wrk,78);
	    printf("\nEnter new msg base path : ");
	    up_gets(inp);
            process_pathname(inp);
	    if (chg_dir(inp)) {
		printf("\nCannot access %s",inp);
		sleep(3);
	    }
	    else {
		getcwd(curr_msg_path,78);
	        chg_dir(wrk);
	        process_pathname(curr_msg_path);
	    }
	    continue;
	}
	if ((! strcmp(inp,"17"))||(inp[0]=='N')) {
	    generate_user_report(curr_msg_path);
	    continue;
	}
	if ((! strcmp(inp,"18"))||(inp[0]=='Q')) {
	    clrscr();
	    inp[0] = 'Q';
	}
    }
    exit(0);
}
