/*
*
*               Borland C++ 3.1.  MEDIUM Memory Model
*
*               Written By: Paul Meiners
*                           P&M Software Co.
*
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <io.h>
#include <dir.h>
#include <fcntl.h>
#include <sys\stat.h>

extern unsigned _stklen  = 4096;
extern unsigned _heaplen = 8192;

unsigned        _ovrbuffer;
int             ems_flag;
struct ftime    ft;
int             verbose;

int changer(char *filename)
{
    int file;

    if ((file = _open(filename,O_RDWR)) < 0) {
	printf("\nCannot find %s\n",filename);
	return(1);
    }
    setftime(file,&ft);
    _close(file);
    return(0);
}

int touch(char *file_spec)
{
    char far *dta;
    char far *mask_dta;
    struct ffblk ffblk;
    int done, result_code, rc;

    result_code = 0;
    dta = getdta();
    done = findfirst(file_spec,&ffblk,0);
    mask_dta = getdta();
    while (!done) {
	setdta(dta);
	if (verbose)
	    printf("\n   processing %s",ffblk.ff_name);
	rc = changer(ffblk.ff_name);
	if (rc)
	    result_code = 1;
	setdta(mask_dta);
	done = findnext(&ffblk);
    }
    setdta(dta);
    return(result_code);
}

int asctoi(char *s)
{
    int result;

    result = ((s[0] - '0') * 10) + (s[1] - '0');
    return(result);
}

int main(int argc,char *argv[])
{
    FILE *list_file;
    char *res;
    char filename[82];
    char list_filename[82];
    int j, k;
    int result_code, rc;
    struct time timep;
    struct date datep;

    printf("TOUCHY: written and distributed by P&M Software Co., 9/7/92.\n");
    verbose = 1;
    result_code = 0;
    gettime(&timep);
    getdate(&datep);
    ft.ft_tsec  = timep.ti_sec / 2;
    ft.ft_min   = timep.ti_min;
    ft.ft_hour  = timep.ti_hour;
    ft.ft_day   = datep.da_day;
    ft.ft_month = datep.da_mon;
    ft.ft_year  = datep.da_year - 1980;
    if (argc < 2) {
	printf("\nUsage: TOUCHY filename ...\n");
	result_code = 1;
    }
    for (j=1; j<argc; j++) {
	strcpy(filename,argv[j]);
	strupr(filename);
	if ((filename[0] == '/') || (filename[0] == '-')) {
	    if (filename[1] == 'V')
		verbose = 1;
	    if (filename[1] == 'T')
		verbose = 0;
	    if (filename[1] == 'D') {
		ft.ft_month = asctoi(&filename[ 2]);
		ft.ft_day   = asctoi(&filename[ 4]);
		ft.ft_year  = asctoi(&filename[ 6]) - 80;
		ft.ft_hour  = asctoi(&filename[ 9]);
		ft.ft_min   = asctoi(&filename[11]);
		ft.ft_tsec  = asctoi(&filename[13]) / 2;
	    }
	    continue;
	}
	if (filename[0] == '@') {
	    strcpy(list_filename,&filename[1]);
	    if ((list_file = fopen(list_filename,"rt")) == NULL) {
		printf("\nCannot find %s\n",list_filename);
		continue;
	    }
	    do {
		if ((res = fgets(filename,80,list_file)) != NULL) {
		    filename[81] = 0;
		    k = strlen(filename) - 1;
		    if (k > 0) {
			if ((filename[k] == '\n') || (filename[k] == '\r'))
			    filename[k--] = 0;
			if (k > 0) {
			    if ((filename[k] == '\n') || (filename[k] == '\r'))
				filename[k] = 0;
			    strupr(filename);
			    rc = touch(filename);
			}
		    }
		}
	    } while (res != NULL);
	    fclose(list_file);
	}
	else {
	    rc = touch(filename);
	}
	if (rc)
	    result_code = 1;
    }
    if (verbose)
	printf("\n");
    return(result_code);
}
